/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.ClassBeanManager;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.extension.module.plugin.objetspartages.PluginRechercheHelper;
import com.kportal.extension.module.plugin.objetspartages.PluginSaisieFicheHelper;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.multitype.MultiTypeCaptchaService;
import com.univ.objetspartages.om.AnnuaireModele;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.FicheAnnuaire;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.RechercheExterne;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.om.StructureModele;
import com.univ.objetspartages.util.AffichageHistorique;
import com.univ.objetspartages.util.AffichageReferences;
import com.univ.objetspartages.util.CritereRecherche;
import com.univ.utils.Chaine;
import com.univ.utils.ClassMetaUtil;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.recherche.RechercheMultificheHelper;
import com.univ.utils.recherche.ResultatRechercheMultifiche;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SaisieFiche
extends ProcessusBean {
    private static final Logger LOG = LoggerFactory.getLogger(SaisieFiche.class);
    protected static final String ECRAN_RECHERCHE = "RECHERCHE";
    protected static final String ECRAN_PRINCIPAL = "PRINCIPAL";
    protected static final String ECRAN_LISTE = "LISTE";
    protected static final String ECRAN_SUPPRESSION = "SUPPRESSION";

    public SaisieFiche(InfoBean ciu) {
        super(ciu);
    }

    public void controlerPerimetreModification() throws Exception {
        Object o = this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        AutorisationBean autorisations = (AutorisationBean)o;
        ((Hashtable)this.getDatas()).put("CONTROLE_PERIMETRE_BO", "1");
        ((Hashtable)this.getDatas()).put("AUTORISATIONS", autorisations);
    }

    protected void preparerLISTE() throws Exception {
        this.ecranLogique = ECRAN_LISTE;
    }

    protected abstract void preparerPRINCIPAL() throws Exception;

    protected abstract void preparerRECHERCHE() throws Exception;

    protected abstract void traiterPRINCIPAL() throws Exception;

    protected void traiterRECHERCHE() throws Exception {
        if (this.action.equals("VALIDER") || this.action.equals("ENREGISTRER")) {
            RechercheExterne bean;
            RechercheExterne rechercheExterne;
            Iterator<RechercheExterne> iterator = ClassBeanManager.getInstance().getBeanOfType(RechercheExterne.class).iterator();
            while (iterator.hasNext() && !(rechercheExterne = (bean = iterator.next())).traiterRECHERCHE(this.infoBean, this)) {
            }
            this.preparerLISTE();
        } else if (this.action.equals("AJOUTER")) {
            this.infoBean.setEtatObjet("CREATION");
            this.preparerPRINCIPAL();
        } else if (this.action.equals("ANNULER")) {
            this.ecranLogique = "FIN_TOOLBOX";
        }
    }

    public void traiterActionParDefaut(FicheUniv ficheUniv) throws Exception {
        Object o = this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        this.infoBean.set("GRS_FILTRE_ARBRE_NOM_CODE_RATTACHEMENT", ClassMetaUtil.getClassMetaValue(this, "NOM_CODE_RATTACHEMENT"));
        if (!"0".equals(PropertyHelper.getCoreProperty("fiche." + ReferentielObjets.getNomObjet(ficheUniv).toUpperCase() + ".filtre_rattachements_secondaires"))) {
            this.infoBean.set("GRS_FILTRE_ARBRE_NOM_CODE_RATTACHEMENT_AUTRES", ClassMetaUtil.getClassMetaValue(this, "NOM_CODE_RATTACHEMENT_AUTRES"));
        }
        this.infoBean.set("GRS_FILTRE_ARBRE_NOM_CODE_RUBRIQUE", ClassMetaUtil.getClassMetaValue(this, "NOM_CODE_RUBRIQUE"));
        this.infoBean.set("GRS_FILTRE_ARBRE_GROUPE", "1");
        this.infoBean.set("GRS_FILTRE_ARBRE_GROUPE_TYPE", "TECH");
        this.infoBean.set("GRS_FILTRE_ARBRE_GROUPE_OBJET", "dsi");
        this.infoBean.set("GRS_FILTRE_ARBRE_GROUPE_ACTION", "");
        String code = ReferentielObjets.getCodeObjetParClasse(ficheUniv.getClass().getName());
        this.infoBean.set("GRS_CODE_OBJET", code);
        this.infoBean.set("GRS_INTITULE_OBJET", ReferentielObjets.getLibelleObjet(code));
        String nomobjet = ReferentielObjets.getNomObjet(code);
        String anonyme = PropertyHelper.getCoreProperty(nomobjet + ".anonyme");
        boolean saisieAnonyme = "1".equals(anonyme);
        boolean isRechercheAnonyme = false;
        boolean isAllRechercheAnonyme = false;
        String sRechercheAnonyme = PropertyHelper.getCoreProperty("fiche." + nomobjet.toUpperCase() + ".recherche_anonyme");
        if (sRechercheAnonyme != null && (sRechercheAnonyme.equals("1") || sRechercheAnonyme.equals("2"))) {
            isRechercheAnonyme = true;
            if (sRechercheAnonyme.equals("2")) {
                isAllRechercheAnonyme = true;
            }
        }
        PluginSaisieFicheHelper.preTraiterAction(this.infoBean, ficheUniv, null);
        if (this.infoBean.get("SAISIE_ANONYME") != null) {
            saisieAnonyme = (Boolean)this.infoBean.get("SAISIE_ANONYME");
        }
        boolean envoilogin = true;
        if (o == null && this.infoBean.get("SAISIE_FRONT") != null && saisieAnonyme && this.infoBean.get("LIEN_DIRECT") == null) {
            envoilogin = false;
        }
        if (o == null && (this.infoBean.get("SAISIE_FRONT") != null && !saisieAnonyme || envoilogin)) {
            ContexteUniv ctx = ContexteUtil.getContexteUniv();
            String callbackUrl = "";
            if (StringUtils.isNotBlank((CharSequence)ctx.getUrlPageCourante())) {
                callbackUrl = ctx.getUrlPageCourante();
            }
            this.infoBean.set("URL_DEMANDEE", callbackUrl);
            this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
            this.infoBean.setEcranLogique("LOGIN");
        } else {
            try {
                AutorisationBean autorisations = (AutorisationBean)o;
                this.ecranLogique = this.infoBean.getEcranLogique();
                this.action = this.infoBean.getActionUtilisateur();
                this.etat = 1;
                PluginSaisieFicheHelper.traiterAction(this.infoBean, ficheUniv, null);
                if (this.ecranLogique == null) {
                    if (this.action.equals("AJOUTER")) {
                        this.infoBean.setEtatObjet("CREATION");
                        this.preparerPRINCIPAL();
                    } else if (this.action.equals("MODIFIER")) {
                        if (ficheUniv.getIdFiche().equals(new Long(0L))) {
                            try {
                                ficheUniv.setIdFiche(new Long(this.infoBean.getString("ID_FICHE")));
                                ficheUniv.retrieve();
                            }
                            catch (Exception e) {
                                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_INEXISTANTE"));
                            }
                        }
                        Metatag meta = FicheUnivMgr.lireMeta(ficheUniv);
                        if (!autorisations.estAutoriseAModifierLaFiche(ficheUniv) && !autorisations.getAutorisationParFiche(ficheUniv, 5, meta.getMetaNiveauApprobation())) {
                            throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_DROIT_MODIFICATION"));
                        }
                        this.infoBean.setEtatObjet("MODIFICATION");
                        this.preparerPRINCIPAL();
                        if (this.infoBean.get("LIBELLE_AFFICHABLE") != null) {
                            this.infoBean.setTitreEcran(this.infoBean.getString("LIBELLE_AFFICHABLE"));
                        }
                    } else if (this.action.equals("SUPPRIMER")) {
                        if (this.infoBean.get("SAISIE_FRONT") != null) {
                            this.preparerSUPPRESSION();
                        } else {
                            this.infoBean.set("TYPE_FICHE", ReferentielObjets.getNomObjet(ficheUniv));
                            this.traiterSUPPRESSION(ficheUniv);
                        }
                    } else if (this.action.equals("ACCUEIL")) {
                        this.infoBean.getSessionHttp().removeAttribute("CURRENT_SEARCH_PARAMS");
                        ArrayList<CritereRecherche> paramRecherche = new ArrayList<CritereRecherche>();
                        paramRecherche.add(new CritereRecherche("OBJET", ReferentielObjets.getNomObjet(ficheUniv), ""));
                        paramRecherche.add(new CritereRecherche("ETAT_OBJET", "0000", ""));
                        paramRecherche.add(new CritereRecherche("BEAN_RECHERCHE", "ficheUnivDatagrid", ""));
                        this.infoBean.set("CRITERE_REQUETE", paramRecherche);
                        this.preparerLISTE();
                    } else if (this.action.equals("RECHERCHER")) {
                        this.infoBean.setEtatObjet(ECRAN_RECHERCHE);
                        if (this.infoBean.get("SEARCH_PARAMS") != null) {
                            this.restoreSearchParams();
                        }
                        PluginRechercheHelper.preparerRecherche(this, this.infoBean);
                        this.preparerRECHERCHE();
                        if (this.infoBean.get("TOOLBOX") == null) {
                            this.infoBean.set("GRS_PERMISSION_TYPE", "FICHE");
                            this.infoBean.set("GRS_PERMISSION_OBJET", this.infoBean.getString("GRS_CODE_OBJET"));
                            this.infoBean.set("GRS_PERMISSION_ACTION", "M");
                        }
                    }
                } else if (this.ecranLogique.equals(ECRAN_RECHERCHE)) {
                    if (autorisations != null && this.infoBean.get("SAISIE_FRONT") == null && (!isRechercheAnonyme || isRechercheAnonyme && this.infoBean.get("TOOLBOX") == null && !isAllRechercheAnonyme)) {
                        this.controlerPerimetreModification();
                        if (this.infoBean.get("TOOLBOX") == null) {
                            if (this.infoBean.get("SEARCH_PARAMS") != null) {
                                this.restoreSearchParams();
                            } else {
                                this.saveSearchParams();
                            }
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)this.infoBean.getString("URL_META"))) {
                        String codeObjet = ReferentielObjets.getCodeObjet(ficheUniv);
                        ResultatRechercheMultifiche resultatRechercheMultifiche = RechercheMultificheHelper.rerchercherParmisToutesLesFiches(this, autorisations, "", codeObjet, "", "", "", "", "", this.infoBean.getString("URL_META"), null, null, null, null, null, null, "", "", "");
                        if (resultatRechercheMultifiche.getResultats().size() > 0) {
                            for (Metatag leMeta : resultatRechercheMultifiche.getResultats()) {
                                if (ficheUniv.selectCodeLangueEtat(leMeta.getMetaCode(), "", "") <= 0) continue;
                                this.preparerLISTE();
                                break;
                            }
                        } else {
                            this.traiterRECHERCHE();
                        }
                    } else {
                        PluginRechercheHelper.traiterRecherche(this, this.infoBean);
                        this.traiterRECHERCHE();
                    }
                } else if (this.ecranLogique.equals(ECRAN_SUPPRESSION)) {
                    this.traiterSUPPRESSION(ficheUniv);
                } else if (this.ecranLogique.indexOf(ECRAN_PRINCIPAL) == 0) {
                    if (this.isEnregistremeentModeAnonyme(this.infoBean, o, saisieAnonyme)) {
                        String captchaId = this.infoBean.getSessionHttp().getId();
                        String captchaResponse = this.infoBean.getString("VALIDATION_ANONYME");
                        MultiTypeCaptchaService captchaService = (MultiTypeCaptchaService)ApplicationContextManager.getCoreContextBean("captchaService");
                        try {
                            if (captchaResponse == null || !captchaService.validateResponseForID(captchaId, (Object)captchaResponse).booleanValue()) {
                                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "JTF_ERR_VALIDATION_ANONYME"));
                            }
                        }
                        catch (CaptchaServiceException e) {
                            throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "JTF_ERR_CAPTCHA_EXPIRE"));
                        }
                    }
                    if (this.action.equals("ONGLET")) {
                        this.infoBean.set("SOUS_ONGLET", this.infoBean.getString("SOUS_ONGLET_DEMANDE"));
                        this.infoBean.set("HISTORIQUE", AffichageHistorique.getListeHistorique(this, this.infoBean));
                        this.infoBean.set("REFERENCE", AffichageReferences.getListeReferences(this, this.infoBean));
                    }
                    this.traiterPRINCIPAL();
                }
                this.infoBean.setEcranLogique(this.ecranLogique);
                PluginSaisieFicheHelper.postTraiterAction(this.infoBean, ficheUniv, null);
            }
            catch (Exception e) {
                LOG.error("erreur dans le processus de saisie de fiche", (Throwable)e);
                this.infoBean.addMessageErreur(e.toString());
            }
        }
    }

    private boolean isEnregistremeentModeAnonyme(InfoBean infoBean, Object autorisations, boolean saisieAnonyme) {
        return saisieAnonyme && infoBean.get("SAISIE_FRONT") != null && autorisations == null && !"1".equals(infoBean.getString("APERCU"));
    }

    private void preparerSUPPRESSION() throws Exception {
        String nomObjet = this.infoBean.getString("TYPE_FICHE").toUpperCase();
        FicheUniv ficheUniv = ReferentielObjets.instancierFiche(nomObjet);
        ficheUniv.setCtx(this);
        ficheUniv.init();
        ficheUniv.setIdFiche(new Long(this.infoBean.getString("ID_FICHE")));
        try {
            ficheUniv.retrieve();
        }
        catch (Exception e) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_INEXISTANTE"));
        }
        this.infoBean.set("INTITULE", ficheUniv.getLibelleAffichable());
        this.ecranLogique = ECRAN_SUPPRESSION;
    }

    private void traiterSUPPRESSION(FicheUniv ficheUniv) throws Exception {
        String nomObjet = this.infoBean.getString("TYPE_FICHE").toUpperCase();
        this.infoBean.set("ID_" + nomObjet, this.infoBean.getString("ID_FICHE"));
        this.infoBean.setEtatObjet(ECRAN_SUPPRESSION);
        this.traiterPRINCIPAL();
        if (this.infoBean.get("ESPACE") == null) {
            String rub = ficheUniv.getCodeRubrique();
            if (rub.length() > 0) {
                this.infoBean.set("RUBRIQUE", ficheUniv.getCodeRubrique());
            }
            this.infoBean.set("ACCUEIL", "true");
        }
    }

    private void saveSearchParams() {
        HashMap<String, Object> currentSearchParams = new HashMap<String, Object>();
        Iterator<String> dataKeysIt = this.infoBean.getDataKeys().iterator();
        String key = null;
        while (dataKeysIt.hasNext()) {
            key = dataKeysIt.next();
            if (key.equals("ETAT_FICHE_ENREGISTREE") || key.equals("NB_RESULTATS")) continue;
            currentSearchParams.put(key, this.infoBean.get(key));
        }
        this.infoBean.getSessionHttp().setAttribute("CURRENT_SEARCH_PARAMS", currentSearchParams);
    }

    private void restoreSearchParams() {
        HashMap searchParams = (HashMap)this.infoBean.getSessionHttp().getAttribute("CURRENT_SEARCH_PARAMS");
        if (searchParams != null) {
            Iterator searchParamsIt = searchParams.keySet().iterator();
            String key = null;
            while (searchParamsIt.hasNext()) {
                key = (String)searchParamsIt.next();
                if (this.infoBean.get(key) != null) continue;
                this.infoBean.set(key, searchParams.get(key));
            }
        }
    }

    public void alimenteDonneesCreation(FicheUniv ficheUniv, boolean bCodeModifiable) throws Exception {
        if (this.infoBean.getEtatObjet().equals("CREATION") || "DUPLIQUER".equals(this.infoBean.get("PREMIERE_ACTION"))) {
            if (bCodeModifiable) {
                if (!this.infoBean.getEtatObjet().equals("CREATION")) {
                    FicheUniv fiche2 = (FicheUniv)ficheUniv.getClass().newInstance();
                    fiche2.init();
                    fiche2.setCtx(this);
                    if (fiche2.selectCodeLangueEtat(this.infoBean.getString("CODE"), this.infoBean.getString("LANGUE"), "") > 0) {
                        while (fiche2.nextItem()) {
                            if (fiche2.getIdFiche().equals(ficheUniv.getIdFiche()) || fiche2.getEtatObjet().equals("0005") || fiche2.getEtatObjet().equals("0006")) continue;
                            throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_ERREUR_CODE_FICHE_DOUBLON"));
                        }
                    }
                }
                if (ficheUniv instanceof StructureModele && this.infoBean.getEtatObjet().equals("CREATION")) {
                    Structure.checkCode((String)this.infoBean.get("CODE"), this.infoBean.getString("LANGUE"), this);
                } else if (ficheUniv instanceof AnnuaireModele && this.infoBean.getEtatObjet().equals("CREATION")) {
                    FicheAnnuaire.checkCode((String)this.infoBean.get("CODE"), this.infoBean.getString("LANGUE"), this);
                } else {
                    Chaine.controlerCodeMetier((String)this.infoBean.get("CODE"));
                }
                ficheUniv.setCode(this.infoBean.getString("CODE"));
            } else if (this.infoBean.getEtatObjet().equals("CREATION")) {
                ficheUniv.setCode(Long.toString(System.currentTimeMillis()));
            }
            if (this.infoBean.getEtatObjet().equals("CREATION")) {
                ficheUniv.setLangue(this.infoBean.getString("LANGUE"));
            }
        }
        if (ficheUniv instanceof StructureModele) {
            String nomColonneStructure = ClassMetaUtil.getClassMetaValue(this, "NOM_CODE_RATTACHEMENT");
            Structure.checkCycle(this.infoBean.getString("CODE"), this.infoBean.getString("LANGUE"), this.infoBean.getString(nomColonneStructure));
        }
    }
}

