/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.extension.module.composant.ComposantGroupe;
import com.univ.objetspartages.cache.CacheGroupeDsiManager;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.Groupeutilisateur;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.PageLibre;
import com.univ.objetspartages.om.RequeteGroupeDynamique;
import com.univ.objetspartages.om.RequeteGroupeDynamiqueSynchronisable;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.objetspartages.processus.ControleurAffectationRole;
import com.univ.objetspartages.util.CritereRecherche;
import com.univ.objetspartages.util.CritereRechercheUtil;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteDao;
import com.univ.utils.RequeteGroupeUtil;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaisieGroupedsi
extends ProcessusBean {
    private static final Logger LOG = LoggerFactory.getLogger(SaisieGroupedsi.class);
    private final CacheGroupeDsiManager cache = (CacheGroupeDsiManager)ApplicationContextManager.getCoreContextBean("cacheGroupeDsiManager");
    private int mode = -1;
    private static final int MODE_AJOUT = 0;
    private static final int MODE_MODIFICATION = 1;
    private static final int MODE_SUPPRESSION = 2;
    private static final int MODE_RECHERCHE = 3;
    private static final String ECRAN_RECHERCHE = "RECHERCHE";
    private static final String ECRAN_PRINCIPAL = "PRINCIPAL";
    private static final String ECRAN_SYNCHRONISER = "SYNCHRONISER";
    private static final String ECRAN_LISTE = "LISTE";
    private static final String ECRAN_LISTE_PREVISUALISE = "LISTE_PREVISUALISER";
    Groupedsi groupedsi = null;
    Long[] listeIdentifiant = null;

    public SaisieGroupedsi(InfoBean ciu) {
        super(ciu);
    }

    private void initialisation() throws Exception {
        this.groupedsi = new Groupedsi();
        this.groupedsi.setCtx(this);
        this.groupedsi.init();
        this.etat = 1;
        if (this.action.equals("AJOUTER")) {
            this.mode = 0;
            this.infoBean.setEtatObjet("CREATION");
            this.preparerPRINCIPAL();
        } else if (this.action.equals("MODIFIER")) {
            this.mode = 1;
            this.infoBean.setEtatObjet("MODIFICATION");
            this.preparerRECHERCHE();
        } else if (this.action.equals("SUPPRIMER")) {
            this.mode = 2;
            this.infoBean.setEtatObjet("SUPPRESSION");
            this.preparerRECHERCHE();
        } else if (this.action.equals("RECHERCHER")) {
            this.mode = 3;
            this.infoBean.setEtatObjet(ECRAN_RECHERCHE);
            this.preparerRECHERCHE();
        } else if (this.action.equals("MODIFIERPARID")) {
            this.infoBean.setEtatObjet("MODIFICATION");
            this.modifierParId();
        } else if (this.action.equals("SUPPRIMERPARID")) {
            this.supprimerParId();
        } else if (this.action.equals("SUPPRIMERDUGROUPE")) {
            this.mode = 1;
            this.infoBean.setEtatObjet("MODIFICATION");
            this.supprimerDuGroupe();
        } else if (this.action.equals("ACCUEIL")) {
            this.preparerLISTE();
            this.ecranLogique = "ACCUEIL";
        }
    }

    private void supprimerDuGroupe() throws Exception {
        String id = this.infoBean.getString("UTILISATEUR");
        String groupeCode = this.infoBean.getString("GROUPE_DSI");
        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNumeric((CharSequence)id)) {
            Utilisateur utilisateur = new Utilisateur();
            utilisateur.setCtx(this);
            utilisateur.init();
            utilisateur.setIdUtilisateur(Long.valueOf(id));
            utilisateur.retrieve();
            Groupeutilisateur.deleteUtilisateurDuGroupe(this, utilisateur.getCode(), groupeCode);
        }
        this.infoBean.set("ID_GROUPE", String.valueOf(Groupedsi.renvoyerItemGroupeDsi(groupeCode).getId()));
        this.modifierParId();
    }

    private void preparerLISTE() throws Exception {
        this.insererRechercheDansInfoBean(this.infoBean);
        this.ecranLogique = ECRAN_LISTE;
    }

    private void preparerPRINCIPAL() throws Exception {
        this.ecranLogique = ECRAN_PRINCIPAL;
        this.infoBean.set("CODE", this.groupedsi.getCode());
        this.infoBean.set("ID_GROUPE", String.valueOf(this.groupedsi.getIdGroupedsi()));
        this.infoBean.set("LIBELLE", this.groupedsi.getLibelle());
        this.infoBean.set("TYPE", this.groupedsi.getType());
        this.infoBean.set("LISTE_TYPES", Libelle.getListe("11", LangueUtil.getDefaultLocale()));
        if (!this.groupedsi.getType().equals("STRUCT")) {
            ((Hashtable)this.infoBean.get("LISTE_TYPES")).remove("STRUCT");
        }
        this.infoBean.set("CODE_STRUCTURE", this.groupedsi.getCodeStructure());
        this.infoBean.set("LIBELLE_CODE_STRUCTURE", Structure.getLibelleAffichable(this.groupedsi.getCodeStructure(), ""));
        String langueFiche = "0";
        String codeFiche = this.groupedsi.getCodePageTete();
        int indiceLangue = codeFiche.indexOf(",LANGUE=");
        if (indiceLangue != -1) {
            langueFiche = codeFiche.substring(indiceLangue + 8);
            codeFiche = codeFiche.substring(0, indiceLangue);
        }
        this.infoBean.set("LIBELLE_CODE_PAGE_TETE", PageLibre.getLibelleAffichable(this, codeFiche, langueFiche));
        this.infoBean.set("CODE_PAGE_TETE", this.groupedsi.getCodePageTete());
        this.infoBean.set("SAISIE_CODE", "1");
        this.infoBean.set("SAISIE_TYPE", "1");
        String typeGroupeStructure = "STRUCT";
        if (this.groupedsi.getType().equals("STRUCT")) {
            this.infoBean.set("SAISIE_CODE", "0");
            this.infoBean.set("SAISIE_TYPE", "0");
        }
        if ("MODIFICATION".equals(this.infoBean.getEtatObjet())) {
            this.infoBean.set("SAISIE_CODE", "0");
        }
        this.infoBean.set("SAISIE_STRUCTURE", "1");
        if (this.groupedsi.getType().equals("STRUCT")) {
            this.infoBean.set("SAISIE_STRUCTURE", "0");
        }
        this.infoBean.set("ROLES", this.groupedsi.getRoles());
        this.infoBean.set("CODE_GROUPE_PERE", this.groupedsi.getCodeGroupePere());
        this.infoBean.set("LIBELLE_CODE_GROUPE_PERE", Groupedsi.getIntitule(this.groupedsi.getCodeGroupePere()));
        this.infoBean.set("REQUETE_GROUPE", this.groupedsi.getRequeteGroupe());
        this.infoBean.set("LISTE_REQUETES_GROUPES", Groupedsi.getListeRequetesGroupes());
        Hashtable<String, String> groups = Groupedsi.getListeRequetesGroupesPourAffichage();
        for (String key : groups.keySet()) {
            RequeteGroupeDynamique dynGroupe = RequeteGroupeUtil.instancierRequete(key);
            if (dynGroupe == null) continue;
            dynGroupe.preparerPRINCIPAL(this.infoBean, this.groupedsi);
        }
        this.infoBean.set("GESTION_CACHE", this.groupedsi.getGestionCache());
        this.infoBean.set("DELAI_EXPIRATION_CACHE", this.groupedsi.getDelaiExpirationCache());
        ControleurAffectationRole.preparerPRINCIPAL(this.infoBean, this);
        if (StringUtils.isNotBlank((CharSequence)this.groupedsi.getLibelle())) {
            this.infoBean.setTitreEcran(this.groupedsi.getLibelle());
        }
    }

    private void preparerRECHERCHE() throws Exception {
        this.ecranLogique = ECRAN_RECHERCHE;
        this.infoBean.set("LISTE_TYPES", Libelle.getListe("11", LangueUtil.getDefaultLocale()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean traiterAction() throws Exception {
        try {
            this.ecranLogique = this.infoBean.getEcranLogique();
            this.action = this.infoBean.getActionUtilisateur();
            AutorisationBean autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
            if (!ComposantGroupe.isAutoriseParActionProcessus(autorisations, null)) {
                if (autorisations != null) throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
                this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
                this.infoBean.setEcranLogique("LOGIN");
            } else {
                if (this.etat == 0) {
                    this.initialisation();
                } else if (this.ecranLogique.equals(ECRAN_RECHERCHE)) {
                    this.traiterRECHERCHE();
                } else if (this.ecranLogique.equals(ECRAN_LISTE)) {
                    this.traiterLISTE();
                } else if (this.ecranLogique.equals(ECRAN_PRINCIPAL)) {
                    this.traiterPRINCIPAL();
                } else if (this.ecranLogique.equals(ECRAN_LISTE_PREVISUALISE)) {
                    this.traiterLISTE_PREVISUALISATION();
                } else if (this.ecranLogique.equals(ECRAN_SYNCHRONISER)) {
                    this.traiterSynchro();
                }
                this.infoBean.setEcranLogique(this.ecranLogique);
            }
        }
        catch (Exception e) {
            LOG.error("erreur de traitement sur le processus", (Throwable)e);
            this.infoBean.addMessageErreur(e.toString());
        }
        if (this.etat != 2) return false;
        return true;
    }

    private void traiterSynchro() throws Exception {
        RequeteGroupeDynamique requeteGroupeDyn;
        this.ecranLogique = ECRAN_LISTE;
        String nomRequete = this.infoBean.getString("REQUETE_GROUPE");
        if (nomRequete != null && (requeteGroupeDyn = RequeteGroupeUtil.instancierRequete(nomRequete)) != null && requeteGroupeDyn instanceof RequeteGroupeDynamiqueSynchronisable) {
            ((RequeteGroupeDynamiqueSynchronisable)requeteGroupeDyn).traiterSYNCHRONISATION(this.infoBean);
        }
    }

    private void traiterLISTE_PREVISUALISATION() throws Exception {
        this.ecranLogique = ECRAN_PRINCIPAL;
        this.infoBean.setEcranLogique(this.ecranLogique);
    }

    private void modifierParId() throws Exception {
        String indice = this.infoBean.getString("ID_GROUPE");
        this.groupedsi.setIdGroupedsi(Long.valueOf(indice));
        this.groupedsi.retrieve();
        this.mode = 1;
        this.preparerPRINCIPAL();
    }

    private void supprimerParId() throws Exception {
        String indice = this.infoBean.getString("ID_GROUPE");
        this.groupedsi.setIdGroupedsi(Long.valueOf(indice));
        this.groupedsi.retrieve();
        this.groupedsi.delete();
        Groupeutilisateur.deleteParGroupe(this, this.groupedsi.getCode());
        this.cache.flush();
        this.etat = 2;
    }

    private void traiterLISTE() throws Exception {
        if (this.action.equals("MODIFIER")) {
            this.modifierParId();
        }
        if (this.action.equals("VALIDER")) {
            int indice = Integer.parseInt((String)this.infoBean.get("LISTE_INDICE"));
            this.groupedsi.setIdGroupedsi(this.listeIdentifiant[indice]);
            this.groupedsi.retrieve();
            this.remplirDonneesRecherche();
            this.etat = 2;
        }
        if (this.action.equals("SUPPRIMER")) {
            this.supprimerParId();
        }
        if (this.action.equals("ANNULER")) {
            this.infoBean.set("ID_GROUPEDSI", null);
            this.etat = 2;
        }
    }

    private void traiterPRINCIPAL() throws Exception {
        ControleurAffectationRole.traiterPRINCIPAL(this.infoBean, this);
        RequeteGroupeDynamique dynGroupe = null;
        if (this.infoBean.getString("REQUETE_GROUPE").length() > 0 && !this.infoBean.getString("REQUETE_GROUPE").equals("0000")) {
            for (String key : Groupedsi.getListeRequetesGroupesPourAffichage().keySet()) {
                if (!key.equals(this.infoBean.getString("REQUETE_GROUPE"))) continue;
                dynGroupe = RequeteGroupeUtil.instancierRequete(key);
            }
        }
        if (this.action.equals("VALIDER")) {
            InfosGroupeDsi groupePere;
            if (dynGroupe != null) {
                dynGroupe.traiterPRINCIPAL(this.infoBean, this.groupedsi);
            }
            if (this.infoBean.getString("SAISIE_CODE").equals("1")) {
                this.groupedsi.setCode((String)this.infoBean.get("CODE"));
            }
            if (this.infoBean.getString("SAISIE_TYPE").equals("1")) {
                this.groupedsi.setType((String)this.infoBean.get("TYPE"));
            }
            this.groupedsi.setLibelle((String)this.infoBean.get("LIBELLE"));
            if (this.infoBean.getString("SAISIE_STRUCTURE").equals("1")) {
                this.groupedsi.setCodeStructure((String)this.infoBean.get("CODE_STRUCTURE"));
            }
            this.groupedsi.setCodePageTete((String)this.infoBean.get("CODE_PAGE_TETE"));
            this.groupedsi.setRoles(this.infoBean.getString("ROLES"));
            if (this.infoBean.getString("CODE_GROUPE_PERE").equals(this.infoBean.get("CODE"))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "GROUPE_DSI.ERREUR.GROUPE_PARENT_LUI_MEME"));
            }
            InfosGroupeDsi groupe = Groupedsi.renvoyerItemGroupeDsi(this.infoBean.getString("CODE"));
            if (groupe.contains(groupePere = Groupedsi.renvoyerItemGroupeDsi(this.infoBean.getString("CODE_GROUPE_PERE")))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "GROUPE_DSI.ERREUR.GROUPE_PARENT_FILS"));
            }
            this.groupedsi.setCodeGroupePere(this.infoBean.getString("CODE_GROUPE_PERE"));
            if (this.infoBean.getString("REQUETE_GROUPE").length() > 0 && !this.infoBean.getString("REQUETE_GROUPE").equals("0000")) {
                String cacheDelay = PropertyHelper.getCoreProperty("groupedsi.groupe_dyn.gestion_cache.delay");
                Long delai = StringUtils.isNumeric((CharSequence)cacheDelay) ? Long.parseLong(cacheDelay) : 0L;
                this.groupedsi.setGestionCache("1".equals(PropertyHelper.getCoreProperty("groupedsi.groupe_dyn.gestion_cache.active")) ? "1" : "0");
                this.groupedsi.setDelaiExpirationCache(delai);
                this.groupedsi.setRequeteGroupe(this.infoBean.getString("REQUETE_GROUPE"));
            } else {
                this.groupedsi.setRequeteGroupe("");
            }
            if (this.mode == 0) {
                Chaine.controlerCodeMetier((String)this.infoBean.get("CODE"));
                Groupedsi groupedsi2 = new Groupedsi();
                groupedsi2.setCtx(this);
                groupedsi2.init();
                if (groupedsi2.select(this.groupedsi.getCode(), "", "", "", "") > 0) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "GROUPE_DSI.ERREUR.CODE_EXISTANT"));
                }
                this.groupedsi.add();
                String confirmation = String.format(MessageHelper.getCoreMessage(this.getLocale(), "CONFIRMATION_CREATION_GROUPEDSI"), this.groupedsi.getLibelle());
                this.infoBean.addMessageConfirmation(confirmation);
            } else if (this.mode == 1) {
                this.groupedsi.update();
                String confirmation = String.format(MessageHelper.getCoreMessage(this.getLocale(), "CONFIRMATION_MODIFICATION_GROUPEDSI"), this.groupedsi.getLibelle());
                this.infoBean.addMessageConfirmation(confirmation);
            }
            this.cache.flush();
            this.etat = 2;
        } else if ("SUPPRIMER".equals(this.action)) {
            if ("1".equals(PropertyHelper.getCoreProperty("saisie_limitation.groupes.suppression"))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "GROUPE_DSI.ERREUR.SUPPRESSION_DESACTIVEE"));
            }
            Long idGroupe = Long.parseLong((String)this.infoBean.get("ID_GROUPE"));
            this.groupedsi.setIdGroupedsi(idGroupe);
            this.groupedsi.retrieve();
            this.groupedsi.delete();
            Groupeutilisateur.deleteParGroupe(this, this.groupedsi.getCode());
            String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_SUPPRESSION_GROUPEDSI"), this.groupedsi.getLibelle());
            this.infoBean.addMessageConfirmation(confirmation);
            this.cache.flush();
            this.etat = 2;
        } else if (this.infoBean.getActionUtilisateur().equals("DETAIL") && dynGroupe != null) {
            String requete = this.infoBean.getString("REQUETE_LDAP_" + this.infoBean.getString("REQUETE_GROUPE"));
            Vector<String> vListeUtilisateur = dynGroupe.getVecteurUtilisateursCache("#req#" + requete, null);
            if (vListeUtilisateur.size() > 0) {
                this.preparerLISTE_PREVISUALISATION(vListeUtilisateur, this.infoBean);
            } else {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "GROUPE_DSI.ERREUR.PAS_UTILISATEUR"));
            }
        }
    }

    private void traiterRECHERCHE() throws Exception {
        if (this.action.equals("VALIDER")) {
            this.preparerLISTE();
        }
        if (this.action.equals("ANNULER") && this.mode == 3) {
            this.infoBean.set("ID_GROUPEDSI", null);
            this.etat = 2;
        }
    }

    private void insererRechercheDansInfoBean(InfoBean infoBean) throws Exception {
        ArrayList<CritereRecherche> criteres = new ArrayList<CritereRecherche>();
        CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVide(infoBean, "CODE"));
        CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereChaineAvecLibelle(infoBean, "TYPE", "11"));
        CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVideFormater(infoBean, "LIBELLE"));
        String codeStructure = infoBean.getString("CODE_STRUCTURE");
        if (StringUtils.isNotBlank((CharSequence)infoBean.getString("CODE_STRUCTURE"))) {
            String libelleStructure = codeStructure;
            try {
                libelleStructure = Structure.getLibelleAffichable(codeStructure, LangueUtil.getLangueLocale(this.getLocale()));
            }
            catch (Exception e) {
                LOG.info("pas de structure de code : " + codeStructure);
            }
            criteres.add(new CritereRecherche("CODE_STRUCTURE", codeStructure, libelleStructure));
            criteres.add(new CritereRecherche("LIBELLE_CODE_STRUCTURE", libelleStructure));
        }
        criteres.add(new CritereRecherche("BEAN_RECHERCHE", "groupeDSIDatagrid"));
        infoBean.set("CRITERE_REQUETE", criteres);
    }

    private void preparerLISTE_PREVISUALISATION(Collection<String> liste, InfoBean infoBean) throws Exception {
        Utilisateur utilisateur = new Utilisateur();
        utilisateur.init();
        int nbElem = 0;
        infoBean.set("LISTE_NB_ITEMS", nbElem);
        if (CollectionUtils.isNotEmpty(liste)) {
            try (ContexteDao ctx = new ContexteDao();){
                utilisateur.setCtx(ctx);
                ClauseWhere whereCodeIn = new ClauseWhere(ConditionHelper.in("CODE", liste));
                if (utilisateur.select(whereCodeIn.formaterSQL()) > 0) {
                    while (utilisateur.nextItem()) {
                        infoBean.set("CODE#" + nbElem, utilisateur.getCode());
                        infoBean.set("NOM#" + nbElem, utilisateur.getNom());
                        infoBean.set("PRENOM#" + nbElem, utilisateur.getPrenom());
                        infoBean.set("LIBELLE_STRUCTURE#" + nbElem, Structure.getLibelleAffichable(utilisateur.getCodeRattachement(), "0"));
                        ++nbElem;
                    }
                    infoBean.set("LISTE_NB_ITEMS", nbElem);
                }
            }
        }
        infoBean.setEcranLogique(ECRAN_LISTE_PREVISUALISE);
        this.ecranLogique = ECRAN_LISTE_PREVISUALISE;
    }

    private void remplirDonneesRecherche() throws Exception {
        this.infoBean.set("ID_GROUPEDSI", this.groupedsi.getIdGroupedsi());
        this.infoBean.set("CODE", this.groupedsi.getCode());
        this.infoBean.set("LIBELLE", this.groupedsi.getLibelle());
        this.infoBean.set("TYPE", this.groupedsi.getType());
        this.infoBean.set("CODE_STRUCTURE", this.groupedsi.getCodeStructure());
    }
}

