/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.upload.UploadedFile;
import com.kportal.core.config.MessageHelper;
import com.kportal.extension.module.composant.ComposantLibelle;
import com.univ.objetspartages.cache.CacheLibelleManager;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.util.CritereRecherche;
import com.univ.objetspartages.util.CritereRechercheUtil;
import com.univ.utils.Chaine;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaisieLibelle
extends ProcessusBean {
    private static final Logger LOG = LoggerFactory.getLogger(SaisieLibelle.class);
    private final CacheLibelleManager cache = (CacheLibelleManager)ApplicationContextManager.getCoreContextBean("cacheLibelleManager");
    private int mode = -1;
    private static final int MODE_AJOUT = 0;
    private static final int MODE_MODIFICATION = 1;
    private static final String ECRAN_PRINCIPAL = "PRINCIPAL";
    private static final String ECRAN_LISTE = "LISTE";
    private static final String ECRAN_IMPORT = "SAISIE_IMPORT";
    private static final String ECRAN_RESULTAT = "RESULTAT";
    private static final String ECRAN_RECHERCHE = "RECHERCHE";
    private Libelle libelle = null;

    public SaisieLibelle(InfoBean ciu) {
        super(ciu);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean traiterAction() throws Exception {
        try {
            AutorisationBean autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
            if (!ComposantLibelle.isAutoriseParActionProcessus(autorisations, null)) {
                if (autorisations != null) throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
                this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
                this.infoBean.setEcranLogique("LOGIN");
            } else {
                this.ecranLogique = this.infoBean.getEcranLogique();
                this.action = this.infoBean.getActionUtilisateur();
                if (this.etat == 0) {
                    this.initialisation();
                } else {
                    if (this.ecranLogique.equals(ECRAN_RECHERCHE)) {
                        this.traiterRECHERCHE();
                    }
                    if (this.ecranLogique.equals(ECRAN_PRINCIPAL)) {
                        this.traiterPRINCIPAL();
                    } else if (this.ecranLogique.equals(ECRAN_IMPORT)) {
                        this.traiterIMPORT();
                    }
                }
                this.infoBean.setEcranLogique(this.ecranLogique);
            }
        }
        catch (Exception e) {
            LOG.error("erreur lors du traitement des libelles", (Throwable)e);
            this.infoBean.addMessageErreur(e.toString());
        }
        if (this.etat != 2) return false;
        return true;
    }

    private void initialisation() throws Exception {
        this.libelle = new Libelle();
        this.libelle.setCtx(this);
        this.libelle.init();
        this.etat = 1;
        if (this.action.equals("AJOUTER")) {
            this.mode = 0;
            this.infoBean.setEtatObjet("CREATION");
            this.preparerPRINCIPAL();
        } else if (this.action.equals("MODIFIER")) {
            this.mode = 1;
            this.infoBean.setEtatObjet("MODIFICATION");
            this.traiterRECHERCHE();
        } else if (this.action.equals("RECHERCHER")) {
            this.mode = 1;
            this.infoBean.setEtatObjet("MODIFICATION");
            this.preparerRECHERCHE();
        } else if (this.action.equals("IMPORTER")) {
            this.infoBean.setEtatObjet("CREATION");
            this.ecranLogique = ECRAN_IMPORT;
        } else if (this.action.equals("MODIFIERPARID")) {
            this.mode = 1;
            this.retrouveLibelleDepuisInfoBean();
            this.preparerPRINCIPAL();
        } else if (this.action.equals("SUPPRIMERPARID")) {
            this.retrouveLibelleDepuisInfoBean();
            this.supprimerLibelle();
            this.preparerPRINCIPAL();
            this.etat = 2;
            this.cache.flushListeInfosLibelles();
        }
    }

    private void preparerRECHERCHE() {
        this.ecranLogique = ECRAN_RECHERCHE;
        this.infoBean.set("LISTE_TYPES_LIBELLES", this.cache.getListeTypesLibelles());
        Hashtable<String, String> langues = LangueUtil.getListeLangues(this.getLocale());
        this.infoBean.set("LISTE_LANGUES", langues);
    }

    private void retrouveLibelleDepuisInfoBean() throws Exception {
        String indice = this.infoBean.getString("ID_LIBELLE");
        this.libelle.init();
        this.libelle.setIdLibelle(Long.valueOf(indice));
        this.libelle.retrieve();
    }

    private void traiterRECHERCHE() throws Exception {
        ArrayList<CritereRecherche> criteres = new ArrayList<CritereRecherche>();
        CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVide(this.infoBean, "LIBELLE"));
        CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVide(this.infoBean, "CODE"));
        CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVideSansValeurDefaut(this.infoBean, "LANGUE"));
        String type = this.infoBean.getString("TYPE");
        if (StringUtils.isNotBlank((CharSequence)type) && !"0000".equals(type)) {
            criteres.add(new CritereRecherche("TYPE", type, this.cache.getListeTypesLibelles().get(type)));
        }
        criteres.add(new CritereRecherche("BEAN_RECHERCHE", "libelleDatagrid"));
        this.infoBean.set("CRITERE_REQUETE", criteres);
        this.ecranLogique = ECRAN_LISTE;
    }

    private void preparerPRINCIPAL() throws Exception {
        this.ecranLogique = ECRAN_PRINCIPAL;
        this.infoBean.set("ACTION_DEMANDEE", this.action);
        this.infoBean.set("TYPE", this.libelle.getType());
        this.infoBean.set("LISTE_TYPES_LIBELLES", this.cache.getListeTypesLibelles());
        if (this.mode == 0) {
            this.libelle.setCode(this.determinerCode());
        }
        this.infoBean.set("CODE", this.libelle.getCode());
        Hashtable<String, String> langues = LangueUtil.getListeLangues(this.getLocale());
        this.infoBean.set("LISTE_LANGUES", langues);
        for (String codeLangue : langues.keySet()) {
            Libelle libelle2 = new Libelle();
            libelle2.setCtx(this);
            ClauseWhere where = new ClauseWhere(ConditionHelper.egalVarchar("TYPE", this.libelle.getType()));
            where.and(ConditionHelper.egalVarchar("CODE", this.libelle.getCode()));
            where.and(ConditionHelper.egalVarchar("LANGUE", codeLangue));
            libelle2.select(where.formaterSQL());
            libelle2.nextItem();
            this.infoBean.set("LIBELLE#" + codeLangue, libelle2.getLibelle() == null ? "" : libelle2.getLibelle());
        }
        String langueInfoBean = this.infoBean.getString("LANGUE_LIBELLE");
        if (StringUtils.isNotBlank((CharSequence)langueInfoBean) && StringUtils.isNumeric((CharSequence)langueInfoBean)) {
            this.libelle.setLangue(langueInfoBean);
        }
        if (StringUtils.isBlank((CharSequence)this.libelle.getLangue())) {
            this.libelle.setLangue("0");
        }
        this.infoBean.set("LANGUE", this.libelle.getLangue());
        if (StringUtils.isNotBlank((CharSequence)this.libelle.getLibelleAffichable())) {
            this.infoBean.setTitreEcran(this.libelle.getLibelleAffichable());
        }
    }

    private void supprimerLibelle() throws Exception {
        Libelle libelle2 = new Libelle();
        libelle2.setCtx(this);
        ClauseWhere where = new ClauseWhere(ConditionHelper.egalVarchar("CODE", this.libelle.getCode()));
        where.and(ConditionHelper.egalVarchar("TYPE", this.libelle.getType()));
        while (libelle2.select(where.formaterSQL()) > 0) {
            libelle2.nextItem();
            this.libelle.setIdLibelle(libelle2.getIdLibelle());
            this.libelle.delete();
        }
        String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_SUPPRESSION_LIBELLE"), this.libelle.getCode());
        this.infoBean.addMessageConfirmation(confirmation);
    }

    private void ajouterLibelle() throws Exception {
        Chaine.controlerCodeMetier((String)this.infoBean.get("CODE"));
        Libelle libelle2 = new Libelle();
        libelle2.setCtx(this);
        ClauseWhere where = new ClauseWhere(ConditionHelper.egalVarchar("CODE", this.infoBean.getString("CODE")));
        where.and(ConditionHelper.egalVarchar("TYPE", this.infoBean.getString("TYPE")));
        if (libelle2.select(where.formaterSQL()) > 0) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "SAISIE_LIBELLE.ERREUR.CODE_EXISTANT"));
        }
        Hashtable<String, String> listeLangue = LangueUtil.getListeLangues(this.getLocale());
        int nbLibelleSaisie = 0;
        for (String codeLangue : listeLangue.keySet()) {
            String valeurLibelle = this.infoBean.getString("LIBELLE#" + codeLangue);
            if (!StringUtils.isNotBlank((CharSequence)valeurLibelle)) continue;
            this.libelle.init();
            this.libelle.setType(this.infoBean.getString("TYPE"));
            this.libelle.setCode(this.infoBean.getString("CODE"));
            this.libelle.setLangue(codeLangue);
            this.libelle.setLibelle(valeurLibelle);
            this.libelle.add();
            ++nbLibelleSaisie;
        }
        if (nbLibelleSaisie == 0) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage("ERREUR_SAISIE_SANS_LIBELLE"));
        }
        String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_CREATION_LIBELLE"), this.libelle.getCode());
        this.infoBean.addMessageConfirmation(confirmation);
    }

    private void mettreLibelleAJour() throws Exception {
        Hashtable<String, String> listeLangue = LangueUtil.getListeLangues(this.getLocale());
        ArrayList<Long> idsLibelleToDelete = new ArrayList<Long>();
        int nbLibelleSaisie = 0;
        for (String codeLangue : listeLangue.keySet()) {
            String valeurLibelle = this.infoBean.getString("LIBELLE#" + codeLangue);
            ClauseWhere where = new ClauseWhere(ConditionHelper.egalVarchar("CODE", this.infoBean.getString("CODE")));
            where.and(ConditionHelper.egalVarchar("TYPE", this.infoBean.getString("TYPE")));
            where.and(ConditionHelper.egalVarchar("LANGUE", codeLangue));
            Libelle libellePourRequete = new Libelle();
            libellePourRequete.setCtx(this);
            if (StringUtils.isNotBlank((CharSequence)valeurLibelle)) {
                this.libelle.init();
                this.libelle.setType(this.infoBean.getString("TYPE"));
                this.libelle.setCode(this.infoBean.getString("CODE"));
                this.libelle.setLangue(codeLangue);
                this.libelle.setLibelle(valeurLibelle);
                if (libellePourRequete.select(where.formaterSQL()) > 0) {
                    libellePourRequete.nextItem();
                    this.libelle.setIdLibelle(libellePourRequete.getIdLibelle());
                    this.libelle.update();
                } else {
                    this.libelle.add();
                }
                ++nbLibelleSaisie;
                continue;
            }
            if (libellePourRequete.select(where.formaterSQL()) <= 0) continue;
            libellePourRequete.nextItem();
            idsLibelleToDelete.add(libellePourRequete.getIdLibelle());
        }
        if (nbLibelleSaisie == 0) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage("ERREUR_SAISIE_SANS_LIBELLE"));
        }
        for (Long idLibelle : idsLibelleToDelete) {
            this.libelle.setIdLibelle(idLibelle);
            this.libelle.delete();
        }
        String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_MODIFICATION_LIBELLE"), this.libelle.getCode());
        this.infoBean.addMessageConfirmation(confirmation);
    }

    private void traiterPRINCIPAL() throws Exception {
        if (this.action == "SUPPRIMER") {
            this.supprimerLibelle();
        } else {
            this.verifierLibelle();
            if (this.mode == 0) {
                this.ajouterLibelle();
            } else if (this.mode == 1) {
                this.mettreLibelleAJour();
            }
        }
        this.etat = 2;
        this.cache.flushListeInfosLibelles();
    }

    private void verifierLibelle() throws Exception {
        Hashtable<String, String> listeLangue = LangueUtil.getListeLangues(this.getLocale());
        for (String codeLangue : listeLangue.keySet()) {
            String lib = this.infoBean.getString("LIBELLE#" + codeLangue);
            if (lib.indexOf(",") <= -1 && lib.indexOf(";") <= -1) continue;
            throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "SAISIE_LIBELLE.ERREUR.REMPLACEMENT_CARACTERE"));
        }
    }

    private String determinerCode() {
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuffer code = new StringBuffer();
        for (int i = 0; i < 8; ++i) {
            int pos = (int)(Math.random() * (double)"ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length());
            if (pos >= "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length()) {
                pos = 0;
            }
            code.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".charAt(pos));
        }
        return code.toString();
    }

    private void traiterIMPORT() throws Exception {
        if (this.action.equals("VALIDER")) {
            UploadedFile file = (UploadedFile)this.infoBean.get("LIBELLE_FICHIER_FILE");
            File f = null;
            if (file == null || file.getContentFilename().length() == 0) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "SAISIE_LIBELLE.ERREUR.FICHIER_INEXISTANT"));
            }
            f = file.getTemporaryFile();
            FileReader freader = new FileReader(f);
            try (BufferedReader fichLogique = new BufferedReader(freader);){
                String ligneLue = fichLogique.readLine();
                int nbLibelle = 0;
                int nbLigne = 0;
                ArrayList<Integer> libellesKo = new ArrayList<Integer>();
                while (ligneLue != null) {
                    ++nbLigne;
                    String typeLibelle = "";
                    String code = "";
                    String libelle = "";
                    String langue = "";
                    StrTokenizer st = StrTokenizer.getCSVInstance((String)ligneLue.substring(1, ligneLue.length() - 1));
                    st.setIgnoreEmptyTokens(false);
                    st.setDelimiterString("','");
                    int ind = 0;
                    while (st.hasNext()) {
                        String item = st.nextToken();
                        if (ind == 0) {
                            typeLibelle = item;
                        }
                        if (ind == 1) {
                            code = item;
                        }
                        if (ind == 2) {
                            libelle = item;
                        }
                        if (ind == 3) {
                            langue = item;
                        }
                        ++ind;
                    }
                    if (typeLibelle.length() > 0 && code.length() > 0 && libelle.length() > 0 && langue.length() > 0) {
                        ++nbLibelle;
                        Libelle.addLibelle(this, typeLibelle, code, libelle, langue);
                    } else {
                        libellesKo.add(nbLigne);
                    }
                    ligneLue = fichLogique.readLine();
                }
                this.cache.flushListeInfosLibelles();
                if (nbLibelle > 0) {
                    String resultatImport;
                    if (nbLibelle == 1) {
                        resultatImport = MessageHelper.getCoreMessage("BO_LIBELLE_RESULTAT_IMPORT_LIBELLE");
                    } else {
                        resultatImport = MessageHelper.getCoreMessage("BO_LIBELLE_RESULTAT_IMPORT_LIBELLES");
                        resultatImport = String.format(resultatImport, nbLibelle);
                    }
                    this.infoBean.addMessageConfirmation(resultatImport);
                    this.traiterRECHERCHE();
                }
                if (CollectionUtils.isNotEmpty(libellesKo)) {
                    this.infoBean.addMessageAlerte(MessageHelper.getCoreMessage("BO_LIBELLE_RESULTAT_KO") + " [" + StringUtils.join(libellesKo, (String)"; ") + "]");
                    this.ecranLogique = ECRAN_IMPORT;
                }
            }
            catch (Exception e) {
                LOG.error("Format du fichier d'import des libell\u00e9s invalide", (Throwable)e);
                this.infoBean.addMessageErreur(MessageHelper.getCoreMessage("BO_LIBELLE_RESULTAT_ERREUR"));
                this.infoBean.setEtatObjet("CREATION");
                this.ecranLogique = ECRAN_IMPORT;
            }
        }
    }

    private String enleverQuote(String chaine) {
        String res = chaine.trim();
        if (res.charAt(0) == '\'') {
            res = res.substring(1);
        }
        if (res.charAt(res.length() - 1) == '\'') {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }
}

