/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.ClassBeanManager;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.core.ProcessusHelper;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.jsbsoft.jtf.upload.UploadedFile;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.kportal.util.compress.Zip;
import com.univ.mediatheque.Mediatheque;
import com.univ.mediatheque.SpecificUrl;
import com.univ.mediatheque.UsingLibelleMedia;
import com.univ.mediatheque.utils.MediathequeHelper;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Ressource;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.SpecificMedia;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.FileUtil;
import com.univ.utils.PhotoUtil;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseLimit;
import com.univ.utils.sql.clause.ClauseWhere;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaisieMedia
extends ProcessusBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaisieMedia.class);
    private int etat = -1;
    private static final int ETAT_CREATION = 0;
    private static final int ETAT_MODIFICATION = 1;
    public static final String MODE_SELECTION = "SELECTION";
    public static final String MODE_INSERTION = "INSERTION";
    public static final String MODE_ADMINISTRATION = "ADMINISTRATION";
    private static final String ID_ONGLET_RESSOURCE = "0";
    private static final String ID_ONGLET_RESSOURCE_SELECTION = "0";
    private static final String ECRAN_RECHERCHE = "RECHERCHE";
    private static final String ECRAN_SELECTION = "SELECTION";
    private static final String ECRAN_LISTE = "LISTE";
    private static final String ECRAN_PRINCIPAL = "PRINCIPAL";
    private static final String ECRAN_UPLOAD = "UPLOAD";
    private static final String ACTION_CONTROLER_RESSOURCE = "CONTROLER_RESSOURCE";
    private static final String ACTION_SELECTIONNER_RESSOURCE = "SELECTIONNER_RESSOURCE";
    private static final String ACTION_INSERER_RESSOURCE = "INSERER_RESSOURCE";
    private static final String ECRAN_CONFIRMATION = "CONFIRMATION";
    private static final String ECRAN_APERCU = "APERCU";
    private static final String ECRAN_REFERENCES = "REFERENCES";
    private AutorisationBean autorisations;
    private Media media;
    private Mediatheque mediatheque;

    public SaisieMedia(InfoBean infoBean) {
        super(infoBean);
    }

    @Override
    public boolean traiterAction() throws Exception {
        boolean saisieFront = Boolean.parseBoolean(this.infoBean.getString("SAISIE_FRONT"));
        this.autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        if (this.autorisations == null && !saisieFront) {
            this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
            this.infoBean.setEcranLogique("LOGIN");
        } else {
            if (this.autorisations != null) {
                ((Hashtable)this.getDatas()).put("AUTORISATIONS", this.autorisations);
            }
            try {
                this.ecranLogique = this.infoBean.getEcranLogique();
                this.action = this.infoBean.getActionUtilisateur();
                this.infoBean.remove("MESSAGE_CONFIRMATION");
                this.media = new Media();
                this.media.setCtx(this);
                this.media.init();
                this.mediatheque = Mediatheque.getInstance();
                this.etat = 1;
                if (this.ecranLogique == null) {
                    if ("AJOUTER".equals(this.action)) {
                        this.etat = 0;
                        this.infoBean.setEtatObjet("CREATION");
                        this.infoBean.remove("CONTROLE_RESSOURCE");
                        this.preparerPRINCIPAL();
                    } else if ("MODIFIER".equals(this.action)) {
                        if (!this.autorisations.possedePermission(new PermissionBean("TECH", "pho", "M")) && !this.media.getCodeRedacteur().equals(this.autorisations.getCode())) {
                            throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
                        }
                        this.etat = 1;
                        this.media.setIdMedia(new Long(this.infoBean.getString("ID_MEDIA")));
                        this.media.retrieve();
                        this.infoBean.setTitreEcran(StringUtils.isEmpty((CharSequence)this.media.getTitre()) ? this.media.getSource() : this.media.getTitre());
                        this.infoBean.setEtatObjet("MODIFICATION");
                        this.infoBean.set("CONTROLE_RESSOURCE", "true");
                        this.preparerReferences();
                        this.preparerPRINCIPAL();
                    } else if (ACTION_CONTROLER_RESSOURCE.equals(this.action)) {
                        this.infoBean.remove("CONTROLE_RESSOURCE");
                        this.controlerMedia();
                    } else if ("SELECTIONNER".equals(this.action)) {
                        if (this.autorisations == null && !saisieFront) {
                            this.ecranLogique = "LOGIN";
                        } else {
                            this.infoBean.set("MODE", "SELECTION");
                            this.preparerINSERTION();
                            this.preparerRECHERCHE();
                            this.ecranLogique = "SELECTION";
                        }
                    } else if ("INSERER".equals(this.action)) {
                        if (this.autorisations == null) {
                            this.ecranLogique = "LOGIN";
                        } else {
                            this.infoBean.set("MODE", MODE_INSERTION);
                            this.preparerINSERTION();
                            this.preparerRECHERCHE();
                            this.ecranLogique = "SELECTION";
                        }
                    } else if ("RECHERCHER".equals(this.action)) {
                        this.infoBean.setEtatObjet(ECRAN_RECHERCHE);
                        this.preparerRECHERCHE();
                    } else if ("IMPORTER".equals(this.action)) {
                        this.infoBean.setEtatObjet("CREATION");
                        this.preparerUPLOAD();
                    } else if (ECRAN_REFERENCES.equals(this.action)) {
                        this.preparerReferences();
                    }
                } else if (ACTION_CONTROLER_RESSOURCE.equals(this.action)) {
                    this.etat = 0;
                    this.infoBean.remove("CONTROLE_RESSOURCE");
                    this.controlerMedia();
                } else if ("AJOUTER".equals(this.action)) {
                    this.etat = 0;
                    this.infoBean.setEtatObjet("CREATION");
                    this.infoBean.remove("CONTROLE_RESSOURCE");
                    this.preparerPRINCIPAL();
                } else if ("SUPPRIMER".equals(this.action)) {
                    this.traiterPRINCIPAL();
                } else if ("RECHERCHER".equals(this.action)) {
                    this.infoBean.setEtatObjet(ECRAN_RECHERCHE);
                    this.traiterRECHERCHE();
                } else if (ACTION_SELECTIONNER_RESSOURCE.equals(this.action)) {
                    this.infoBean.set("MODE", "SELECTION");
                    this.selectionnerMedia();
                } else if (ECRAN_APERCU.equals(this.action)) {
                    this.preparerApercu();
                } else if (ECRAN_REFERENCES.equals(this.action)) {
                    this.preparerReferences();
                } else if (ECRAN_RECHERCHE.equals(this.action)) {
                    this.preparerRECHERCHE();
                } else if (ACTION_INSERER_RESSOURCE.equals(this.action)) {
                    this.infoBean.set("MODE", MODE_INSERTION);
                    this.insererMedia();
                } else if ("MODIFIER".equals(this.action)) {
                    if (this.autorisations == null || !this.autorisations.possedePermission(new PermissionBean("TECH", "pho", "M")) && !this.media.getCodeRedacteur().equals(this.autorisations.getCode())) {
                        throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
                    }
                    this.etat = 1;
                    this.media.setIdMedia(new Long(this.infoBean.getString("ID_MEDIA")));
                    this.media.retrieve();
                    this.infoBean.setEtatObjet("MODIFICATION");
                    this.infoBean.set("CONTROLE_RESSOURCE", "true");
                    this.preparerReferences();
                    this.preparerPRINCIPAL();
                } else if (ECRAN_RECHERCHE.equals(this.ecranLogique)) {
                    this.traiterRECHERCHE();
                } else if (ECRAN_LISTE.equals(this.ecranLogique)) {
                    this.traiterRECHERCHE();
                } else if (ECRAN_PRINCIPAL.equals(this.ecranLogique)) {
                    this.traiterPRINCIPAL();
                } else if (ECRAN_UPLOAD.equals(this.ecranLogique)) {
                    this.traiterUPLOAD();
                }
                this.infoBean.setEcranLogique(this.ecranLogique);
            }
            catch (Exception e) {
                LOGGER.error("An error occured during the process", (Throwable)e);
                this.infoBean.addMessageErreur(e.toString());
            }
        }
        return this.etat == 2;
    }

    private void preparerPRINCIPAL() throws Exception {
        this.ecranLogique = ECRAN_PRINCIPAL;
        this.infoBean.set("SUPPRESSION_MEDIA", "0");
        this.infoBean.set("AJOUT_MEDIA", "0");
        if (this.autorisations != null) {
            Vector<Perimetre> vPerimetre = this.autorisations.getListePerimetres(new PermissionBean("TECH", "pho", "S"));
            if (CollectionUtils.isNotEmpty(vPerimetre) || this.media.getCodeRedacteur().equals(this.autorisations.getCode())) {
                this.infoBean.set("SUPPRESSION_MEDIA", "1");
            }
            if (CollectionUtils.isNotEmpty(vPerimetre = this.autorisations.getListePerimetres(new PermissionBean("TECH", "pho", "C")))) {
                this.infoBean.set("AJOUT_MEDIA", "1");
            }
        } else {
            this.ecranLogique = "LOGIN";
            return;
        }
        this.etat = this.media.getIdMedia().equals(new Long(0L)) ? 0 : 1;
        this.infoBean.set("ID_MEDIA", this.media.getIdMedia().toString());
        this.infoBean.set("URL_RESSOURCE", this.media.getUrlAbsolue());
        this.infoBean.set("URL_VIGNETTE", this.media.getUrlVignetteAbsolue());
        String extensions = "";
        SpecificMedia specificMedia = this.mediatheque.getRessource("photo");
        for (String ext : specificMedia.getExtensions()) {
            if (extensions.length() > 0) {
                extensions = extensions + ",";
            }
            extensions = extensions + ext;
        }
        this.infoBean.set("KEY_FILE_EXTENSIONS_VIGNETTE", extensions);
        this.infoBean.set("SOURCE", this.media.getSource());
        this.infoBean.set("FORMAT", this.media.getFormat());
        this.infoBean.set("TITRE", this.media.getTitre());
        this.infoBean.set("LEGENDE", this.media.getLegende());
        this.infoBean.set("DESCRIPTION", this.media.getDescription());
        this.infoBean.set("AUTEUR", this.media.getAuteur());
        this.infoBean.set("COPYRIGHT", this.media.getCopyright());
        this.setTraductionInfoBean();
        DecimalFormat df = new DecimalFormat("#########0.##");
        String unite = "Ko";
        float fTaille = this.media.getPoids().intValue();
        if (this.media.getPoids() >= 1024) {
            fTaille = (float)this.media.getPoids().intValue() / 1024.0f;
            unite = "Mo";
        }
        String libelleTaille = df.format(fTaille) + "&nbsp;" + unite;
        this.infoBean.set("POIDS", libelleTaille);
        if (this.infoBean.getString("TYPE_RESSOURCE") != null) {
            this.infoBean.set("TYPE_RESSOURCE_PREV", this.infoBean.getString("TYPE_RESSOURCE"));
        }
        this.infoBean.set("TYPE_RESSOURCE", this.media.getTypeRessource());
        if (this.etat == 0) {
            for (String sKeyType : this.mediatheque.getTypesMedia().keySet()) {
                specificMedia = this.mediatheque.getRessource(sKeyType);
                this.infoBean.set("LISTE_TYPE_MEDIA_" + sKeyType.toUpperCase(), Libelle.getListe(specificMedia.getCodeTypeLibelle(), LangueUtil.getDefaultLocale()));
                this.infoBean.set("TEMPLATE_JSP_" + sKeyType.toUpperCase(), specificMedia.getJspSaisie());
                this.infoBean.set("TEMPLATE_JSP_APERCU_" + sKeyType.toUpperCase(), specificMedia.getJspApercu());
                this.infoBean.set("TEMPLATE_JSP_INSERTION_" + sKeyType.toUpperCase(), specificMedia.getJspInsertion());
            }
            this.infoBean.set("LISTE_TYPE_RESSOURCES", this.mediatheque.getTypesRessourcesAffichables());
            String isLocal = this.infoBean.get("IS_LOCAL", String.class);
            if (!StringUtils.isNotBlank((CharSequence)isLocal)) {
                this.infoBean.set("IS_LOCAL", "true");
            }
            if ("true".equals(this.infoBean.get("IS_LOCAL"))) {
                this.infoBean.remove("TYPE_RESSOURCE_PREV");
            }
        } else {
            specificMedia = this.mediatheque.getRessource(this.media.getTypeRessource().toLowerCase());
            this.infoBean.set("LIBELLE_TYPE_RESSOURCE", specificMedia.getLibelleAffichable());
            this.infoBean.set("TYPE_MEDIA_" + this.media.getTypeRessource().toUpperCase(), this.media.getTypeMedia());
            this.infoBean.set("LISTE_TYPE_MEDIA_" + this.media.getTypeRessource().toUpperCase(), Libelle.getListe(specificMedia.getCodeTypeLibelle(), LangueUtil.getDefaultLocale()));
            this.infoBean.set("TEMPLATE_JSP_" + this.media.getTypeRessource().toUpperCase(), specificMedia.getJspSaisie());
            this.infoBean.set("TEMPLATE_JSP_APERCU_" + this.media.getTypeRessource().toUpperCase(), specificMedia.getJspApercu());
            this.infoBean.set("TEMPLATE_JSP_INSERTION_" + this.media.getTypeRessource().toUpperCase(), specificMedia.getJspInsertion());
            specificMedia.prepareMedia(this.infoBean, this.media);
            this.infoBean.set("IS_LOCAL", this.media.isLocal() ? "true" : "false");
            if (this.media.isLocal()) {
                String tag = "[id-image]" + this.media.getIdMedia() + "[/id-image]";
                HttpSession session = this.infoBean.getSessionHttp();
                SessionUtilisateur sessionUtilisateur = (SessionUtilisateur)session.getAttribute("session");
                Hashtable<String, Object> infosSession = sessionUtilisateur.getInfos();
                infosSession.put(this.media.getUrlAbsolue(), true);
                this.infoBean.set("URL_APERCU", "/servlet/com.univ.utils.LectureImageToolbox?TAG=" + tag);
            } else {
                SpecificUrl specificUrl = this.mediatheque.getSpecificUrl(this.media.getUrlAbsolue());
                if (specificUrl != null) {
                    this.infoBean.set("SPECIFIC_URL", "1");
                }
                this.infoBean.set("URL_APERCU", this.media.getUrlAbsolue());
            }
        }
        this.infoBean.set("CODE_RATTACHEMENT", this.media.getCodeRattachement());
        this.infoBean.set("LIBELLE_CODE_RATTACHEMENT", Structure.getLibelleAffichable(this.media.getCodeRattachement(), ""));
        this.infoBean.set("CODE_RUBRIQUE", this.media.getCodeRubrique());
        this.infoBean.set("LIBELLE_CODE_RUBRIQUE", Rubrique.renvoyerItemRubrique(this.media.getCodeRubrique()).getIntitule());
        this.infoBean.set("DATE_CREATION", this.media.getDateCreation());
        this.infoBean.set("THEMATIQUE", this.media.getThematique());
        this.infoBean.set("LIBELLE_THEMATIQUE", this.media.getLibelleThematique());
        this.infoBean.set("LISTE_THEMATIQUES", Libelle.getListe("04", LangueUtil.getDefaultLocale()));
        this.infoBean.set("CODE_REDACTEUR", this.media.getCodeRedacteur());
        this.infoBean.set("LIBELLE_CODE_REDACTEUR", Utilisateur.getLibelle(this.media.getCodeRedacteur()));
        this.infoBean.set("META_KEYWORDS", this.media.getMetaKeywords());
        if (this.etat == 0) {
            String codeRedacteur = (String)this.getGp().getSessionUtilisateur().getInfos().get("CODE");
            this.infoBean.set("CODE_REDACTEUR", codeRedacteur);
            this.infoBean.set("LIBELLE_CODE_REDACTEUR", Utilisateur.getLibelle(codeRedacteur));
        }
        String action = "C";
        if (this.etat == 1) {
            action = "M";
        }
        this.preparerPerimetre("pho", action);
        if (StringUtils.isNotBlank((CharSequence)this.media.getLibelleAffichable())) {
            this.infoBean.setTitreEcran(this.media.getLibelleAffichable());
        }
    }

    private void preparerPerimetre(String permission, String action) throws Exception {
        if (this.autorisations == null) {
            this.ecranLogique = "LOGIN";
            return;
        }
        this.infoBean.set("GRS_FILTRE_ARBRE_NOM_CODE_RUBRIQUE", "CODE_RUBRIQUE");
        this.infoBean.set("GRS_FILTRE_ARBRE_NOM_CODE_RATTACHEMENT", "CODE_RATTACHEMENT");
        this.infoBean.set("GRS_SAUVEGARDE_CODE_RUBRIQUE", this.media.getCodeRubrique());
        this.infoBean.set("GRS_SAUVEGARDE_CODE_RATTACHEMENT", this.media.getCodeRattachement());
        this.infoBean.set("GRS_PERMISSION_TYPE", "TECH");
        this.infoBean.set("GRS_PERMISSION_OBJET", permission);
        this.infoBean.set("GRS_PERMISSION_ACTION", action);
        if ("pho".equals(permission) && "C".equals(action)) {
            boolean initProcessus = false;
            if (this.infoBean.get("CODE_RUBRIQUE") != null && this.infoBean.getString("CODE_RUBRIQUE").length() > 0) {
                initProcessus = true;
            }
            if (this.infoBean.getString("CODE_RATTACHEMENT") != null && this.infoBean.getString("CODE_RATTACHEMENT").length() > 0) {
                initProcessus = true;
            }
            String structureParDefaut = "";
            String rubriqueParDefaut = "";
            if (!initProcessus && this.autorisations != null) {
                String structureUtilisateur;
                int niveauRubriqueCourante = 10;
                Vector<Perimetre> listePerimetres = this.autorisations.getListePerimetres(new PermissionBean("TECH", "pho", "C"));
                for (Perimetre perimetreCourant : listePerimetres) {
                    InfosRubriques infosRubrique;
                    int niveauRubrique;
                    if (!"".equals(perimetreCourant.getCodeEspaceCollaboratif()) || perimetreCourant.getCodeRubrique().length() <= 0 || (niveauRubrique = (infosRubrique = Rubrique.renvoyerItemRubrique(perimetreCourant.getCodeRubrique())).getNiveau()) >= niveauRubriqueCourante) continue;
                    niveauRubriqueCourante = niveauRubrique;
                    rubriqueParDefaut = perimetreCourant.getCodeRubrique();
                    structureParDefaut = perimetreCourant.getCodeStructure();
                }
                if (rubriqueParDefaut.length() > 0) {
                    this.infoBean.set("CODE_RUBRIQUE", rubriqueParDefaut);
                    this.infoBean.set("LIBELLE_CODE_RUBRIQUE", Rubrique.renvoyerItemRubrique(rubriqueParDefaut).getIntitule());
                }
                if ("".equals(structureParDefaut) && (structureUtilisateur = this.autorisations.getCodeStructure()).length() > 0 && this.autorisations.possedePermission(new PermissionBean("TECH", "pho", "C"), new Perimetre(structureUtilisateur, rubriqueParDefaut, "*", "*", ""))) {
                    structureParDefaut = structureUtilisateur;
                }
                if (structureParDefaut.length() > 0) {
                    this.infoBean.set("CODE_RATTACHEMENT", structureParDefaut);
                    this.infoBean.set("LIBELLE_CODE_RATTACHEMENT", Structure.getLibelleAffichable(structureParDefaut, "0"));
                }
            }
        }
    }

    private void traiterPRINCIPAL() throws Exception {
        if (this.infoBean.getEtatObjet().equals("CREATION")) {
            if (this.infoBean.getString("URL_RESSOURCE").length() == 0) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("MEDIATHEQUE.MEDIA.ERREUR.FICHIER_SOURCE_OBLIGATOIRE"));
            }
            this.media.init();
            this.etat = 0;
            this.media.setDateCreation(new Date(System.currentTimeMillis()));
            if (this.autorisations != null && (this.infoBean.get("MUTUALISE") == null && this.infoBean.get("MODE") == null || this.infoBean.get("MODE") != null && "1".equals(this.infoBean.get("MUTUALISE")))) {
                this.media.setIsMutualise("0");
            } else {
                String secure = PropertyHelper.getCoreProperty("mediatheque.secure." + this.infoBean.getString("TYPE_RESSOURCE").toLowerCase());
                if ("2".equals(secure)) {
                    this.media.setIsMutualise("2");
                } else {
                    this.media.setIsMutualise("1");
                }
            }
        } else {
            this.media.setIdMedia(new Long(this.infoBean.getString("ID_MEDIA")));
            this.media.retrieve();
            this.etat = 1;
        }
        if (this.action.equals("SUPPRIMER")) {
            File file;
            if (this.autorisations != null) {
                if (!this.autorisations.possedePermission(new PermissionBean("TECH", "pho", "S"), new Perimetre(this.media.getCodeRattachement(), this.media.getCodeRubrique(), "*", "*", ""))) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE") + " : " + MessageHelper.getCoreMessage("AUTORISATION_SUPPRESSION_HORS_PERIMETRE"));
                }
            } else {
                this.ecranLogique = "LOGIN";
                return;
            }
            Ressource ressource = new Ressource();
            ressource.setCtx(this);
            ressource.init();
            if (ressource.select("WHERE ID_MEDIA ='" + this.media.getIdMedia() + "' AND ETAT='1'") > 0) {
                throw new ErreurApplicative("Impossible de supprimer cette ressource car elle est utilis\u00e9e");
            }
            for (UsingLibelleMedia bean : ClassBeanManager.getInstance().getBeanOfType(UsingLibelleMedia.class)) {
                if (!bean.getCodesLibelleMedia().contains(this.media.getTypeMedia())) continue;
                bean.checkCodesLibelleMedia(this, this.media.getIdMedia());
            }
            if (this.media.isLocal() && (file = new File(this.media.getPathAbsolu())).exists()) {
                file.delete();
            }
            this.media.delete();
            this.infoBean.addMessageConfirmation("La suppression de \u00ab" + (StringUtils.isNotEmpty((CharSequence)this.media.getTitre()) ? this.media.getTitre() : this.media.getUrl()) + "\u00bb a bien \u00e9t\u00e9 effectu\u00e9e.");
            if (ECRAN_RECHERCHE.equals(this.infoBean.getEtatObjet())) {
                this.traiterRECHERCHE();
            } else {
                this.infoBean.remove("TYPE_RESSOURCE");
                this.preparerRECHERCHE();
            }
        }
        if (this.action.equals("ENREGISTRER")) {
            Ressource ressource;
            SpecificMedia specificMedia;
            String codeRubrique = this.infoBean.getString("CODE_RUBRIQUE");
            String codeRattachement = this.infoBean.getString("CODE_RATTACHEMENT");
            if (this.ecranLogique.equals("SELECTION")) {
                if (this.infoBean.get("CODE_RUBRIQUE2") != null) {
                    codeRubrique = this.infoBean.getString("CODE_RUBRIQUE2");
                }
                if (this.infoBean.get("CODE_RATTACHEMENT2") != null) {
                    codeRattachement = this.infoBean.getString("CODE_RATTACHEMENT2");
                }
            }
            if ("0".equals(this.media.getIsMutualise())) {
                if (this.etat == 0 && !this.autorisations.possedePermission(new PermissionBean("TECH", "pho", "C"), new Perimetre(codeRattachement, codeRubrique, "*", "*", ""))) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE") + " : " + MessageHelper.getCoreMessage("AUTORISATION_ENREGISTREMENT_HORS_PERIMETRE"));
                }
                if (this.etat == 1) {
                    boolean effectuerControle = true;
                    if (this.autorisations.getCode().equals(this.media.getCodeRedacteur())) {
                        effectuerControle = false;
                        if (this.infoBean.get("CODE_RATTACHEMENT") != null && !this.infoBean.getString("GRS_SAUVEGARDE_CODE_RATTACHEMENT").equals(this.infoBean.get("CODE_RATTACHEMENT"))) {
                            effectuerControle = true;
                        }
                        if (this.infoBean.get("CODE_RUBRIQUE") != null && !this.infoBean.getString("GRS_SAUVEGARDE_CODE_RUBRIQUE").equals(this.infoBean.get("CODE_RUBRIQUE"))) {
                            effectuerControle = true;
                        }
                    }
                    if (effectuerControle && !this.autorisations.possedePermission(new PermissionBean("TECH", "pho", "M"), new Perimetre(this.infoBean.getString("CODE_RATTACHEMENT"), this.infoBean.getString("CODE_RUBRIQUE"), "*", "*", ""))) {
                        throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE") + " : " + MessageHelper.getCoreMessage("AUTORISATION_ENREGISTREMENT_HORS_PERIMETRE"));
                    }
                }
                this.media.setCodeRattachement(codeRattachement);
                this.media.setCodeRubrique(codeRubrique);
            }
            if (this.ecranLogique.equals("SELECTION")) {
                this.media.setTitre(this.infoBean.getString("TITRE2"));
                this.media.setLegende(this.infoBean.getString("LEGENDE2"));
                this.media.setDescription(this.infoBean.getString("DESCRIPTION2"));
            } else {
                this.media.setTitre(this.infoBean.getString("TITRE"));
                this.media.setLegende(this.infoBean.getString("LEGENDE"));
                this.media.setDescription(this.infoBean.getString("DESCRIPTION"));
            }
            this.media.setFormat(this.infoBean.getString("FORMAT"));
            this.media.setSource(this.infoBean.getString("SOURCE"));
            this.media.setAuteur(this.infoBean.getString("AUTEUR"));
            this.media.setCopyright(this.infoBean.getString("COPYRIGHT"));
            this.media.setThematique(this.infoBean.getString("THEMATIQUE"));
            this.media.setMetaKeywords(this.infoBean.getString("META_KEYWORDS"));
            this.getTraductionInfoBean();
            if (StringUtils.isNotBlank((CharSequence)this.infoBean.getString("CODE_REDACTEUR"))) {
                this.media.setCodeRedacteur(this.infoBean.getString("CODE_REDACTEUR"));
            } else {
                this.media.setCodeRedacteur((String)this.getGp().getSessionUtilisateur().getInfos().get("CODE"));
            }
            this.media.setTypeRessource(this.infoBean.getString("TYPE_RESSOURCE").toLowerCase());
            String sPathVignette = this.media.getPathVignetteAbsolu();
            UploadedFile file = (UploadedFile)this.infoBean.get("VIGNETTE_FILE");
            boolean vignetteExterne = false;
            String sVignetteName = "";
            if (file != null) {
                try {
                    int hauteur;
                    int largeur;
                    if (StringUtils.isNotEmpty((CharSequence)PropertyHelper.getCoreProperty("mediatheque." + this.media.getTypeRessource() + ".vignette.width")) && StringUtils.isNotEmpty((CharSequence)PropertyHelper.getCoreProperty("mediatheque." + this.media.getTypeRessource() + ".vignette.height"))) {
                        largeur = Integer.parseInt(PropertyHelper.getCoreProperty("mediatheque." + this.media.getTypeRessource() + ".vignette.width"));
                        hauteur = Integer.parseInt(PropertyHelper.getCoreProperty("mediatheque." + this.media.getTypeRessource() + ".vignette.height"));
                    } else if (this.media.getTypeRessource().equals(PropertyHelper.getCoreProperty("mediatheque.video.player.media.type"))) {
                        largeur = Integer.parseInt(PropertyHelper.getCoreProperty("mediatheque.video.player.width"));
                        hauteur = Integer.parseInt(PropertyHelper.getCoreProperty("mediatheque.video.player.height"));
                    } else {
                        String critere = PropertyHelper.getCoreProperty("phototheque.vignette");
                        String[] lstLimite = critere.split("/", -2);
                        largeur = Integer.parseInt(lstLimite[1]);
                        hauteur = Integer.parseInt(lstLimite[2]);
                    }
                    File fVignette = file.getTemporaryFile();
                    String extension = FileUtil.getExtension(file.getContentFilename()).toLowerCase();
                    fVignette = PhotoUtil.resize(fVignette.getAbsolutePath(), extension, largeur, hauteur, false);
                    sPathVignette = fVignette.getAbsolutePath();
                    vignetteExterne = true;
                    sVignetteName = this.infoBean.getString("TYPE_RESSOURCE").toLowerCase() + "_" + System.currentTimeMillis() + "." + extension;
                }
                catch (Exception largeur) {}
            } else if (sPathVignette.length() > 0 && "".equals(this.infoBean.getString("URL_VIGNETTE"))) {
                sPathVignette = "";
                vignetteExterne = true;
            }
            String sPathFile = "";
            String fileName = "";
            if ("false".equals(this.infoBean.get("IS_LOCAL"))) {
                UrlValidator urlValidator = new UrlValidator(){
                    private static final long serialVersionUID = 8724756142717134449L;

                    public boolean isValid(String value) {
                        return super.isValid(value) || super.isValid("http:" + value);
                    }
                };
                String surl = this.infoBean.getString("URL_RESSOURCE");
                if (!urlValidator.isValid(surl)) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("ST_MEDIATHEQUE_MSG_URL_INVALIDE"));
                }
                this.media.setSource(surl);
                this.media.setUrl(MediathequeHelper.convertToEmbedUrl(surl));
                this.media.setTypeRessource(this.infoBean.getString("TYPE_RESSOURCE").toLowerCase());
                SpecificUrl specificUrl = this.mediatheque.getSpecificUrl(surl);
                if (specificUrl != null) {
                    this.media.setUrl(specificUrl.processUrl(surl));
                    this.media.setTypeRessource(specificUrl.getTypeRessource());
                    this.infoBean.set("SPECIFIC_URL", "1");
                }
                specificMedia = this.mediatheque.getRessource(this.media.getTypeRessource());
                if (this.infoBean.get("TYPE_MEDIA_" + this.media.getTypeRessource().toUpperCase()) != null && !"0000".equals(this.infoBean.getString("TYPE_MEDIA_" + this.media.getTypeRessource().toUpperCase()))) {
                    this.media.setTypeMedia(this.infoBean.getString("TYPE_MEDIA_" + this.media.getTypeRessource().toUpperCase()));
                }
            } else {
                specificMedia = this.mediatheque.getRessource(this.infoBean.getString("TYPE_RESSOURCE").toLowerCase());
                if (specificMedia != null) {
                    fileName = this.media.generateName(FileUtil.getExtension(this.media.getSource()));
                    try {
                        String prefixUploadedTmpFiles;
                        File temp;
                        String pathTmpFile;
                        String sPathTemp = this.infoBean.getString("URL_RESSOURCE");
                        if (!sPathTemp.equals(this.media.getUrlAbsolue()) && !(pathTmpFile = StringUtils.replace((String)(temp = new File(sPathTemp)).getAbsolutePath(), (String)File.separator, (String)"/")).startsWith(prefixUploadedTmpFiles = StringUtils.replace((String)WebAppUtil.getUploadDefaultPath(), (String)File.separator, (String)"/") + "/upl_")) {
                            throw new Exception("le fichier source a \u00e9t\u00e9 modifi\u00e9");
                        }
                        sPathFile = specificMedia.processMedia(this.infoBean, this.media);
                        if (!vignetteExterne) {
                            sPathVignette = specificMedia.processVignette(this.infoBean, this.media);
                        }
                        fileName = this.media.getGenerateName();
                    }
                    catch (Exception e) {
                        throw new ErreurApplicative(e.getMessage());
                    }
                }
            }
            this.media.save(this, sPathFile, sPathVignette, fileName, sVignetteName);
            Rubrique.invaliderCacheRubriqueParMedia(this.media.getIdMedia());
            this.infoBean.addMessageConfirmation("Le m\u00e9dia \u00ab" + (StringUtils.isNotEmpty((CharSequence)this.media.getTitre()) ? this.media.getTitre() : this.media.getUrl()) + "\u00bb a bien \u00e9t\u00e9 enregistr\u00e9.");
            if ("SELECTION".equals(this.infoBean.getString("MODE"))) {
                if ("0".equals(this.media.getIsMutualise()) && this.ecranLogique.equals("SELECTION")) {
                    this.etat = 1;
                    this.infoBean.setEtatObjet("MODIFICATION");
                    this.preparerPRINCIPAL();
                } else {
                    String libelleFichierJoint = "";
                    if (this.media.getTitre().length() > 0) {
                        libelleFichierJoint = this.media.getTitre() + " - ";
                    }
                    libelleFichierJoint = libelleFichierJoint + this.media.getSource();
                    this.infoBean.set("TITRE", libelleFichierJoint);
                    this.infoBean.set("DATE_CREATION", this.media.getDateCreation());
                    ressource = new Ressource();
                    ressource.setCtx(this);
                    ressource.init();
                    ressource.setIdMedia(this.media.getIdMedia());
                    try {
                        ressource.setOrdre(new Integer(this.infoBean.getString("NO_FICHIER")));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if ("CONTRIBUTION".equals(this.infoBean.getString("MODE_FICHIER"))) {
                        ressource.setEtat("1");
                        ressource.setCodeParent(this.infoBean.getString("CODE_PARENT"));
                    } else {
                        ressource.setEtat("0");
                    }
                    ressource.add();
                    this.infoBean.set("ID_RESSOURCE", ressource.getIdRessource());
                    this.ecranLogique = ECRAN_CONFIRMATION;
                }
            } else if (MODE_INSERTION.equals(this.infoBean.getString("MODE"))) {
                this.infoBean.set("ID_MEDIA", this.media.getIdMedia().toString());
                if ("0".equals(this.media.getIsMutualise()) && this.ecranLogique.equals("SELECTION")) {
                    this.etat = 1;
                    this.infoBean.setEtatObjet("MODIFICATION");
                    this.preparerPRINCIPAL();
                } else {
                    String codeParent = "";
                    if (this.infoBean.get("ID_FICHE") != null && !"0".equals(this.infoBean.get("ID_FICHE"))) {
                        codeParent = codeParent + this.infoBean.getString("ID_FICHE") + ",";
                    }
                    codeParent = codeParent + "TYPE=IMG_" + this.infoBean.getString("OBJET") + ",CODE=" + this.infoBean.getString("CODE");
                    ressource = new Ressource();
                    ressource.setCtx(this);
                    ressource.init();
                    ressource.setCodeParent(codeParent);
                    ressource.setIdMedia(this.media.getIdMedia());
                    ressource.setEtat("0");
                    ressource.add();
                    if (this.media.getUrlVignetteAbsolue().length() > 0) {
                        this.infoBean.set("URL_VIGNETTE", this.media.getUrlVignetteAbsolue());
                    } else {
                        this.infoBean.set("URL_VIGNETTE", specificMedia.getUrlVignette());
                    }
                    if (!"LIEN".equals(this.infoBean.getString("MODE_FICHIER"))) {
                        this.preparerRECHERCHE();
                        this.ecranLogique = "SELECTION";
                    } else {
                        this.ecranLogique = ECRAN_CONFIRMATION;
                    }
                }
            } else {
                this.infoBean.remove("TYPE_RESSOURCE");
                this.preparerRECHERCHE();
            }
        }
        if (this.action.equals("ANNULER")) {
            this.ecranLogique = "FIN_TOOLBOX";
        }
    }

    private void traiterUPLOAD() throws Exception {
        UploadedFile zip = (UploadedFile)this.infoBean.get("ZIP_FILE");
        File archive = zip.getTemporaryFile();
        File folder = new File(archive.getParentFile().getAbsolutePath() + File.separator + "upload");
        if (!archive.exists()) {
            LOGGER.info("Aucune archive d'import trouv\u00e9e...");
            return;
        }
        LOGGER.info("D\u00e9compression de l'archive d'import...");
        Zip.decompress(archive, folder, false);
        String typeRessource = this.infoBean.getString("TYPE_RESSOURCE");
        if (typeRessource == null || typeRessource.length() == 0 || "0000".equals(typeRessource)) {
            typeRessource = "";
            this.infoBean.set("TYPE_RESSOURCE", typeRessource);
        }
        this.infoBean.set("NB_UPLOAD", 0);
        this.infoBean.set("NB_ERROR", 0);
        this.infoBean.set("MSG_ERROR", "");
        this.mediatheque.uploadMediasByFolder(this, this.infoBean, folder, true, this.autorisations.getCode());
        this.ecranLogique = ECRAN_UPLOAD;
        this.infoBean.setEtatObjet(ECRAN_UPLOAD);
        this.infoBean.setTitreEcran(MessageHelper.getCoreMessage("MEDIATHEQUE.MEDIA.IMPORT.SUMSUP"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void controlerMedia() throws Exception {
        if (this.ecranLogique.equals("SELECTION")) {
            this.infoBean.set("ID_ACTIVE_ONGLET", "0");
        } else {
            this.infoBean.set("ID_ACTIVE_ONGLET", "0");
        }
        if ("true".equals(this.infoBean.get("IS_LOCAL"))) {
            String typeRessource = this.infoBean.getString("TYPE_RESSOURCE_PREV");
            boolean filtreType = true;
            UploadedFile file = (UploadedFile)this.infoBean.get("MEDIA_FILE");
            if (file == null) {
                if (this.infoBean.get("SOURCE") != null && StringUtils.isNotEmpty((CharSequence)this.infoBean.getString("URL_RESSOURCE"))) {
                    try {
                        file = new UploadedFile(this.infoBean.getString("FORMAT"), 0, this.infoBean.getString("SOURCE"), new File(this.infoBean.getString("URL_RESSOURCE")));
                    }
                    catch (Exception e) {
                        throw new ErreurApplicative(MessageHelper.getCoreMessage("MEDIATHEQUE.MEDIA.ERREUR.FICHIER_SOURCE_INEXISTANT"));
                    }
                } else {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("MEDIATHEQUE.MEDIA.ERREUR.FICHIER_SOURCE_OBLIGATOIRE"));
                }
            }
            if ((StringUtils.isEmpty((CharSequence)typeRessource) || "0000".equals(typeRessource)) && ((typeRessource = this.infoBean.getString("TYPE_RESSOURCE")) == null || typeRessource.length() == 0 || "0000".equals(typeRessource))) {
                typeRessource = "fichier";
                String extension = FileUtil.getExtension(file.getContentFilename());
                String typeTemp = this.mediatheque.getTypesRessourcesByExtensions().get(extension);
                if (typeTemp != null) {
                    typeRessource = typeTemp;
                }
                filtreType = false;
            }
            String sUrlMedia = "";
            SpecificMedia specificMedia = null;
            try {
                specificMedia = this.mediatheque.getRessource(typeRessource.toLowerCase());
            }
            catch (Exception exception) {
            }
            finally {
                if (specificMedia == null) {
                    filtreType = false;
                    typeRessource = "fichier";
                    specificMedia = this.mediatheque.getRessource(typeRessource);
                }
            }
            if (filtreType) {
                String extensions = "";
                for (String ext : specificMedia.getExtensions()) {
                    if (extensions.length() > 0) {
                        extensions = extensions + ",";
                    }
                    extensions = extensions + ext;
                }
                this.infoBean.set("KEY_FILE_EXTENSIONS_MEDIA", extensions);
            }
            this.infoBean.set("LIBELLE_TYPE_RESSOURCE", specificMedia.getLibelleAffichable());
            try {
                sUrlMedia = specificMedia.checkMedia(this.infoBean, file);
            }
            catch (Exception e) {
                this.infoBean.remove("CONTROLE_RESSOURCE");
                this.infoBean.remove("NEW_RESSOURCE");
                this.infoBean.set("URL_RESSOURCE", this.infoBean.getString("URL_RESSOURCE"));
                throw new ErreurApplicative(e.getMessage());
            }
            this.infoBean.set("EXTENSION", FileUtil.getExtension(file.getContentFullFilename()));
            this.infoBean.set("TYPE_RESSOURCE", typeRessource);
            this.infoBean.set("URL_RESSOURCE", sUrlMedia);
            DecimalFormat df = new DecimalFormat("#########0.##");
            String unite = "Ko";
            float fTaille = Float.parseFloat(this.infoBean.getString("POIDS"));
            if (fTaille >= 1024.0f) {
                fTaille /= 1024.0f;
                unite = "Mo";
            }
            String libelleTaille = df.format(fTaille) + "&nbsp;" + unite;
            this.infoBean.set("POIDS", libelleTaille);
        } else {
            this.infoBean.set("POIDS", "0");
            this.infoBean.set("FORMAT", "");
            String typeRessource = this.infoBean.getString("TYPE_RESSOURCE_PREV");
            String source = this.infoBean.getString("URL_RESSOURCE");
            if ((typeRessource == null || typeRessource.length() == 0 || "0000".equals(typeRessource)) && ((typeRessource = this.infoBean.getString("TYPE_RESSOURCE")) == null || typeRessource.length() == 0 || "0000".equals(typeRessource))) {
                typeRessource = "fichier";
                String typeTemp = this.mediatheque.getTypesRessourcesByExtensions().get(FileUtil.getExtension(source));
                if (typeTemp != null) {
                    typeRessource = typeTemp;
                }
            }
            if (typeRessource.length() > 0) {
                this.infoBean.set("TYPE_RESSOURCE", typeRessource);
                this.infoBean.set("FORMAT", this.mediatheque.getContentType(source));
            }
        }
        this.infoBean.set("CRITERE", "4");
        this.infoBean.set("CRITERE4", "4");
        this.infoBean.set("CONTROLE_RESSOURCE", "true");
        this.infoBean.set("NEW_RESSOURCE", "true");
        if (this.ecranLogique.equals("SELECTION")) {
            this.action = "ENREGISTRER";
            this.infoBean.setEtatObjet("CREATION");
            this.traiterPRINCIPAL();
        } else {
            this.ecranLogique = ECRAN_PRINCIPAL;
        }
    }

    public void selectionnerMedia() throws Exception {
        this.media.setIdMedia(new Long(this.infoBean.getString("ID_MEDIA")));
        this.media.retrieve();
        String libelleFichierJoint = "";
        if (this.media.getTitre().length() > 0) {
            libelleFichierJoint = this.media.getTitre() + " - ";
        }
        libelleFichierJoint = libelleFichierJoint + this.media.getSource();
        this.infoBean.set("TITRE", libelleFichierJoint);
        this.infoBean.set("DATE_CREATION", this.media.getDateCreation());
        this.infoBean.set("FORMAT", this.media.getFormat());
        this.infoBean.set("LEGENDE", this.media.getLegende());
        this.infoBean.set("TYPE_RESSOURCE", this.media.getTypeRessource());
        if (StringUtils.isNotEmpty((CharSequence)this.media.getSpecificData("LARGEUR"))) {
            this.infoBean.set("WIDTH", this.media.getSpecificData("LARGEUR"));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.media.getSpecificData("HAUTEUR"))) {
            this.infoBean.set("HEIGHT", this.media.getSpecificData("HAUTEUR"));
        }
        Ressource ressource = new Ressource();
        ressource.setCtx(this);
        ressource.init();
        ressource.setIdMedia(this.media.getIdMedia());
        try {
            ressource.setOrdre(new Integer(this.infoBean.getString("NO_FICHIER")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ("CONTRIBUTION".equals(this.infoBean.getString("MODE_FICHIER"))) {
            ressource.setEtat("1");
            ressource.setCodeParent(this.infoBean.getString("CODE_PARENT"));
        } else {
            ressource.setEtat("0");
        }
        ressource.add();
        this.infoBean.set("ID_RESSOURCE", ressource.getIdRessource());
        this.ecranLogique = ECRAN_CONFIRMATION;
    }

    public void insererMedia() throws Exception {
        SpecificUrl specificUrl;
        String codeParent = "";
        this.media.setIdMedia(new Long(this.infoBean.getString("ID_MEDIA")));
        this.media.retrieve();
        if (!this.media.isLocal() && (specificUrl = this.mediatheque.getSpecificUrl(this.media.getUrlAbsolue())) != null) {
            this.infoBean.set("SPECIFIC_URL", "1");
        }
        if (this.infoBean.get("ID_FICHE") != null && !"0".equals(this.infoBean.get("ID_FICHE"))) {
            codeParent = codeParent + this.infoBean.getString("ID_FICHE") + ",";
        }
        codeParent = codeParent + "TYPE=IMG_" + this.infoBean.getString("OBJET") + ",CODE=" + this.infoBean.getString("CODE");
        Ressource ressource = new Ressource();
        ressource.setCtx(this);
        ressource.init();
        if (ressource.select("WHERE ID_MEDIA ='" + this.media.getIdMedia() + "' AND CODE_PARENT LIKE '" + codeParent + "'") == 0) {
            ressource.setCodeParent(codeParent);
            ressource.setIdMedia(this.media.getIdMedia());
            ressource.setEtat("0");
            ressource.add();
        }
        this.infoBean.set("TYPE_RESSOURCE", this.media.getTypeRessource());
        this.infoBean.set("ID_MEDIA", this.media.getIdMedia().toString());
        this.infoBean.set("EXTENSION", this.media.getExtension());
        this.infoBean.set("IS_LOCAL", Boolean.toString(this.media.isLocal()));
        this.infoBean.get("MODE");
        SpecificMedia specificMedia = this.mediatheque.getRessource(this.media.getTypeRessource().toLowerCase());
        specificMedia.setContenuInfoBean(this.infoBean, this.media.getSpecificData());
        if (this.media.getUrlVignetteAbsolue().length() > 0) {
            this.infoBean.set("URL_VIGNETTE", this.media.getUrlVignetteAbsolue());
        } else {
            this.infoBean.set("URL_VIGNETTE", specificMedia.getUrlVignette());
        }
        if (!"LIEN".equals(this.infoBean.getString("MODE_FICHIER"))) {
            this.preparerINSERTION();
            this.preparerRECHERCHE();
            this.ecranLogique = "SELECTION";
        } else {
            this.ecranLogique = ECRAN_CONFIRMATION;
        }
    }

    public void preparerApercu() throws Exception {
        this.media.setIdMedia(new Long(this.infoBean.getString("ID_MEDIA")));
        this.media.retrieve();
        SpecificMedia specificMedia = this.mediatheque.getRessource(this.media.getTypeRessource().toLowerCase());
        this.infoBean.set("ID_MEDIA", this.media.getIdMedia().toString());
        this.infoBean.set("TYPE_RESSOURCE", this.media.getTypeRessource());
        this.infoBean.set("URL_RESSOURCE", this.media.getUrlAbsolue());
        this.infoBean.set("SOURCE", this.media.getSource());
        this.infoBean.set("FORMAT", this.media.getFormat());
        this.infoBean.set("POIDS", this.media.getPoids());
        this.infoBean.set("SPECIFIC_DATA", this.media.getSpecificDataAsString().replaceAll("\n", "<br />"));
        this.infoBean.set("TYPE_MEDIA", this.media.getTypeMedia());
        this.infoBean.set("LIBELLE_TYPE_MEDIA", Libelle.getLibelle(specificMedia.getCodeTypeLibelle(), this.media.getTypeMedia(), LangueUtil.getDefaultLocale()));
        this.infoBean.set("TEMPLATE_JSP_APERCU", specificMedia.getJspApercu());
        if (this.media.isLocal()) {
            HttpSession session = this.infoBean.getSessionHttp();
            SessionUtilisateur sessionUtilisateur = (SessionUtilisateur)session.getAttribute("session");
            Hashtable<String, Object> infosSession = sessionUtilisateur.getInfos();
            infosSession.put(this.media.getUrlAbsolue(), true);
        } else {
            SpecificUrl specificUrl = this.mediatheque.getSpecificUrl(this.media.getUrlAbsolue());
            if (specificUrl != null) {
                this.infoBean.set("SPECIFIC_URL", "1");
            }
        }
        specificMedia.setContenuInfoBean(this.infoBean, this.media.getSpecificData());
        this.ecranLogique = ECRAN_APERCU;
    }

    public void preparerReferences() throws Exception {
        Ressource ressource = new Ressource();
        ressource.setCtx(this);
        ressource.init();
        int i = 0;
        if (ressource.select("WHERE ID_MEDIA ='" + this.infoBean.getString("ID_MEDIA") + "' AND ETAT='1' ") > 0) {
            while (ressource.nextItem()) {
                FicheUniv ficheUniv;
                String codeParent = ressource.getCodeParent();
                if (codeParent == null || codeParent.trim().length() <= 0) continue;
                String url = "";
                String redacteur = "";
                String idFiche = codeParent.substring(0, codeParent.indexOf(","));
                String typeObjet = codeParent.substring(codeParent.indexOf("TYPE=") + 5);
                if (typeObjet.length() > 4) {
                    int indiceDecoup = typeObjet.indexOf("_");
                    if (indiceDecoup != -1) {
                        typeObjet = typeObjet.substring(indiceDecoup + 1, indiceDecoup + 5);
                    }
                    if ((indiceDecoup = typeObjet.indexOf(",")) != -1) {
                        typeObjet = typeObjet.substring(0, indiceDecoup);
                    }
                }
                if ((ficheUniv = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(typeObjet))) != null) {
                    ficheUniv.setCtx(this);
                    ficheUniv.init();
                    try {
                        Utilisateur utilisateur;
                        ficheUniv.setIdFiche(new Long(idFiche));
                        ficheUniv.retrieve();
                        if (StringUtils.isNotBlank((CharSequence)ficheUniv.getCodeRedacteur()) && (utilisateur = Utilisateur.getUtilisateur(ficheUniv.getCodeRedacteur())) != null) {
                            redacteur = utilisateur.getPrenom() + " " + utilisateur.getNom();
                        }
                        String libelle = ficheUniv.getLibelleAffichable();
                        String extension = ReferentielObjets.getExtension(ficheUniv);
                        Class<? extends ProcessusBean> procClass = ProcessusHelper.getClasseProcessus("SAISIE_" + ReferentielObjets.getNomObjet(typeObjet).toUpperCase(), extension);
                        if (procClass != null) {
                            url = String.format("/servlet/com.jsbsoft.jtf.core.SG?EXT=%s&PROC=SAISIE_%s&ACTION=MODIFIER&ID_FICHE=%s", extension, ReferentielObjets.getNomObjet(typeObjet).toUpperCase(), idFiche);
                        }
                        this.infoBean.set("OBJET#" + i, ReferentielObjets.getLibelleObjet(typeObjet));
                        this.infoBean.set("TITRE#" + i, libelle);
                        this.infoBean.set("AUTEUR#" + i, redacteur);
                        this.infoBean.set("URL#" + i, url);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Fiche inexistante, la r\u00e9f\u00e9rence a \u00e9t\u00e9 supprim\u00e9e", (Throwable)e);
                        ressource.delete();
                    }
                } else {
                    this.infoBean.set("OBJET#" + i, typeObjet);
                    this.infoBean.set("TITRE#" + i, "Autre contenu");
                    this.infoBean.set("AUTEUR#" + i, redacteur);
                    this.infoBean.set("URL#" + i, "");
                }
                ++i;
            }
        }
        this.infoBean.setInt("NB_REFERENCES", i);
        this.ecranLogique = ECRAN_REFERENCES;
    }

    private void setTraductionInfoBean() throws Exception {
        Hashtable<String, String> hLangue = LangueUtil.getListeLangues();
        if (hLangue.containsKey("0")) {
            hLangue.remove("0");
        }
        this.infoBean.set("LISTE_LANGUES", hLangue);
        if (MapUtils.isNotEmpty(hLangue)) {
            String sDatas = this.media.getTraductionData();
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(sDatas.getBytes()));
            Enumeration<String> en = hLangue.keys();
            while (en.hasMoreElements()) {
                String sLg = en.nextElement();
                this.infoBean.set("TITRE_" + sLg, properties.getProperty("TITRE_" + sLg) != null ? properties.getProperty("TITRE_" + sLg) : "");
                this.infoBean.set("LEGENDE_" + sLg, properties.getProperty("LEGENDE_" + sLg) != null ? properties.getProperty("LEGENDE_" + sLg) : "");
                this.infoBean.set("DESCRIPTION_" + sLg, properties.getProperty("DESCRIPTION_" + sLg) != null ? properties.getProperty("DESCRIPTION_" + sLg) : "");
                this.infoBean.set("AUTEUR_" + sLg, properties.getProperty("AUTEUR_" + sLg) != null ? properties.getProperty("AUTEUR_" + sLg) : "");
                this.infoBean.set("COPYRIGHT_" + sLg, properties.getProperty("COPYRIGHT_" + sLg) != null ? properties.getProperty("COPYRIGHT_" + sLg) : "");
                this.infoBean.set("META_KEYWORDS_" + sLg, properties.getProperty("META_KEYWORDS_" + sLg) != null ? properties.getProperty("META_KEYWORDS_" + sLg) : "");
            }
        }
    }

    private void getTraductionInfoBean() throws Exception {
        Hashtable<String, String> hLangue = LangueUtil.getListeLangues();
        if (hLangue.containsKey("0")) {
            hLangue.remove("0");
        }
        String sDatas = "";
        if (MapUtils.isNotEmpty(hLangue)) {
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(sDatas.getBytes()));
            Enumeration<String> en = hLangue.keys();
            while (en.hasMoreElements()) {
                String sLg = en.nextElement();
                if (this.infoBean.getString("TITRE_" + sLg) != null && this.infoBean.getString("TITRE_" + sLg).length() > 0) {
                    properties.setProperty("TITRE_" + sLg, this.infoBean.getString("TITRE_" + sLg));
                }
                if (this.infoBean.getString("LEGENDE_" + sLg) != null && this.infoBean.getString("LEGENDE_" + sLg).length() > 0) {
                    properties.setProperty("LEGENDE_" + sLg, this.infoBean.getString("LEGENDE_" + sLg));
                }
                if (this.infoBean.getString("DESCRIPTION_" + sLg) != null && this.infoBean.getString("DESCRIPTION_" + sLg).length() > 0) {
                    properties.setProperty("DESCRIPTION_" + sLg, this.infoBean.getString("DESCRIPTION_" + sLg));
                }
                if (this.infoBean.getString("AUTEUR_" + sLg) != null && this.infoBean.getString("AUTEUR_" + sLg).length() > 0) {
                    properties.setProperty("AUTEUR_" + sLg, this.infoBean.getString("AUTEUR_" + sLg));
                }
                if (this.infoBean.getString("COPYRIGHT_" + sLg) != null && this.infoBean.getString("COPYRIGHT_" + sLg).length() > 0) {
                    properties.setProperty("COPYRIGHT_" + sLg, this.infoBean.getString("COPYRIGHT_" + sLg));
                }
                if (this.infoBean.getString("META_KEYWORDS_" + sLg) == null || this.infoBean.getString("META_KEYWORDS_" + sLg).length() <= 0) continue;
                properties.setProperty("META_KEYWORDS_" + sLg, this.infoBean.getString("META_KEYWORDS_" + sLg));
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            properties.store(baos, "");
            sDatas = baos.toString();
        }
        this.media.setTraductionData(sDatas);
    }

    private void preparerUPLOAD() throws Exception {
        this.ecranLogique = ECRAN_UPLOAD;
        this.infoBean.setEtatObjet(ECRAN_UPLOAD);
        this.infoBean.set("CODE_RATTACHEMENT", "");
        this.infoBean.set("LIBELLE_CODE_RATTACHEMENT", "");
        this.infoBean.set("CODE_RUBRIQUE", "");
        this.infoBean.set("LIBELLE_CODE_RUBRIQUE", "");
        this.preparerPerimetre("pho", "C");
        this.infoBean.set("DESCRIPTION", "");
        this.infoBean.set("AUTEUR", "");
        this.infoBean.set("COPYRIGHT", "");
        this.infoBean.set("THEMATIQUE", "");
        this.infoBean.set("LIBELLE_THEMATIQUE", this.media.getLibelleThematique());
        this.infoBean.set("LISTE_THEMATIQUES", Libelle.getListe("04", LangueUtil.getDefaultLocale()));
        this.infoBean.set("META_KEYWORDS", "");
        this.infoBean.set("KEY_FILE_EXTENSIONS_ZIP", "zip");
        for (String sKeyType : this.mediatheque.getTypesMedia().keySet()) {
            SpecificMedia specificMedia = this.mediatheque.getRessource(sKeyType.toLowerCase());
            this.infoBean.set("LISTE_TYPE_MEDIA_" + sKeyType.toUpperCase(), Libelle.getListe(specificMedia.getCodeTypeLibelle(), LangueUtil.getDefaultLocale()));
        }
        this.infoBean.set("LISTE_TYPE_RESSOURCES", this.mediatheque.getTypesRessourcesAffichables());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preparerRECHERCHE() throws Exception {
        this.ecranLogique = ECRAN_RECHERCHE;
        this.infoBean.setEtatObjet(ECRAN_RECHERCHE);
        this.infoBean.set("AJOUT_MEDIA", "0");
        this.infoBean.set("RECHERCHE_MEDIA", "0");
        if (this.autorisations != null) {
            Vector<Perimetre> vPerimetre = this.autorisations.getListePerimetres(new PermissionBean("TECH", "pho", "C"));
            if (CollectionUtils.isNotEmpty(vPerimetre)) {
                this.infoBean.set("AJOUT_MEDIA", "1");
            }
            if (CollectionUtils.isNotEmpty(vPerimetre = this.autorisations.getListePerimetres(new PermissionBean("TECH", "acp", "")))) {
                this.infoBean.set("RECHERCHE_MEDIA", "1");
            }
        } else {
            this.ecranLogique = "LOGIN";
            return;
        }
        this.preparerPerimetre("acp", "");
        this.infoBean.set("CODE_RATTACHEMENT", "");
        this.infoBean.set("LIBELLE_CODE_RATTACHEMENT", "");
        this.infoBean.set("CODE_RUBRIQUE", "");
        this.infoBean.set("LIBELLE_CODE_RUBRIQUE", "");
        this.infoBean.set("TITRE", "");
        this.infoBean.set("LEGENDE", "");
        this.infoBean.set("DESCRIPTION", "");
        this.infoBean.set("AUTEUR", "");
        this.infoBean.set("COPYRIGHT", "");
        this.infoBean.set("THEMATIQUE", "");
        this.infoBean.set("LIBELLE_THEMATIQUE", this.media.getLibelleThematique());
        this.infoBean.set("LISTE_THEMATIQUES", Libelle.getListe("04", this.getLocale()));
        this.infoBean.set("DATE_CREATION", "");
        this.infoBean.set("CODE_REDACTEUR", "");
        this.infoBean.set("LIBELLE_CODE_REDACTEUR", "");
        this.infoBean.set("META_KEYWORDS", "");
        String sTypeRessource = this.infoBean.getString("TYPE_RESSOURCE");
        if (sTypeRessource == null || sTypeRessource.length() == 0) {
            this.infoBean.remove("TYPE_RESSOURCE");
            for (String sKeyType : this.mediatheque.getTypesMedia().keySet()) {
                SpecificMedia specificMedia = this.mediatheque.getRessource(sKeyType.toLowerCase());
                this.infoBean.set("LISTE_TYPE_MEDIA_" + sKeyType.toUpperCase(), Libelle.getListe(specificMedia.getCodeTypeLibelle(), this.getLocale()));
            }
            this.infoBean.set("LISTE_TYPE_RESSOURCES", this.mediatheque.getTypesRessourcesAffichables());
        } else {
            SpecificMedia specificMedia = null;
            try {
                specificMedia = this.mediatheque.getRessource(sTypeRessource.toLowerCase());
            }
            catch (Exception exception) {
            }
            finally {
                if (specificMedia == null) {
                    sTypeRessource = "fichier";
                    specificMedia = this.mediatheque.getRessource(sTypeRessource);
                }
            }
            this.infoBean.set("LIBELLE_TYPE_RESSOURCE", specificMedia.getLibelleAffichable());
            this.infoBean.set("TYPE_MEDIA_" + sTypeRessource.toUpperCase(), "");
            this.infoBean.set("LISTE_TYPE_MEDIA_" + sTypeRessource.toUpperCase(), Libelle.getListe(specificMedia.getCodeTypeLibelle(), this.getLocale()));
        }
        this.infoBean.setTitreEcran("");
    }

    private void preparerINSERTION() throws Exception {
        Vector<Perimetre> vPerimetre;
        this.ecranLogique = "SELECTION";
        this.infoBean.set("AJOUT_MEDIA", "0");
        this.preparerPerimetre("pho", "C");
        this.infoBean.set("CODE_RATTACHEMENT2", this.infoBean.get("CODE_RATTACHEMENT"));
        this.infoBean.set("CODE_RUBRIQUE2", this.infoBean.get("CODE_RUBRIQUE"));
        if (this.autorisations != null && CollectionUtils.isNotEmpty(vPerimetre = this.autorisations.getListePerimetres(new PermissionBean("TECH", "pho", "C")))) {
            this.infoBean.set("AJOUT_MEDIA", "1");
        }
        boolean type = false;
        String typeRessource = "";
        if (this.infoBean.get("TYPE_RESSOURCE") != null && this.infoBean.getString("TYPE_RESSOURCE").length() > 0) {
            typeRessource = this.infoBean.getString("TYPE_RESSOURCE");
            SpecificMedia mediaSpecific = this.mediatheque.getRessource(typeRessource.toLowerCase());
            this.infoBean.set("TEMPLATE_JSP_INSERTION", mediaSpecific.getJspInsertion());
            String extensions = "";
            for (String ext : mediaSpecific.getExtensions()) {
                if (extensions.length() > 0) {
                    extensions = extensions + ",";
                }
                extensions = extensions + ext;
            }
            this.infoBean.set("KEY_FILE_EXTENSIONS_MEDIA", extensions);
            type = true;
        }
        if (MODE_INSERTION.equals(this.infoBean.getString("MODE"))) {
            String codeParent = "";
            if (this.infoBean.get("ID_FICHE") != null && !"0".equals(this.infoBean.get("ID_FICHE"))) {
                codeParent = codeParent + this.infoBean.getString("ID_FICHE") + ",";
            }
            codeParent = codeParent + "TYPE=%_" + this.infoBean.getString("OBJET") + ",CODE=" + this.infoBean.getString("CODE");
            this.infoBean.set("CODE_PARENT", codeParent);
            Vector<Ressource> v = Ressource.getListeFichier(codeParent, "");
            int j = 0;
            if (CollectionUtils.isNotEmpty(v)) {
                for (Ressource file : v) {
                    if (type && !file.getTypeRessource().equalsIgnoreCase(typeRessource)) continue;
                    SpecificMedia mediaSpecific = this.mediatheque.getRessource(file.getTypeRessource().toLowerCase());
                    this.infoBean.set("ID_FICHIER#" + j, file.getIdMedia());
                    if (StringUtils.isNotEmpty((CharSequence)file.getMedia().getSpecificData("HAUTEUR"))) {
                        this.infoBean.set("HEIGHT#" + j, file.getMedia().getSpecificData("HAUTEUR"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)file.getMedia().getSpecificData("LARGEUR"))) {
                        this.infoBean.set("WIDTH#" + j, file.getMedia().getSpecificData("LARGEUR"));
                    }
                    this.infoBean.set("LIBELLE_FICHIER#" + j, file.getLibelle());
                    if (file.getMedia().getUrlVignetteAbsolue().length() > 0) {
                        this.infoBean.set("URL_VIGNETTE#" + j, file.getMedia().getUrlVignetteAbsolue());
                    } else {
                        this.infoBean.set("URL_VIGNETTE#" + j, mediaSpecific.getUrlVignette());
                    }
                    if (file.getMedia().getUrlAbsolue().length() > 0) {
                        this.infoBean.set("URL_RESSOURCE#" + j, file.getMedia().getUrlAbsolue());
                    } else {
                        this.infoBean.set("URL_RESSOURCE#" + j, mediaSpecific.getUrl());
                    }
                    ++j;
                }
            }
            this.infoBean.setInt("FICHIER_NB_ITEMS", j);
        } else if (this.infoBean.getString("MODE") == null) {
            this.infoBean.set("MODE", MODE_ADMINISTRATION);
        }
    }

    private void traiterRECHERCHE() throws Exception {
        String cleMedia;
        Date date = null;
        Long idMedia = 0L;
        try {
            idMedia = new Long(this.infoBean.getString("ID"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String dateCreation = (String)this.infoBean.get("DATE_CREATION");
        if (StringUtils.isNotBlank((CharSequence)dateCreation)) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            date = new Date(sdf.parse(dateCreation).getTime());
        }
        String typeMedia = "";
        if (this.infoBean.getString("TYPE_RESSOURCE") != null && this.infoBean.getString("TYPE_RESSOURCE").length() > 0 && !"0000".equals(this.infoBean.getString("TYPE_RESSOURCE")) && this.infoBean.getString(cleMedia = "TYPE_MEDIA_" + this.infoBean.getString("TYPE_RESSOURCE").toUpperCase()) != null && this.infoBean.getString(cleMedia).length() > 0 && !"0000".equals(this.infoBean.getString(cleMedia))) {
            typeMedia = this.infoBean.getString(cleMedia);
        }
        String poidsMinimum = "";
        String poidsMaximum = "";
        if (StringUtils.isNotBlank((CharSequence)this.infoBean.getString("POIDS_MINIMUM"))) {
            poidsMinimum = this.infoBean.getString("POIDS_MINIMUM");
        }
        if (StringUtils.isNotBlank((CharSequence)this.infoBean.getString("POIDS_MAXIMUM"))) {
            poidsMaximum = this.infoBean.getString("POIDS_MAXIMUM");
        }
        if (this.infoBean.getString("MODE") == null) {
            this.infoBean.set("MODE", MODE_ADMINISTRATION);
        }
        ClauseWhere where = this.media.preparerRequete(idMedia, this.infoBean.getString("TITRE"), this.infoBean.getString("LEGENDE"), this.infoBean.getString("DESCRIPTION"), this.infoBean.getString("COPYRIGHT"), this.infoBean.getString("AUTEUR"), this.infoBean.getString("TYPE_RESSOURCE"), typeMedia, this.infoBean.getString("THEMATIQUE"), this.infoBean.getString("CODE_RATTACHEMENT"), this.infoBean.getString("CODE_RUBRIQUE"), this.infoBean.getString("CODE_REDACTEUR"), this.infoBean.getString("META_KEYWORDS"), date, this.infoBean.getString("MODE"), poidsMinimum, poidsMaximum);
        int count = this.media.count(where.formaterSQL());
        this.infoBean.set("COUNT", String.valueOf(count));
        Integer from = 0;
        if (this.infoBean.get("FROM") != null && this.infoBean.getString("FROM").length() > 0) {
            from = Integer.valueOf(this.infoBean.getString("FROM"));
        }
        Integer increment = 12;
        if (this.infoBean.get("INCREMENT") != null) {
            increment = Integer.valueOf(this.infoBean.getString("INCREMENT"));
        }
        ClauseLimit limite = new ClauseLimit(from, increment);
        RequeteSQL requeteSQL = new RequeteSQL();
        requeteSQL.where(where).limit(limite);
        this.media.selectNoCount(requeteSQL.formaterRequete());
        if (count > increment && from + increment < count) {
            this.infoBean.set("FROMPLUS", from + increment);
        } else {
            this.infoBean.remove("FROMPLUS");
        }
        if (from > 0) {
            this.infoBean.set("FROMMOINS", from - increment);
        } else {
            this.infoBean.remove("FROMMOINS");
        }
        this.infoBean.set("INCREMENT", increment);
        this.preparerLISTE();
    }

    private void preparerLISTE() throws Exception {
        int i = 0;
        boolean displayList = false;
        if (StringUtils.isNotBlank((CharSequence)this.infoBean.getString("SELECTION_MEDIA"))) {
            displayList = "1".equals(this.infoBean.getString("SELECTION_MEDIA"));
        } else {
            this.infoBean.set("SELECTION_MEDIA", "0");
            if (this.ecranLogique.equals("SELECTION")) {
                displayList = true;
                this.infoBean.set("SELECTION_MEDIA", "1");
            }
        }
        this.ecranLogique = ECRAN_LISTE;
        this.infoBean.set("SUPPRESSION_MEDIA", "0");
        this.infoBean.set("MODIFICATION_MEDIA", "0");
        this.infoBean.set("CREATION_MEDIA", "0");
        if (this.autorisations != null) {
            Vector<Perimetre> vPerimetre = this.autorisations.getListePerimetres(new PermissionBean("TECH", "pho", "S"));
            if (CollectionUtils.isNotEmpty(vPerimetre) || this.media.getCodeRedacteur().equals(this.autorisations.getCode())) {
                this.infoBean.set("SUPPRESSION_MEDIA", "1");
            }
            if (CollectionUtils.isNotEmpty(vPerimetre = this.autorisations.getListePerimetres(new PermissionBean("TECH", "pho", "M"))) || this.media.getCodeRedacteur().equals(this.autorisations.getCode())) {
                displayList = true;
                this.infoBean.set("MODIFICATION_MEDIA", "1");
            }
            if (CollectionUtils.isNotEmpty(vPerimetre = this.autorisations.getListePerimetres(new PermissionBean("TECH", "pho", "C"))) || this.media.getCodeRedacteur().equals(this.autorisations.getCode())) {
                displayList = true;
                this.infoBean.set("CREATION_MEDIA", "1");
            }
        }
        while (this.media.nextItem() && displayList) {
            SpecificMedia specificMedia = this.mediatheque.getRessource(this.media.getTypeRessource().toLowerCase());
            if (specificMedia == null) continue;
            this.infoBean.set("ID_FICHE#" + i, this.media.getIdMedia().toString());
            this.infoBean.set("URL#" + i, this.media.getUrlAbsolue());
            this.infoBean.set("SOURCE#" + i, this.media.getSource());
            this.infoBean.set("IS_LOCAL#" + i, this.media.isLocal() ? "true" : "false");
            if (this.media.isLocal() || !"photo".equals(specificMedia.getCode())) {
                this.infoBean.set("URL_VIGNETTE#" + i, StringUtils.defaultIfBlank((CharSequence)this.media.getUrlVignetteAbsolue(), (CharSequence)specificMedia.getUrlVignette()));
            } else {
                this.infoBean.set("URL_VIGNETTE#" + i, StringUtils.defaultIfBlank((CharSequence)this.media.getUrlAbsolue(), (CharSequence)specificMedia.getUrlVignette()));
            }
            if (this.media.getUrlAbsolue().length() > 0) {
                this.infoBean.set("URL_RESSOURCE#" + i, this.media.getUrlAbsolue());
            } else {
                this.infoBean.set("URL_RESSOURCE#" + i, this.media.getUrl());
            }
            this.infoBean.set("URL_ICONE#" + i, specificMedia.getUrlIcone());
            this.infoBean.set("TITRE#" + i, this.media.getLibelleAffichable());
            if (StringUtils.isNotEmpty((CharSequence)this.media.getSpecificData("HAUTEUR"))) {
                this.infoBean.set("HEIGHT#" + i, this.media.getSpecificData("HAUTEUR"));
            }
            if (StringUtils.isNotEmpty((CharSequence)this.media.getSpecificData("LARGEUR"))) {
                this.infoBean.set("WIDTH#" + i, this.media.getSpecificData("LARGEUR"));
            }
            DecimalFormat df = new DecimalFormat("#########0.##");
            String unite = "Ko";
            float fTaille = this.media.getPoids().intValue();
            if (this.media.getPoids() >= 1024) {
                fTaille = (float)this.media.getPoids().intValue() / 1024.0f;
                unite = "Mo";
            }
            String libelleTaille = df.format(fTaille) + "&nbsp;" + unite;
            this.infoBean.set("TAILLE#" + i, libelleTaille);
            this.infoBean.set("SPECIFIC_DATA#" + i, this.media.getSpecificDataAsString().replaceAll("\n", "<br />"));
            this.infoBean.set("TYPE_RESSOURCE#" + i, this.media.getTypeRessource());
            this.infoBean.set("LIBELLE_TYPE_RESSOURCE#" + i, specificMedia.getLibelleAffichable());
            this.infoBean.set("TYPE_MEDIA#" + i, this.media.getTypeMedia());
            this.infoBean.set("LIBELLE_TYPE_MEDIA#" + i, Libelle.getLibelle(specificMedia.getCodeTypeLibelle(), this.media.getTypeMedia(), LangueUtil.getDefaultLocale()));
            ++i;
        }
        this.infoBean.set("LISTE_NB_ITEMS", i);
    }
}

