/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.univ.objetspartages.om.PageLibre;
import com.univ.objetspartages.om.ParagrapheBean;
import com.univ.objetspartages.processus.ControleurUniv;
import com.univ.objetspartages.processus.SaisieFiche;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public class SaisiePageLibre
extends SaisieFiche {
    private PageLibre pagelibre = null;

    public SaisiePageLibre(InfoBean infoBean) {
        super(infoBean);
    }

    @Override
    public boolean traiterAction() throws Exception {
        this.infoBean.set("CODE_OBJET", "0016");
        this.pagelibre = new PageLibre();
        this.pagelibre.setCtx(this);
        this.pagelibre.init();
        this.traiterActionParDefaut(this.pagelibre);
        this.infoBean.set("NOM_ONGLET", "pagelibre");
        return this.etat == 2;
    }

    @Override
    protected void preparerRECHERCHE() throws Exception {
        this.ecranLogique = "RECHERCHE";
        this.infoBean.set("LISTE_LANGUES", LangueUtil.getListeLangues(this.getLocale()));
    }

    @Override
    protected void preparerPRINCIPAL() throws Exception {
        this.infoBean.set("TITRE", this.pagelibre.getTitre());
        this.infoBean.set("RATTACHEMENT_BANDEAU", this.pagelibre.getRattachementBandeau());
        this.infoBean.set("COMPLEMENTS", this.pagelibre.getComplements());
        Vector<ParagrapheBean> listeParagraphes = this.pagelibre.getParagraphes();
        Enumeration<ParagrapheBean> e = listeParagraphes.elements();
        ParagrapheBean paragraphe = null;
        if (this.infoBean.getEtatObjet().equals("CREATION") || this.pagelibre.getContenu().length() == 0) {
            boolean nbItems = false;
            this.infoBean.set("CONTENU_0", "");
            this.infoBean.setInt("LIGNE_0", 1);
            this.infoBean.setInt("COLONNE_0", 1);
            this.infoBean.setInt("LARGEUR_0", 100);
            this.infoBean.set("PARAGRAPHES_NB_ITEMS", "1");
        } else {
            int i = 0;
            while (e.hasMoreElements()) {
                paragraphe = e.nextElement();
                this.infoBean.set("CONTENU_" + i, paragraphe.getContenu());
                this.infoBean.setInt("LIGNE_" + i, paragraphe.getLigne());
                this.infoBean.setInt("COLONNE_" + i, paragraphe.getColonne());
                this.infoBean.setInt("LARGEUR_" + i, paragraphe.getLargeur());
                ++i;
            }
            this.infoBean.set("PARAGRAPHES_NB_ITEMS", "" + i);
        }
        this.infoBean.set("CODE_RUBRIQUE", this.pagelibre.getCodeRubrique());
        this.infoBean.set("LIBELLE_CODE_RUBRIQUE", this.pagelibre.getInfosRubrique().getLibelleAffichable());
        this.infoBean.set("CODE_RATTACHEMENT", this.pagelibre.getCodeRattachement());
        this.infoBean.set("LIBELLE_CODE_RATTACHEMENT", this.pagelibre.getInfosStructure().getLibelleAffichable());
        this.infoBean.set("SOUS_ONGLET", "PRINCIPAL");
        this.ecranLogique = "PRINCIPAL";
        this.infoBean.set("ID_PAGELIBRE", this.pagelibre.getIdFiche().toString());
        this.infoBean.set("LIBELLE_AFFICHABLE", this.pagelibre.getTitre());
        ControleurUniv.preparerPRINCIPAL(this.infoBean, this.pagelibre, this);
    }

    @Override
    protected void traiterPRINCIPAL() throws Exception {
        if (this.infoBean.getEtatObjet().equals("CREATION")) {
            this.pagelibre.init();
            if (this.infoBean.get("LANGUE") != null) {
                this.pagelibre.setLangue((String)this.infoBean.get("LANGUE"));
            }
        } else {
            this.pagelibre.setIdPagelibre(new Long(this.infoBean.getString("ID_PAGELIBRE")));
            this.pagelibre.retrieve();
        }
        if (this.action.indexOf("SUPPRIMER_PARAGRAPHE") == 0) {
            int indiceDiese = this.action.indexOf("#");
            int indice = Integer.parseInt(this.action.substring(indiceDiese + 1));
            int nbItems = Integer.parseInt(this.infoBean.getString("PARAGRAPHES_NB_ITEMS"));
            for (int j = indice; j < nbItems - 1; ++j) {
                this.infoBean.set("CONTENU_" + j, this.infoBean.getString("CONTENU_" + (j + 1)));
                this.infoBean.setInt("LIGNE_" + j, this.infoBean.getInt("LIGNE_" + (j + 1)));
                this.infoBean.setInt("COLONNE_" + j, this.infoBean.getInt("COLONNE_" + (j + 1)));
                this.infoBean.setInt("LARGEUR_" + j, this.infoBean.getInt("LARGEUR_" + (j + 1)));
            }
            this.infoBean.set("PARAGRAPHES_NB_ITEMS", "" + (nbItems - 1));
            this.ecranLogique = "PRINCIPAL";
        } else if (this.action.equals("AJOUTER_PARAGRAPHE")) {
            int nbItems = Integer.parseInt(this.infoBean.getString("PARAGRAPHES_NB_ITEMS"));
            int positionLigne = 0;
            for (int i = 0; i < nbItems; ++i) {
                int positionParagraphe = this.infoBean.getInt("LIGNE_" + i);
                if (positionLigne > positionParagraphe) continue;
                positionLigne = positionParagraphe + 1;
            }
            this.infoBean.set("CONTENU_" + nbItems, "");
            this.infoBean.setInt("LIGNE_" + nbItems, nbItems + 1);
            this.infoBean.setInt("COLONNE_" + nbItems, 1);
            this.infoBean.setInt("LARGEUR_" + nbItems, 100);
            this.infoBean.set("PARAGRAPHES_NB_ITEMS", "" + (nbItems + 1));
            this.infoBean.set("FOCUS", String.valueOf(nbItems));
            this.ecranLogique = "PRINCIPAL";
        } else {
            if (this.action.equals("ONGLET")) {
                this.infoBean.set("SOUS_ONGLET", this.infoBean.getString("SOUS_ONGLET_DEMANDE"));
            } else if (this.action.equals("ENREGISTRER")) {
                this.alimenteDonneesCreation(this.pagelibre, true);
                this.pagelibre.setTitre((String)this.infoBean.get("TITRE"));
                this.pagelibre.setRattachementBandeau((String)this.infoBean.get("RATTACHEMENT_BANDEAU"));
                int nbItems = Integer.parseInt(this.infoBean.getString("PARAGRAPHES_NB_ITEMS"));
                ArrayList<ParagrapheBean> listeParagraphes = new ArrayList<ParagrapheBean>();
                ParagrapheBean paragraphe = null;
                for (int i = 0; i < nbItems; ++i) {
                    paragraphe = new ParagrapheBean();
                    if (this.infoBean.get("LIGNE_" + i) != null) {
                        paragraphe.setLigne(this.infoBean.getInt("LIGNE_" + i));
                    } else {
                        paragraphe.setLigne(i + 1);
                    }
                    if (this.infoBean.get("COLONNE_" + i) != null) {
                        paragraphe.setColonne(this.infoBean.getInt("COLONNE_" + i));
                    } else {
                        paragraphe.setColonne(1);
                    }
                    if (this.infoBean.get("LARGEUR_" + i) != null) {
                        paragraphe.setLargeur(this.infoBean.getInt("LARGEUR_" + i));
                    } else {
                        paragraphe.setLargeur(100);
                    }
                    paragraphe.setContenu(this.infoBean.getString("CONTENU_" + i));
                    listeParagraphes.add(paragraphe);
                }
                this.pagelibre.setParagraphes(listeParagraphes);
                this.pagelibre.setComplements((String)this.infoBean.get("COMPLEMENTS"));
                if (!this.infoBean.getString("CODE_RUBRIQUE").equals("0000")) {
                    this.pagelibre.setCodeRubrique(this.infoBean.getString("CODE_RUBRIQUE"));
                } else {
                    this.pagelibre.setCodeRubrique("");
                }
                this.pagelibre.setCodeRattachement(this.infoBean.getString("CODE_RATTACHEMENT"));
            }
            this.ecranLogique = ControleurUniv.traiterPRINCIPAL(this.infoBean, this.pagelibre, this);
            if (this.ecranLogique.length() == 0) {
                this.etat = 2;
            }
        }
    }
}

