/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.upload.UploadedFile;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosPreferences;
import com.univ.objetspartages.om.Service;
import com.univ.objetspartages.om.ServiceBean;
import com.univ.portail.deploiment.Deploy;
import com.univ.portail.deploiment.DeployWarService;
import com.univ.portail.deploiment.util.PlutoAdminContext;
import com.univ.utils.Chaine;
import com.univ.utils.FileUtil;
import com.univ.utils.ServicesUtil;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaisiePreferences
extends ProcessusBean {
    private AutorisationBean autorisations = null;
    private static String dirDelim = System.getProperty("file.separator");
    private static final String ECRAN_ORDRE = "ORDRE";
    private static final String ECRAN_SERVICE = "SERVICE";
    private static final String ECRAN_PREFS_GENERALES = "PREFS_GENERALES";
    private static final String ECRAN_DEPLOIEMENT = "DEPLOIEMENT";
    private static final String ECRAN_RESULTAT = "RESULTAT";
    private static final String ECRAN_RECHERCHE = "RECHERCHE";
    private static final String ECRAN_LISTE = "LISTE";
    private ServiceBean serviceBean = null;
    private int mode = -1;
    private static final int MODE_AJOUT = 0;
    private static final int MODE_MODIFICATION = 1;
    private static final int MODE_SUPPRESSION = 2;
    private static Logger LOG = LoggerFactory.getLogger(SaisiePreferences.class);

    public SaisiePreferences(InfoBean ciu) {
        super(ciu);
    }

    private void initialisation() throws Exception {
        this.etat = 1;
        if (this.action.equals("DEPLOYER")) {
            this.infoBean.setEtatObjet("CREATION");
            this.preparerDEPLOIEMENT();
        } else if (this.action.equals("AJOUTER")) {
            this.mode = 0;
            this.infoBean.setEtatObjet("CREATION");
            this.serviceBean = new ServiceBean();
            this.preparerSERVICE();
        } else if (this.action.equals("MODIFIER")) {
            this.mode = 1;
            this.infoBean.setEtatObjet("MODIFICATION");
            this.preparerRECHERCHE();
        } else if (this.action.equals("MODIFIERPARCODE")) {
            this.mode = 1;
            this.infoBean.setEtatObjet("MODIFICATION");
            this.traiterRECHERCHE();
        } else if (this.action.equals("SUPPRIMER")) {
            this.mode = 2;
            this.infoBean.setEtatObjet("SUPPRESSION");
            this.preparerRECHERCHE();
        } else if (this.action.equals("SUPPRIMERPARCODE")) {
            this.mode = 2;
            this.infoBean.setEtatObjet("SUPPRESSION");
            ServiceBean serviceASupprimer = ServicesUtil.getService(this.infoBean.getString("CODE_SERVICE"));
            ServicesUtil.removeInstanceService(this, this.infoBean.getString("CODE_SERVICE"));
            ServicesUtil.getCacheServiceManager().asyncRefresh();
            String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_SUPPRESSION_SERVICE"), serviceASupprimer.getIntitule());
            this.infoBean.addMessageConfirmation(confirmation);
            this.etat = 2;
        } else if (this.action.equals("ORDONNER")) {
            this.preparerORDRE();
        }
    }

    private void preparerRECHERCHE() throws Exception {
        this.ecranLogique = ECRAN_RECHERCHE;
        this.infoBean.set("CODE_SERVICE", "");
        Hashtable<String, String> listeServices = new Hashtable<String, String>();
        for (ServiceBean service : ServicesUtil.getServices().values()) {
            listeServices.put(service.getCode(), service.getIntitule());
        }
        this.infoBean.set("LISTE_SERVICES", listeServices);
        this.infoBean.set("SERVICES", ServicesUtil.getServices().values());
        this.infoBean.setTitreEcran(MessageHelper.getCoreMessage("BO.SAISIE_PREFERENCES.SERVICES.TITRE"));
    }

    private void preparerLISTE() throws Exception {
        this.ecranLogique = ECRAN_LISTE;
        this.infoBean.set("CODE#0", this.serviceBean.getCode());
        this.infoBean.set("LIBELLE#0", this.serviceBean.getIntitule());
        this.infoBean.setInt("LISTE_NB_ITEMS", 1);
    }

    private void preparerDEPLOIEMENT() throws Exception {
        this.ecranLogique = ECRAN_DEPLOIEMENT;
    }

    private void preparerPREFS_GENERALES() throws Exception {
        this.infoBean.setInt("PREFERENCES_NB_ITEMS", 0);
        this.infoBean.set("PREFERENCE_NOM", "");
        this.infoBean.set("PREFERENCE_VALEUR", "");
        this.infoBean.set("TMP_PREFERENCE_VALEUR", "");
        this.infoBean.set("LIBELLE_PREFERENCE_VALEUR", "");
        this.infoBean.set("PREFERENCES_NB_ITEMS", this.infoBean.get("SERVICE_PREFERENCES_NB_ITEMS"));
        int nbPreferences = this.infoBean.getInt("PREFERENCES_NB_ITEMS");
        for (int k = 0; k < nbPreferences; ++k) {
            this.infoBean.set("PREFERENCES_NOM#" + k, this.infoBean.get("SERVICE_PREFERENCES_NOM#" + k));
            this.infoBean.set("PREFERENCES_VALEUR#" + k, this.infoBean.get("SERVICE_PREFERENCES_VALEUR#" + k));
        }
        this.ecranLogique = ECRAN_PREFS_GENERALES;
    }

    private void preparerORDRE() throws Exception {
        this.ecranLogique = ECRAN_ORDRE;
        Collection<ServiceBean> vServices = ServicesUtil.getServices().values();
        this.infoBean.setInt("SERVICES_NB_ITEMS", vServices.size());
        int i = 0;
        for (ServiceBean service : vServices) {
            this.infoBean.set("SERVICE_CODE#" + i, service.getCode());
            this.infoBean.set("SERVICE_INTITULE#" + i, service.getIntitule());
            ++i;
        }
        this.rafraichirORDRE();
    }

    private void rafraichirORDRE() throws Exception {
        this.ecranLogique = ECRAN_ORDRE;
    }

    @Override
    public boolean traiterAction() throws Exception {
        this.autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        if (this.autorisations == null) {
            this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
            this.infoBean.setEcranLogique("LOGIN");
        } else {
            try {
                this.ecranLogique = this.infoBean.getEcranLogique();
                this.action = this.infoBean.getActionUtilisateur();
                if (this.etat == 0) {
                    this.initialisation();
                } else if (this.ecranLogique.equals(ECRAN_ORDRE)) {
                    this.traiterORDRE();
                } else if (this.ecranLogique.equals(ECRAN_RECHERCHE)) {
                    this.traiterRECHERCHE();
                } else if (this.ecranLogique.equals(ECRAN_SERVICE)) {
                    this.traiterSERVICE();
                } else if (this.ecranLogique.equals(ECRAN_PREFS_GENERALES)) {
                    this.traiterPREFS_GENERALES();
                } else if (this.ecranLogique.equals(ECRAN_DEPLOIEMENT)) {
                    this.traiterDEPLOIEMENT();
                }
                this.infoBean.setEcranLogique(this.ecranLogique);
            }
            catch (Exception e) {
                LOG.error("erreur de traitement sur le processus", (Throwable)e);
                this.infoBean.addMessageErreur(e.toString());
            }
        }
        return this.etat == 2;
    }

    private void traiterRECHERCHE() throws Exception {
        this.serviceBean = ServicesUtil.getService(this.infoBean.getString("CODE_SERVICE"));
        if (this.mode == 1) {
            this.preparerSERVICE();
        } else if (this.mode == 2) {
            this.preparerLISTE();
        }
    }

    private void traiterORDRE() throws Exception {
        if (this.action.indexOf("REMONTER_SERVICE#") != -1) {
            int indiceDiese = this.action.indexOf("#");
            int indice = Integer.parseInt(this.action.substring(indiceDiese + 1));
            String tmpCODE = this.infoBean.getString("SERVICE_CODE#" + indice);
            String tmpINTITULE = this.infoBean.getString("SERVICE_INTITULE#" + indice);
            this.infoBean.set("SERVICE_CODE#" + indice, this.infoBean.getString("SERVICE_CODE#" + (indice - 1)));
            this.infoBean.set("SERVICE_INTITULE#" + indice, this.infoBean.getString("SERVICE_INTITULE#" + (indice - 1)));
            this.infoBean.set("SERVICE_CODE#" + (indice - 1), tmpCODE);
            this.infoBean.set("SERVICE_INTITULE#" + (indice - 1), tmpINTITULE);
        } else if (this.action.indexOf("BAISSER_SERVICE#") != -1) {
            int indiceDiese = this.action.indexOf("#");
            int indice = Integer.parseInt(this.action.substring(indiceDiese + 1));
            String tmpCODE = this.infoBean.getString("SERVICE_CODE#" + indice);
            String tmpINTITULE = this.infoBean.getString("SERVICE_INTITULE#" + indice);
            this.infoBean.set("SERVICE_CODE#" + indice, this.infoBean.getString("SERVICE_CODE#" + (indice + 1)));
            this.infoBean.set("SERVICE_INTITULE#" + indice, this.infoBean.getString("SERVICE_INTITULE#" + (indice + 1)));
            this.infoBean.set("SERVICE_CODE#" + (indice + 1), tmpCODE);
            this.infoBean.set("SERVICE_INTITULE#" + (indice + 1), tmpINTITULE);
        } else if ("VALIDER".equals(this.action)) {
            ArrayList<String> vCodesServices = new ArrayList<String>();
            for (int i = 0; i < this.infoBean.getInt("SERVICES_NB_ITEMS"); ++i) {
                vCodesServices.add(this.infoBean.getString("SERVICE_CODE#" + i));
            }
            ServicesUtil.ordonnerInstancesServices(this, vCodesServices);
            ServicesUtil.getCacheServiceManager().asyncRefresh();
            this.etat = 2;
        }
    }

    private void preparerSERVICE() throws Exception {
        this.infoBean.set("ACTION_SERVICE", this.action);
        this.infoBean.set("SERVICE_CODE", this.serviceBean.getCode());
        this.infoBean.set("SERVICE_INTITULE", this.serviceBean.getIntitule());
        this.infoBean.set("SERVICE_TYPE", this.serviceBean.getType());
        if (this.serviceBean.getExpirationCacheService().equals(new Integer(-1))) {
            this.infoBean.set("SERVICE_EXPIRATION_CACHE", "");
        } else {
            this.infoBean.set("SERVICE_EXPIRATION_CACHE", this.serviceBean.getExpirationCacheService().toString());
        }
        this.infoBean.set("SERVICE_JETON_KPORTAL", this.serviceBean.getJetonKportal());
        this.infoBean.set("SERVICE_PROXY_CAS", this.serviceBean.getProxyCas());
        this.infoBean.set("SERVICE_URL", this.serviceBean.getUrl());
        this.infoBean.set("SERVICE_PORTLET_DEFINITION_ID", this.serviceBean.getPortletDefinitionId());
        this.infoBean.set("SERVICE_URL_POPUP", this.serviceBean.getUrlPopup());
        this.infoBean.set("SERVICE_VUE_REDUITE_TYPE", this.serviceBean.getVueReduiteType());
        this.infoBean.set("SERVICE_VUE_REDUITE_URL", this.serviceBean.getVueReduiteUrl());
        this.infoBean.set("SERVICE_VUE_REDUITE_CTX", this.serviceBean.getVueReduiteCtx());
        this.infoBean.set("SERVICE_VUE_REDUITE_URL_CROSS_CTX", this.serviceBean.getVueReduiteUrlCrossCtx());
        this.infoBean.set("SERVICE_DIFFUSION_MODE", this.serviceBean.getDiffusionMode());
        this.infoBean.set("SERVICE_DIFFUSION_PUBLIC_VISE", Chaine.convertirPointsVirgules(this.serviceBean.getDiffusionPublicVise()));
        this.infoBean.set("SERVICE_DIFFUSION_MODE_RESTRICTION", this.serviceBean.getDiffusionModeRestriction());
        this.infoBean.set("SERVICE_DIFFUSION_PUBLIC_VISE_RESTRICTION", Chaine.convertirPointsVirgules(this.serviceBean.getDiffusionPublicViseRestriction()));
        List<InfosPreferences> listePreferences = this.serviceBean.getPreferencesGenerales();
        InfosPreferences infosPref = null;
        this.infoBean.setInt("SERVICE_PREFERENCES_NB_ITEMS", listePreferences.size());
        int k = 0;
        Iterator<InfosPreferences> iterator = listePreferences.iterator();
        while (iterator.hasNext()) {
            InfosPreferences element;
            infosPref = element = iterator.next();
            this.infoBean.set("SERVICE_PREFERENCES_NOM#" + k, infosPref.getNom());
            this.infoBean.set("SERVICE_PREFERENCES_VALEUR#" + k, infosPref.getValeursAsString());
            ++k;
        }
        this.infoBean.set("SERVICE_TYPE_SAISIE", "0");
        if (this.infoBean.get("SERVICE_TYPE").equals("U")) {
            this.infoBean.set("SERVICE_TYPE_SAISIE", "0");
        }
        if (this.infoBean.get("SERVICE_TYPE").equals("P")) {
            this.infoBean.set("SERVICE_TYPE_SAISIE", "1");
        }
        this.infoBean.set("LIBELLE_SERVICE_DIFFUSION_PUBLIC_VISE", Groupedsi.getIntitule(this.infoBean.getString("SERVICE_DIFFUSION_PUBLIC_VISE")));
        this.infoBean.set("LIBELLE_SERVICE_DIFFUSION_PUBLIC_VISE_RESTRICTION", Groupedsi.getIntitule(this.infoBean.getString("SERVICE_DIFFUSION_PUBLIC_VISE_RESTRICTION")));
        this.infoBean.set("GRS_FILTRE_ARBRE_GROUPE", "1");
        this.infoBean.set("GRS_FILTRE_ARBRE_GROUPE_TYPE", "TECH");
        this.infoBean.set("GRS_FILTRE_ARBRE_GROUPE_OBJET", "dsi");
        this.infoBean.set("GRS_FILTRE_ARBRE_GROUPE_ACTION", "");
        this.ecranLogique = ECRAN_SERVICE;
        if (StringUtils.isNotBlank((CharSequence)this.serviceBean.getIntitule())) {
            this.infoBean.setTitreEcran(this.serviceBean.getIntitule());
        }
    }

    private void traiterSERVICE() throws Exception {
        if (this.action.equals("MODIFIER_PREFS_GENERALES")) {
            this.preparerPREFS_GENERALES();
        } else if ("VALIDER".equals(this.action)) {
            if (this.infoBean.getEtatObjet().equals("CREATION")) {
                if (this.infoBean.getString("SERVICE_CODE").length() == 0) {
                    throw new ErreurApplicative("Le code du service est obligatoire");
                }
                String serviceCode = this.infoBean.getString("SERVICE_CODE");
                Chaine.controlerCodeMetier(serviceCode);
                ClauseWhere whereCode = new ClauseWhere(ConditionHelper.egalVarchar("CODE", serviceCode));
                Service service = new Service();
                service.setCtx(this);
                service.init();
                if (service.select(whereCode.formaterSQL()) > 0) {
                    throw new ErreurApplicative("Il existe d\u00e9j\u00e0 un service ayant ce code.");
                }
            }
            if (this.infoBean.getString("SERVICE_INTITULE").length() == 0) {
                throw new ErreurApplicative("L'intitul\u00e9 du service est obligatoire");
            }
            if (this.infoBean.getString("SERVICE_INTITULE").indexOf(";") != -1) {
                throw new ErreurApplicative("Le service ne doit pas contrenir de point-virgule");
            }
            if (this.infoBean.getString("SERVICE_VUE_REDUITE_TYPE").equals("1") && this.infoBean.getString("SERVICE_VUE_REDUITE_URL").length() == 0) {
                throw new ErreurApplicative("L'url de la vue r\u00e9duite est obligatoire");
            }
            if (this.infoBean.getString("SERVICE_VUE_REDUITE_TYPE").equals("2") && this.infoBean.getString("SERVICE_VUE_REDUITE_URL_CROSS_CTX").length() == 0) {
                throw new ErreurApplicative("L'url cross-context de la vue r\u00e9duite est obligatoire");
            }
            Integer expirationCache = new Integer(-1);
            if (this.infoBean.getString("SERVICE_EXPIRATION_CACHE").length() > 0) {
                try {
                    expirationCache = new Integer(this.infoBean.getString("SERVICE_EXPIRATION_CACHE"));
                }
                catch (Exception e) {
                    throw new ErreurApplicative("Format de la dur\u00e9e de cache incorrect");
                }
            }
            if (this.infoBean.get("SERVICE_TYPE_SAISIE").equals("0")) {
                this.infoBean.set("SERVICE_TYPE", "U");
            }
            if (this.infoBean.get("SERVICE_TYPE_SAISIE").equals("1")) {
                this.infoBean.set("SERVICE_TYPE", "P");
            }
            InfosPreferences infoPref = null;
            ArrayList<InfosPreferences> listeInfosPref = null;
            String code = "";
            String typeService = this.infoBean.getString("SERVICE_TYPE");
            if ("P".equals(typeService)) {
                code = this.infoBean.getString("SERVICE_PORTLET_DEFINITION_ID");
                if (StringUtils.isEmpty((CharSequence)code)) {
                    throw new ErreurApplicative("L'id du portlet est obligatoire");
                }
            } else {
                code = this.infoBean.getString("SERVICE_CODE");
            }
            listeInfosPref = new ArrayList<InfosPreferences>();
            for (int k = 0; k < this.infoBean.getInt("SERVICE_PREFERENCES_NB_ITEMS"); ++k) {
                infoPref = new InfosPreferences("", code, typeService, this.infoBean.getString("SERVICE_PREFERENCES_NOM#" + k), this.infoBean.getString("SERVICE_PREFERENCES_VALEUR#" + k));
                listeInfosPref.add(infoPref);
            }
            this.serviceBean = new ServiceBean(this.infoBean.getString("SERVICE_CODE"), this.infoBean.getString("SERVICE_INTITULE"), typeService, "UTF-8", expirationCache, expirationCache, this.infoBean.getString("SERVICE_JETON_KPORTAL"), this.infoBean.getString("SERVICE_PROXY_CAS"), this.infoBean.getString("SERVICE_URL"), this.infoBean.getString("SERVICE_PORTLET_DEFINITION_ID"), this.infoBean.getString("SERVICE_URL_POPUP"), this.infoBean.getString("SERVICE_VUE_REDUITE_TYPE"), this.infoBean.getString("SERVICE_VUE_REDUITE_URL"), this.infoBean.getString("SERVICE_VUE_REDUITE_CTX"), this.infoBean.getString("SERVICE_VUE_REDUITE_URL_CROSS_CTX"), this.infoBean.getString("SERVICE_DIFFUSION_MODE"), Chaine.getVecteurPointsVirgules(this.infoBean.getString("SERVICE_DIFFUSION_PUBLIC_VISE")), this.infoBean.getString("SERVICE_DIFFUSION_MODE_RESTRICTION"), Chaine.getVecteurPointsVirgules(this.infoBean.getString("SERVICE_DIFFUSION_PUBLIC_VISE_RESTRICTION")), listeInfosPref);
            ServicesUtil.setInstanceService(this, this.serviceBean);
            ServicesUtil.getCacheServiceManager().asyncRefresh();
            String messageConfirmation = MessageHelper.getCoreMessage("CONFIRMATION_MODIFICATION_SERVICE");
            if (this.infoBean.getEtatObjet().equals("CREATION")) {
                messageConfirmation = MessageHelper.getCoreMessage("CONFIRMATION_CREATION_SERVICE");
            }
            String confirmation = String.format(messageConfirmation, this.serviceBean.getIntitule());
            this.infoBean.addMessageConfirmation(confirmation);
            this.etat = 2;
        } else if (this.action.equals("SUPPRIMER")) {
            ServicesUtil.removeInstanceService(this, this.serviceBean.getCode());
            ServicesUtil.getCacheServiceManager().asyncRefresh();
            String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_SUPPRESSION_SERVICE"), this.serviceBean.getIntitule());
            this.infoBean.addMessageConfirmation(confirmation);
            this.etat = 2;
        }
    }

    private void traiterPREFS_GENERALES() throws Exception {
        int indice = 0;
        if (this.action.equals("AJOUTER_PREFERENCE")) {
            if (this.infoBean.getString("PREFERENCE_NOM").length() == 0) {
                throw new ErreurApplicative("Le nom doit etre renseign\u00e9");
            }
            indice = this.infoBean.getInt("PREFERENCES_NB_ITEMS");
            this.infoBean.setInt("PREFERENCES_NB_ITEMS", indice + 1);
            this.infoBean.set("PREFERENCES_NOM#" + indice, this.infoBean.getString("PREFERENCE_NOM"));
            this.infoBean.set("PREFERENCES_VALEUR#" + indice, this.infoBean.getString("PREFERENCE_VALEUR"));
            this.infoBean.set("PREFERENCE_NOM", "");
            this.infoBean.set("PREFERENCE_VALEUR", "");
            this.infoBean.set("TMP_PREFERENCE_VALEUR", "");
            this.infoBean.set("LIBELLE_PREFERENCE_VALEUR", "");
        } else if (this.action.indexOf("SUPPRIMER_PREFERENCE") != -1) {
            int indiceDiese = this.action.indexOf("#");
            for (int j = indice = Integer.parseInt(this.action.substring(indiceDiese + 1)); j < this.infoBean.getInt("PREFERENCES_NB_ITEMS") - 1; ++j) {
                this.infoBean.set("PREFERENCES_NOM#" + j, this.infoBean.get("PREFERENCES_NOM#" + (j + 1)));
                this.infoBean.set("PREFERENCES_VALEUR#" + j, this.infoBean.get("PREFERENCES_VALEUR#" + (j + 1)));
            }
            this.infoBean.setInt("PREFERENCES_NB_ITEMS", this.infoBean.getInt("PREFERENCES_NB_ITEMS") - 1);
        } else if ("VALIDER".equals(this.action)) {
            this.infoBean.setInt("SERVICE_PREFERENCES_NB_ITEMS", this.infoBean.getInt("PREFERENCES_NB_ITEMS"));
            for (int j = indice; j < this.infoBean.getInt("PREFERENCES_NB_ITEMS"); ++j) {
                this.infoBean.set("SERVICE_PREFERENCES_NOM#" + j, this.infoBean.get("PREFERENCES_NOM#" + j));
                this.infoBean.set("SERVICE_PREFERENCES_VALEUR#" + j, this.infoBean.get("PREFERENCES_VALEUR#" + j));
            }
            this.ecranLogique = ECRAN_SERVICE;
        } else if ("REVENIR".equals(this.action)) {
            this.ecranLogique = ECRAN_SERVICE;
        }
    }

    private void traiterDEPLOIEMENT() throws Exception {
        if (this.action.equals("VALIDER")) {
            UploadedFile file = (UploadedFile)this.infoBean.get("PORTLET_WAR_FILE");
            String context = "";
            String serverFileName = "";
            String workDefaultDir = "";
            File f = null;
            String pathFichierDest = null;
            if (file == null || file.getContentFilename().length() == 0) {
                throw new ErreurApplicative("Fichier non renseign\u00e9");
            }
            f = file.getTemporaryFile();
            workDefaultDir = WebAppUtil.getWorkDefaultPath();
            serverFileName = file.getContentFilename();
            pathFichierDest = workDefaultDir + File.separator + serverFileName;
            new File(pathFichierDest).delete();
            FileUtil.copierFichier(f, new File(pathFichierDest), true);
            int index = serverFileName.indexOf(".war");
            context = index != -1 ? serverFileName.substring(0, index) : serverFileName;
            String deployDir = PlutoAdminContext.getDeploymentPath();
            if (!deployDir.endsWith(dirDelim)) {
                deployDir = deployDir + dirDelim;
            }
            Deploy.deployArchive(deployDir, pathFichierDest);
            DeployWarService dws = new DeployWarService();
            dws.updateWebXml(context);
            String msg = "D\u00e9ploiement effectu\u00e9";
            this.ecranLogique = ECRAN_RESULTAT;
            this.infoBean.set(ECRAN_RESULTAT, "D\u00e9ploiement effectu\u00e9");
            f.delete();
        }
    }
}

