/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;
import com.kportal.extension.module.composant.ComposantProfil;
import com.univ.objetspartages.cache.CacheProfilDsiManager;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.Profildsi;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.Chaine;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaisieProfildsi
extends ProcessusBean {
    private final CacheProfilDsiManager cache = (CacheProfilDsiManager)ApplicationContextManager.getCoreContextBean("cacheProfilDsiManager");
    private int mode = -1;
    private static final int MODE_AJOUT = 0;
    private static final int MODE_MODIFICATION = 1;
    private static final int MODE_SUPPRESSION = 2;
    private static final int MODE_RECHERCHE = 3;
    private static final String ECRAN_RECHERCHE = "RECHERCHE";
    private static final String ECRAN_PRINCIPAL = "PRINCIPAL";
    private static final String ECRAN_LISTE = "LISTE";
    private static Logger LOG = LoggerFactory.getLogger(SaisieProfildsi.class);
    Profildsi profildsi = null;
    Long[] listeIdentifiant = null;

    public SaisieProfildsi(InfoBean ciu) {
        super(ciu);
    }

    private void initialisation() throws Exception {
        this.profildsi = new Profildsi();
        this.profildsi.setCtx(this);
        this.profildsi.init();
        this.etat = 1;
        if (this.action.equals("AJOUTER")) {
            this.mode = 0;
            this.infoBean.setEtatObjet("CREATION");
            this.preparerPRINCIPAL();
        }
        if (this.action.equals("MODIFIER")) {
            this.mode = 1;
            this.infoBean.setEtatObjet("MODIFICATION");
            this.preparerRECHERCHE();
        }
        if (this.action.equals("SUPPRIMER")) {
            this.mode = 2;
            this.infoBean.setEtatObjet("SUPPRESSION");
            this.preparerRECHERCHE();
        }
        if (this.action.equals("RECHERCHER")) {
            this.mode = 3;
            this.infoBean.setEtatObjet(ECRAN_RECHERCHE);
            this.preparerRECHERCHE();
        }
        if (this.action.equals("MODIFIERPARID")) {
            this.modifierParId();
        }
        if (this.action.equals("SUPPRIMERPARID")) {
            this.supprimerParId();
        }
    }

    private void preparerLISTE() throws Exception {
        int i = 0;
        this.ecranLogique = ECRAN_LISTE;
        ClauseWhere whereIdProfil = new ClauseWhere(ConditionHelper.egalVarchar("ID_PROFILDSI", this.infoBean.getString("ID_PROFILDSI")));
        int count = this.profildsi.select(whereIdProfil.formaterSQL());
        ArrayList<Profildsi> profilsSelectionnes = new ArrayList<Profildsi>();
        this.listeIdentifiant = new Long[count];
        while (this.profildsi.nextItem()) {
            profilsSelectionnes.add(this.profildsi.clone());
            this.listeIdentifiant[i] = this.profildsi.getIdProfildsi();
            ++i;
        }
        this.infoBean.set("LISTE_PROFILDSI", profilsSelectionnes);
    }

    private void preparerPRINCIPAL() throws Exception {
        this.ecranLogique = ECRAN_PRINCIPAL;
        this.infoBean.set("CODE", this.profildsi.getCode());
        this.infoBean.set("ID_PROFIL", this.profildsi.getIdProfildsi());
        this.infoBean.set("LIBELLE", this.profildsi.getLibelle());
        String codeRubrique = this.profildsi.getCodeRubriqueAccueil();
        this.infoBean.set("LIBELLE_CODE_RUBRIQUE_ACCUEIL", Rubrique.getIntitule(codeRubrique));
        this.infoBean.set("CODE_RUBRIQUE_ACCUEIL", this.profildsi.getCodeRubriqueAccueil());
        String sTmp = Chaine.convertirPointsVirgules(this.profildsi.getVecteurGroupes());
        this.infoBean.set("GROUPES", sTmp);
        this.infoBean.set("LIBELLE_GROUPES", Groupedsi.getIntitule(sTmp));
        if (StringUtils.isNotBlank((CharSequence)this.profildsi.getLibelle())) {
            this.infoBean.setTitreEcran(this.profildsi.getLibelle());
        }
    }

    private void preparerRECHERCHE() throws Exception {
        this.ecranLogique = ECRAN_RECHERCHE;
        this.infoBean.set("ID_PROFILDSI", this.profildsi.getIdProfildsi());
        this.infoBean.set("LISTE_PROFILDSI", Profildsi.getListeProfilsDSI(this));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean traiterAction() throws Exception {
        try {
            this.ecranLogique = this.infoBean.getEcranLogique();
            this.action = this.infoBean.getActionUtilisateur();
            AutorisationBean autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
            if (!ComposantProfil.isAutoriseParActionProcessus(autorisations, null)) {
                if (autorisations != null) throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
                this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
                this.infoBean.setEcranLogique("LOGIN");
            } else {
                if (this.etat == 0) {
                    this.initialisation();
                } else if (this.ecranLogique.equals(ECRAN_RECHERCHE)) {
                    this.traiterRECHERCHE();
                } else if (this.ecranLogique.equals(ECRAN_LISTE)) {
                    this.traiterLISTE();
                } else if (this.ecranLogique.equals(ECRAN_PRINCIPAL)) {
                    this.traiterPRINCIPAL();
                }
                this.infoBean.setEcranLogique(this.ecranLogique);
            }
        }
        catch (Exception e) {
            LOG.error("erreur de traitement sur le processus", (Throwable)e);
            this.infoBean.addMessageErreur(e.toString());
        }
        if (this.etat != 2) return false;
        return true;
    }

    private void traiterLISTE() throws Exception {
        int indice;
        if (this.action.equals("MODIFIER")) {
            this.modifierParId();
        }
        if (this.action.equals("VALIDER")) {
            indice = Integer.parseInt((String)this.infoBean.get("LISTE_INDICE"));
            this.profildsi.setIdProfildsi(this.listeIdentifiant[indice]);
            this.profildsi.retrieve();
            this.remplirDonneesRecherche();
            this.etat = 2;
        }
        if (this.action.equals("SUPPRIMER")) {
            indice = Integer.parseInt((String)this.infoBean.get("LISTE_INDICE"));
            this.profildsi.setIdProfildsi(this.listeIdentifiant[indice]);
            this.profildsi.retrieve();
            this.profildsi.delete();
            this.cache.flush();
            this.etat = 2;
        }
        if (this.action.equals("ANNULER")) {
            this.infoBean.set("ID_PROFILDSI", null);
            this.etat = 2;
        }
    }

    private void modifierParId() throws Exception {
        this.mode = 1;
        String idProfil = this.infoBean.getString("ID_PROFIL");
        this.profildsi.setIdProfildsi(Long.valueOf(idProfil));
        this.profildsi.retrieve();
        this.preparerPRINCIPAL();
    }

    private void traiterPRINCIPAL() throws Exception {
        if (this.action.equals("VALIDER")) {
            this.profildsi.setCode((String)this.infoBean.get("CODE"));
            this.profildsi.setLibelle((String)this.infoBean.get("LIBELLE"));
            this.profildsi.setCodeRubriqueAccueil((String)this.infoBean.get("CODE_RUBRIQUE_ACCUEIL"));
            this.profildsi.setVecteurGroupes(Chaine.getVecteurPointsVirgules(this.infoBean.getString("GROUPES")));
            if (this.mode == 0) {
                Profildsi profildsi2 = new Profildsi();
                profildsi2.setCtx(this);
                profildsi2.init();
                if (profildsi2.select(this.profildsi.getCode(), "") > 0) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "PROFIL_DSI.ERREUR.CODE_EXISTANT"));
                }
                this.profildsi.add();
                String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_CREATION_PROFILDSI"), this.profildsi.getLibelle());
                this.infoBean.addMessageConfirmation(confirmation);
            }
            if (this.mode == 1) {
                this.profildsi.update();
                String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_MODIFICATION_PROFILDSI"), this.profildsi.getLibelle());
                this.infoBean.addMessageConfirmation(confirmation);
            }
            this.cache.flush();
            this.etat = 2;
        } else if (this.action.equals("SUPPRIMER")) {
            this.supprimerParId();
        }
    }

    private void supprimerParId() throws Exception {
        Long idProfil = Long.parseLong((String)this.infoBean.get("ID_PROFIL"));
        this.profildsi.setIdProfildsi(idProfil);
        this.profildsi.retrieve();
        this.profildsi.delete();
        this.cache.flush();
        String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_SUPPRESSION_PROFILDSI"), this.profildsi.getLibelle());
        this.infoBean.addMessageConfirmation(confirmation);
        this.etat = 2;
    }

    private void traiterRECHERCHE() throws Exception {
        if (this.action.equals("VALIDER")) {
            ClauseWhere whereIdProfil = new ClauseWhere(ConditionHelper.egalVarchar("ID_PROFILDSI", this.infoBean.getString("ID_PROFILDSI")));
            int count = this.profildsi.select(whereIdProfil.formaterSQL());
            if (count == 0) {
                this.infoBean.addMessageErreur("Aucun enregistrement s\u00e9lectionn\u00e9");
            }
            if (count == 1) {
                this.profildsi.nextItem();
                if (this.mode == 3) {
                    this.remplirDonneesRecherche();
                    this.etat = 2;
                }
                if (this.mode == 1) {
                    this.preparerPRINCIPAL();
                }
                if (this.mode == 2) {
                    this.preparerLISTE();
                }
            }
            if (count > 1) {
                this.preparerLISTE();
            }
        }
        if (this.action.equals("ANNULER") && this.mode == 3) {
            this.infoBean.set("ID_PROFILDSI", null);
            this.etat = 2;
        }
    }

    private void remplirDonneesRecherche() throws Exception {
        this.infoBean.set("ID_PROFILDSI", this.profildsi.getIdProfildsi());
        this.infoBean.set("CODE", this.profildsi.getCode());
        this.infoBean.set("LIBELLE", this.profildsi.getLibelle());
        this.infoBean.set("CODE_RUBRIQUE_ACCUEIL", this.profildsi.getCodeRubriqueAccueil());
    }
}

