/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.CodeLibelle;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.cms.objetspartages.Objetpartage;
import com.kportal.core.autorisation.ActionPermission;
import com.kportal.core.autorisation.Permission;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.ExtensionManager;
import com.kportal.extension.IExtension;
import com.kportal.extension.module.IModule;
import com.kportal.extension.module.ModuleHelper;
import com.kportal.extension.module.ModuleManager;
import com.kportal.extension.module.composant.ComposantRole;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.objetspartages.cache.CacheRoleManager;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Role;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Structure;
import com.univ.utils.Chaine;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaisieRole
extends ProcessusBean {
    private static final int MODE_AJOUT = 0;
    private static final int MODE_MODIFICATION = 1;
    private static final int MODE_SUPPRESSION = 2;
    private static final int MODE_RECHERCHE = 3;
    private static final String ECRAN_RECHERCHE = "RECHERCHE";
    private static final String ECRAN_PRINCIPAL = "PRINCIPAL";
    private static final String ECRAN_LISTE = "LISTE";
    private static Logger LOG = LoggerFactory.getLogger(SaisieRole.class);
    private final CacheRoleManager cache = (CacheRoleManager)ApplicationContextManager.getCoreContextBean("cacheRoleManager");
    Role role = null;
    AutorisationBean autorisations = null;
    Long[] listeIdentifiant = null;
    private int mode = -1;

    public SaisieRole(InfoBean ciu) {
        super(ciu);
    }

    private void initialisation() throws Exception {
        this.role = new Role();
        this.role.setCtx(this);
        this.role.init();
        this.infoBean.set("LISTE_TECHS", CodeLibelle.lireTable(this.infoBean.getNomExtension(), "permission_objet_tech", null));
        this.etat = 1;
        if (this.action.equals("AJOUTER")) {
            this.mode = 0;
            this.infoBean.setEtatObjet("CREATION");
            this.preparerPRINCIPAL();
        } else if (this.action.equals("MODIFIER")) {
            this.mode = 1;
            this.infoBean.setEtatObjet("MODIFICATION");
            this.preparerRECHERCHE();
        } else if (this.action.equals("MODIFIERPARID")) {
            String paramIdRole = this.infoBean.getString("ID_ROLE");
            long idRole = 0L;
            if (StringUtils.isNotBlank((CharSequence)paramIdRole) && StringUtils.isNumeric((CharSequence)paramIdRole)) {
                idRole = Long.valueOf(paramIdRole);
            }
            this.role.setIdRole(idRole);
            try {
                this.role.retrieve();
            }
            catch (Exception e) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "ROLE.ERREUR.ROLE_INEXISTANT"));
            }
            this.mode = 1;
            this.infoBean.setEtatObjet("MODIFICATION");
            this.preparerPRINCIPAL();
        } else if (this.action.equals("SUPPRIMER")) {
            this.mode = 2;
            this.infoBean.setEtatObjet("SUPPRESSION");
            this.preparerRECHERCHE();
        } else if (this.action.equals("SUPPRIMERPARID")) {
            this.supprimerParId(Long.valueOf(this.infoBean.getString("ID_ROLE")));
        } else if (this.action.equals("RECHERCHER")) {
            this.mode = 3;
            this.infoBean.setEtatObjet(ECRAN_RECHERCHE);
            this.preparerRECHERCHE();
        }
    }

    private void preparerLISTE() throws Exception {
        int i = 0;
        this.ecranLogique = ECRAN_LISTE;
        ClauseWhere whereIdRole = new ClauseWhere(ConditionHelper.egalVarchar("ID_ROLE", this.infoBean.getString("ID_ROLE")));
        int count = this.role.select(whereIdRole.formaterSQL());
        this.listeIdentifiant = new Long[count];
        while (this.role.nextItem()) {
            this.infoBean.set("CODE#" + i, this.role.getCode());
            this.infoBean.set("LIBELLE#" + i, this.role.getLibelle());
            this.infoBean.set("ID_ROLE#" + i, this.role.getIdRole());
            this.listeIdentifiant[i] = this.role.getIdRole();
            ++i;
        }
        this.infoBean.set("LISTE_NB_ITEMS", i);
    }

    private void preparerPRINCIPAL() throws Exception {
        this.ecranLogique = ECRAN_PRINCIPAL;
        this.infoBean.set("CODE", this.role.getCode());
        this.infoBean.set("LIBELLE", this.role.getLibelle());
        Perimetre perimetre = new Perimetre(this.role.getPerimetre());
        this.infoBean.set("STRUCTURE_TYPE_PERIMETRE", "");
        this.infoBean.set("STRUCTURE_PERIMETRE", "");
        this.infoBean.set("LIBELLE_STRUCTURE_PERIMETRE", "");
        if (perimetre.getCodeStructure().equals("")) {
            this.infoBean.set("STRUCTURE_TYPE_PERIMETRE", "0");
        } else if (perimetre.getCodeStructure().equals("-")) {
            this.infoBean.set("STRUCTURE_TYPE_PERIMETRE", "2");
        } else {
            this.infoBean.set("STRUCTURE_TYPE_PERIMETRE", "1");
            this.infoBean.set("STRUCTURE_PERIMETRE", perimetre.getCodeStructure());
            this.infoBean.set("LIBELLE_STRUCTURE_PERIMETRE", Structure.getLibelleAffichable(perimetre.getCodeStructure(), ""));
        }
        this.infoBean.set("RUBRIQUE_TYPE_PERIMETRE", "");
        this.infoBean.set("RUBRIQUE_PERIMETRE", "");
        this.infoBean.set("LIBELLE_RUBRIQUE_PERIMETRE", "");
        if (perimetre.getCodeRubrique().equals("")) {
            this.infoBean.set("RUBRIQUE_TYPE_PERIMETRE", "0");
        } else if (perimetre.getCodeRubrique().equals("-")) {
            this.infoBean.set("RUBRIQUE_TYPE_PERIMETRE", "2");
        } else {
            this.infoBean.set("RUBRIQUE_TYPE_PERIMETRE", "1");
            this.infoBean.set("RUBRIQUE_PERIMETRE", perimetre.getCodeRubrique());
            this.infoBean.set("LIBELLE_RUBRIQUE_PERIMETRE", Rubrique.renvoyerItemRubrique(perimetre.getCodeRubrique()).getIntitule());
        }
        this.infoBean.set("GROUPE_TYPE_PERIMETRE", "");
        this.infoBean.set("GROUPE_PERIMETRE", "");
        this.infoBean.set("LIBELLE_GROUPE_PERIMETRE", "");
        if (perimetre.getCodeGroupe().equals("")) {
            this.infoBean.set("GROUPE_TYPE_PERIMETRE", "0");
        } else if (perimetre.getCodeGroupe().equals("-")) {
            this.infoBean.set("GROUPE_TYPE_PERIMETRE", "2");
        } else {
            this.infoBean.set("GROUPE_TYPE_PERIMETRE", "1");
            this.infoBean.set("GROUPE_PERIMETRE", perimetre.getCodeGroupe());
            this.infoBean.set("LIBELLE_GROUPE_PERIMETRE", Groupedsi.getIntitule(perimetre.getCodeGroupe()));
        }
        if (Espacecollaboratif.isExtensionActivated()) {
            if (perimetre.getCodeEspaceCollaboratif().equals("*")) {
                this.infoBean.set("ESPACE_COLLABORATIF_COURANT_PERIMETRE", "1");
            } else {
                this.infoBean.set("ESPACE_COLLABORATIF_COURANT_PERIMETRE", "0");
            }
        }
        this.infoBean.set("PERMISSIONS", this.role.getPermissions());
        ModuleManager moduleManager = ModuleHelper.getModuleManager();
        ExtensionManager extensionManager = ExtensionHelper.getExtensionManager();
        HashMap permissionsByType = new HashMap();
        if (moduleManager.getModules().size() > 0) {
            for (IExtension extension : extensionManager.getExtensions().values()) {
                ArrayList<IModule> modules = new ArrayList<IModule>();
                modules.addAll(extension.getModules());
                Collections.sort(modules, new Comparator<IModule>(){

                    @Override
                    public int compare(IModule o1, IModule o2) {
                        int nbActionsO1 = 0;
                        int nbActionsO2 = 0;
                        for (Permission permission : o1.getPermissions()) {
                            nbActionsO1 += permission.getActions().size();
                        }
                        for (Permission permission : o2.getPermissions()) {
                            nbActionsO2 += permission.getActions().size();
                        }
                        return nbActionsO2 - nbActionsO1;
                    }
                });
                for (IModule module : modules) {
                    if (module.getEtat() != 1) continue;
                    for (Permission permission : module.getPermissions()) {
                        if (permissionsByType.get((Object)permission.getType()) == null) {
                            permissionsByType.put(permission.getType(), new ArrayList());
                        }
                        ((List)permissionsByType.get((Object)permission.getType())).add(permission);
                    }
                }
            }
        }
        this.infoBean.setInt("DEBUT_ONGLET_0", 0);
        int i = 0;
        int j = 0;
        int k = 0;
        int indiceOnglet = 0;
        Enumeration<PermissionBean> enumPermissions = null;
        String[] ordre = ReferentielObjets.getOrdreOnglets();
        while (k < ordre.length) {
            String codeObjet = ordre[k];
            Objetpartage objet = ReferentielObjets.getObjetByCode(codeObjet);
            if (ReferentielObjets.instancierFiche(codeObjet) == null || objet.isStrictlyCollaboratif()) {
                ++k;
                continue;
            }
            int nbActions = 0;
            if (i == 0) {
                this.infoBean.set("PERMISSION_ONGLET_" + i, "contenu");
                this.infoBean.set("PERMISSION_PERIMETRE_" + i + "_0", "rubrique");
                this.infoBean.set("PERMISSION_PERIMETRE_" + i + "_1", "structure");
                this.infoBean.set("PERMISSION_TITRE_" + i, "Fiches");
                ++indiceOnglet;
            }
            this.infoBean.set("PERMISSION_TYPE_" + i, "FICHE");
            this.infoBean.set("PERMISSION_CODE_OBJET_" + i, codeObjet);
            this.infoBean.set("PERMISSION_INTITULE_" + i, ReferentielObjets.getLibelleObjet(codeObjet));
            this.infoBean.set("PERMISSION_HORS_PERIMETRE_" + i, "0");
            this.infoBean.set("PERMISSION_ACTION_" + i + "_" + nbActions, "C");
            if (!ReferentielObjets.isActionParametrableDansRole(ReferentielObjets.getNomObjet(codeObjet), "C")) {
                this.infoBean.set("PERMISSION_ACTION_DISABLED_" + i + "_" + nbActions, "1");
            }
            this.infoBean.set("PERMISSION_ACTION_" + i + "_" + ++nbActions, "M");
            if (!ReferentielObjets.isActionParametrableDansRole(ReferentielObjets.getNomObjet(codeObjet), "M")) {
                this.infoBean.set("PERMISSION_ACTION_DISABLED_" + i + "_" + nbActions, "1");
            }
            this.infoBean.set("PERMISSION_ACTION_" + i + "_" + ++nbActions, "D");
            if (!ReferentielObjets.isActionParametrableDansRole(ReferentielObjets.getNomObjet(codeObjet), "D")) {
                this.infoBean.set("PERMISSION_ACTION_DISABLED_" + i + "_" + nbActions, "1");
            }
            this.infoBean.set("PERMISSION_ACTION_" + i + "_" + ++nbActions, "S");
            if (!ReferentielObjets.isActionParametrableDansRole(ReferentielObjets.getNomObjet(codeObjet), "S")) {
                this.infoBean.set("PERMISSION_ACTION_DISABLED_" + i + "_" + nbActions, "1");
            }
            this.infoBean.set("PERMISSION_ACTION_" + i + "_" + ++nbActions, "V");
            if (!ReferentielObjets.isActionParametrableDansRole(ReferentielObjets.getNomObjet(codeObjet), "V")) {
                this.infoBean.set("PERMISSION_ACTION_DISABLED_" + i + "_" + nbActions, "1");
            }
            this.infoBean.set("PERMISSION_ACTION_" + i + "_" + ++nbActions, "N");
            if (!ReferentielObjets.isActionParametrableDansRole(ReferentielObjets.getNomObjet(codeObjet), "N")) {
                this.infoBean.set("PERMISSION_ACTION_DISABLED_" + i + "_" + nbActions, "1");
            }
            this.infoBean.set("PERMISSION_ACTION_" + i + "_" + ++nbActions, "U");
            if (!ReferentielObjets.isActionParametrableDansRole(ReferentielObjets.getNomObjet(codeObjet), "U")) {
                this.infoBean.set("PERMISSION_ACTION_DISABLED_" + i + "_" + nbActions, "1");
            }
            this.infoBean.set("PERMISSION_ACTION_" + i + "_" + ++nbActions, "R");
            if (!ReferentielObjets.isActionParametrableDansRole(ReferentielObjets.getNomObjet(codeObjet), "R")) {
                this.infoBean.set("PERMISSION_ACTION_DISABLED_" + i + "_" + nbActions, "1");
            }
            if (i == 0) {
                nbActions = 0;
                this.infoBean.set("PERMISSION_ACTION_LIBELLE_" + i + "_" + nbActions++, "Cr\u00e9ation");
                this.infoBean.set("PERMISSION_ACTION_LIBELLE_" + i + "_" + nbActions++, "Modification");
                this.infoBean.set("PERMISSION_ACTION_LIBELLE_" + i + "_" + nbActions++, "Traduction");
                this.infoBean.set("PERMISSION_ACTION_LIBELLE_" + i + "_" + nbActions++, "Suppression");
                this.infoBean.set("PERMISSION_ACTION_LIBELLE_" + i + "_" + nbActions++, "Validation");
                this.infoBean.set("PERMISSION_ACTION_LIBELLE_" + i + "_" + nbActions++, "Notification");
                this.infoBean.set("PERMISSION_ACTION_LIBELLE_" + i + "_" + nbActions++, "Mise en ligne");
                this.infoBean.set("PERMISSION_ACTION_LIBELLE_" + i + "_" + nbActions++, "Suppression");
            }
            enumPermissions = this.role.getVecteurPermissions().elements();
            while (enumPermissions.hasMoreElements()) {
                PermissionBean permission = enumPermissions.nextElement();
                if (!permission.getType().equals("FICHE") || !permission.getObjet().equals(codeObjet)) continue;
                if (permission.getAction().equals("C")) {
                    this.infoBean.set("PERMISSION_ACTION_SELECT_" + i + "_0", "1");
                }
                if (permission.getAction().equals("M")) {
                    this.infoBean.set("PERMISSION_ACTION_SELECT_" + i + "_1", "1");
                }
                if (permission.getAction().equals("D")) {
                    this.infoBean.set("PERMISSION_ACTION_SELECT_" + i + "_2", "1");
                }
                if (permission.getAction().equals("S")) {
                    this.infoBean.set("PERMISSION_ACTION_SELECT_" + i + "_3", "1");
                }
                if (permission.getAction().equals("V")) {
                    this.infoBean.set("PERMISSION_ACTION_SELECT_" + i + "_4", "1");
                }
                if (permission.getAction().equals("N")) {
                    this.infoBean.set("PERMISSION_ACTION_SELECT_" + i + "_5", "1");
                }
                if (permission.getAction().equals("U")) {
                    this.infoBean.set("PERMISSION_ACTION_SELECT_" + i + "_6", "1");
                }
                if (!permission.getAction().equals("R")) continue;
                this.infoBean.set("PERMISSION_ACTION_SELECT_" + i + "_7", "1");
            }
            this.infoBean.setInt("PERMISSIONS_NB_ACTIONS_" + i, 8);
            ++i;
            ++k;
        }
        Hashtable<String, String> hDejaAffiche = new Hashtable<String, String>();
        Hashtable<String, String> hPermissionsTechniques = CodeLibelle.lireTable(this.infoBean.getNomExtension(), "permission_objet_tech", null);
        i = this.ajouterPermissionTechnique(i, "rub", hPermissionsTechniques.get("rub"), "Gestion \u00e9ditoriale", hDejaAffiche, new String[]{"C", "M", "S", "P"}, null);
        i = this.ajouterPermissionTechnique(i, "pho", hPermissionsTechniques.get("pho"), null, hDejaAffiche, new String[]{"U", "C", "M", "S"}, null);
        i = this.ajouterPermissionTechnique(i, "enc", hPermissionsTechniques.get("enc"), null, hDejaAffiche, new String[]{"M"}, null);
        if (CollectionUtils.isNotEmpty((Collection)((Collection)permissionsByType.get((Object)Permission.Type.CONTENU)))) {
            i = this.ajouterPermissionExtension(i, (List)permissionsByType.get((Object)Permission.Type.CONTENU));
        }
        this.infoBean.setInt("FIN_ONGLET_0", i - 1);
        Hashtable<String, String> hPermissionsValidation = AutorisationBean.getListeNiveauxApprobation();
        if (MapUtils.isNotEmpty(hPermissionsValidation)) {
            this.infoBean.setInt("DEBUT_ONGLET_" + indiceOnglet, i);
            i = this.mapRoleMultiNiveau(i, ordre, hPermissionsValidation);
            this.infoBean.setInt("FIN_ONGLET_" + indiceOnglet, i - 1);
            ++indiceOnglet;
        }
        this.infoBean.setInt("DEBUT_ONGLET_" + indiceOnglet, i);
        this.infoBean.set("PERMISSION_ONGLET_" + i, "contribution-avancee");
        i = this.ajouterPermissionTechnique(i, "mda", hPermissionsTechniques.get("mda"), "Mode de contribution", hDejaAffiche, null, null);
        i = this.ajouterPermissionTechnique(i, "flf", hPermissionsTechniques.get("flf"), "Fonctionnalit\u00e9s avanc\u00e9es", hDejaAffiche, null, null);
        i = this.ajouterPermissionTechnique(i, "fat", hPermissionsTechniques.get("fat"), null, hDejaAffiche, null, null);
        i = this.ajouterPermissionTechnique(i, "fra", hPermissionsTechniques.get("fra"), null, hDejaAffiche, null, null);
        i = this.ajouterPermissionTechnique(i, "fgm", hPermissionsTechniques.get("fgm"), null, hDejaAffiche, null, null);
        i = this.ajouterPermissionTechnique(i, "fpg", hPermissionsTechniques.get("fpg"), null, hDejaAffiche, null, null);
        i = this.ajouterPermissionTechnique(i, "mdh", hPermissionsTechniques.get("mdh"), null, hDejaAffiche, null, null);
        if (CollectionUtils.isNotEmpty((Collection)((Collection)permissionsByType.get((Object)Permission.Type.CONTRIBUTION)))) {
            i = this.ajouterPermissionExtension(i, (List)permissionsByType.get((Object)Permission.Type.CONTRIBUTION));
        }
        this.infoBean.setInt("FIN_ONGLET_" + indiceOnglet, i - 1);
        ++indiceOnglet;
        String activationDsi = PropertyHelper.getCoreProperty("dsi.activation");
        this.infoBean.set("GRS_SAISIE_DSI", "0");
        if ("1".equals(activationDsi)) {
            this.infoBean.set("GRS_SAISIE_DSI", "1");
            this.infoBean.setInt("DEBUT_ONGLET_" + indiceOnglet, i);
            this.infoBean.set("PERMISSION_PERIMETRE_" + i + "_0", "groupe");
            this.infoBean.set("PERMISSION_ONGLET_" + i, "diffusion");
            if (CollectionUtils.isNotEmpty((Collection)((Collection)permissionsByType.get((Object)Permission.Type.DIFFUSION)))) {
                i = this.ajouterPermissionExtension(i, (List)permissionsByType.get((Object)Permission.Type.DIFFUSION));
            }
            i = this.ajouterPermissionTechnique(i, "dsi", hPermissionsTechniques.get("dsi"), "Groupes", hDejaAffiche, null, null);
            this.infoBean.setInt("FIN_ONGLET_" + indiceOnglet, i - 1);
            ++indiceOnglet;
        } else {
            hPermissionsTechniques.remove("dsi");
        }
        if (Espacecollaboratif.isExtensionActivated()) {
            this.infoBean.setInt("DEBUT_ONGLET_" + indiceOnglet, i);
            k = 0;
            j = i;
            this.infoBean.set("PERMISSION_ONGLET_" + i, "collaboratif");
            while (k < ordre.length) {
                String codeObjet = ordre[k];
                if (!ReferentielObjets.getObjetByCode(codeObjet).isCollaboratif()) {
                    ++k;
                    continue;
                }
                if (j == i) {
                    this.infoBean.set("PERMISSION_TITRE_" + i, "Fiches");
                }
                this.infoBean.set("PERMISSION_TYPE_" + i, "FICHE");
                this.infoBean.set("PERMISSION_CODE_OBJET_" + i, codeObjet);
                this.infoBean.set("PERMISSION_INTITULE_" + i, ReferentielObjets.getLibelleObjet(codeObjet));
                this.infoBean.set("PERMISSION_HORS_PERIMETRE_" + i, "0");
                this.infoBean.set("PERMISSION_ACTION_" + i + "_0", "C");
                if (!ReferentielObjets.isActionParametrableDansRole(ReferentielObjets.getNomObjet(codeObjet), "C")) {
                    this.infoBean.set("PERMISSION_ACTION_DISABLED_" + i + "_0", "1");
                }
                this.infoBean.set("PERMISSION_ACTION_" + i + "_1", "M");
                if (!ReferentielObjets.isActionParametrableDansRole(ReferentielObjets.getNomObjet(codeObjet), "M")) {
                    this.infoBean.set("PERMISSION_ACTION_DISABLED_" + i + "_1", "1");
                }
                this.infoBean.set("PERMISSION_ACTION_" + i + "_2", "S");
                if (!ReferentielObjets.isActionParametrableDansRole(ReferentielObjets.getNomObjet(codeObjet), "S")) {
                    this.infoBean.set("PERMISSION_ACTION_DISABLED_" + i + "_2", "1");
                }
                this.infoBean.set("PERMISSION_ACTION_" + i + "_3", "V");
                if (!ReferentielObjets.isActionParametrableDansRole(ReferentielObjets.getNomObjet(codeObjet), "V")) {
                    this.infoBean.set("PERMISSION_ACTION_DISABLED_" + i + "_3", "1");
                }
                if (j == i) {
                    this.infoBean.set("PERMISSION_ACTION_LIBELLE_" + i + "_0", "Cr\u00e9ation");
                    this.infoBean.set("PERMISSION_ACTION_LIBELLE_" + i + "_1", "Modification");
                    this.infoBean.set("PERMISSION_ACTION_LIBELLE_" + i + "_2", "Suppression");
                    this.infoBean.set("PERMISSION_ACTION_LIBELLE_" + i + "_3", "Validation");
                }
                enumPermissions = this.role.getVecteurPermissions().elements();
                while (enumPermissions.hasMoreElements()) {
                    PermissionBean permission = enumPermissions.nextElement();
                    if (!permission.getType().equals("FICHE") || !permission.getObjet().equals(codeObjet)) continue;
                    if (permission.getAction().equals("C")) {
                        this.infoBean.set("PERMISSION_ACTION_SELECT_" + i + "_0", "1");
                    }
                    if (permission.getAction().equals("M")) {
                        this.infoBean.set("PERMISSION_ACTION_SELECT_" + i + "_1", "1");
                    }
                    if (permission.getAction().equals("S")) {
                        this.infoBean.set("PERMISSION_ACTION_SELECT_" + i + "_2", "1");
                    }
                    if (!permission.getAction().equals("V")) continue;
                    this.infoBean.set("PERMISSION_ACTION_SELECT_" + i + "_3", "1");
                }
                this.infoBean.setInt("PERMISSIONS_NB_ACTIONS_" + i, 4);
                ++k;
                ++i;
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)permissionsByType.get((Object)Permission.Type.COLLABORATIF)))) {
                i = this.ajouterPermissionExtension(i, (List)permissionsByType.get((Object)Permission.Type.COLLABORATIF));
            }
            i = this.ajouterPermissionTechnique(i, "ges", hPermissionsTechniques.get("ges"), "Gestion des espaces", hDejaAffiche, null, null);
            this.infoBean.setInt("FIN_ONGLET_" + indiceOnglet, i - 1);
            ++indiceOnglet;
        } else {
            hPermissionsTechniques.remove("ges");
        }
        this.infoBean.setInt("DEBUT_ONGLET_" + indiceOnglet, i);
        this.infoBean.set("PERMISSION_ONGLET_" + i, "administration");
        if (CollectionUtils.isNotEmpty((Collection)((Collection)permissionsByType.get((Object)Permission.Type.ADMINISTRATION)))) {
            i = this.ajouterPermissionExtension(i, (List)permissionsByType.get((Object)Permission.Type.ADMINISTRATION));
        }
        i = this.ajouterPermissionTechnique(i, "wmg", hPermissionsTechniques.get("wmg"), "Super administrateur", hDejaAffiche, null, null);
        this.infoBean.setInt("FIN_ONGLET_" + indiceOnglet, i - 1);
        ++indiceOnglet;
        if (CollectionUtils.isNotEmpty((Collection)((Collection)permissionsByType.get((Object)Permission.Type.MODULE)))) {
            this.infoBean.setInt("DEBUT_ONGLET_" + indiceOnglet, i);
            this.infoBean.set("PERMISSION_ONGLET_" + i, "modules");
            i = this.ajouterPermissionExtension(i, (List)permissionsByType.get((Object)Permission.Type.MODULE));
            this.infoBean.setInt("FIN_ONGLET_" + indiceOnglet, i - 1);
            ++indiceOnglet;
            this.infoBean.set("GRS_SAISIE_MODULES", "1");
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)permissionsByType.get((Object)Permission.Type.SCRIPT)))) {
            this.infoBean.setInt("DEBUT_ONGLET_" + indiceOnglet, i);
            this.infoBean.set("PERMISSION_ONGLET_" + i, "scripts");
            i = this.ajouterPermissionExtension(i, (List)permissionsByType.get((Object)Permission.Type.SCRIPT));
            this.infoBean.setInt("FIN_ONGLET_" + indiceOnglet, i - 1);
            ++indiceOnglet;
            this.infoBean.set("GRS_SAISIE_MODULES", "1");
        }
        this.infoBean.setInt("PERMISSIONS_NB_ITEMS", i);
        this.infoBean.setInt("ONGLETS_NB_ITEMS", indiceOnglet);
        if (StringUtils.isNotBlank((CharSequence)this.role.getLibelle())) {
            this.infoBean.setTitreEcran(this.role.getLibelle());
        }
    }

    private int mapRoleMultiNiveau(int i, String[] ordre, Hashtable<String, String> hPermissionsValidation) {
        int debutIndex = i;
        TreeSet<String> tmPermissionsValidation = AutorisationBean.getListePermissionsValidation();
        this.infoBean.set("PERMISSION_ONGLET_" + i, "validation-multi-niveau");
        this.infoBean.set("PERMISSION_TITRE_" + i, "Fiches");
        int j = 0;
        int k = 0;
        while (k < ordre.length) {
            String codeObjet = ordre[k];
            Objetpartage objet = ReferentielObjets.getObjetByCode(codeObjet);
            if (ReferentielObjets.instancierFiche(codeObjet) == null || objet.isStrictlyCollaboratif()) {
                ++k;
                continue;
            }
            j = 0;
            int indexPermission = 0;
            this.infoBean.set("PERMISSION_CODE_OBJET_" + i, codeObjet);
            this.infoBean.set("PERMISSION_TYPE_" + i, "FICHE");
            this.infoBean.set("PERMISSION_HORS_PERIMETRE_" + i, "0");
            this.infoBean.set("PERMISSION_INTITULE_" + i, ReferentielObjets.getLibelleObjet(codeObjet));
            for (String code : tmPermissionsValidation) {
                this.infoBean.set("PERMISSION_ACTION_" + i + "_" + j, code);
                if (i == debutIndex) {
                    this.infoBean.set("PERMISSION_ACTION_LIBELLE_" + i + "_" + j, hPermissionsValidation.get(code));
                }
                if (!ReferentielObjets.isActionParametrableDansRole(ReferentielObjets.getNomObjet(codeObjet), code)) {
                    this.infoBean.set("PERMISSION_ACTION_DISABLED_" + i + "_" + j, "1");
                }
                ++j;
            }
            Enumeration<PermissionBean> enumPermissions = this.role.getVecteurPermissions().elements();
            if (enumPermissions != null) {
                while (enumPermissions.hasMoreElements()) {
                    indexPermission = 0;
                    PermissionBean permission = enumPermissions.nextElement();
                    if (!permission.getType().equals("FICHE") || !permission.getObjet().equals(codeObjet)) continue;
                    for (String code : tmPermissionsValidation) {
                        if (permission.getAction().equals(code)) {
                            this.infoBean.set("PERMISSION_ACTION_SELECT_" + i + "_" + indexPermission, "1");
                        }
                        ++indexPermission;
                    }
                }
            }
            this.infoBean.setInt("PERMISSIONS_NB_ACTIONS_" + i, j);
            ++k;
            ++i;
        }
        return i;
    }

    private int ajouterPermissionExtension(int i, List<Permission> permissions) throws Exception {
        String idExtension = "";
        String section = null;
        for (Permission permission : permissions) {
            IExtension extension = ExtensionHelper.getExtension(permission.getIdExtension());
            if (!permission.getIdExtension().equals(idExtension)) {
                idExtension = permission.getIdExtension();
                section = extension.getLibelleAffichable(extension.getLibelle());
            }
            i = this.ajouterPermissionModule(i, permission.getId(), permission.getCode(), section, permission.getLibelleAffichable(), permission.getActions());
            section = null;
        }
        return i;
    }

    public int ajouterPermissionTechnique(int _nbItems, String objet, String intituleObjet, String titreSection, Hashtable<String, String> hDejaAffiche, String[] codesAction, String titreActionParDefaut) throws Exception {
        int nbItems = _nbItems;
        if (hDejaAffiche.get(objet) == null) {
            int j;
            this.infoBean.set("PERMISSION_TITRE_" + nbItems, titreSection);
            this.infoBean.set("PERMISSION_TYPE_" + nbItems, "TECH");
            this.infoBean.set("PERMISSION_CODE_OBJET_" + nbItems, objet);
            this.infoBean.set("PERMISSION_INTITULE_" + nbItems, intituleObjet);
            this.infoBean.set("PERMISSION_HORS_PERIMETRE_" + nbItems, "0");
            int nbActions = 0;
            Hashtable<String, String> listeActions = CodeLibelle.lireTable(this.infoBean.getNomExtension(), "permission_action_tech_" + objet, null);
            if (codesAction == null) {
                if (listeActions.size() == 0) {
                    this.infoBean.set("PERMISSION_ACTION_" + nbItems + "_0", "");
                    nbActions = 1;
                } else {
                    Enumeration<String> eActions = listeActions.keys();
                    while (eActions.hasMoreElements()) {
                        this.infoBean.set("PERMISSION_ACTION_" + nbItems + "_" + nbActions, eActions.nextElement());
                        ++nbActions;
                    }
                }
            } else {
                for (String element : codesAction) {
                    this.infoBean.set("PERMISSION_ACTION_" + nbItems + "_" + nbActions, element);
                    ++nbActions;
                }
            }
            String objetSave = objet;
            for (j = 0; j < nbActions; ++j) {
                String libelleAction;
                String codeAction;
                String codeActionPourLibelle = codeAction = this.infoBean.getString("PERMISSION_ACTION_" + nbItems + "_" + j);
                objet = objetSave;
                if (objet.equals("rub") && codeAction.equals("P")) {
                    objet = "pub";
                    codeAction = "";
                }
                if (objet.equals("pho") && codeAction.equals("U")) {
                    objet = "acp";
                    codeAction = "";
                }
                if ((libelleAction = listeActions.get(codeActionPourLibelle)) == null) {
                    if (titreActionParDefaut != null) {
                        this.infoBean.set("PERMISSION_ACTION_LIBELLE_" + nbItems + "_" + j, titreActionParDefaut);
                    }
                } else {
                    this.infoBean.set("PERMISSION_ACTION_LIBELLE_" + nbItems + "_" + j, libelleAction);
                }
                Enumeration<PermissionBean> enumPermissions = this.role.getVecteurPermissions().elements();
                while (enumPermissions.hasMoreElements()) {
                    PermissionBean permission = enumPermissions.nextElement();
                    if (!permission.getType().equals("TECH") || !permission.getObjet().equals(objet) || !permission.getAction().equals(codeAction)) continue;
                    this.infoBean.set("PERMISSION_ACTION_SELECT_" + nbItems + "_" + j, "1");
                }
            }
            this.infoBean.setInt("PERMISSIONS_NB_ACTIONS_" + nbItems, j);
            hDejaAffiche.put(objet, "");
            ++nbItems;
        }
        return nbItems;
    }

    public int ajouterPermissionModule(int _nbItems, String type, String objet, String section, String intituleObjet, List<ActionPermission> actions) throws Exception {
        int nbItems = _nbItems;
        this.infoBean.set("PERMISSION_TYPE_" + nbItems, type.toUpperCase());
        this.infoBean.set("PERMISSION_CODE_OBJET_" + nbItems, objet);
        this.infoBean.set("PERMISSION_INTITULE_" + nbItems, intituleObjet);
        this.infoBean.set("PERMISSION_HORS_PERIMETRE_" + nbItems, "0");
        this.infoBean.set("PERMISSION_TITRE_" + nbItems, section);
        if (actions.size() == 0) {
            actions.add(new ActionPermission());
        }
        int nbActions = 0;
        for (ActionPermission action : actions) {
            this.infoBean.set("PERMISSION_ACTION_" + nbItems + "_" + nbActions, action.getCode());
            if (action.getLibelle().length() > 0) {
                this.infoBean.set("PERMISSION_ACTION_LIBELLE_" + nbItems + "_" + nbActions, action.getLibelle());
            }
            Enumeration<PermissionBean> enumPermissions = this.role.getVecteurPermissions().elements();
            while (enumPermissions.hasMoreElements()) {
                PermissionBean permission = enumPermissions.nextElement();
                if (!permission.getType().equals(type.toUpperCase()) || !permission.getObjet().equals(objet) || !permission.getAction().equals(action.getCode())) continue;
                this.infoBean.set("PERMISSION_ACTION_SELECT_" + nbItems + "_" + nbActions, "1");
            }
            ++nbActions;
        }
        this.infoBean.setInt("PERMISSIONS_NB_ACTIONS_" + nbItems, nbActions);
        return ++nbItems;
    }

    private void preparerRECHERCHE() throws Exception {
        this.ecranLogique = ECRAN_RECHERCHE;
        this.infoBean.set("LISTE_ROLES", Role.getAllRolesWithoutCollab());
    }

    @Override
    public boolean traiterAction() throws Exception {
        this.autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        if (this.autorisations == null) {
            this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
            this.infoBean.setEcranLogique("LOGIN");
        } else {
            if (!ComposantRole.isAutoriseParActionProcessus(this.autorisations, null)) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
            }
            try {
                this.ecranLogique = this.infoBean.getEcranLogique();
                this.action = this.infoBean.getActionUtilisateur();
                if (this.etat == 0) {
                    this.initialisation();
                } else if (this.ecranLogique.equals(ECRAN_RECHERCHE)) {
                    this.traiterRECHERCHE();
                } else if (this.ecranLogique.equals(ECRAN_LISTE)) {
                    this.traiterLISTE();
                } else if (this.ecranLogique.equals(ECRAN_PRINCIPAL)) {
                    this.traiterPRINCIPAL();
                }
                this.infoBean.setEcranLogique(this.ecranLogique);
            }
            catch (Exception e) {
                LOG.error("erreur de traitement sur le processus", (Throwable)e);
                this.infoBean.addMessageErreur(e.toString());
            }
        }
        return this.etat == 2;
    }

    private void traiterLISTE() throws Exception {
        int indice;
        if (this.action.equals("MODIFIER")) {
            indice = Integer.parseInt((String)this.infoBean.get("LISTE_INDICE"));
            this.role.setIdRole(this.listeIdentifiant[indice]);
            this.role.retrieve();
            this.preparerPRINCIPAL();
        }
        if (this.action.equals("VALIDER")) {
            indice = Integer.parseInt((String)this.infoBean.get("LISTE_INDICE"));
            this.role.setIdRole(this.listeIdentifiant[indice]);
            this.role.retrieve();
            this.remplirDonneesRecherche();
        }
        if (this.action.equals("ANNULER")) {
            this.infoBean.set("ID_ROLE", null);
            this.etat = 2;
        }
    }

    private void traiterPRINCIPAL() throws Exception {
        if (this.action.equals("VALIDER")) {
            Chaine.controlerCodeMetier((String)this.infoBean.get("CODE"));
            this.role.setCode((String)this.infoBean.get("CODE"));
            this.role.setLibelle((String)this.infoBean.get("LIBELLE"));
            String perimetreCodeEspaceCollaboratif = "";
            if ("1".equals(this.infoBean.getString("ESPACE_COLLABORATIF_COURANT_PERIMETRE"))) {
                perimetreCodeEspaceCollaboratif = "*";
            }
            String structurePerimetre = "";
            if (StringUtils.isNotBlank((CharSequence)this.infoBean.getString("STRUCTURE_PERIMETRE"))) {
                structurePerimetre = this.infoBean.getString("STRUCTURE_PERIMETRE");
            }
            String rubriquePerimetre = "";
            if (StringUtils.isNotBlank((CharSequence)this.infoBean.getString("RUBRIQUE_PERIMETRE"))) {
                rubriquePerimetre = this.infoBean.getString("RUBRIQUE_PERIMETRE");
            }
            String groupePerimetre = "";
            if (StringUtils.isNotBlank((CharSequence)this.infoBean.getString("GROUPE_PERIMETRE"))) {
                groupePerimetre = this.infoBean.getString("GROUPE_PERIMETRE");
            }
            this.role.setPerimetre(new Perimetre(structurePerimetre, rubriquePerimetre, "", groupePerimetre, perimetreCodeEspaceCollaboratif).getChaineSerialisee());
            Vector<PermissionBean> v = new Vector<PermissionBean>();
            for (int j = 0; j < this.infoBean.getInt("PERMISSIONS_NB_ITEMS"); ++j) {
                for (int k = 0; k < this.infoBean.getInt("PERMISSIONS_NB_ACTIONS_" + j); ++k) {
                    String select;
                    String permissionAction = this.infoBean.getString("PERMISSION_ACTION_" + j + "_" + k);
                    if (permissionAction == null || (select = this.infoBean.getString("PERMISSION_ACTION_SELECT_" + j + "_" + k)) == null || !select.equals("1")) continue;
                    if (this.infoBean.getString("PERMISSION_CODE_OBJET_" + j).equals("rub") && permissionAction.equals("P")) {
                        v.add(new PermissionBean(this.infoBean.getString("PERMISSION_TYPE_" + j), "pub", ""));
                        continue;
                    }
                    if (this.infoBean.getString("PERMISSION_CODE_OBJET_" + j).equals("pho") && permissionAction.equals("U")) {
                        v.add(new PermissionBean(this.infoBean.getString("PERMISSION_TYPE_" + j), "acp", ""));
                        continue;
                    }
                    v.add(new PermissionBean(this.infoBean.getString("PERMISSION_TYPE_" + j), this.infoBean.getString("PERMISSION_CODE_OBJET_" + j), permissionAction));
                }
            }
            this.role.setVecteurPermissions(v);
            if (this.mode == 0) {
                Role role2 = new Role();
                role2.setCtx(this);
                role2.init();
                if (role2.select(this.role.getCode(), "", "") > 0) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "ROLE.ERREUR.CODE_EXISTANT"));
                }
                this.role.add();
                String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_CREATION_ROLE"), this.role.getLibelle());
                this.infoBean.addMessageConfirmation(confirmation);
            }
            if (this.mode == 1) {
                this.role.update();
                String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_MODIFICATION_ROLE"), this.role.getLibelle());
                this.infoBean.addMessageConfirmation(confirmation);
            }
            this.cache.flush();
            this.etat = 2;
        } else if (this.action.equals("SUPPRIMER")) {
            this.supprimerParId(Long.valueOf(this.infoBean.getString("ID_ROLE")));
        }
    }

    private void supprimerParId(Long idRoleASupprimer) throws Exception {
        this.role.setIdRole(idRoleASupprimer);
        this.role.retrieve();
        this.role.delete();
        this.ecranLogique = ECRAN_LISTE;
        this.cache.flush();
        String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_SUPPRESSION_ROLE"), this.role.getLibelle());
        this.infoBean.addMessageConfirmation(confirmation);
        this.etat = 2;
    }

    private void traiterRECHERCHE() throws Exception {
        if (this.action.equals("MODIFIER")) {
            ClauseWhere whereIdRole = new ClauseWhere(ConditionHelper.egalVarchar("ID_ROLE", this.infoBean.getString("ID_ROLE")));
            int count = this.role.select(whereIdRole.formaterSQL());
            if (count == 0) {
                this.infoBean.addMessageErreur("Aucun enregistrement s\u00e9lectionn\u00e9");
            }
            if (count == 1) {
                this.role.nextItem();
                if (this.mode == 3) {
                    this.remplirDonneesRecherche();
                    this.etat = 2;
                } else if (this.mode == 1) {
                    this.preparerPRINCIPAL();
                } else if (this.mode == 2) {
                    this.preparerLISTE();
                }
            }
            if (count > 1) {
                this.preparerLISTE();
            }
        }
        if (this.action.equals("SUPPRIMER")) {
            try {
                Long indice = new Long(this.infoBean.getString("ID_ROLE"));
                this.role.setIdRole(indice);
                this.role.retrieve();
                this.role.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cache.flush();
            this.etat = 2;
        }
        if (this.action.equals("ANNULER") && this.mode == 3) {
            this.infoBean.set("ID_ROLE", null);
            this.etat = 2;
        }
    }

    private void remplirDonneesRecherche() throws Exception {
        this.infoBean.set("ID_ROLE", this.role.getIdRole());
        this.infoBean.set("CODE", this.role.getCode());
        this.infoBean.set("LIBELLE", this.role.getLibelle());
        this.infoBean.set("PERIMETRE", this.role.getPerimetre());
        this.infoBean.set("PERMISSIONS", this.role.getPermissions());
    }
}

