/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.core.ProcessusHelper;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.cms.objetspartages.annotation.FicheAnnotationHelper;
import com.kportal.core.config.MessageHelper;
import com.kportal.extension.module.plugin.rubrique.BeanPageAccueil;
import com.kportal.extension.module.plugin.rubrique.IPageAccueilRubrique;
import com.kportal.extension.module.plugin.rubrique.PageAccueilRubriqueManager;
import com.univ.multisites.InfosFicheComparator;
import com.univ.multisites.InfosFicheReferencee;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.FicheObjet;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Media;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Rubriquepublication;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.util.CritereRecherche;
import com.univ.objetspartages.util.CritereRechercheUtil;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteUtil;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import com.univ.utils.recherche.RechercheMultificheHelper;
import com.univ.utils.recherche.ResultatRechercheMultifiche;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaisieRubrique
extends ProcessusBean {
    public static final int MAX_FICHE_AFFICHAGE = 100;
    private static final Logger LOGGER = LoggerFactory.getLogger(SaisieRubrique.class);
    private static final int MODE_AJOUT = 0;
    private static final int MODE_MODIFICATION = 1;
    private static final int MODE_SUPPRESSION = 2;
    private static final int MODE_RECHERCHE = 3;
    private static final String ECRAN_RECHERCHE = "RECHERCHE";
    private static final String ECRAN_PRINCIPAL = "PRINCIPAL";
    private static final String ECRAN_ACCUEIL = "ACCUEIL";
    private static final String ECRAN_LISTE = "LISTE";
    private static final String ECRAN_RECHERCHE_FICHES_REFERENCEES = "RECHERCHE_FICHES_REFERENCEES";
    private static final String ECRAN_AJOUT_REQUETE = "AJOUT_REQUETE";
    private static final String ECRAN_LISTE_FICHES_REFERENCEES = "LISTE_FICHES_REFERENCEES";
    Rubrique rubrique = null;
    Long[] listeIdentifiant = null;
    AutorisationBean autorisations = null;
    TreeSet<InfosFicheReferencee> listeFichesReferencees = new TreeSet<InfosFicheReferencee>(new InfosFicheComparator());
    Collection<InfosRubriques> listeRubriqueFille = null;
    Vector<String> listeRequeteRubriquePublication = new Vector();
    Collection<InfosRubriques> listeRubriquePrincipale = null;
    private int mode = -1;

    public SaisieRubrique(InfoBean ciu) {
        super(ciu);
    }

    private void initialisation() throws Exception {
        this.rubrique = new Rubrique();
        this.rubrique.setCtx(this);
        this.rubrique.init();
        this.rubrique.setCodeRubriqueMere(StringUtils.defaultString((String)this.infoBean.getString("CODE_RUBRIQUE_MERE")));
        this.etat = 1;
        ((Hashtable)this.getDatas()).put("AUTORISATIONS", this.autorisations);
        if ("AJOUTER".equals(this.action)) {
            if (!this.autorisations.possedePermission(new PermissionBean("TECH", "rub", "C"))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
            }
            this.mode = 0;
            this.infoBean.setEtatObjet("CREATION");
            this.preparerPRINCIPAL();
        } else if ("MODIFIERRUBRIQUE".equals(this.action)) {
            this.mode = 1;
            this.infoBean.setEtatObjet("MODIFICATION");
            Long idRub = new Long((String)this.infoBean.get("ID_RUBRIQUE"));
            this.rubrique.setIdRubrique(idRub);
            this.rubrique.retrieve();
            if (!this.autorisations.possedePermission(new PermissionBean("TECH", "rub", "M"), new Perimetre("*", this.rubrique.getCode(), "*", "*", ""))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
            }
            this.preparerPRINCIPAL();
        } else if ("MODIFIERRUBRIQUEPARCODE".equals(this.action)) {
            this.mode = 1;
            this.infoBean.setEtatObjet("MODIFICATION");
            String code = this.infoBean.getString("CODE_RUBRIQUE");
            if (!this.autorisations.possedePermission(new PermissionBean("TECH", "rub", "M"), new Perimetre("*", code, "*", "*", ""))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
            }
            if (this.rubrique.select(code, "", "", "") != 1) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_RUBRIQUE_INEXISTANTE"));
            }
            this.rubrique.nextItem();
            this.preparerPRINCIPAL();
        } else if ("SUPPRIMERRUBRIQUEPARCODE".equals(this.action)) {
            String code = this.infoBean.getString("CODE_RUBRIQUE");
            if (!this.autorisations.possedePermission(new PermissionBean("TECH", "rub", "S"), new Perimetre("*", code, "*", "*", ""))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
            }
            if (this.rubrique.select(code, "", "", "") != 1) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_RUBRIQUE_INEXISTANTE"));
            }
            this.rubrique.nextItem();
            this.traiterSuppression(this.rubrique.getIdRubrique());
        } else if ("MODIFIER".equals(this.action)) {
            if (!this.autorisations.possedePermission(new PermissionBean("TECH", "rub", "M")) && !this.autorisations.possedePermission(new PermissionBean("TECH", "rub", "S"))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
            }
            this.mode = 1;
            this.infoBean.setEtatObjet("MODIFICATION");
            this.preparerRECHERCHE();
        } else if ("SUPPRIMER".equals(this.action)) {
            if (!this.autorisations.possedePermission(new PermissionBean("TECH", "rub", "S"))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
            }
            this.mode = 2;
            this.infoBean.setEtatObjet("SUPPRESSION");
            this.preparerRECHERCHE();
        } else if ("RECHERCHER".equals(this.action)) {
            if (!this.autorisations.possedePermission(new PermissionBean("TECH", "rub", "M"))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
            }
            this.mode = 3;
            this.infoBean.setEtatObjet(ECRAN_RECHERCHE);
            this.preparerRECHERCHE();
        } else if (ECRAN_ACCUEIL.equals(this.action)) {
            this.insererRechercheDansInfoBean(this.infoBean, new ArrayList<CritereRecherche>());
            this.ecranLogique = ECRAN_ACCUEIL;
        }
    }

    private void preparerLISTE() throws Exception {
        this.ecranLogique = ECRAN_LISTE;
    }

    private void preparerPRINCIPAL() throws Exception {
        this.ecranLogique = ECRAN_PRINCIPAL;
        this.infoBean.set("CODE", this.rubrique.getCode());
        this.infoBean.set("LISTE_TYPE_RUBRIQUE", PageAccueilRubriqueManager.getInstance().getListeTypesRubrique());
        this.infoBean.set("LANGUE", this.rubrique.getLangue());
        this.infoBean.set("LISTE_LANGUES", LangueUtil.getListeLangues(this.getLocale()));
        this.infoBean.set("INTITULE", this.rubrique.getIntitule());
        this.infoBean.set("ACCROCHE", this.rubrique.getAccroche());
        this.infoBean.set("ID_BANDEAU", this.rubrique.getIdBandeau().toString());
        this.infoBean.set("LISTE_BANDEAUX", Media.getListePhotoParType(this, "0100"));
        this.infoBean.set("ID_PICTO", this.rubrique.getIdPicto().toString());
        this.infoBean.set("LISTE_PICTOS", Media.getListePhotoParType(this, "0104"));
        if (this.infoBean.getEtatObjet().equals("CREATION")) {
            this.infoBean.set("LISTE_CATEGORIES", Libelle.getListe("80", LangueUtil.getLocale(ContexteUtil.getContexteUniv().getLangue())));
        } else {
            this.infoBean.set("LISTE_CATEGORIES", Libelle.getListe("80", LangueUtil.getLocale(this.rubrique.getLangue())));
        }
        this.infoBean.set("CATEGORIE", this.rubrique.getCategorie());
        this.infoBean.set("COULEUR_TITRE", this.rubrique.getCouleurTitre());
        this.infoBean.set("COULEUR_FOND", this.rubrique.getCouleurFond());
        this.infoBean.set("NOM_ONGLET", this.rubrique.getNomOnglet());
        this.infoBean.set("CONTACT", this.rubrique.getContact());
        InfosRubriques rubriqueMere = Rubrique.renvoyerItemRubrique(this.rubrique.getCodeRubriqueMere());
        this.infoBean.set("CODE_RUBRIQUE_MERE", rubriqueMere.getCode());
        this.infoBean.set("LIBELLE_CODE_RUBRIQUE_MERE", rubriqueMere.getIntitule());
        this.infoBean.set("SAUVEGARDE_CODE_RUBRIQUE_MERE", this.rubrique.getCodeRubriqueMere());
        this.infoBean.set("GRS_FILTRE_ARBRE_NOM_CODE_RUBRIQUE", "CODE_RUBRIQUE_MERE");
        this.infoBean.set("GRS_PERMISSION_TYPE", "TECH");
        this.infoBean.set("GRS_PERMISSION_OBJET", "rub");
        if (this.mode == 0) {
            this.infoBean.set("GRS_PERMISSION_ACTION", "C");
        } else {
            this.infoBean.set("GRS_PERMISSION_ACTION", "M");
        }
        this.infoBean.set("GRS_FILTRE_ARBRE_GROUPE", "1");
        this.infoBean.set("GRS_FILTRE_ARBRE_GROUPE_TYPE", "TECH");
        this.infoBean.set("GRS_FILTRE_ARBRE_GROUPE_OBJET", "dsi");
        this.infoBean.set("GRS_FILTRE_ARBRE_GROUPE_ACTION", "");
        this.infoBean.set("LISTE_RUBRIQUES", Rubrique.getListeRubriquesParIntituleComplet());
        PageAccueilRubriqueManager.getInstance().preparerPRINCIPAL(this.infoBean, this.rubrique);
        this.infoBean.set("GESTION_ENCADRE", this.rubrique.getGestionEncadre());
        this.infoBean.set("ENCADRE", this.rubrique.getEncadre());
        this.infoBean.set("ENCADRE_SOUS_RUBRIQUE", this.rubrique.getEncadreSousRubrique());
        String sTmp = Chaine.convertirPointsVirgules(Chaine.getVecteurAccolades(this.rubrique.getGroupesDsi()));
        this.infoBean.set("GROUPES_DSI", sTmp);
        this.infoBean.set("LIBELLE_GROUPES_DSI", Groupedsi.getIntitule(sTmp));
        this.infoBean.set("GRS_SAISIE_DIFFUSION", this.autorisations.isDiffuseurDSI() ? "1" : "0");
        if (this.mode == 1) {
            this.listeFichesReferencees.addAll(Rubriquepublication.getListeFichesReferences(this, this.rubrique.getCode(), true));
        }
        InfosRubriques infosRubrique = Rubrique.renvoyerItemRubrique(this.rubrique.getCode());
        this.listeRubriqueFille = infosRubrique.getListeSousRubriques();
        HashMap<String, Collection> rubriqueParRestriction = new HashMap<String, Collection>();
        if (infosRubrique.getCodeRubriqueMere().length() > 0) {
            String codeRubriqueCourante = infosRubrique.getCodeRubriqueMere();
            while (codeRubriqueCourante.length() > 0) {
                InfosRubriques infoRubriqueCourante = Rubrique.renvoyerItemRubrique(codeRubriqueCourante);
                Collection intitulesGroupes = CollectionUtils.collect(infoRubriqueCourante.getGroupesDsi(), (Transformer)new Transformer(){

                    public String transform(Object input) {
                        return Groupedsi.getIntitule((String)input);
                    }
                });
                if (CollectionUtils.isNotEmpty((Collection)intitulesGroupes)) {
                    rubriqueParRestriction.put(infoRubriqueCourante.getIntitule(), intitulesGroupes);
                }
                codeRubriqueCourante = infoRubriqueCourante.getCodeRubriqueMere();
            }
        } else {
            this.listeRubriquePrincipale = Rubrique.getListeRubriquesPrincipale();
        }
        this.infoBean.set("GROUPES_DSI_RESTRICTION", rubriqueParRestriction);
        this.listeRequeteRubriquePublication = Chaine.getVecteurAccolades(this.rubrique.getRequetesRubriquePublication());
        Hashtable<String, String> hashOjbets = new Hashtable<String, String>();
        for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
            FicheUniv fiche = ReferentielObjets.instancierFiche(codeObjet);
            if (fiche == null || fiche instanceof FicheObjet || !FicheAnnotationHelper.isAccessibleBo(fiche)) continue;
            hashOjbets.put(ReferentielObjets.getNomObjet(codeObjet), ReferentielObjets.getLibelleObjet(codeObjet));
        }
        this.infoBean.set("LISTE_OBJETS_REQUETE", hashOjbets);
        if (Rubrique.controlerPermission(this.autorisations, "TECH/pub/", this.rubrique.getCode())) {
            this.infoBean.set("GRS_SAISIE_PUBLICATION", "1");
        }
        this.rafraichirPRINCIPAL();
        if (StringUtils.isNotBlank((CharSequence)this.rubrique.getIntitule())) {
            this.infoBean.setTitreEcran(this.rubrique.getIntitule());
        }
    }

    private void rafraichirPRINCIPAL() throws Exception {
        this.infoBean.setInt("FICHES_REFERENCEES_NB_ITEMS", Math.min(this.listeFichesReferencees.size(), 100));
        int i = 0;
        for (InfosFicheReferencee infosFicheReferencee : this.listeFichesReferencees) {
            if (i == 100) break;
            this.infoBean.set("FICHE_REFERENCEE_INTITULE#" + i, infosFicheReferencee.getIntitule());
            this.infoBean.set("FICHE_REFERENCEE_CODE#" + i, infosFicheReferencee.getCode());
            this.infoBean.set("FICHE_REFERENCEE_LANGUE#" + i, infosFicheReferencee.getLangue());
            this.infoBean.set("FICHE_REFERENCEE_TYPE#" + i, infosFicheReferencee.getType());
            this.infoBean.set("FICHE_REFERENCEE_TYPE_LIBELLE#" + i, ReferentielObjets.getLibelleObjet(infosFicheReferencee.getType()));
            this.infoBean.set("FICHE_REFERENCEE_ETAT_LIBELLE#" + i, ReferentielObjets.getLibelleEtatObjet(infosFicheReferencee.getEtat()));
            FicheUniv ficheUniv = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(infosFicheReferencee.getType()));
            ficheUniv.init();
            ficheUniv.setCtx(this);
            ficheUniv.setIdFiche(new Long(infosFicheReferencee.getId()));
            String urlModification = "";
            try {
                ficheUniv.retrieve();
                if (this.autorisations.estAutoriseAModifierLaFiche(ficheUniv)) {
                    String urlModif = ProcessusHelper.getUrlProcessAction(this.infoBean, ReferentielObjets.getExtension(ficheUniv), "SAISIE_" + ReferentielObjets.getNomObjet(infosFicheReferencee.getType()).toUpperCase(), "MODIFIER", new String[][]{{"ID_FICHE", String.valueOf(ficheUniv.getIdFiche())}});
                    urlModification = "<a class=\"action modifier\" href=\"" + URLResolver.getAbsoluteUrl(urlModif, this) + "\" title=\"Modifier la fiche\">Modifier</a>";
                }
            }
            catch (Exception urlModif) {
                // empty catch block
            }
            Metatag meta = FicheUnivMgr.lireMeta(ficheUniv);
            this.infoBean.set("FICHE_REFERENCEE_ID_META#" + i, meta.getIdMetatag());
            this.infoBean.set("FICHE_REFERENCEE_URL_MODIF#" + i, urlModification);
            ++i;
        }
        i = 0;
        this.infoBean.setInt("RUBRIQUES_FILLES_NB_ITEMS", this.listeRubriqueFille.size());
        for (InfosRubriques infosRubriques : this.listeRubriqueFille) {
            String intitule = infosRubriques.getIntitule();
            if (intitule.contains("<BR>")) {
                intitule = StringUtils.replace((String)intitule, (String)"<BR>", (String)"");
            } else if (intitule.contains("<br>")) {
                intitule = StringUtils.replace((String)intitule, (String)"<br>", (String)"");
            }
            this.infoBean.set("RUBRIQUE_FILLE_CODE#" + i, infosRubriques.getCode());
            if (this.autorisations.possedePermission(new PermissionBean("TECH", "rub", "M"), new Perimetre("*", infosRubriques.getCode(), "*", "*", ""))) {
                this.infoBean.set("RUBRIQUE_FILLE_INTITULE#" + i, "<a href=\"/servlet/com.jsbsoft.jtf.core.SG?PROC=SAISIE_RUBRIQUE&amp;ACTION=MODIFIERRUBRIQUE&amp;ID_RUBRIQUE=" + infosRubriques.getIdRubrique() + "\" target=\"_blank\" title=\"Modifier la rubrique\"><span class=\"coco\">" + intitule + "</span></a>");
            } else {
                this.infoBean.set("RUBRIQUE_FILLE_INTITULE#" + i, intitule);
            }
            BeanPageAccueil beanAccueil = PageAccueilRubriqueManager.getInstance().getBeanPageAccueil(infosRubriques);
            IPageAccueilRubrique pageAccueil = PageAccueilRubriqueManager.getInstance().getPageAccueilRubrique(infosRubriques.getTypeRubrique());
            String actions = "";
            if (pageAccueil != null && beanAccueil != null) {
                String libelle = beanAccueil.getLibelleAffichable();
                String url = beanAccueil.getUrlModification(infosRubriques.getCode(), infosRubriques.getLangue(), true);
                actions = StringUtils.isNotEmpty((CharSequence)url) ? actions + "<a href=\"#\" onclick=\"openRub('" + url + "');\" title=\"Modifier la page\">" + libelle + "</a>" : actions + libelle;
                if (StringUtils.isNotBlank((CharSequence)actions)) {
                    actions = actions + " - ";
                }
                if (StringUtils.isNotEmpty((CharSequence)(url = beanAccueil.getUrlRubrique(infosRubriques.getCode(), infosRubriques.getLangue(), true)))) {
                    actions = actions + "<a href=\"#\" onclick=\"openRub('" + url + "');\" title=\"Voir la page\">Aper\u00e7u</a>";
                }
                if (StringUtils.isNotBlank((CharSequence)actions)) {
                    actions = pageAccueil.getLibelleAffichable() + " : " + actions;
                }
            }
            this.infoBean.set("RUBRIQUE_FILLE_PAGE#" + i, actions);
            ++i;
        }
        this.infoBean.setInt("REQUETE_NB_ITEMS", this.listeRequeteRubriquePublication.size());
        i = 0;
        for (String string : this.listeRequeteRubriquePublication) {
            String structure;
            String[] item = string.split("/", -2);
            String codeObjet = ReferentielObjets.getCodeObjet(item[0]);
            String libelleObjet = "-";
            if (StringUtils.isNotBlank((CharSequence)codeObjet)) {
                libelleObjet = ReferentielObjets.getLibelleObjet(codeObjet);
            }
            if ((structure = item[1]).length() > 0) {
                String[] temp = structure.split(";", -2);
                InfosStructure infosStructure = Structure.renvoyerItemStructure(temp[0]);
                if ((structure = infosStructure.getLibelleCourt().length() > 0 ? infosStructure.getLibelleCourt() : infosStructure.getLibelleLong()).equals("")) {
                    structure = "-( inexistante)";
                } else if (temp[1].equals("1")) {
                    structure = structure + " (sous structures incluses)";
                }
            } else {
                structure = "-";
            }
            String codeRubrique = item[2];
            String libelleRubrique = "";
            if (codeRubrique.length() > 0) {
                String[] temp = codeRubrique.split(";", -2);
                libelleRubrique = Rubrique.renvoyerItemRubrique(temp[0]).getIntitule();
                if (codeRubrique.length() == 0) {
                    libelleRubrique = "- (inexistante)";
                } else if ("1".equals(temp[1])) {
                    libelleRubrique = libelleRubrique + " (sous rubriques incluses)";
                }
            } else {
                libelleRubrique = "-";
            }
            String dernierItem = item[3];
            String langueRequete = "";
            if (item.length > 4) {
                langueRequete = item[3];
                dernierItem = item[4];
            }
            this.infoBean.set("REQUETE_OBJET#" + i, libelleObjet);
            this.infoBean.set("REQUETE_STRUCTURE#" + i, structure);
            this.infoBean.set("REQUETE_RUBRIQUE#" + i, libelleRubrique);
            this.infoBean.set("REQUETE_LANGUE#" + i, langueRequete);
            if ("1".equals(dernierItem)) {
                this.infoBean.set("REQUETE_MODE#" + i, "Synchronis\u00e9");
            }
            this.infoBean.set("REQUETE#" + i, string);
            ++i;
        }
        this.ecranLogique = ECRAN_PRINCIPAL;
    }

    private void preparerRECHERCHE_FICHES_REFERENCEES() throws Exception {
        this.infoBean.set("GRS_PERMISSION_TYPE", "FICHE");
        this.infoBean.set("GRS_PERMISSION_OBJET", "");
        this.infoBean.set("GRS_PERMISSION_ACTION", "M");
        this.ecranLogique = ECRAN_RECHERCHE_FICHES_REFERENCEES;
    }

    private void traiterRECHERCHE_FICHES_REFERENCEES() throws Exception {
        if ("REVENIR".equals(this.action)) {
            this.rafraichirPRINCIPAL();
        }
        if ("VALIDER".equals(this.action)) {
            this.preparerLISTE_FICHES_REFERENCEES();
        }
        this.infoBean.set("ANCRE", "contenu-fiches-ref");
    }

    private void preparerLISTE_FICHES_REFERENCEES() throws Exception {
        Date dateFinMiseEnLigne;
        Date dateDebutMiseEnLigne;
        Date dateFinModification;
        Date dateDebutModification;
        Date dateFinCreation;
        AutorisationBean autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        String sCodeRubriqueCourante = this.infoBean.getString("CODE_RUBRIQUE");
        String sLibelle = this.infoBean.getString("TITRE");
        String sCodeObjet = this.infoBean.getString("CODE_OBJET");
        String sCodeRubrique = this.infoBean.getString("CODE_RUBRIQUE_RECHERCHE");
        String sCodeRattachement = this.infoBean.getString("CODE_RATTACHEMENT");
        String sCodeRedacteur = this.infoBean.getString("CODE_REDACTEUR");
        String sIdMeta = this.infoBean.getString("ID_META");
        String urlFiche = this.infoBean.getString("URL_FICHE");
        Date dateDebutCreation = this.infoBean.getDate("DATE_CREATION_DEBUT");
        if (!Formateur.estSaisie(dateDebutCreation)) {
            dateDebutCreation = null;
        }
        if (!Formateur.estSaisie(dateFinCreation = this.infoBean.getDate("DATE_CREATION_FIN"))) {
            dateFinCreation = null;
        }
        if (!Formateur.estSaisie(dateDebutModification = this.infoBean.getDate("DATE_MODIFICATION_DEBUT"))) {
            dateDebutModification = null;
        }
        if (!Formateur.estSaisie(dateFinModification = this.infoBean.getDate("DATE_MODIFICATION_FIN"))) {
            dateFinModification = null;
        }
        if (!Formateur.estSaisie(dateDebutMiseEnLigne = this.infoBean.getDate("DATE_MISE_EN_LIGNE_DEBUT"))) {
            dateDebutMiseEnLigne = null;
        }
        if (!Formateur.estSaisie(dateFinMiseEnLigne = this.infoBean.getDate("DATE_MISE_EN_LIGNE_FIN"))) {
            dateFinMiseEnLigne = null;
        }
        ResultatRechercheMultifiche resultatRechercheMultifiche = RechercheMultificheHelper.rerchercherParmisToutesLesFiches(this, autorisations, sLibelle, sCodeObjet, "", sCodeRubrique, sCodeRattachement, sCodeRedacteur, sIdMeta, urlFiche, dateDebutCreation, dateFinCreation, dateDebutModification, dateFinModification, dateDebutMiseEnLigne, dateFinMiseEnLigne, "", "", "");
        this.infoBean.setInt("LISTE_NB_ITEMS", 0);
        int cptFiche = 0;
        if (resultatRechercheMultifiche.getResultats().size() > 0) {
            for (Metatag leMeta : resultatRechercheMultifiche.getResultats()) {
                FicheUniv fiche = FicheUnivMgr.init(leMeta);
                fiche.setCtx(this);
                fiche.setIdFiche(leMeta.getMetaIdFiche());
                fiche.retrieve();
                boolean insertion = true;
                if (fiche.getCodeRubrique().equals(sCodeRubriqueCourante)) {
                    insertion = false;
                }
                if (insertion && fiche instanceof DiffusionSelective && ((DiffusionSelective)((Object)fiche)).getDiffusionModeRestriction().equals("4")) {
                    insertion = false;
                }
                if (!insertion) continue;
                this.infoBean.set("RECHERCHE_FICHES_REFERENCEES_INTITULE#" + cptFiche, fiche.getLibelleAffichable());
                this.infoBean.set("RECHERCHE_FICHES_REFERENCEES_CODE#" + cptFiche, fiche.getCode());
                this.infoBean.set("RECHERCHE_FICHES_REFERENCEES_LANGUE#" + cptFiche, fiche.getLangue());
                String typeObjet = ReferentielObjets.getCodeObjet(fiche);
                this.infoBean.set("RECHERCHE_FICHES_REFERENCEES_TYPE#" + cptFiche, typeObjet);
                this.infoBean.set("RECHERCHE_FICHES_REFERENCEES_ID#" + cptFiche, fiche.getIdFiche().toString());
                this.infoBean.set("RECHERCHE_FICHES_REFERENCEES_ETAT#" + cptFiche, fiche.getEtatObjet());
                this.infoBean.set("RECHERCHE_FICHES_REFERENCEES_LIBELLE_TYPE#" + cptFiche, ReferentielObjets.getLibelleObjet(typeObjet));
                this.infoBean.set("RECHERCHE_FICHES_REFERENCEES_DATE#" + cptFiche, Formateur.formaterDate(fiche.getDateModification(), ""));
                String url = UnivWebFmt.determinerUrlFiche(this, ReferentielObjets.getNomObjet(typeObjet), fiche.getCode(), fiche.getLangue(), false);
                this.infoBean.set("RECHERCHE_FICHES_REFERENCEES_URL#" + cptFiche, url);
                this.infoBean.set("RECHERCHE_FICHES_REFERENCEES_INTITULE_RUBRIQUE#" + cptFiche, "");
                this.infoBean.set("RECHERCHE_FICHES_REFERENCEES_INTITULE_RUBRIQUE#" + cptFiche, Rubrique.getIntitule(fiche.getCodeRubrique()));
                this.infoBean.set("RECHERCHE_FICHES_REFERENCEES_SELECTION#" + cptFiche, "0");
                ++cptFiche;
            }
        } else {
            throw new ErreurApplicative(MessageHelper.getCoreMessage("ST_RECHERCHE_DIRECTE_AUCUN_RESULTAT"));
        }
        this.infoBean.setInt("RECHERCHE_FICHES_REFERENCEES_NB_ITEMS", cptFiche);
        this.ecranLogique = ECRAN_LISTE_FICHES_REFERENCEES;
    }

    private void traiterLISTE_FICHES_REFERENCEES() throws Exception {
        if ("REVENIR".equals(this.action)) {
            this.ecranLogique = ECRAN_RECHERCHE_FICHES_REFERENCEES;
        }
        if ("VALIDER".equals(this.action)) {
            for (int i = 0; i < this.infoBean.getInt("RECHERCHE_FICHES_REFERENCEES_NB_ITEMS"); ++i) {
                if (!this.infoBean.getString("RECHERCHE_FICHES_REFERENCEES_SELECTION#" + i).equals("1")) continue;
                InfosFicheReferencee infosFiche = new InfosFicheReferencee();
                infosFiche.setCode(this.infoBean.getString("RECHERCHE_FICHES_REFERENCEES_CODE#" + i));
                infosFiche.setType(this.infoBean.getString("RECHERCHE_FICHES_REFERENCEES_TYPE#" + i));
                infosFiche.setLangue(this.infoBean.getString("RECHERCHE_FICHES_REFERENCEES_LANGUE#" + i));
                infosFiche.setIntitule(this.infoBean.getString("RECHERCHE_FICHES_REFERENCEES_INTITULE#" + i));
                infosFiche.setEtat(this.infoBean.getString("RECHERCHE_FICHES_REFERENCEES_ETAT#" + i));
                infosFiche.setId(this.infoBean.getString("RECHERCHE_FICHES_REFERENCEES_ID#" + i));
                this.listeFichesReferencees.add(infosFiche);
            }
            this.rafraichirPRINCIPAL();
        }
    }

    private void traiterAJOUT_REQUETE() throws Exception {
        if ("REVENIR".equals(this.action)) {
            this.infoBean.setTitreEcran(this.rubrique.getIntitule());
            this.ecranLogique = ECRAN_PRINCIPAL;
        }
        if (this.action.contains("AJOUTER_REQUETE#")) {
            String requete;
            int indiceDiese = this.action.indexOf("#");
            int i = Integer.parseInt(this.action.substring(indiceDiese + 1));
            String objet = this.infoBean.getString("REQUETE_OBJET_" + i);
            String structure = this.infoBean.getString("REQUETE_STRUCTURE_" + i);
            String codeRubrique = this.infoBean.getString("REQUETE_RUBRIQUE_" + i);
            String langue = this.infoBean.getString("REQUETE_LANGUE_" + i);
            String mode = this.infoBean.getString("REQUETE_MODE_" + i);
            if ("0000".equals(objet) && "".equals(structure) && "".equals(codeRubrique) && "0000".equals(langue)) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "RUBRIQUE.REQUETE.ERREUR.CRITERE_REQUETE"));
            }
            if ("annuaire".equals(objet) && codeRubrique.length() > 0) {
                codeRubrique = "";
            }
            if (structure.length() > 0) {
                structure = structure + ";" + this.infoBean.getString("REQUETE_STRUCTURE_ARBO_" + i);
            }
            if (codeRubrique.length() > 0) {
                codeRubrique = codeRubrique + ";" + this.infoBean.getString("REQUETE_RUBRIQUE_ARBO_" + i);
            }
            if ("0000".equals(objet)) {
                objet = "";
            }
            if ("0000".equals(langue)) {
                langue = "";
            }
            if (this.listeRequeteRubriquePublication.contains(requete = objet + "/" + structure + "/" + codeRubrique + "/" + langue + "/" + mode)) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "RUBRIQUE.REQUETE.ERREUR.REQUETE_EXISTANTE"));
            }
            this.listeRequeteRubriquePublication.add(requete);
            this.infoBean.set("REQUETE_OBJET_" + i, "");
            this.infoBean.set("REQUETE_STRUCTURE_" + i, "");
            this.infoBean.set("REQUETE_RUBRIQUE_" + i, "");
            this.infoBean.set("REQUETE_LANGUE_" + i, "");
            this.infoBean.set("REQUETE_STRUCTURE_ARBO_" + i, "");
            this.infoBean.set("REQUETE_RUBRIQUE_ARBO_" + i, "");
            this.infoBean.set("LIBELLE_REQUETE_STRUCTURE_" + i, "");
            this.infoBean.set("LIBELLE_REQUETE_RUBRIQUE_" + i, "");
            this.infoBean.set("LIBELLE_REQUETE_LANGUE_" + i, "");
            this.infoBean.set("REQUETE_MODE_" + i, "");
            this.rafraichirPRINCIPAL();
            this.infoBean.setTitreEcran(this.rubrique.getIntitule());
            this.infoBean.setActionUtilisateur("VALIDER");
        }
        this.infoBean.set("ANCRE", "contenu-requete");
    }

    private void preparerRECHERCHE() throws Exception {
        this.ecranLogique = ECRAN_RECHERCHE;
        this.infoBean.set("GRS_FILTRE_ARBRE_NOM_CODE_RUBRIQUE", "CODE");
        this.infoBean.set("GRS_PERMISSION_TYPE", "TECH");
        this.infoBean.set("GRS_PERMISSION_OBJET", "rub");
        if (this.mode == 2) {
            this.infoBean.set("GRS_PERMISSION_ACTION", "C");
        }
        if (this.mode == 1) {
            this.infoBean.set("GRS_PERMISSION_ACTION", "M");
        }
        this.infoBean.set("LISTE_LANGUES", LangueUtil.getListeLangues(this.getLocale()));
    }

    @Override
    public boolean traiterAction() throws Exception {
        this.autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        if (this.autorisations == null) {
            this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
            this.infoBean.setEcranLogique("LOGIN");
        } else {
            try {
                this.infoBean.getMessages().clear();
                this.ecranLogique = this.infoBean.getEcranLogique();
                this.action = this.infoBean.getActionUtilisateur();
                if (this.etat == 0) {
                    this.initialisation();
                } else if (ECRAN_RECHERCHE.equals(this.ecranLogique)) {
                    this.traiterRECHERCHE();
                } else if (ECRAN_LISTE.equals(this.ecranLogique)) {
                    this.traiterLISTE();
                } else if (ECRAN_PRINCIPAL.equals(this.ecranLogique)) {
                    this.traiterPRINCIPAL();
                } else if (ECRAN_RECHERCHE_FICHES_REFERENCEES.equals(this.ecranLogique)) {
                    this.traiterRECHERCHE_FICHES_REFERENCEES();
                } else if (ECRAN_LISTE_FICHES_REFERENCEES.equals(this.ecranLogique)) {
                    this.traiterLISTE_FICHES_REFERENCEES();
                } else if (ECRAN_AJOUT_REQUETE.equals(this.ecranLogique)) {
                    this.traiterAJOUT_REQUETE();
                }
                this.infoBean.setEcranLogique(this.ecranLogique);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                this.infoBean.addMessageErreur(e.toString());
            }
        }
        return this.etat == 2;
    }

    private void traiterLISTE() throws Exception {
        if ("MODIFIER".equals(this.action)) {
            int indice = Integer.parseInt((String)this.infoBean.get("LISTE_INDICE"));
            this.rubrique.setIdRubrique(this.listeIdentifiant[indice]);
            this.rubrique.retrieve();
            this.preparerPRINCIPAL();
        } else if ("VALIDER".equals(this.action)) {
            int indice = Integer.parseInt((String)this.infoBean.get("LISTE_INDICE"));
            this.rubrique.setIdRubrique(this.listeIdentifiant[indice]);
            this.rubrique.retrieve();
            this.remplirDonneesRecherche();
            this.etat = 2;
        } else if ("SUPPRIMER".equals(this.action)) {
            int indice = Integer.parseInt((String)this.infoBean.get("LISTE_INDICE"));
            this.traiterSuppression(this.listeIdentifiant[indice]);
        } else if ("ANNULER".equals(this.action)) {
            this.infoBean.set("ID_RUBRIQUE", null);
            this.etat = 2;
        }
    }

    private void traiterSuppression(Long idRubrique) throws Exception {
        this.rubrique.setIdRubrique(idRubrique);
        this.rubrique.delete();
        Rubrique.rechargement();
        this.infoBean.addMessageConfirmation(MessageHelper.getCoreMessage("CONFIRMATION_SUPPRESSION_RUBRIQUE"));
        this.etat = 2;
    }

    private void traiterPRINCIPAL() throws Exception {
        if ("AJOUTER_REQUETE".equals(this.action)) {
            this.infoBean.setTitreEcran(MessageHelper.getCoreMessage("SAISIE_RUBRIQUE.PRINCIPAL.AJOUTER_REQUETE"));
            this.ecranLogique = ECRAN_AJOUT_REQUETE;
        } else if (this.action.equals("AJOUTER_FICHE_REFERENCEE")) {
            this.preparerRECHERCHE_FICHES_REFERENCEES();
        } else if (this.action.contains("SUPPRIMER_FICHE_REFERENCEE")) {
            this.infoBean.set("ANCRE", "contenu-fiches-ref");
            int indiceDiese = this.action.indexOf("#");
            int i = Integer.parseInt(this.action.substring(indiceDiese + 1));
            InfosFicheReferencee infosFiche = new InfosFicheReferencee();
            infosFiche.setCode(this.infoBean.getString("FICHE_REFERENCEE_CODE#" + i));
            infosFiche.setType(this.infoBean.getString("FICHE_REFERENCEE_TYPE#" + i));
            infosFiche.setLangue(this.infoBean.getString("FICHE_REFERENCEE_LANGUE#" + i));
            infosFiche.setIntitule(this.infoBean.getString("FICHE_REFERENCEE_INTITULE#" + i));
            this.listeFichesReferencees.remove(infosFiche);
            this.rafraichirPRINCIPAL();
            String confirmation = MessageHelper.getCoreMessage("BO_RUBRIQUE_CONFIRMATION_SUPPRESSION_REFERENCE_FICHE");
            this.infoBean.addMessageConfirmation(String.format(confirmation, infosFiche.getIntitule()));
        } else if (this.action.contains("SUPPRIMER_REQUETE")) {
            this.infoBean.set("ANCRE", "contenu-requete");
            int indiceDiese = this.action.indexOf("#");
            int i = Integer.parseInt(this.action.substring(indiceDiese + 1));
            this.listeRequeteRubriquePublication.remove(this.infoBean.getString("REQUETE#" + i));
            this.rafraichirPRINCIPAL();
            this.infoBean.addMessageConfirmation(MessageHelper.getCoreMessage("BO_RUBRIQUE_CONFIRMATION_SUPPRESSION_REQUETE"));
        } else if (this.action.contains("REMONTER_RUBRIQUE_FILLE#")) {
            int indiceDiese = this.action.indexOf("#");
            int indice = Integer.parseInt(this.action.substring(indiceDiese + 1));
            String tmpCode = this.infoBean.getString("RUBRIQUE_FILLE_CODE#" + indice);
            String tmpIntitule = this.infoBean.getString("RUBRIQUE_FILLE_INTITULE#" + indice);
            String tmpPage = this.infoBean.getString("RUBRIQUE_FILLE_PAGE#" + indice);
            this.infoBean.set("RUBRIQUE_FILLE_CODE#" + indice, this.infoBean.getString("RUBRIQUE_FILLE_CODE#" + (indice - 1)));
            this.infoBean.set("RUBRIQUE_FILLE_INTITULE#" + indice, this.infoBean.getString("RUBRIQUE_FILLE_INTITULE#" + (indice - 1)));
            this.infoBean.set("RUBRIQUE_FILLE_PAGE#" + indice, this.infoBean.getString("RUBRIQUE_FILLE_PAGE#" + (indice - 1)));
            this.infoBean.set("RUBRIQUE_FILLE_CODE#" + (indice - 1), tmpCode);
            this.infoBean.set("RUBRIQUE_FILLE_INTITULE#" + (indice - 1), tmpIntitule);
            this.infoBean.set("RUBRIQUE_FILLE_PAGE#" + (indice - 1), tmpPage);
            this.infoBean.set("ANCRE", "sousrubrique");
        } else if (this.action.contains("BAISSER_RUBRIQUE_FILLE#")) {
            int indiceDiese = this.action.indexOf("#");
            int indice = Integer.parseInt(this.action.substring(indiceDiese + 1));
            String tmpCode = this.infoBean.getString("RUBRIQUE_FILLE_CODE#" + indice);
            String tmpIntitule = this.infoBean.getString("RUBRIQUE_FILLE_INTITULE#" + indice);
            String tmpPage = this.infoBean.getString("RUBRIQUE_FILLE_PAGE#" + indice);
            this.infoBean.set("RUBRIQUE_FILLE_CODE#" + indice, this.infoBean.getString("RUBRIQUE_FILLE_CODE#" + (indice + 1)));
            this.infoBean.set("RUBRIQUE_FILLE_INTITULE#" + indice, this.infoBean.getString("RUBRIQUE_FILLE_INTITULE#" + (indice + 1)));
            this.infoBean.set("RUBRIQUE_FILLE_PAGE#" + indice, this.infoBean.getString("RUBRIQUE_FILLE_PAGE#" + (indice + 1)));
            this.infoBean.set("RUBRIQUE_FILLE_CODE#" + (indice + 1), tmpCode);
            this.infoBean.set("RUBRIQUE_FILLE_INTITULE#" + (indice + 1), tmpIntitule);
            this.infoBean.set("RUBRIQUE_FILLE_PAGE#" + (indice + 1), tmpPage);
            this.infoBean.set("ANCRE", "sousrubrique");
        } else if (this.action.equals("VALIDER")) {
            InfosRubriques rubriqueMere;
            if (this.mode == 0) {
                if (!this.autorisations.possedePermission(new PermissionBean("TECH", "rub", "C"), new Perimetre("*", this.infoBean.getString("CODE_RUBRIQUE_MERE"), "*", "*", ""))) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE") + " : " + MessageHelper.getCoreMessage("AUTORISATION_CREATION_HORS_PERIMETRE"));
                }
                Chaine.controlerCodeMetier((String)this.infoBean.get("CODE"));
            } else if (this.mode == 1) {
                if (!this.infoBean.getString("SAUVEGARDE_CODE_RUBRIQUE_MERE").equals(this.infoBean.getString("CODE_RUBRIQUE_MERE"))) {
                    if (!this.autorisations.possedePermission(new PermissionBean("TECH", "rub", "C"), new Perimetre("*", this.infoBean.getString("CODE_RUBRIQUE_MERE"), "*", "*", ""))) {
                        throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE") + " : " + MessageHelper.getCoreMessage("AUTORISATION_DEPLACEMENT_HORS_PERIMETRE"));
                    }
                } else if (!this.autorisations.possedePermission(new PermissionBean("TECH", "rub", "M"), new Perimetre("*", this.infoBean.getString("CODE"), "*", "*", ""))) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE") + " : " + MessageHelper.getCoreMessage("AUTORISATION_MODIFICATION_HORS_PERIMETRE"));
                }
            }
            this.rubrique.setCode((String)this.infoBean.get("CODE"));
            this.rubrique.setLangue((String)this.infoBean.get("LANGUE"));
            this.rubrique.setIntitule((String)this.infoBean.get("INTITULE"));
            this.rubrique.setAccroche((String)this.infoBean.get("ACCROCHE"));
            this.rubrique.setCategorie((String)this.infoBean.get("CATEGORIE"));
            if (this.infoBean.get("ID_BANDEAU") != null) {
                this.rubrique.setIdBandeau(new Long(this.infoBean.getString("ID_BANDEAU")));
                this.rubrique.setCouleurFond((String)this.infoBean.get("COULEUR_FOND"));
                this.rubrique.setCouleurTitre((String)this.infoBean.get("COULEUR_TITRE"));
            }
            this.rubrique.setIdPicto(new Long(this.infoBean.getString("ID_PICTO")));
            this.rubrique.setNomOnglet((String)this.infoBean.get("NOM_ONGLET"));
            this.rubrique.setContact((String)this.infoBean.get("CONTACT"));
            if (this.infoBean.getString("CODE_RUBRIQUE_MERE").equals(this.infoBean.get("CODE"))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "RUBRIQUE.RUBRIQUE_MERE.ERREUR.RUBRIQUE_MERE_ELLE_MEME"));
            }
            InfosRubriques newRubrique = Rubrique.renvoyerItemRubrique(this.infoBean.getString("CODE"));
            if (newRubrique.contains(rubriqueMere = Rubrique.renvoyerItemRubrique(this.infoBean.getString("CODE_RUBRIQUE_MERE")))) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "RUBRIQUE.RUBRIQUE_MERE.ERREUR.RUBRIQUE_MERE_FILLE"));
            }
            if (!"0000".equals(this.infoBean.getString("CODE_RUBRIQUE_MERE"))) {
                this.rubrique.setCodeRubriqueMere((String)this.infoBean.get("CODE_RUBRIQUE_MERE"));
            } else {
                this.rubrique.setCodeRubriqueMere("");
            }
            if (this.autorisations.isDiffuseurDSI()) {
                this.rubrique.setGroupesDsi(Chaine.convertirAccolades(Chaine.getVecteurPointsVirgules(this.infoBean.getString("GROUPES_DSI"))));
            } else if (this.rubrique.getGroupesDsi() == null) {
                this.rubrique.setGroupesDsi("");
            }
            PageAccueilRubriqueManager.getInstance().traiterPRINCIPAL(this.infoBean, this.rubrique);
            this.rubrique.setGestionEncadre(StringUtils.defaultString((String)this.infoBean.getString("GESTION_ENCADRE"), (String)"0"));
            this.rubrique.setEncadre((String)this.infoBean.get("ENCADRE"));
            this.rubrique.setEncadreSousRubrique(StringUtils.defaultString((String)this.infoBean.getString("ENCADRE_SOUS_RUBRIQUE"), (String)"0"));
            Vector<String> requeteASupprimer = Chaine.getVecteurAccolades(this.rubrique.getRequetesRubriquePublication());
            int nbRequete = this.infoBean.getInt("REQUETE_NB_ITEMS");
            for (int i = 0; i < nbRequete; ++i) {
                String requete = this.infoBean.getString("REQUETE#" + i);
                if (!requeteASupprimer.contains(requete)) continue;
                requeteASupprimer.remove(requete);
            }
            TreeSet<InfosFicheReferencee> listeFichesReferencementSupprimees = new TreeSet<InfosFicheReferencee>(new InfosFicheComparator());
            for (String aRequeteASupprimer : requeteASupprimer) {
                listeFichesReferencementSupprimees.addAll(Rubriquepublication.supprimerRubriquePublicationAutomatique(this, this.rubrique.getCode(), aRequeteASupprimer, true));
            }
            this.rubrique.setRequetesRubriquePublication(Chaine.convertirAccolades(this.listeRequeteRubriquePublication));
            if (this.mode == 0) {
                Rubrique rubrique2 = new Rubrique();
                rubrique2.setCtx(this);
                rubrique2.init();
                if (rubrique2.selectCodeLangue(this.rubrique.getCode(), "") > 0) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "RUBRIQUE.CODE_RUBRIQUE.ERREUR.CODE_EXISTANT"));
                }
                int ordre = rubrique2.selectMaxOrder(this.rubrique.getCodeRubriqueMere());
                ordre = ordre == 0 ? ordre : ordre + 1;
                this.rubrique.setOrdre(String.valueOf(ordre));
                this.rubrique.add();
                this.infoBean.addMessageConfirmation(String.format(MessageHelper.getCoreMessage(this.getLocale(), "CONFIRMATION_CREATION_RUBRIQUE"), this.rubrique.getIntitule()));
            } else if (this.mode == 1) {
                Rubrique rubriqueFille = new Rubrique();
                rubriqueFille.init();
                rubriqueFille.setCtx(this);
                int nbRubrique = this.infoBean.getInt("RUBRIQUES_FILLES_NB_ITEMS");
                for (int i = 0; i < nbRubrique; ++i) {
                    String codeRubrique = this.infoBean.getString("RUBRIQUE_FILLE_CODE#" + i);
                    if (rubriqueFille.select(codeRubrique, "", "", "") <= 0 || !rubriqueFille.nextItem()) continue;
                    rubriqueFille.setOrdre(Integer.toString(i + 1));
                    rubriqueFille.update();
                }
                this.rubrique.update();
                this.infoBean.addMessageConfirmation(String.format(MessageHelper.getCoreMessage(this.getLocale(), "CONFIRMATION_MODIFICATION_RUBRIQUE"), this.rubrique.getIntitule()));
            }
            ArrayList<InfosFicheReferencee> listeAvantValidation = Rubriquepublication.getListeFichesReferences(this, this.rubrique.getCode(), false);
            Rubriquepublication.enregistrerRubriquePublication(this, this.rubrique.getCode(), new ArrayList<InfosFicheReferencee>(this.listeFichesReferencees));
            TreeSet<InfosFicheReferencee> listeFichesAIndexer = new TreeSet<InfosFicheReferencee>(new InfosFicheComparator());
            listeFichesAIndexer.addAll(listeAvantValidation);
            listeFichesAIndexer.addAll(this.listeFichesReferencees);
            listeFichesAIndexer.addAll(listeFichesReferencementSupprimees);
            for (InfosFicheReferencee infos : listeFichesAIndexer) {
                FicheUniv ficheAreindexee = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(infos.getType()));
                ficheAreindexee.init();
                ficheAreindexee.setCtx(this);
                if (ficheAreindexee.selectCodeLangueEtat(infos.getCode(), infos.getLangue(), "0003") <= 0) continue;
                ficheAreindexee.nextItem();
                ficheAreindexee.setDateProposition(new Date(System.currentTimeMillis()));
                ficheAreindexee.update();
                Metatag meta = FicheUnivMgr.lireMeta(ficheAreindexee);
                meta.setMetaDateProposition(ficheAreindexee.getDateProposition());
                FicheUnivMgr.enregistrerMeta(meta);
            }
            Rubrique.rechargement();
            Media.modifierCodeRubriqueParInfobean(this.infoBean, this.rubrique.getCode());
            this.etat = 2;
        } else if (this.action.equals("SUPPRIMER")) {
            this.traiterSuppression(this.rubrique.getIdRubrique());
        } else if (this.action.equals("RAFRAICHIR")) {
            this.infoBean.set("ANCRE", "contenu-fiches-rat");
        }
    }

    private void traiterRECHERCHE() throws Exception {
        this.insererRechercheDansInfoBean(this.infoBean, this.getCriteresRecherche(this.infoBean));
        if (this.action.equals("VALIDER")) {
            int count = this.rubrique.select(this.infoBean.getString("CODE"), this.infoBean.getString("LANGUE"), this.infoBean.getString("INTITULE"), this.infoBean.getString("CODE_SAISI"));
            if (count == 1) {
                this.rubrique.nextItem();
                if (this.mode == 3) {
                    this.remplirDonneesRecherche();
                    this.etat = 2;
                }
                if (this.mode == 1) {
                    this.preparerPRINCIPAL();
                }
                if (this.mode == 2) {
                    this.preparerLISTE();
                }
            } else {
                this.preparerLISTE();
            }
        } else if (this.action.equals("ANNULER") && this.mode == 3) {
            this.infoBean.set("ID_RUBRIQUE", null);
            this.etat = 2;
        }
    }

    private List<CritereRecherche> getCriteresRecherche(InfoBean infoBean) {
        String langue;
        ArrayList<CritereRecherche> criteres = new ArrayList<CritereRecherche>();
        CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVideFormater(infoBean, "INTITULE"));
        CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVide(infoBean, "CODE_SAISI"));
        String codeRubrique = infoBean.getString("CODE");
        if (StringUtils.isNotBlank((CharSequence)codeRubrique)) {
            String libelleRubrique = codeRubrique;
            try {
                libelleRubrique = Rubrique.getIntitule(codeRubrique);
            }
            catch (Exception e) {
                LOGGER.info("pas de structure de code : " + codeRubrique);
            }
            criteres.add(new CritereRecherche("CODE", codeRubrique, libelleRubrique));
            criteres.add(new CritereRecherche("LIBELLE_CODE", libelleRubrique));
        }
        if (StringUtils.isNotBlank((CharSequence)(langue = infoBean.getString("LANGUE"))) && !"0000".equals(langue)) {
            criteres.add(new CritereRecherche("LANGUE", langue, LangueUtil.getLocale(langue).getDisplayLanguage(ContexteUtil.getContexteUniv().getLocale())));
        }
        return criteres;
    }

    private void insererRechercheDansInfoBean(InfoBean infoBean, List<CritereRecherche> criteres) throws ErreurApplicative {
        criteres.add(new CritereRecherche("BEAN_RECHERCHE", "rubriqueDatagrid"));
        infoBean.set("CRITERE_REQUETE", criteres);
    }

    private void remplirDonneesRecherche() throws Exception {
        this.infoBean.set("ID_RUBRIQUE", this.rubrique.getIdRubrique());
        this.infoBean.set("CODE", this.rubrique.getCode());
        this.infoBean.set("INTITULE", this.rubrique.getIntitule());
        this.infoBean.set("NOM_ONGLET", this.rubrique.getNomOnglet());
        this.infoBean.set("CODE_RUBRIQUE_MERE", this.rubrique.getCodeRubriqueMere());
    }
}

