/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.textsearch.sitesdistants.IndexeurSitesDistants;
import com.jsbsoft.jtf.textsearch.sitesdistants.RechercheSitesDistants;
import com.kportal.core.config.MessageHelper;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Site;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Perl5Compiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaisieSite
extends ProcessusBean {
    private static final String ECRAN_PRINCIPAL = "PRINCIPAL";
    private static final String ECRAN_LISTE = "LISTE";
    private AutorisationBean autorisations = null;
    private Site site = null;
    private static Logger LOG = LoggerFactory.getLogger(SaisieSite.class);

    public SaisieSite(InfoBean ciu) {
        super(ciu);
    }

    @Override
    public boolean traiterAction() throws Exception {
        this.autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        if (this.autorisations == null) {
            this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
            this.infoBean.setEcranLogique("LOGIN");
        } else {
            try {
                this.ecranLogique = this.infoBean.getEcranLogique();
                this.action = this.infoBean.getActionUtilisateur();
                if (this.ecranLogique == null) {
                    this.site = new Site();
                    this.site.setCtx(this);
                    this.site.init();
                    this.etat = 1;
                    if (this.action.equals("AJOUTER")) {
                        this.infoBean.setEtatObjet("CREATION");
                        this.preparerPRINCIPAL();
                    } else if (this.action.equals("MODIFIER")) {
                        this.infoBean.setEtatObjet("MODIFICATION");
                        this.preparerLISTE();
                    } else if (this.action.equals("MODIFIERPARID")) {
                        this.infoBean.setEtatObjet("MODIFICATION");
                        if (this.infoBean.get("ID_SITE") == null) {
                            throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "SAISIE_SITE.ERREUR.SITE_A_MODIFIER_VIDE"));
                        }
                        this.site.setIdSite(Long.valueOf(this.infoBean.getString("ID_SITE")));
                        this.site.retrieve();
                        this.preparerPRINCIPAL();
                    } else if (this.action.equals("SUPPRIMERPARID")) {
                        if (this.infoBean.get("ID_SITE") == null) {
                            throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "SAISIE_SITE.ERREUR.SITE_A_SUPPRIMER_VIDE"));
                        }
                        this.site.setIdSite(Long.valueOf(this.infoBean.getString("ID_SITE")));
                        this.site.setCtx(this);
                        this.site.retrieve();
                        File repertoireIndex = this.site.getRepertoireIndexation();
                        this.site.delete();
                        RechercheSitesDistants.init();
                        if (repertoireIndex.exists()) {
                            repertoireIndex.delete();
                        }
                        String confirmation = String.format(MessageHelper.getCoreMessage(this.getLocale(), "CONFIRMATION_SUPPRESSION_SITEEXTERNE"), this.site.getLibelle());
                        this.infoBean.addMessageConfirmation(confirmation);
                        this.etat = 2;
                    } else if (this.action.equals("INDEXERPARID")) {
                        if (this.infoBean.get("ID_SITE") == null) {
                            throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "SAISIE_SITE.ERREUR.SITE_A_SUPPRIMER_VIDE"));
                        }
                        this.site.setIdSite(Long.valueOf(this.infoBean.getString("ID_SITE")));
                        this.site.setCtx(this);
                        this.site.retrieve();
                        IndexeurSitesDistants.getInstance().indexeSite(this.site, false);
                        this.preparerLISTE();
                        this.etat = 2;
                    }
                } else if (this.ecranLogique.equals(ECRAN_LISTE)) {
                    this.traiterLISTE();
                } else if (this.ecranLogique.equals(ECRAN_PRINCIPAL)) {
                    this.traiterPRINCIPAL();
                }
                this.infoBean.setEcranLogique(this.ecranLogique);
            }
            catch (Exception e) {
                LOG.error("erreur de traitement sur le processus", (Throwable)e);
                this.infoBean.addMessageErreur(e.getMessage());
            }
        }
        return this.etat == 2;
    }

    private void preparerLISTE() throws Exception {
        this.ecranLogique = ECRAN_LISTE;
        Map<Long, String> mapEtatSites = IndexeurSitesDistants.getInstance().getEtatsSites();
        List<Site> toutLesSites = Site.getListeSites(this);
        ArrayList<String> sitesEnCoursDIndexation = new ArrayList<String>();
        for (Site siteCourant : toutLesSites) {
            if (StringUtils.isNotBlank((CharSequence)mapEtatSites.get(siteCourant.getIdSite()))) {
                siteCourant.setEtatIndexation(mapEtatSites.get(siteCourant.getIdSite()));
                if (!"indexation en cours".equals(siteCourant.getEtatIndexation())) continue;
                sitesEnCoursDIndexation.add(siteCourant.getLibelle());
                continue;
            }
            siteCourant.setEtatIndexation("non ex\u00e9cut\u00e9e");
        }
        this.infoBean.set("LISTE_SITES", toutLesSites);
        this.infoBean.set("SITES_EN_COURS_INDEXATION", sitesEnCoursDIndexation);
    }

    private void preparerPRINCIPAL() throws Exception {
        this.ecranLogique = ECRAN_PRINCIPAL;
        this.infoBean.set("CODE", this.site.getCode());
        this.infoBean.set("LIBELLE", this.site.getLibelle());
        this.infoBean.set("URL", this.site.getUrl().equals("") ? "http://" : this.site.getUrl());
        this.infoBean.set("REG_EXP_ACCEPTE", this.site.getRegExpAccepte());
        this.infoBean.set("NIVEAU_PROFONDEUR", this.site.getNiveauProfondeur());
        this.infoBean.set("REG_EXP_REFUSE", this.site.getRegExpRefuse());
        this.infoBean.set("LISTE_LANGUES", LangueUtil.getListeLangues(this.getLocale()));
        this.infoBean.set("LANGUE", this.site.getLangue());
        if (StringUtils.isNotBlank((CharSequence)this.site.getLibelle())) {
            this.infoBean.setTitreEcran(this.site.getLibelle());
        }
    }

    private void traiterLISTE() throws Exception {
        if (this.action.equals("MODIFIER")) {
            if (this.infoBean.get("ID_SITE") == null) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "SAISIE_SITE.ERREUR.SITE_A_MODIFIER_VIDE"));
            }
            this.site.setIdSite(Long.valueOf(this.infoBean.getString("ID_SITE")));
            this.site.retrieve();
            this.preparerPRINCIPAL();
        } else if (this.action.equals("SUPPRIMER")) {
            if (this.infoBean.get("ID_SITE") == null) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "SAISIE_SITE.ERREUR.SITE_A_SUPPRIMER_VIDE"));
            }
            this.site.setIdSite(Long.valueOf(this.infoBean.getString("ID_SITE")));
            this.site.setCtx(this);
            this.site.retrieve();
            File repertoireIndex = this.site.getRepertoireIndexation();
            this.site.delete();
            RechercheSitesDistants.init();
            if (repertoireIndex.exists()) {
                repertoireIndex.delete();
            }
            this.etat = 2;
        } else if (this.action.equals("ANNULER") || this.action.equals("ABANDON")) {
            this.etat = 2;
        }
    }

    private void traiterPRINCIPAL() throws Exception {
        if (this.action.equals("VALIDER")) {
            this.site.setLibelle((String)this.infoBean.get("LIBELLE"));
            String szUrl = (String)this.infoBean.get("URL");
            if (szUrl.indexOf("http://") == -1 || szUrl.equals("http://")) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "SAISIE_SITE.ERREUR.URL_INVALIDE"));
            }
            if (szUrl.charAt(szUrl.length() - 1) != '/' && szUrl.lastIndexOf(47) == "http://".lastIndexOf(47)) {
                szUrl = szUrl + '/';
            }
            this.site.setUrl(szUrl);
            String szRegExp = szUrl.substring(0, szUrl.lastIndexOf(47) + 1) + ".*";
            try {
                new Perl5Compiler().compile(szRegExp);
                this.site.setRegExpAccepte(szRegExp);
            }
            catch (MalformedPatternException e) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "SAISIE_SITE.ERREUR.REGEXP_INVALIDE"));
            }
            String szRegExpRefus = StringUtils.isNotBlank((CharSequence)this.infoBean.getString("REG_EXP_REFUSE")) ? this.infoBean.getString("REG_EXP_REFUSE") : "";
            try {
                new Perl5Compiler().compile(szRegExpRefus);
                this.site.setRegExpRefuse(szRegExpRefus);
            }
            catch (MalformedPatternException e) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "SAISIE_SITE.ERREUR.REGEXP_INVALIDE"));
            }
            this.site.setNiveauProfondeur(Integer.valueOf(this.infoBean.getString("NIVEAU_PROFONDEUR")));
            if (this.infoBean.getEtatObjet().equals("CREATION")) {
                String code = this.infoBean.getString("CODE");
                if (code.indexOf(59) != -1) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "SAISIE_SITE.ERREUR.CARACTERE_INTERDIT"));
                }
                this.site.setCode(code);
                this.site.add();
                String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_CREATION_SITEEXTERNE"), this.site.getLibelle());
                this.infoBean.addMessageConfirmation(confirmation);
            } else if (this.infoBean.getEtatObjet().equals("MODIFICATION")) {
                this.site.update();
                String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_MODIFICATION_SITEEXTERNE"), this.site.getLibelle());
                this.infoBean.addMessageConfirmation(confirmation);
            }
            this.etat = 2;
            RechercheSitesDistants.init();
        } else if (this.action.equals("SUPPRIMER")) {
            if (this.infoBean.get("ID_SITE") == null) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "SAISIE_SITE.ERREUR.SITE_A_SUPPRIMER_VIDE"));
            }
            this.site.setIdSite(Long.valueOf(this.infoBean.getString("ID_SITE")));
            this.site.setCtx(this);
            this.site.retrieve();
            File repertoireIndex = this.site.getRepertoireIndexation();
            this.site.delete();
            RechercheSitesDistants.init();
            if (repertoireIndex.exists()) {
                repertoireIndex.delete();
            }
            String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_SUPPRESSION_SITEEXTERNE"), this.site.getLibelle());
            this.infoBean.addMessageConfirmation(confirmation);
            this.etat = 2;
        }
    }
}

