/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.RequeteGroupeDynamique;
import com.univ.objetspartages.om.RequeteGroupeDynamiqueSynchronisable;
import com.univ.utils.RequeteGroupeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaisieSynchronisationGroupeDynamique
extends ProcessusBean {
    private static Logger LOG = LoggerFactory.getLogger(SaisieSynchronisationGroupeDynamique.class);
    private AutorisationBean autorisations = null;
    private static final String ECRAN_CONFIRMATION = "CONFIRMATION";

    public SaisieSynchronisationGroupeDynamique(InfoBean ciu) {
        super(ciu);
    }

    @Override
    public boolean traiterAction() throws Exception {
        this.autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        if (this.autorisations == null) {
            this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
            this.infoBean.setEcranLogique("LOGIN");
        } else if (this.autorisations.isWebMaster()) {
            try {
                this.ecranLogique = this.infoBean.getEcranLogique();
                this.action = this.infoBean.getActionUtilisateur();
                if (this.action.equals("SYNCHRONISER")) {
                    this.traiterSYNCHRONISATION();
                }
                this.infoBean.setEcranLogique(this.ecranLogique);
            }
            catch (Exception e) {
                LOG.error("erreur de traitement sur le processus", (Throwable)e);
                this.infoBean.addMessageErreur(e.toString());
            }
        } else {
            throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
        }
        return this.etat == 2;
    }

    private void traiterSYNCHRONISATION() throws Exception {
        RequeteGroupeDynamique requeteGroupeDyn;
        this.ecranLogique = ECRAN_CONFIRMATION;
        String nomRequete = this.infoBean.getString("REQUETE_GROUPE");
        if (nomRequete != null && (requeteGroupeDyn = RequeteGroupeUtil.instancierRequete((OMContext)this, nomRequete)) != null && requeteGroupeDyn instanceof RequeteGroupeDynamiqueSynchronisable) {
            requeteGroupeDyn.setCtx(this);
            ((RequeteGroupeDynamiqueSynchronisable)requeteGroupeDyn).traiterSYNCHRONISATION(this.infoBean);
        }
    }
}

