/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.core.SynchroniseurUtilisateur;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.ldap.ISynchroLdapUtilisateur;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.security.MySQLHelper;
import com.kportal.extension.module.composant.ComposantUtilisateur;
import com.univ.collaboratif.om.Espacecollaboratif;
import com.univ.objetspartages.om.AnnuaireModele;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.Groupeutilisateur;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.InfosStructure;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Profildsi;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Structure;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.objetspartages.processus.ControleurAffectationRole;
import com.univ.objetspartages.util.CritereRecherche;
import com.univ.objetspartages.util.CritereRechercheUtil;
import com.univ.utils.Chaine;
import com.univ.utils.FicheUnivMgr;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaisieUtilisateur
extends ProcessusBean {
    private static final String ECRAN_RECHERCHE = "RECHERCHE";
    private static final String ECRAN_PRINCIPAL = "PRINCIPAL";
    private static final String ECRAN_LISTE = "LISTE";
    private static final Logger LOG = LoggerFactory.getLogger(SaisieUtilisateur.class);
    protected Utilisateur utilisateur = null;
    private final Long[] listeIdentifiant = null;

    public SaisieUtilisateur(InfoBean ciu) {
        super(ciu);
    }

    public void preparerPRINCIPAL() throws Exception {
        this.ecranLogique = ECRAN_PRINCIPAL;
        this.infoBean.set("CODE", this.utilisateur.getCode());
        this.infoBean.set("CODE_LDAP", this.utilisateur.getCodeLdap());
        this.infoBean.set("CIVILITE", this.utilisateur.getCivilite());
        this.infoBean.set("NOM", this.utilisateur.getNom());
        this.infoBean.set("PRENOM", this.utilisateur.getPrenom());
        this.infoBean.set("CODE_RATTACHEMENT", this.utilisateur.getCodeRattachement());
        this.infoBean.set("LIBELLE_CODE_RATTACHEMENT", Structure.getLibelleAffichable(this.utilisateur.getCodeRattachement(), ""));
        this.infoBean.set("ADRESSE_MAIL", this.utilisateur.getAdresseMail());
        String formatEnvoiNL = (String)StringUtils.defaultIfBlank((CharSequence)this.utilisateur.getFormatEnvoi(), (CharSequence)"0");
        this.infoBean.set("FORMAT_ENVOI", formatEnvoiNL);
        this.infoBean.set("RADIO0", "HTML");
        this.infoBean.set("RADIO1", "Texte");
        this.infoBean.set("TYPE_POPULATION", "");
        this.infoBean.set("LISTE_TYPES_POPULATION", Libelle.getListe("10", LangueUtil.getDefaultLocale()));
        this.infoBean.set("CORPS", "");
        this.infoBean.set("DISCIPLINE", "");
        this.infoBean.set("LISTE_DISCIPLINES", Libelle.getListe("02", LangueUtil.getDefaultLocale()));
        Vector<String> groupesDsi = Groupeutilisateur.getAllDatasourceGroupsCodesByUserCode(this.utilisateur.getCode());
        Enumeration<String> en = groupesDsi.elements();
        String sGroupes = "";
        String libelles = "";
        while (en.hasMoreElements()) {
            String currentCode = en.nextElement();
            InfosGroupeDsi currentGroupe = Groupedsi.renvoyerItemGroupeDsi(currentCode);
            if (sGroupes.length() > 0) {
                sGroupes = sGroupes + ";";
                libelles = libelles + ";";
            }
            libelles = String.format("%s%s", libelles, StringUtils.defaultIfBlank((CharSequence)currentGroupe.getIntitule(), (CharSequence)MessageHelper.getCoreMessage("BO.GROUP.LABEL.UNKNOWN")));
            sGroupes = String.format("%s%s%s", sGroupes, StringUtils.isNotBlank((CharSequence)currentGroupe.getRequete()) || !currentGroupe.isSelectionnable() ? "#AUTO#" : "", currentCode);
        }
        this.infoBean.set("GROUPE_DSI", sGroupes);
        this.infoBean.set("LIBELLE_GROUPE_DSI", libelles);
        Collection<String> groupesDynamic = Groupeutilisateur.getAllDynamicGroupsCodesByUserCode(this.utilisateur.getCode());
        ArrayList<InfosGroupeDsi> dynamicGroups = new ArrayList<InfosGroupeDsi>();
        for (String currentCode : groupesDynamic) {
            InfosGroupeDsi currentGroupe = Groupedsi.renvoyerItemGroupeDsi(currentCode);
            if (currentGroupe == null) continue;
            dynamicGroups.add(currentGroupe);
        }
        this.infoBean.set("GROUPE_DSI_DYN", dynamicGroups);
        this.infoBean.set("PROFIL_DEFAUT", this.utilisateur.getProfilDefaut());
        Hashtable<String, String> profiles = Profildsi.getListeProfilsDSIParGroupes(groupesDsi);
        profiles.putAll(Profildsi.getListeProfilsDSIParGroupes(new Vector<String>(groupesDynamic)));
        this.infoBean.set("LISTE_PROFILS", profiles);
        Vector<String> vThemesUtilisateurs = this.utilisateur.getVecteurCentresInteret();
        int iTheme = 0;
        Libelle libelle = new Libelle();
        libelle.setCtx(this);
        if (libelle.select("WHERE TYPE='04' AND LANGUE='0' ORDER BY LIBELLE") > 0) {
            while (libelle.nextItem()) {
                String valeurTheme = "0";
                if (vThemesUtilisateurs.indexOf(libelle.getCode()) != -1) {
                    valeurTheme = "1";
                }
                this.infoBean.set("CODE_THEME#" + iTheme, libelle.getCode());
                this.infoBean.set("LIBELLE_THEME#" + iTheme, libelle.getLibelle());
                this.infoBean.set("VALEUR_THEME#" + iTheme, valeurTheme);
                ++iTheme;
            }
        }
        this.infoBean.set("THEMES_NB_ITEMS", iTheme);
        this.infoBean.set("ROLES", this.utilisateur.getRoles());
        this.infoBean.set("GRS_FILTRE_ARBRE_GROUPE_TMP_GROUPE_DSI", "1");
        this.infoBean.set("GRS_FILTRE_ARBRE_GROUPE_TYPE", "DYN");
        this.infoBean.set("GRS_FILTRE_ARBRE_GROUPE_OBJET", "dyn");
        this.infoBean.set("GRS_FILTRE_ARBRE_GROUPE_ACTION", "");
        if ("MODIFICATION".equals(this.infoBean.getEtatObjet()) && this.utilisateur.isModificationMotDePasseInterditeParSource()) {
            this.infoBean.set("MODIFICATION_MOTDEPASSE_AUTORISEE", "0");
        } else {
            this.infoBean.set("MODIFICATION_MOTDEPASSE_AUTORISEE", "1");
        }
        if ("MODIFICATION".equals(this.infoBean.getEtatObjet()) && this.utilisateur.provientDuLdap()) {
            this.infoBean.set("MODIFICATION_AUTORISEE", "0");
        } else {
            this.infoBean.set("MODIFICATION_AUTORISEE", "1");
        }
        if (StringUtils.isNotBlank((CharSequence)this.utilisateur.getLibelle())) {
            this.infoBean.setTitreEcran(this.utilisateur.getLibelle());
        }
        ControleurAffectationRole.preparerPRINCIPAL(this.infoBean, this);
    }

    private void preparerRECHERCHE() throws Exception {
        this.ecranLogique = ECRAN_RECHERCHE;
        this.infoBean.set("LISTE_PROFILS_DSI", Profildsi.getListeProfilsDSI());
    }

    @Override
    public boolean traiterAction() throws Exception {
        try {
            this.ecranLogique = this.infoBean.getEcranLogique();
            this.action = this.infoBean.getActionUtilisateur();
            if (this.utilisateur == null) {
                this.utilisateur = new Utilisateur();
                this.utilisateur.setCtx(this);
                this.utilisateur.init();
            }
            AutorisationBean autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
            String modeAffichage = this.infoBean.getString("MODE");
            if (modeAffichage == null) {
                modeAffichage = "GESTION";
            }
            this.infoBean.set("MODE", modeAffichage);
            if (autorisations == null) {
                this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
                this.ecranLogique = "LOGIN";
            } else {
                if (!ComposantUtilisateur.isAutoriseParActionProcessusEtEcranLogique(autorisations, this.action, this.ecranLogique)) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
                }
                if (this.ecranLogique == null) {
                    if (this.action.equals("AJOUTER")) {
                        this.infoBean.setEtatObjet("CREATION");
                        this.preparerPRINCIPAL();
                    } else if (this.action.equals("MODIFIER")) {
                        this.infoBean.setEtatObjet("MODIFICATION");
                        this.preparerRECHERCHE();
                    } else if (this.action.equals("RECHERCHER")) {
                        this.infoBean.setEtatObjet(ECRAN_RECHERCHE);
                        this.preparerRECHERCHE();
                    } else if (this.action.equals(ECRAN_LISTE)) {
                        this.infoBean.setEtatObjet(ECRAN_RECHERCHE);
                        this.traiterRECHERCHE();
                    } else if (this.action.equals("ACCUEIL")) {
                        this.action = "VALIDER";
                        this.infoBean.setEtatObjet(ECRAN_RECHERCHE);
                        this.traiterRECHERCHE();
                    } else if (this.action.equals("LISTE_ROLES")) {
                        this.infoBean.setEtatObjet(ECRAN_RECHERCHE);
                        this.infoBean.set(ECRAN_LISTE, "ROLES");
                        this.preparerRECHERCHE();
                    } else if (this.action.equals("MODIFIERPARID")) {
                        this.infoBean.setEtatObjet("MODIFICATION");
                        String id = this.infoBean.getString("ID");
                        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNumeric((CharSequence)id)) {
                            this.utilisateur.setIdUtilisateur(Long.valueOf(id));
                            this.utilisateur.retrieve();
                            this.preparerPRINCIPAL();
                        }
                    } else if (this.action.equals("SUPPRIMERPARID")) {
                        this.infoBean.setEtatObjet("SUPPRESSION");
                        String id = this.infoBean.getString("ID");
                        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNumeric((CharSequence)id)) {
                            this.utilisateur.setIdUtilisateur(Long.valueOf(id));
                            this.utilisateur.retrieve();
                            this.supprimerUtilisateur();
                            this.etat = 2;
                        }
                    }
                } else if (this.ecranLogique.equals(ECRAN_RECHERCHE)) {
                    this.traiterRECHERCHE();
                } else if (this.ecranLogique.equals(ECRAN_LISTE)) {
                    this.traiterLISTE();
                } else if (this.ecranLogique.equals(ECRAN_PRINCIPAL)) {
                    this.traiterPRINCIPAL();
                }
            }
            this.infoBean.setEcranLogique(this.ecranLogique);
        }
        catch (Exception e) {
            LOG.error("erreur dans le traitement du processus", (Throwable)e);
            this.infoBean.addMessageErreur(e.toString());
        }
        return this.etat == 2;
    }

    private void supprimerUtilisateur() throws Exception {
        if (Espacecollaboratif.isExtensionActivated()) {
            try {
                Espacecollaboratif.supprimerUtilisateur(this.utilisateur.getCode());
            }
            catch (Exception e) {
                this.action = ECRAN_LISTE;
                this.traiterRECHERCHE();
                throw new ErreurApplicative(e.toString());
            }
        }
        Groupeutilisateur.deleteParUtilisateur(this, this.utilisateur.getCode());
        this.utilisateur.delete();
        String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_SUPPRESSION_UTILISATEUR"), this.utilisateur.getLibelle());
        this.infoBean.addMessageConfirmation(confirmation);
    }

    private void traiterLISTE() throws Exception {
        if (this.action.equals("MODIFIER")) {
            int indice = Integer.parseInt((String)this.infoBean.get("LISTE_INDICE"));
            this.utilisateur.setIdUtilisateur(this.listeIdentifiant[indice]);
            this.utilisateur.retrieve();
            this.preparerPRINCIPAL();
        } else if (this.action.equals("SUPPRIMER")) {
            int indice = Integer.parseInt((String)this.infoBean.get("LISTE_INDICE"));
            this.utilisateur.setIdUtilisateur(this.listeIdentifiant[indice]);
            this.utilisateur.retrieve();
            this.supprimerUtilisateur();
            this.etat = 2;
        } else if (this.action.equals(ECRAN_LISTE)) {
            this.traiterRECHERCHE();
        } else if (this.action.equals("ANNULER")) {
            this.infoBean.set("ID_UTILISATEUR", null);
            this.etat = 2;
        }
    }

    public void traiterPRINCIPAL() throws Exception {
        ControleurAffectationRole.traiterPRINCIPAL(this.infoBean, this);
        if (this.action.equals("SUPPRIMER")) {
            this.supprimerUtilisateur();
            this.etat = 2;
        } else if (this.action.equals("ACTUALISER_PROFIL")) {
            Vector<String> vGroupesDsi = new Vector<String>();
            StringTokenizer st = new StringTokenizer(this.infoBean.getString("GROUPE_DSI"), ";");
            while (st.hasMoreTokens()) {
                String val = st.nextToken();
                vGroupesDsi.add(val);
            }
            Hashtable<String, String> hProfil = Profildsi.getListeProfilsDSIParGroupes(vGroupesDsi);
            if (hProfil.containsKey(this.utilisateur.getProfilDefaut())) {
                this.infoBean.set("PROFIL_DEFAUT", this.utilisateur.getProfilDefaut());
            } else {
                this.infoBean.set("PROFIL_DEFAUT", "");
            }
            this.infoBean.set("LISTE_PROFILS", hProfil);
        } else if (this.action.equals("VALIDER")) {
            if (this.infoBean.getEtatObjet().equals("CREATION")) {
                Chaine.controlerCodeMetier((String)this.infoBean.get("CODE"));
                if (Utilisateur.getUtilisateur(this.infoBean.getString("CODE")).getCode().equalsIgnoreCase(this.infoBean.getString("CODE"))) {
                    throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "UTILISATEUR.ERREUR.IDENTIFIANT_EXISTANT"));
                }
                this.utilisateur.setCode((String)this.infoBean.get("CODE"));
                String codeLdap = (String)this.infoBean.get("CODE_LDAP");
                if (codeLdap != null && !codeLdap.equals("")) {
                    if (this.utilisateur.select("WHERE CODE_LDAP = '" + codeLdap + "'") > 0) {
                        throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "UTILISATEUR.ERREUR.LOGIN_EXISTANT"));
                    }
                    ISynchroLdapUtilisateur synchroLdap = SynchroniseurUtilisateur.getInstance().getSynchroLdap();
                    if (synchroLdap != null && !synchroLdap.isUnique(codeLdap)) {
                        throw new ErreurApplicative(MessageHelper.getCoreMessage(this.getLocale(), "UTILISATEUR.ERREUR.LOGIN_LDAP_EXISTANT"));
                    }
                    this.utilisateur.setCodeLdap(codeLdap);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.infoBean.getString("NEW_MOT_DE_PASSE"))) {
                String message = !this.infoBean.getString("NEW_MOT_DE_PASSE").equals(this.infoBean.getString("CONFIRM_MOT_DE_PASSE")) ? "Vous avez saisi 2 mots de passe diff\u00e9rents" : Utilisateur.verifieMotDePasse(this.infoBean.getString("NEW_MOT_DE_PASSE"));
                if (message.length() > 0) {
                    throw new ErreurApplicative(message);
                }
                this.utilisateur.setMotDePasse(MySQLHelper.encodePassword(this.infoBean.getString("NEW_MOT_DE_PASSE")));
            }
            if (this.infoBean.get("FORMAT_ENVOI") != null) {
                this.utilisateur.setFormatEnvoi((String)this.infoBean.get("FORMAT_ENVOI"));
            }
            this.utilisateur.setCivilite((String)this.infoBean.get("CIVILITE"));
            this.utilisateur.setNom((String)this.infoBean.get("NOM"));
            this.utilisateur.setPrenom((String)this.infoBean.get("PRENOM"));
            this.utilisateur.setCodeRattachement((String)this.infoBean.get("CODE_RATTACHEMENT"));
            this.utilisateur.setAdresseMail((String)this.infoBean.get("ADRESSE_MAIL"));
            String profilDSI = this.infoBean.getString("PROFIL_DEFAUT");
            if (profilDSI.equals("0000")) {
                profilDSI = "";
            }
            this.utilisateur.setProfilDefaut(profilDSI);
            Vector<String> vGroupesDsi = new Vector<String>();
            StringTokenizer st = new StringTokenizer(this.infoBean.getString("GROUPE_DSI"), ";");
            while (st.hasMoreTokens()) {
                String val = st.nextToken();
                vGroupesDsi.add(val);
            }
            Vector<String> v = new Vector<String>();
            for (int j = 0; j < this.infoBean.getInt("THEMES_NB_ITEMS"); ++j) {
                if (!"1".equals(this.infoBean.getString("VALEUR_THEME#" + j))) continue;
                v.add(this.infoBean.getString("CODE_THEME#" + j));
            }
            this.utilisateur.setVecteurCentresInteret(v);
            this.utilisateur.setRoles(this.infoBean.getString("ROLES"));
            if (this.infoBean.getEtatObjet().equals("CREATION")) {
                FicheUniv ficheUniv;
                String typeFiche;
                this.utilisateur.add();
                Groupeutilisateur.setVecteurGroupes(this, this.utilisateur.getCode(), vGroupesDsi);
                if ("1".equals(this.infoBean.getString("CREER_FICHE")) && StringUtils.isNotBlank((CharSequence)(typeFiche = this.infoBean.getString("TYPE_FICHE"))) && (ficheUniv = ReferentielObjets.instancierFiche(typeFiche)) != null) {
                    ficheUniv.setCtx(this);
                    ficheUniv.init();
                    ficheUniv.setCode((String)this.infoBean.get("CODE"));
                    ficheUniv.setCodeRedacteur((String)this.infoBean.get("CODE"));
                    ficheUniv.setCodeRattachement((String)this.infoBean.get("CODE_RATTACHEMENT"));
                    ((AnnuaireModele)ficheUniv).setCivilite((String)this.infoBean.get("CIVILITE"));
                    ((AnnuaireModele)ficheUniv).setDateNaissance((Date)this.infoBean.get("DATE_NAISSANCE"));
                    ((AnnuaireModele)ficheUniv).setNom((String)this.infoBean.get("NOM"));
                    ((AnnuaireModele)ficheUniv).setPrenom((String)this.infoBean.get("PRENOM"));
                    ((AnnuaireModele)ficheUniv).setAdresseMail((String)this.infoBean.get("ADRESSE_MAIL"));
                    ((AnnuaireModele)ficheUniv).setTypePopulation((String)this.infoBean.get("TYPE_POPULATION"));
                    ((AnnuaireModele)ficheUniv).setCorps((String)this.infoBean.get("CORPS"));
                    ((AnnuaireModele)ficheUniv).setDiscipline((String)this.infoBean.get("DISCIPLINE"));
                    if ("1".equals(this.infoBean.get("CREER_FICHE_EN_LIGNE"))) {
                        ficheUniv.setEtatObjet("0003");
                    }
                    ficheUniv.add();
                    Metatag meta = FicheUnivMgr.lireMeta(ficheUniv);
                    meta.synchroniser(ficheUniv, false);
                    FicheUnivMgr.enregistrerMeta(meta);
                }
                String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_CREATION_UTILISATEUR"), this.utilisateur.getLibelle());
                this.infoBean.addMessageConfirmation(confirmation);
            }
            if (this.infoBean.getEtatObjet().equals("MODIFICATION")) {
                this.utilisateur.update();
                Groupeutilisateur.setVecteurGroupes(this, this.utilisateur.getCode(), vGroupesDsi);
                String confirmation = String.format(MessageHelper.getCoreMessage("CONFIRMATION_MODIFICATION_UTILISATEUR"), this.utilisateur.getLibelle());
                this.infoBean.addMessageConfirmation(confirmation);
            }
            if (!this.ecranLogique.equals("CONFIRMATION")) {
                this.etat = 2;
            }
        }
    }

    private void traiterRECHERCHE() throws Exception {
        if (this.action.equals("VALIDER") || this.action.equals(ECRAN_LISTE)) {
            String codeStructure;
            String groupeDSI;
            Hashtable<String, String> listeProfil;
            ArrayList<CritereRecherche> criteres = new ArrayList<CritereRecherche>();
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVide(this.infoBean, "CODE"));
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVideFormater(this.infoBean, "NOM"));
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVideFormater(this.infoBean, "PRENOM"));
            CollectionUtils.addIgnoreNull(criteres, (Object)CritereRechercheUtil.getCritereTexteNonVideFormater(this.infoBean, "ADRESSE_MAIL"));
            String codeProfil = this.infoBean.getString("PROFIL_DSI");
            if (StringUtils.isNotBlank((CharSequence)codeProfil) && (listeProfil = Profildsi.getListeProfilsDSI()) != null && listeProfil.get(codeProfil) != null) {
                criteres.add(new CritereRecherche("PROFIL_DSI", codeProfil, listeProfil.get(codeProfil)));
            }
            if (StringUtils.isNotBlank((CharSequence)(groupeDSI = this.infoBean.getString("GROUPE_DSI")))) {
                String libelleGroupeDSI = Groupedsi.getIntitule(groupeDSI);
                criteres.add(new CritereRecherche("GROUPE_DSI", groupeDSI, libelleGroupeDSI));
                criteres.add(new CritereRecherche("LIBELLE_GROUPE_DSI", libelleGroupeDSI));
            }
            if (StringUtils.isNotBlank((CharSequence)(codeStructure = this.infoBean.getString("CODE_RATTACHEMENT")))) {
                try {
                    InfosStructure structure = Structure.renvoyerItemStructure(codeStructure, LangueUtil.getLangueLocale(this.getLocale()));
                    String libelleStructure = structure.getLibelleLong();
                    criteres.add(new CritereRecherche("CODE_RATTACHEMENT", codeStructure, libelleStructure));
                    criteres.add(new CritereRecherche("LIBELLE_CODE_RATTACHEMENT", libelleStructure));
                }
                catch (Exception e) {
                    LOG.debug("impossible de r\u00e9cuperer le libelle structure dans la recherche");
                }
            }
            criteres.add(new CritereRecherche("BEAN_RECHERCHE", "utilisateurDatagrid"));
            this.infoBean.set("CRITERE_REQUETE", criteres);
            this.ecranLogique = ECRAN_LISTE;
        } else if (this.action.equals("ANNULER") && this.infoBean.getEtatObjet().equals(ECRAN_RECHERCHE)) {
            this.infoBean.set("ID_UTILISATEUR", null);
            this.etat = 2;
        }
    }
}

