/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.PageLibre;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.processus.SaisieFiche;
import com.univ.utils.FicheUnivMgr;
import java.sql.Date;

public class TraitementPageLibre
extends SaisieFiche {
    private static final String ECRAN_PRINCIPAL = "PRINCIPAL";
    PageLibre pageLibre = null;
    private static final String ECRAN_CONFIRMATION = "CONFIRMATION";

    public TraitementPageLibre(InfoBean ciu) {
        super(ciu);
    }

    @Override
    protected void preparerLISTE() throws Exception {
    }

    @Override
    protected void preparerPRINCIPAL() throws Exception {
        this.infoBean.set("LISTE_LANGUES", LangueUtil.getListeLangues(this.getLocale()));
        this.ecranLogique = ECRAN_PRINCIPAL;
    }

    @Override
    protected void preparerRECHERCHE() throws Exception {
    }

    @Override
    public boolean traiterAction() throws Exception {
        this.infoBean.set("CODE_OBJET", "0016");
        this.etat = 1;
        this.pageLibre = new PageLibre();
        this.pageLibre.setCtx(this);
        this.pageLibre.init();
        this.traiterActionParDefaut(this.pageLibre);
        if (this.ecranLogique.equals(ECRAN_CONFIRMATION)) {
            this.traiterCONFIRMATION();
        }
        this.infoBean.setEcranLogique(this.ecranLogique);
        this.infoBean.set("NOM_ONGLET", "pagelibre");
        return this.etat == 2;
    }

    protected void traiterLISTE() throws Exception {
    }

    @Override
    protected void traiterPRINCIPAL() throws Exception {
        if (this.action.equals("ANNULER")) {
            this.ecranLogique = "FIN_TOOLBOX";
        } else if (this.action.equals("ENREGISTRER")) {
            this.pageLibre.init();
            this.pageLibre.setLangue((String)this.infoBean.get("LANGUE"));
            this.pageLibre.setTitre((String)this.infoBean.get("TITRE"));
            this.pageLibre.setCodeRubrique((String)this.infoBean.get("CODE_RUBRIQUE"));
            this.pageLibre.setCodeRedacteur((String)this.getGp().getSessionUtilisateur().getInfos().get("CODE"));
            SessionUtilisateur sessionUtilisateur = this.getGp().getSessionUtilisateur();
            AutorisationBean autorisations = (AutorisationBean)sessionUtilisateur.getInfos().get("AUTORISATIONS");
            String structureUtilisateur = autorisations.getCodeStructure();
            if (structureUtilisateur.length() > 0 && autorisations.possedePermission(new PermissionBean("FICHE", ReferentielObjets.getCodeObjetParClasse(this.pageLibre.getClass().getName()), "C"), new Perimetre(structureUtilisateur, this.pageLibre.getCodeRubrique(), "*", "*", ""))) {
                this.pageLibre.setCodeRattachement(structureUtilisateur);
            }
            this.pageLibre.setEtatObjet("0001");
            Date date = new Date(System.currentTimeMillis());
            this.pageLibre.setDateModification(date);
            FicheUnivMgr.enregistrer(true, this.pageLibre);
            Metatag meta = FicheUnivMgr.creerMeta(this.pageLibre);
            meta.addHistorique(Metatag.HISTORIQUE_CREATION, (String)this.getGp().getSessionUtilisateur().getInfos().get("CODE"), this.pageLibre.getEtatObjet());
            FicheUnivMgr.enregistrerMeta(meta);
            this.infoBean.set("CODE", this.pageLibre.getCode());
            this.preparerCONFIRMATION();
        }
    }

    @Override
    protected void traiterRECHERCHE() throws Exception {
    }

    private void preparerCONFIRMATION() throws Exception {
        this.ecranLogique = ECRAN_CONFIRMATION;
    }

    protected void traiterCONFIRMATION() throws Exception {
        if (this.action.equals("ANNULER")) {
            this.ecranLogique = "FIN_TOOLBOX";
        }
    }
}

