/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.kportal.core.config.PropertyHelper;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.FicheRattachementsSecondaires;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.FicheUnivMgr;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validation
extends ProcessusBean {
    private static Logger LOG = LoggerFactory.getLogger(Validation.class);
    private static final String ECRAN_SELECTION_NIVEAU_APPROBATION = "APPROBATION";
    private static final String ECRAN_SELECTION_VALIDATEUR = "VALIDATEUR";
    private static final String ECRAN_CONFIRMATION = "CONFIRMATION";
    private static final String ECRAN_LISTE = "LISTE";
    AutorisationBean autorisations;
    FicheUniv ficheUniv;

    public Validation(InfoBean ciu) {
        super(ciu);
    }

    @Override
    public boolean traiterAction() throws Exception {
        Object o = this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        if (o == null) {
            this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
            this.infoBean.setEcranLogique("LOGIN");
        } else {
            try {
                this.autorisations = (AutorisationBean)o;
                this.ecranLogique = this.infoBean.getEcranLogique();
                this.action = this.infoBean.getActionUtilisateur();
                this.etat = 1;
                if (this.infoBean.get("CODE_OBJET") != null) {
                    this.ficheUniv = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(this.infoBean.getString("CODE_OBJET")));
                    this.ficheUniv.setCtx(this);
                    this.ficheUniv.init();
                    if (this.infoBean.get("CODE_RATTACHEMENT") != null) {
                        this.ficheUniv.setCodeRattachement(this.infoBean.getString("CODE_RATTACHEMENT"));
                    }
                    if (this.ficheUniv instanceof FicheRattachementsSecondaires && this.infoBean.get("CODE_RATTACHEMENT_AUTRES") != null) {
                        ((FicheRattachementsSecondaires)((Object)this.ficheUniv)).setCodeRattachementAutres(this.infoBean.getString("CODE_RATTACHEMENT_AUTRES"));
                    }
                    if (this.infoBean.get("CODE_RUBRIQUE") != null) {
                        this.ficheUniv.setCodeRubrique(this.infoBean.getString("CODE_RUBRIQUE"));
                    }
                    if (this.ficheUniv instanceof DiffusionSelective && this.infoBean.get("PUBLIC_VISE_DSI") != null) {
                        ((DiffusionSelective)((Object)this.ficheUniv)).setDiffusionPublicVise(this.infoBean.getString("PUBLIC_VISE_DSI"));
                    }
                }
                if (this.ecranLogique == null) {
                    if (this.action.equals(ECRAN_LISTE)) {
                        this.preparerListeAValider(this.autorisations.getCode(), this.autorisations);
                    } else if (this.action.equals(ECRAN_SELECTION_NIVEAU_APPROBATION)) {
                        this.preparerListeApprobation(this.infoBean.getString("NIVEAU_APPROBATION"));
                    }
                } else if (this.action.equals("ANNULER")) {
                    this.etat = 2;
                } else if (this.ecranLogique.equals(ECRAN_SELECTION_NIVEAU_APPROBATION)) {
                    this.preparerListeValidateur(this.infoBean.getString("NIVEAU_APPROBATION"));
                } else if (this.ecranLogique.equals(ECRAN_SELECTION_VALIDATEUR)) {
                    this.traiterListeValidateur();
                }
                this.infoBean.setEcranLogique(this.ecranLogique);
            }
            catch (Exception e) {
                LOG.error("erreur de traitement sur le processus", (Throwable)e);
                this.infoBean.addMessageErreur(e.toString());
            }
        }
        this.infoBean.set("NOM_ONGLET", "valider");
        return this.etat == 2;
    }

    protected int insererElement(FicheUniv ficheUniv, String codeObjet, int nbItems) throws Exception {
        this.infoBean.set("NOM_PROCESSUS#" + nbItems, ReferentielObjets.getProcessus(codeObjet));
        this.infoBean.set("EXTENSION#" + nbItems, ReferentielObjets.getExtension(codeObjet));
        this.infoBean.set("ID_FICHE#" + nbItems, ficheUniv.getIdFiche().toString());
        this.infoBean.set("LIBELLE#" + nbItems, ficheUniv.getLibelleAffichable());
        this.infoBean.set("NOM_OBJET#" + nbItems, ReferentielObjets.getLibelleObjet(codeObjet));
        this.infoBean.set("CODE_RUBRIQUE#" + nbItems, Rubrique.getIntitule(ficheUniv.getCodeRubrique()));
        this.infoBean.set("DATE_PROPOSITION#" + nbItems, ficheUniv.getDateProposition());
        this.infoBean.set("LIBELLE_REDACTEUR#" + nbItems, Utilisateur.getLibelle(ficheUniv.getCodeRedacteur()));
        this.infoBean.set("LANGUE#" + nbItems, ficheUniv.getLangue());
        this.infoBean.set("ETAT_OBJET#" + nbItems, ficheUniv.getEtatObjet());
        return ++nbItems;
    }

    private void preparerListeApprobation(String _code) throws Exception {
        Hashtable<String, String> hPermissionsValidation = AutorisationBean.getListeNiveauxApprobation();
        Iterator<String> it = AutorisationBean.getListePermissionsValidation().iterator();
        boolean possedePermissionApprobation = true;
        boolean possedeTouteLesPermissions = true;
        boolean debut = false;
        String codeApprobation = "";
        int i = 0;
        if (it.hasNext()) {
            while (it.hasNext() && possedePermissionApprobation) {
                codeApprobation = it.next();
                if (_code.length() == 0) {
                    debut = true;
                } else if (_code.equals(codeApprobation)) {
                    if (it.hasNext()) {
                        codeApprobation = it.next();
                        debut = true;
                    } else {
                        codeApprobation = "V";
                    }
                }
                if (!debut) continue;
                if (!this.autorisations.getAutorisationParFiche(this.ficheUniv, 5, codeApprobation)) {
                    possedePermissionApprobation = false;
                    possedeTouteLesPermissions = false;
                    this.infoBean.set("CODE_NIVEAU_AUTOMATIQUE", codeApprobation);
                    this.infoBean.set("LIBELLE_NIVEAU_AUTOMATIQUE", "A valider : " + hPermissionsValidation.get(codeApprobation));
                    continue;
                }
                this.infoBean.set("CODE_NIVEAU_APPROBATION#" + i, codeApprobation);
                this.infoBean.set("LIBELLE_NIVEAU_APPROBATION#" + i, hPermissionsValidation.get(codeApprobation));
                ++i;
            }
        } else {
            codeApprobation = "V";
        }
        if (possedeTouteLesPermissions) {
            if (this.autorisations.getAutorisationParFiche(this.ficheUniv, 6, "")) {
                this.infoBean.set("CODE_NIVEAU_APPROBATION#" + i, "V");
                this.infoBean.set("LIBELLE_NIVEAU_APPROBATION#" + i, "Mise en ligne");
                this.infoBean.set("CODE_NIVEAU_AUTOMATIQUE", "M");
                this.infoBean.set("LIBELLE_NIVEAU_AUTOMATIQUE", "En ligne");
                ++i;
            } else {
                this.infoBean.set("CODE_NIVEAU_AUTOMATIQUE", "V");
                this.infoBean.set("LIBELLE_NIVEAU_AUTOMATIQUE", "A valider : Mise en ligne");
            }
        }
        if (i > 0) {
            this.infoBean.setInt("NB_ITEMS_NIVEAU_APPROBATION", i);
            this.ecranLogique = ECRAN_SELECTION_NIVEAU_APPROBATION;
        } else {
            this.preparerListeValidateur(codeApprobation);
        }
    }

    private void preparerListeValidateur(String codeApprobation) throws Exception {
        if (!codeApprobation.equals("M")) {
            String libelleApprobation = "";
            Hashtable<String, String> hPermissionsValidation = AutorisationBean.getListeNiveauxApprobation();
            libelleApprobation = codeApprobation.equals("V") ? "Mise en ligne" : hPermissionsValidation.get(codeApprobation);
            String codeUtilisateur2 = "";
            Set<String> mails = Validation.getUtilisateurMailParFicheUnivEtCodeApprobation(codeApprobation, this.ficheUniv);
            int i = 0;
            if (mails != null) {
                for (String codeUtilisateur2 : mails) {
                    if (codeUtilisateur2.equals(this.autorisations.getCode())) continue;
                    this.infoBean.set("CODE_VALIDATEUR_" + i, codeUtilisateur2);
                    this.infoBean.set("NOM_VALIDATEUR_" + i, Utilisateur.getLibelle(codeUtilisateur2));
                    ++i;
                }
            }
            if (!this.infoBean.get("CODE_NIVEAU_AUTOMATIQUE").equals(codeApprobation)) {
                this.infoBean.set("NIVEAU_APPROBATION", codeApprobation);
            } else {
                this.infoBean.set("NIVEAU_APPROBATION", "");
            }
            this.infoBean.set("LIBELLE_APPROBATION", libelleApprobation);
            this.infoBean.setInt("NB_ITEMS_VALIDATEUR", i);
            this.ecranLogique = ECRAN_SELECTION_VALIDATEUR;
        } else {
            this.infoBean.set("NIVEAU_APPROBATION", "M");
            this.infoBean.set("LIBELLE_APPROBATION", "");
            this.infoBean.set("CHAINE_VALIDATEURS", "");
            this.infoBean.set("LISTE_VALIDATEURS", "");
            this.ecranLogique = ECRAN_CONFIRMATION;
        }
    }

    private void traiterListeValidateur() throws Exception {
        String chaineValidateurs = "";
        String listeValidateurs = "";
        for (int i = 0; i < (Integer)this.infoBean.get("NB_ITEMS_VALIDATEUR"); ++i) {
            if (this.infoBean.get("VALIDATEUR_" + i) == null) continue;
            if (chaineValidateurs.length() > 0) {
                listeValidateurs = listeValidateurs + ";";
                chaineValidateurs = chaineValidateurs + ", ";
            }
            listeValidateurs = listeValidateurs + this.infoBean.getString("CODE_VALIDATEUR_" + i);
            chaineValidateurs = chaineValidateurs + Utilisateur.getLibelle(this.infoBean.getString("CODE_VALIDATEUR_" + i));
        }
        if (listeValidateurs.length() == 0) {
            listeValidateurs = "[AUCUNS]";
            chaineValidateurs = "[aucuns]";
        }
        this.infoBean.set("CHAINE_VALIDATEURS", chaineValidateurs);
        this.infoBean.set("LISTE_VALIDATEURS", listeValidateurs);
        this.ecranLogique = ECRAN_CONFIRMATION;
    }

    private void preparerListeAValider(String codeValidateur, AutorisationBean autorisations) throws Exception {
        int nbItems = 0;
        String codeApprobation = "";
        for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
            if (!autorisations.getAutorisation(codeObjet, 3)) continue;
            this.ficheUniv = ReferentielObjets.instancierFiche(codeObjet);
            if (this.ficheUniv == null) continue;
            this.ficheUniv.setCtx(this);
            this.ficheUniv.init();
            int count = this.ficheUniv.selectCodeLangueEtat("", "", "0002");
            if (count <= 0) continue;
            while (this.ficheUniv.nextItem()) {
                boolean ficheEspace = false;
                if (this.ficheUniv instanceof DiffusionSelective && ((DiffusionSelective)((Object)this.ficheUniv)).getDiffusionModeRestriction().equals("4")) {
                    ficheEspace = true;
                }
                if (ficheEspace) continue;
                codeApprobation = "";
                Metatag meta = FicheUnivMgr.lireMeta(this.ficheUniv);
                if (!meta.getMetaNiveauApprobation().equals("")) {
                    codeApprobation = meta.getMetaNiveauApprobation();
                }
                if (!autorisations.getAutorisationParFiche(this.ficheUniv, 5, codeApprobation)) continue;
                nbItems = this.insererElement(this.ficheUniv, codeObjet, nbItems);
            }
        }
        nbItems = this.traiterValidationsSpecifiques(nbItems, autorisations);
        this.infoBean.set("LISTE_NB_ITEMS", new Integer(nbItems));
        this.ecranLogique = ECRAN_LISTE;
    }

    protected int traiterValidationsSpecifiques(int _nbItems, AutorisationBean autorisations) throws Exception {
        return _nbItems;
    }

    public static boolean hasUserAuthorizedNextLevel(String codeApprobation, FicheUniv ficheUniv) {
        if ("1".equals(PropertyHelper.getCoreProperty("validation_multi_niveaux.activation")) && StringUtils.isNotEmpty((CharSequence)codeApprobation) && !StringUtils.equals((CharSequence)codeApprobation, (CharSequence)"M") && !StringUtils.equals((CharSequence)codeApprobation, (CharSequence)"V")) {
            return CollectionUtils.isNotEmpty(Validation.getUtilisateurMailParFicheUnivEtCodeApprobation(codeApprobation, ficheUniv));
        }
        return true;
    }

    private static Set<String> getUtilisateurMailParFicheUnivEtCodeApprobation(String codeApprobation, FicheUniv ficheUniv) {
        PermissionBean permissionBean = new PermissionBean("FICHE", ReferentielObjets.getCodeObjet(ficheUniv), codeApprobation);
        String codeRubrique = ficheUniv.getCodeRubrique();
        String publicsVises = "";
        String espace = "";
        if (ficheUniv instanceof DiffusionSelective && ((DiffusionSelective)((Object)ficheUniv)).getDiffusionModeRestriction().equals("4")) {
            espace = ((DiffusionSelective)((Object)ficheUniv)).getDiffusionPublicViseRestriction();
        }
        TreeSet<String> mails = null;
        try {
            mails = Utilisateur.getListeUtilisateursPossedantPermission(permissionBean, AutorisationBean.getStructuresPerimetreFiche(ficheUniv), ficheUniv.getCodeRubrique(), "", espace, false);
        }
        catch (Exception e) {
            LOG.error("Erreur lors de la r\u00e9cup\u00e9ration des utilisateurs", (Throwable)e);
        }
        return mails;
    }

    public static String getLibelleAprobationParCodeNiveau(String codeApprobation) {
        Hashtable<String, String> hPermissionsValidation = AutorisationBean.getListeNiveauxApprobation();
        if (hPermissionsValidation != null) {
            return StringUtils.defaultString((String)((String)hPermissionsValidation.get(codeApprobation)));
        }
        return "";
    }
}

