/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.sgbd;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.bean.RessourceBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RessourceDB
extends RessourceBean {
    private static final long serialVersionUID = -4880848783605042416L;
    protected transient OMContext ctx = null;
    protected String qualifier = null;
    private transient ResultSet rs = null;

    public String toString() {
        return this.toString(".");
    }

    public String toString(String aSeparator) {
        String s = "" + this.getIdRessource() + aSeparator + this.getIdMedia() + aSeparator + this.getCodeParent() + aSeparator + this.getEtat() + aSeparator + this.getOrdre();
        return s;
    }

    public void setCtx(OMContext _ctx) {
        this.ctx = _ctx;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    private Connection getConnection() {
        return this.ctx.getConnection();
    }

    public void add() throws Exception {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getConnection().prepareStatement("insert into RESSOURCE (ID_RESSOURCE , ID_MEDIA , CODE_PARENT , ETAT , ORDRE) values (?, ?, ?, ?, ?)", 1);
            stmt.setObject(1, (Object)this.getIdRessource(), -5);
            stmt.setObject(2, (Object)this.getIdMedia(), -5);
            stmt.setObject(3, (Object)this.getCodeParent(), 12);
            stmt.setObject(4, (Object)this.getEtat(), 12);
            stmt.setObject(5, (Object)this.getOrdre(), 4);
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected == 0) {
                throw new Exception("METHOD_AFFCTD_NOROWS");
            }
            if (rowsAffected > 1) {
                throw new Exception("METHOD_AFFCTD_MULTROWS");
            }
            rs = stmt.getGeneratedKeys();
            rs.next();
            this.setIdRessource(rs.getLong(1));
        }
        catch (SQLException e) {
            throw new Exception("ERROR_IN_METHOD add()", e);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public void delete() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("delete from RESSOURCE where ID_RESSOURCE = ?");
            stmt.setObject(1, (Object)this.getIdRessource(), -5);
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected == 0) {
                throw new Exception("METHOD_AFFCTD_NOROWS");
            }
            if (rowsAffected > 1) {
                throw new Exception("METHOD_AFFCTD_MULTROWS");
            }
        }
    }

    public String getSQLBaseQuery() {
        String query = "select distinct T1.ID_RESSOURCE, T1.ID_MEDIA, T1.CODE_PARENT, T1.ETAT, T1.ORDRE from " + (this.qualifier == null ? "" : this.qualifier) + "RESSOURCE T1 ";
        return query;
    }

    public boolean nextItem() throws Exception {
        boolean res;
        block6: {
            res = false;
            try {
                if (this.rs.next()) {
                    this.retrieveFromRS();
                    res = true;
                    break block6;
                }
                try {
                    this.rs.close();
                }
                finally {
                    this.rs = null;
                }
            }
            catch (Exception e) {
                throw new Exception("ERROR_IN_METHOD nextItem()", e);
            }
        }
        return res;
    }

    public void retrieve() throws Exception {
        PreparedStatement stmt = null;
        try {
            stmt = this.getConnection().prepareStatement("select T1.ID_RESSOURCE, T1.ID_MEDIA, T1.CODE_PARENT, T1.ETAT, T1.ORDRE from RESSOURCE T1 where T1.ID_RESSOURCE = ?");
            stmt.setObject(1, (Object)this.getIdRessource(), -5);
            this.rs = stmt.executeQuery();
            if (!this.rs.next()) {
                throw new Exception("retrieve : METHOD_NO_RESULTS");
            }
            this.retrieveFromRS();
        }
        catch (SQLException e) {
            throw new Exception("ERROR_IN_METHOD retrieve()", e);
        }
        finally {
            if (this.rs != null) {
                this.rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private void retrieveFromRS() throws Exception {
        try {
            this.setIdRessource(new Long(this.rs.getLong(1)));
            this.setIdMedia(new Long(this.rs.getLong(2)));
            this.setCodeParent(this.rs.getString(3));
            this.setEtat(this.rs.getString(4));
            this.setOrdre(new Integer(this.rs.getInt(5)));
        }
        catch (SQLException e) {
            throw new Exception("ERROR_IN_METHOD retrieveFromRS()", e);
        }
    }

    public void selectNoCount(String sqlSuffix) throws Exception {
        PreparedStatement stmt = null;
        try {
            String query = this.getSQLBaseQuery();
            if (sqlSuffix != null) {
                query = query + sqlSuffix;
            }
            stmt = this.getConnection().prepareStatement(query);
            this.rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            throw new Exception("SELECT_FAILED", e);
        }
    }

    public int select(String sqlSuffix) throws Exception {
        int count = 0;
        PreparedStatement stmt = null;
        try {
            String query = "select count(distinct T1.ID_RESSOURCE) from " + (this.qualifier == null ? "" : this.qualifier) + "RESSOURCE T1 ";
            if (sqlSuffix != null) {
                query = query + sqlSuffix;
            }
            stmt = this.getConnection().prepareStatement(query);
            this.rs = stmt.executeQuery();
            this.rs.next();
            count = this.rs.getInt(1);
            query = this.getSQLBaseQuery();
            if (sqlSuffix != null) {
                query = query + sqlSuffix;
            }
            stmt = this.getConnection().prepareStatement(query);
            this.rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            throw new Exception("SELECT_FAILED", e);
        }
        return count;
    }

    public void update() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("update RESSOURCE set ID_RESSOURCE = ?, ID_MEDIA = ?, CODE_PARENT = ?, ETAT = ?, ORDRE = ? where ID_RESSOURCE = ?");
            stmt.setObject(1, (Object)this.getIdRessource(), -5);
            stmt.setObject(2, (Object)this.getIdMedia(), -5);
            stmt.setObject(3, (Object)this.getCodeParent(), 12);
            stmt.setObject(4, (Object)this.getEtat(), 12);
            stmt.setObject(5, (Object)this.getOrdre(), 4);
            stmt.setObject(6, (Object)this.getIdRessource(), -5);
            stmt.executeUpdate();
        }
    }
}

