/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.sgbd;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.bean.RubriqueBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RubriqueDB
extends RubriqueBean {
    private static final long serialVersionUID = -8476789393175049315L;
    protected transient OMContext ctx = null;
    private transient ResultSet rs = null;

    public String toString() {
        return this.toString(".");
    }

    public String toString(String aSeparator) {
        return "" + this.getIdRubrique() + aSeparator + this.getCode() + aSeparator + this.getLangue() + aSeparator + this.getIntitule() + aSeparator + this.getNomOnglet() + aSeparator + this.getAccroche() + aSeparator + this.getIdBandeau() + aSeparator + this.getCouleurFond() + aSeparator + this.getCouleurTitre() + aSeparator + this.getCodeRubriqueMere() + aSeparator + this.getTypeRubrique() + aSeparator + this.getPageAccueil() + aSeparator + this.getGestionEncadre() + aSeparator + this.getEncadre() + aSeparator + this.getEncadreSousRubrique() + aSeparator + this.getOrdre() + aSeparator + this.getContact() + aSeparator + this.getGroupesDsi() + aSeparator + this.getRequetesRubriquePublication() + aSeparator + this.getCategorie();
    }

    public void setCtx(OMContext _ctx) {
        this.ctx = _ctx;
    }

    private Connection getConnection() {
        return this.ctx.getConnection();
    }

    public void add() throws Exception {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getConnection().prepareStatement("insert into RUBRIQUE (ID_RUBRIQUE , CODE , LANGUE , INTITULE , NOM_ONGLET , ACCROCHE , ID_BANDEAU , COULEUR_FOND , COULEUR_TITRE , CODE_RUBRIQUE_MERE , TYPE_RUBRIQUE , PAGE_ACCUEIL , GESTION_ENCADRE , ENCADRE , ENCADRE_SOUS_RUBRIQUE , ORDRE , CONTACT , GROUPES_DSI , REQUETES_RUBRIQUE_PUBLICATION , CATEGORIE, ID_PICTO) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);
            stmt.setObject(1, (Object)this.getIdRubrique(), -5);
            stmt.setObject(2, (Object)this.getCode(), 12);
            stmt.setObject(3, (Object)this.getLangue(), 12);
            stmt.setObject(4, (Object)this.getIntitule(), 12);
            stmt.setObject(5, (Object)this.getNomOnglet(), 12);
            stmt.setObject(6, (Object)this.getAccroche(), -1);
            stmt.setObject(7, (Object)this.getIdBandeau(), -5);
            stmt.setObject(8, (Object)this.getCouleurFond(), 12);
            stmt.setObject(9, (Object)this.getCouleurTitre(), 12);
            stmt.setObject(10, (Object)this.getCodeRubriqueMere(), 12);
            stmt.setObject(11, (Object)this.getTypeRubrique(), 12);
            stmt.setObject(12, (Object)this.getPageAccueil(), -1);
            stmt.setObject(13, (Object)this.getGestionEncadre(), 12);
            stmt.setObject(14, (Object)this.getEncadre(), -1);
            stmt.setObject(15, (Object)this.getEncadreSousRubrique(), 12);
            stmt.setObject(16, (Object)this.getOrdre(), 12);
            stmt.setObject(17, (Object)this.getContact(), 12);
            stmt.setObject(18, (Object)this.getGroupesDsi(), -1);
            stmt.setObject(19, (Object)this.getRequetesRubriquePublication(), -1);
            stmt.setObject(20, (Object)this.getCategorie(), 12);
            stmt.setObject(21, (Object)this.getIdPicto(), -5);
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected == 0) {
                throw new Exception("METHOD_AFFCTD_NOROWS");
            }
            if (rowsAffected > 1) {
                throw new Exception("METHOD_AFFCTD_MULTROWS");
            }
            rs = stmt.getGeneratedKeys();
            rs.next();
            this.setIdRubrique(rs.getLong(1));
        }
        catch (SQLException e) {
            throw new Exception("ERROR_IN_METHOD add()", e);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public void delete() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("delete from RUBRIQUE where ID_RUBRIQUE = ?");
            stmt.setObject(1, (Object)this.getIdRubrique(), -5);
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected == 0) {
                throw new Exception("METHOD_AFFCTD_NOROWS");
            }
            if (rowsAffected > 1) {
                throw new Exception("METHOD_AFFCTD_MULTROWS");
            }
        }
    }

    public String getSQLBaseQuery() {
        return "select distinct T1.ID_RUBRIQUE, T1.CODE, T1.LANGUE, T1.INTITULE, T1.NOM_ONGLET, T1.ACCROCHE, T1.ID_BANDEAU, T1.COULEUR_FOND, T1.COULEUR_TITRE, T1.CODE_RUBRIQUE_MERE, T1.TYPE_RUBRIQUE, T1.PAGE_ACCUEIL, T1.GESTION_ENCADRE, T1.ENCADRE, T1.ENCADRE_SOUS_RUBRIQUE, T1.ORDRE, T1.CONTACT, T1.GROUPES_DSI, T1.REQUETES_RUBRIQUE_PUBLICATION, T1.CATEGORIE, T1.ID_PICTO from RUBRIQUE T1 ";
    }

    public boolean nextItem() throws Exception {
        boolean res;
        block6: {
            res = false;
            try {
                if (this.rs.next()) {
                    this.retrieveFromRS();
                    res = true;
                    break block6;
                }
                try {
                    this.rs.close();
                }
                finally {
                    this.rs = null;
                }
            }
            catch (Exception e) {
                throw new Exception("ERROR_IN_METHOD nextItem()", e);
            }
        }
        return res;
    }

    public void retrieve() throws Exception {
        PreparedStatement stmt = null;
        try {
            stmt = this.getConnection().prepareStatement("select T1.ID_RUBRIQUE, T1.CODE, T1.LANGUE, T1.INTITULE, T1.NOM_ONGLET, T1.ACCROCHE, T1.ID_BANDEAU, T1.COULEUR_FOND, T1.COULEUR_TITRE, T1.CODE_RUBRIQUE_MERE, T1.TYPE_RUBRIQUE, T1.PAGE_ACCUEIL, T1.GESTION_ENCADRE, T1.ENCADRE, T1.ENCADRE_SOUS_RUBRIQUE, T1.ORDRE, T1.CONTACT, T1.GROUPES_DSI, T1.REQUETES_RUBRIQUE_PUBLICATION, T1.CATEGORIE, T1.ID_PICTO from RUBRIQUE T1 where T1.ID_RUBRIQUE = ?");
            stmt.setObject(1, (Object)this.getIdRubrique(), -5);
            this.rs = stmt.executeQuery();
            if (!this.rs.next()) {
                throw new Exception("retrieve : METHOD_NO_RESULTS");
            }
            this.retrieveFromRS();
        }
        catch (SQLException e) {
            throw new Exception("ERROR_IN_METHOD retrieve()", e);
        }
        finally {
            if (this.rs != null) {
                this.rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private void retrieveFromRS() throws Exception {
        try {
            this.setIdRubrique(this.rs.getLong(1));
            this.setCode(this.rs.getString(2));
            this.setLangue(this.rs.getString(3));
            this.setIntitule(this.rs.getString(4));
            this.setNomOnglet(this.rs.getString(5));
            this.setAccroche(this.rs.getString(6));
            this.setIdBandeau(this.rs.getLong(7));
            this.setCouleurFond(this.rs.getString(8));
            this.setCouleurTitre(this.rs.getString(9));
            this.setCodeRubriqueMere(this.rs.getString(10));
            this.setTypeRubrique(this.rs.getString(11));
            this.setPageAccueil(this.rs.getString(12));
            this.setGestionEncadre(this.rs.getString(13));
            this.setEncadre(this.rs.getString(14));
            this.setEncadreSousRubrique(this.rs.getString(15));
            this.setOrdre(this.rs.getString(16));
            this.setContact(this.rs.getString(17));
            this.setGroupesDsi(this.rs.getString(18));
            this.setRequetesRubriquePublication(this.rs.getString(19));
            this.setCategorie(this.rs.getString(20));
            this.setIdPicto(this.rs.getLong(21));
        }
        catch (SQLException e) {
            throw new Exception("ERROR_IN_METHOD retrieveFromRS()", e);
        }
    }

    public void selectNoCount(String sqlSuffix) throws Exception {
        try {
            String query = this.getSQLBaseQuery();
            if (sqlSuffix != null) {
                query = query + sqlSuffix;
            }
            PreparedStatement stmt = this.getConnection().prepareStatement(query);
            this.rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            throw new Exception("SELECT_FAILED", e);
        }
    }

    public int select(String sqlSuffix) throws Exception {
        int count = 0;
        try {
            String query = "select count(distinct T1.ID_RUBRIQUE) from RUBRIQUE T1 ";
            if (sqlSuffix != null) {
                query = query + sqlSuffix;
            }
            PreparedStatement stmt = this.getConnection().prepareStatement(query);
            this.rs = stmt.executeQuery();
            this.rs.next();
            count = this.rs.getInt(1);
            query = this.getSQLBaseQuery();
            if (sqlSuffix != null) {
                query = query + sqlSuffix;
            }
            stmt = this.getConnection().prepareStatement(query);
            this.rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            throw new Exception("SELECT_FAILED", e);
        }
        return count;
    }

    public int selectMaxOrder(String codeRubriqueMere) throws Exception {
        int ordre = 0;
        PreparedStatement stmt = null;
        try {
            String query = "select max(T1.ORDRE) from RUBRIQUE T1 WHERE T1.CODE_RUBRIQUE_MERE = ?";
            stmt = this.getConnection().prepareStatement("select max(T1.ORDRE) from RUBRIQUE T1 WHERE T1.CODE_RUBRIQUE_MERE = ?");
            stmt.setString(1, codeRubriqueMere);
            this.rs = stmt.executeQuery();
            this.rs.next();
            ordre = this.rs.getInt(1);
        }
        catch (SQLException e) {
            throw new Exception("SELECT_FAILED", e);
        }
        return ordre;
    }

    public void update() throws Exception {
        try (PreparedStatement stmt = null;){
            stmt = this.getConnection().prepareStatement("update RUBRIQUE set ID_RUBRIQUE = ?, CODE = ?, LANGUE = ?, INTITULE = ?, NOM_ONGLET = ?, ACCROCHE = ?, ID_BANDEAU = ?, COULEUR_FOND = ?, COULEUR_TITRE = ?, CODE_RUBRIQUE_MERE = ?, TYPE_RUBRIQUE = ?, PAGE_ACCUEIL = ?, GESTION_ENCADRE = ?, ENCADRE = ?, ENCADRE_SOUS_RUBRIQUE = ?, ORDRE = ?, CONTACT = ?, GROUPES_DSI = ?, REQUETES_RUBRIQUE_PUBLICATION = ?, CATEGORIE = ?, ID_PICTO = ? where ID_RUBRIQUE = ?");
            stmt.setObject(1, (Object)this.getIdRubrique(), -5);
            stmt.setObject(2, (Object)this.getCode(), 12);
            stmt.setObject(3, (Object)this.getLangue(), 12);
            stmt.setObject(4, (Object)this.getIntitule(), 12);
            stmt.setObject(5, (Object)this.getNomOnglet(), 12);
            stmt.setObject(6, (Object)this.getAccroche(), -1);
            stmt.setObject(7, (Object)this.getIdBandeau(), -5);
            stmt.setObject(8, (Object)this.getCouleurFond(), 12);
            stmt.setObject(9, (Object)this.getCouleurTitre(), 12);
            stmt.setObject(10, (Object)this.getCodeRubriqueMere(), 12);
            stmt.setObject(11, (Object)this.getTypeRubrique(), 12);
            stmt.setObject(12, (Object)this.getPageAccueil(), -1);
            stmt.setObject(13, (Object)this.getGestionEncadre(), 12);
            stmt.setObject(14, (Object)this.getEncadre(), -1);
            stmt.setObject(15, (Object)this.getEncadreSousRubrique(), 12);
            stmt.setObject(16, (Object)this.getOrdre(), 12);
            stmt.setObject(17, (Object)this.getContact(), 12);
            stmt.setObject(18, (Object)this.getGroupesDsi(), -1);
            stmt.setObject(19, (Object)this.getRequetesRubriquePublication(), -1);
            stmt.setObject(20, (Object)this.getCategorie(), 12);
            stmt.setObject(21, (Object)this.getIdPicto(), -5);
            stmt.setObject(22, (Object)this.getIdRubrique(), -5);
            stmt.executeUpdate();
            stmt.close();
        }
    }
}

