/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.util;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.bean.HistoriqueBean;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.ContexteDao;
import com.univ.utils.FicheUnivMgr;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AffichageHistorique {
    private static final Logger LOG = LoggerFactory.getLogger(AffichageHistorique.class);

    public static List<HistoriqueBean> getListeHistorique(OMContext ctx, InfoBean infoBean) throws Exception {
        String codeObjet = infoBean.getString("CODE_OBJET");
        Long idFiche = Long.valueOf(infoBean.getString("ID_FICHE"));
        FicheUniv ficheUniv = AffichageHistorique.retrouverFiche(ctx, ReferentielObjets.getNomObjet(codeObjet), idFiche);
        return AffichageHistorique.getAllHistorique(ficheUniv);
    }

    public static List<HistoriqueBean> getAllHistorique(FicheUniv ficheUniv) throws Exception {
        ArrayList<HistoriqueBean> historiqueDispo = new ArrayList<HistoriqueBean>();
        if (ficheUniv != null) {
            Metatag meta = FicheUnivMgr.lireMeta(ficheUniv);
            historiqueDispo.addAll(AffichageHistorique.instancierFicheHistoriqueDepuisInfoMeta(ficheUniv, meta.getVecteurHistorique()));
            String codeObjet = ReferentielObjets.getCodeObjet(ficheUniv);
            FicheUniv fichesAparentees = ReferentielObjets.instancierFiche(codeObjet);
            try (ContexteDao ctx = new ContexteDao();){
                fichesAparentees.setCtx(ctx);
                fichesAparentees.selectCodeLangueEtat(ficheUniv.getCode(), ficheUniv.getLangue(), "");
                while (fichesAparentees.nextItem()) {
                    if (fichesAparentees.getEtatObjet().equals(ficheUniv.getEtatObjet()) && fichesAparentees.getIdFiche().equals(ficheUniv.getIdFiche())) continue;
                    meta = FicheUnivMgr.lireMeta(codeObjet, ficheUniv.getIdFiche());
                    historiqueDispo.addAll(AffichageHistorique.instancierFicheHistoriqueDepuisInfoMeta(ficheUniv, meta.getVecteurHistorique()));
                }
            }
        }
        return historiqueDispo;
    }

    public static List<HistoriqueBean> getHistorique(FicheUniv ficheUniv) throws Exception {
        ArrayList<HistoriqueBean> historiqueDispo = new ArrayList<HistoriqueBean>();
        if (ficheUniv != null) {
            Metatag meta = FicheUnivMgr.lireMeta(ficheUniv);
            historiqueDispo.addAll(AffichageHistorique.instancierFicheHistoriqueDepuisInfoMeta(ficheUniv, meta.getVecteurHistorique()));
        }
        return historiqueDispo;
    }

    private static List<HistoriqueBean> instancierFicheHistoriqueDepuisInfoMeta(FicheUniv fiche, Vector<String> vecteurHistorique) {
        ArrayList<HistoriqueBean> historiques = new ArrayList<HistoriqueBean>();
        for (String valeur : vecteurHistorique) {
            HistoriqueBean historique = new HistoriqueBean();
            valeur = StringUtils.substringBetween((String)valeur, (String)"[", (String)"]");
            String[] valeursSplittes = valeur.split("/");
            historique.setIdFiche(fiche.getIdFiche());
            historique.setAction(Metatag.getIntituleAction(valeursSplittes[0]));
            try {
                historique.setDateAction(DateUtils.parseDate((String)valeursSplittes[1], (String[])new String[]{"yyyyMMddhhmmss"}));
            }
            catch (ParseException e) {
                LOG.info("impossible de parser la date de l'historique de la fiche.", (Throwable)e);
            }
            historique.setUtilisateur(valeursSplittes[2]);
            historique.setEtat(EtatFiche.getEtatParCode(valeursSplittes[3]));
            historiques.add(historique);
        }
        return historiques;
    }

    private static FicheUniv retrouverFiche(OMContext ctx, String codeObjet, Long idFiche) {
        FicheUniv ficheUniv = ReferentielObjets.instancierFiche(codeObjet);
        ficheUniv.setCtx(ctx);
        ficheUniv.init();
        try {
            ficheUniv.setIdFiche(idFiche);
            ficheUniv.retrieve();
        }
        catch (Exception ex) {
            ficheUniv = null;
        }
        return ficheUniv;
    }

    public static void preparerLISTE(InfoBean infoBean, OMContext ctx) throws Exception {
        TreeMap<Long, String> historique = new TreeMap<Long, String>();
        Enumeration<String> e = null;
        String objet = ReferentielObjets.getNomObjet(infoBean.getString("CODE_OBJET"));
        FicheUniv ficheUniv = ReferentielObjets.instancierFiche(objet);
        ficheUniv.setCtx(ctx);
        ficheUniv.init();
        infoBean.set("AVERTISSEMENT", "0");
        boolean historiqueVide = false;
        try {
            ficheUniv.setIdFiche(new Long(infoBean.getString("ID_FICHE")));
            ficheUniv.retrieve();
        }
        catch (Exception ex) {
            historiqueVide = true;
        }
        if (!historiqueVide) {
            Metatag meta = FicheUnivMgr.lireMeta(infoBean.getString("CODE_OBJET"), new Long(infoBean.getString("ID_FICHE")));
            e = meta.getVecteurHistorique().elements();
            if (meta.getVecteurHistorique().size() == 0) {
                historiqueVide = true;
            }
        }
        if (!historiqueVide) {
            while (e.hasMoreElements()) {
                String action = (String)e.nextElement();
                StringTokenizer st = new StringTokenizer(action, "[/]");
                st.nextToken();
                Long dateInversee = 999999999999L - new Long(st.nextToken());
                historique.put(dateInversee, ficheUniv.getIdFiche() + action);
            }
            FicheUniv ficheUniv2 = ReferentielObjets.instancierFiche(objet);
            ficheUniv2.setCtx(ctx);
            ficheUniv2.init();
            if (ficheUniv2.selectCodeLangueEtat(ficheUniv.getCode(), ficheUniv.getLangue(), "") > 0) {
                while (ficheUniv2.nextItem()) {
                    Metatag meta = FicheUnivMgr.lireMeta(infoBean.getString("CODE_OBJET"), ficheUniv2.getIdFiche());
                    e = meta.getVecteurHistorique().elements();
                    while (e.hasMoreElements()) {
                        String action = e.nextElement();
                        StringTokenizer st = new StringTokenizer(action, "[/]");
                        st.nextToken();
                        Long dateInversee = 999999999999L - new Long(st.nextToken());
                        if (historique.get(dateInversee) != null) continue;
                        historique.put(dateInversee, ficheUniv2.getIdFiche() + action);
                    }
                }
            }
            Iterator iter = historique.values().iterator();
            for (int i = 0; iter.hasNext() && i < 20; ++i) {
                String action = (String)iter.next();
                StringTokenizer st = new StringTokenizer(action, "[/]");
                int indToken = 0;
                while (st.hasMoreTokens()) {
                    String item = st.nextToken();
                    if (indToken == 0) {
                        infoBean.set("ID_FICHE#" + i, item);
                        if (!item.equals(ficheUniv.getIdFiche().toString())) {
                            infoBean.set("AVERTISSEMENT", "1");
                        }
                    }
                    if (indToken == 1) {
                        infoBean.set("ACTION#" + i, Metatag.getIntituleAction(item));
                    }
                    if (indToken == 2) {
                        infoBean.set("DATE#" + i, item.substring(6, 8) + "/" + item.substring(4, 6) + "/" + item.substring(0, 4));
                        infoBean.set("HEURE#" + i, item.substring(8, 10) + ":" + item.substring(10, 12));
                    }
                    if (indToken == 3) {
                        if (item.equalsIgnoreCase("nobody")) {
                            infoBean.set("UTILISATEUR#" + i, "Script de mise \u00e0 jour");
                        } else {
                            infoBean.set("UTILISATEUR#" + i, Utilisateur.getLibelle(item));
                        }
                    }
                    if (indToken == 4) {
                        infoBean.set("ETAT#" + i, item);
                    }
                    ++indToken;
                }
            }
        }
    }
}

