/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.util;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.bean.ReferenceBean;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AffichageReferences {
    private static final Logger LOG = LoggerFactory.getLogger(AffichageReferences.class);

    public static List<ReferenceBean> getListeReferences(OMContext ctx, InfoBean infoBean) throws Exception {
        ArrayList<ReferenceBean> referencesDispo = new ArrayList<ReferenceBean>();
        String codeObjet = infoBean.getString("CODE_OBJET");
        String codeFiche = infoBean.getString("CODE");
        String langue = infoBean.getString("LANGUE");
        if (StringUtils.isNotBlank((CharSequence)codeObjet)) {
            Metatag meta = new Metatag();
            meta.init();
            meta.setCtx(ctx);
            meta.selectParReferences(codeObjet, codeFiche, langue, 0L);
            while (meta.nextItem()) {
                FicheUniv ficheUniv = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(meta.getMetaCodeObjet()));
                ficheUniv.setCtx(ctx);
                ficheUniv.init();
                ficheUniv.setIdFiche(meta.getMetaIdFiche());
                try {
                    ficheUniv.retrieve();
                    if (!EtatFiche.isEtatPerene(ficheUniv.getEtatObjet())) continue;
                    ReferenceBean reference = new ReferenceBean();
                    reference.setTitre(ficheUniv.getLibelleAffichable());
                    reference.setLangue(ficheUniv.getLangue());
                    reference.setType(ReferentielObjets.getLibelleObjet(meta.getMetaCodeObjet()));
                    reference.setEtat(EtatFiche.getEtatParCode(ficheUniv.getEtatObjet()));
                    referencesDispo.add(reference);
                }
                catch (Exception e) {
                    LOG.info("impossible de r\u00e9cuperer la fiche depuis les metas", (Throwable)e);
                }
            }
            Rubrique rub = new Rubrique();
            rub.init();
            rub.setCtx(ctx);
            ClauseWhere whereCodeObjet = new ClauseWhere();
            String codePageTete = codeFiche + ",LANGUE=" + langue + ",TYPE=" + ReferentielObjets.getNomObjet(codeObjet);
            whereCodeObjet.setPremiereCondition(ConditionHelper.egalVarchar("CODE_PAGE_TETE", codePageTete));
            String chaineIdFiche = "[id-fiche]" + ReferentielObjets.getNomObjet(codeObjet) + "[/id-fiche]";
            whereCodeObjet.or(ConditionHelper.like("ENCADRE", chaineIdFiche, "%", "%"));
            whereCodeObjet.or(ConditionHelper.like("ACCROCHE", chaineIdFiche, "%", "%"));
            rub.select(whereCodeObjet.formaterSQL());
            while (rub.nextItem()) {
                String titre = rub.getIntitule();
                for (InfosRubriques rubAriane = Rubrique.renvoyerItemRubrique(rub.getCodeRubriqueMere()); rubAriane != null && rubAriane.getOnglet() != null && rubAriane.getOnglet().length() > 0; rubAriane = rubAriane.getRubriqueMere()) {
                    titre = rubAriane.getOnglet() + " &gt; " + titre;
                }
                ReferenceBean reference = new ReferenceBean();
                reference.setTitre(titre);
                reference.setType("Rubrique");
                reference.setEtat(EtatFiche.EN_LIGNE);
                reference.setLangue(rub.getLangue());
                referencesDispo.add(reference);
            }
        }
        return referencesDispo;
    }
}

