/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.util;

import com.jsbsoft.jtf.core.CodeLibelle;
import com.jsbsoft.jtf.core.Formateur;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.textsearch.RechercheFmt;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.util.CritereRecherche;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.DateUtil;
import java.sql.Date;
import org.apache.commons.lang3.StringUtils;

public class CritereRechercheUtil {
    public static CritereRecherche getCritereTexteNonVide(InfoBean infoBean, String nomChamp) {
        CritereRecherche critere = null;
        String valeur = infoBean.getString(nomChamp);
        if (StringUtils.isNotBlank((CharSequence)valeur)) {
            critere = new CritereRecherche(nomChamp, valeur, valeur);
        }
        return critere;
    }

    public static CritereRecherche getCritereTexteNonVideFormater(InfoBean infoBean, String nomChamp) {
        CritereRecherche critere = null;
        String valeur = infoBean.getString(nomChamp);
        if (StringUtils.isNotBlank((CharSequence)valeur)) {
            critere = new CritereRecherche(nomChamp, RechercheFmt.formaterTexteRecherche(valeur), valeur);
        }
        return critere;
    }

    public static CritereRecherche getCritereTexteNonVideSansValeurDefaut(InfoBean infoBean, String nomChamp) {
        CritereRecherche critere = null;
        String valeur = infoBean.getString(nomChamp);
        if (StringUtils.isNotBlank((CharSequence)valeur) && !"0000".equals(valeur)) {
            critere = new CritereRecherche(nomChamp, RechercheFmt.formaterTexteRecherche(valeur), valeur);
        }
        return critere;
    }

    public static CritereRecherche getCritereChaineAvecLibelle(InfoBean infoBean, String nomChamp, String typeLibelle) {
        CritereRecherche critere = null;
        String valeur = infoBean.getString(nomChamp);
        if (StringUtils.isNotBlank((CharSequence)valeur) && !"0000".equals(valeur)) {
            ContexteUniv ctx = ContexteUtil.getContexteUniv();
            String libelleValeur = Libelle.getLibelle(typeLibelle, valeur, ctx.getLocale());
            critere = new CritereRecherche(nomChamp, valeur, libelleValeur);
        }
        return critere;
    }

    public static CritereRecherche getCritereChaineAvecFichierDat(InfoBean infoBean, String nomChamp, String nomFichierDat, String idExtension) {
        CritereRecherche critere = null;
        String valeur = infoBean.getString(nomChamp);
        if (StringUtils.isNotBlank((CharSequence)valeur) && !"0000".equals(valeur)) {
            String valeurFichierDat = CodeLibelle.lireLibelle(idExtension, nomFichierDat, valeur);
            critere = new CritereRecherche(nomChamp, valeur, valeurFichierDat);
        }
        return critere;
    }

    public static CritereRecherche getCritereDate(InfoBean infoBean, String nomChamp) {
        CritereRecherche critere = null;
        Object infoBeanValue = infoBean.get(nomChamp);
        Date valeur = null;
        if (infoBeanValue != null && infoBeanValue instanceof Date) {
            valeur = (Date)infoBeanValue;
        } else if (infoBeanValue != null && infoBeanValue instanceof String) {
            valeur = DateUtil.parseDate((String)infoBeanValue);
        }
        if (Formateur.estSaisie(valeur)) {
            String valeurDateFormat = Formateur.formater(valeur);
            critere = new CritereRecherche(nomChamp, valeurDateFormat, valeurDateFormat);
        }
        return critere;
    }

    public static CritereRecherche getCritereThematique(InfoBean infoBean) {
        return CritereRechercheUtil.getCritereChaineAvecLibelle(infoBean, "THEMATIQUE", "04");
    }
}

