/*
 * Decompiled with CFR 0.152.
 */
package com.univ.objetspartages.util;

import com.kportal.cms.objetspartages.annotation.FicheAnnotationHelper;
import com.univ.objetspartages.bean.MetatagBean;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.DiffusionSelective;
import com.univ.objetspartages.om.EtatFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.FicheUnivHelper;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseOrderBy;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FichesAValiderUtil {
    private static DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final Logger LOG = LoggerFactory.getLogger(FichesAValiderUtil.class);

    private static String computeHash(Metatag meta, FicheUniv ficheUniv, String codeObjet) {
        String dateString = dateFormat.format(meta.getMetaDateCreation());
        if (meta.getMetaDateProposition().getTime() > 0L) {
            dateString = dateFormat.format(meta.getMetaDateProposition());
        } else if (meta.getMetaDateModification().getTime() > 0L) {
            dateString = dateFormat.format(meta.getMetaDateModification());
        }
        return String.format("%s-%s-%s-%s-%s", dateString, codeObjet, ficheUniv.getLibelleAffichable(), ficheUniv.getCode(), ficheUniv.getLangue());
    }

    public static int compterObjetsAValider() throws Exception {
        return FichesAValiderUtil.getListeObjetsAValider().size();
    }

    public static Collection<FicheUniv> getListeObjetsAValiderRecents(int limit) throws Exception {
        SortedMap<String, FicheUniv> fichesAValider = FichesAValiderUtil.getListeObjetsAValider();
        if (limit <= 0 || limit >= fichesAValider.size()) {
            return fichesAValider.values();
        }
        String[] keys = new String[fichesAValider.keySet().size()];
        return fichesAValider.subMap(fichesAValider.firstKey(), fichesAValider.keySet().toArray(keys)[limit]).values();
    }

    public static SortedMap<String, FicheUniv> getListeObjetsAValider() throws Exception {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        AutorisationBean autorisations = ctx.getAutorisation();
        TreeMap<String, FicheUniv> liste = new TreeMap<String, FicheUniv>();
        for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
            FicheUniv ficheUniv;
            if (!autorisations.getAutorisation(codeObjet, 3) || (ficheUniv = ReferentielObjets.instancierFiche(codeObjet)) == null || !FicheAnnotationHelper.isAccessibleBo(ficheUniv)) continue;
            ficheUniv.setCtx(ctx);
            ficheUniv.init();
            ficheUniv.selectCodeLangueEtat("", "", "0002");
            while (ficheUniv.nextItem()) {
                boolean ficheEspace = false;
                if (ficheUniv instanceof DiffusionSelective && "4".equals(((DiffusionSelective)((Object)ficheUniv)).getDiffusionModeRestriction())) {
                    ficheEspace = true;
                }
                if (ficheEspace) continue;
                String codeApprobation = "";
                Metatag meta = FicheUnivMgr.lireMeta(ficheUniv);
                if (!"".equals(meta.getMetaNiveauApprobation())) {
                    codeApprobation = meta.getMetaNiveauApprobation();
                }
                if (!autorisations.getAutorisationParFiche(ficheUniv, 5, codeApprobation)) continue;
                String hash = FichesAValiderUtil.computeHash(meta, ficheUniv, codeObjet);
                liste.put(hash, FicheUnivHelper.getFicheParIdMeta(meta.getIdMetatag()));
            }
        }
        return liste;
    }

    public static List<MetatagBean> getObjetsAValider(AutorisationBean autorisations) {
        ArrayList<String> codeObjets = new ArrayList<String>();
        ArrayList<MetatagBean> result = new ArrayList<MetatagBean>();
        for (String codeObjet : ReferentielObjets.getListeCodesObjet()) {
            if (!autorisations.getAutorisation(codeObjet, 3)) continue;
            codeObjets.add(codeObjet);
        }
        Metatag meta = new Metatag();
        try (ContexteDao ctx = new ContexteDao();){
            meta.setCtx(ctx);
            ClauseWhere whereMetaCodeObjetEtEtat = new ClauseWhere(ConditionHelper.egalVarchar("META_ETAT_OBJET", EtatFiche.A_VALIDER.toString()));
            if (!codeObjets.isEmpty()) {
                whereMetaCodeObjetEtEtat.and(ConditionHelper.in("META_CODE_OBJET", codeObjets));
            }
            ClauseOrderBy orderBy = new ClauseOrderBy("META_DATE_MODIFICATION", ClauseOrderBy.SensDeTri.DESC);
            RequeteSQL requete = new RequeteSQL();
            requete.where(whereMetaCodeObjetEtEtat).orderBy(orderBy);
            meta.select(requete.formaterRequete());
            while (meta.nextItem()) {
                if ("4".equals(meta.getMetaDiffusionModeRestriction())) continue;
                String codeApprobation = StringUtils.defaultString((String)meta.getMetaNiveauApprobation());
                if (!autorisations.getAutorisation(meta.getMetaCodeObjet(), meta.getMetaCode(), meta.getMetaCodeRubrique(), meta.getMetaCodeRattachement(), meta.getMetaCodeRattachementAutres(), meta.getMetaDiffusionPublicVise(), meta.getMetaDiffusionModeRestriction(), meta.getMetaDiffusionPublicViseRestriction(), 5, codeApprobation)) continue;
                MetatagBean currentMeta = new MetatagBean();
                currentMeta.init(meta);
                result.add(currentMeta);
            }
        }
        catch (Exception e) {
            LOG.error("Impossible de r\u00e9cup\u00e9rer les fiches \u00e0 valider");
        }
        return result;
    }
}

