/*
 * Decompiled with CFR 0.152.
 */
package com.univ.portail;

import com.jsbsoft.jtf.core.LangueUtil;
import com.univ.objetspartages.om.ServiceBean;
import com.univ.portail.core.FactoryAccess;
import com.univ.portail.core.PortalControlParameter;
import com.univ.portail.core.PortalEnvironment;
import com.univ.portail.core.PortalURL;
import com.univ.portail.core.PortletContainerFactory;
import com.univ.portail.core.SessionStatefullParameter;
import com.univ.portail.core.impl.DynamicTitleServiceImpl;
import com.univ.portail.om.window.impl.PortletWindowImpl;
import com.univ.portail.service.registry.PortletEntityRegistry;
import com.univ.portail.servlet.ServletObjectAccess;
import com.univ.portail.servlet.ServletRequestImpl;
import com.univ.services.CacheServiceViewManager;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ServicesUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.UnavailableException;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.om.ControllerObjectAccess;
import org.apache.pluto.om.Model;
import org.apache.pluto.om.common.Language;
import org.apache.pluto.om.common.LanguageSet;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.portlet.ContentType;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.servlet.ServletDefinition;
import org.apache.pluto.om.servlet.ServletDefinitionCtrl;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.om.window.PortletWindowCtrl;
import org.apache.pluto.om.window.PortletWindowList;
import org.apache.pluto.om.window.PortletWindowListCtrl;
import org.apache.pluto.portalImpl.servlet.ServletResponseImpl;
import org.apache.pluto.services.information.PortalContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KportalPortletFragment {
    private static Logger LOG = LoggerFactory.getLogger(KportalPortletFragment.class);
    public static final String OCCURENCE_SUFFIXE = "_occ";
    private PortletWindow portletWindow = null;
    public String name = null;
    public static final String PORTLET_ERROR_MSG = "Error occurred in portlet!";

    public KportalPortletFragment(String id) throws PortletException {
        String portletEntityId = null;
        portletEntityId = id.indexOf(OCCURENCE_SUFFIXE) != -1 ? id.substring(0, id.indexOf(OCCURENCE_SUFFIXE)) : id;
        PortletEntity portletEntity = PortletEntityRegistry.getPortletEntity(portletEntityId);
        if (portletEntity == null) {
            LOG.error("La portlet demand\u00e9e: '" + id + "' n'existe pas.");
            throw new PortletException("La portlet demand\u00e9e: '" + id + "' n'existe pas.");
        }
        this.portletWindow = new PortletWindowImpl(id);
        ((PortletWindowCtrl)this.portletWindow).setPortletEntity(portletEntity);
        PortletWindowList windowList = portletEntity.getPortletWindowList();
        ((PortletWindowListCtrl)windowList).add(this.portletWindow);
    }

    public String service(ContexteUniv ctx, String encodage) throws ServletException, IOException {
        HttpServletRequest wrappedRequestKportal;
        Language lang;
        String idService = this.portletWindow.getId().toString();
        if (idService.indexOf(OCCURENCE_SUFFIXE) != -1) {
            idService = idService.substring(0, idService.indexOf(OCCURENCE_SUFFIXE));
        }
        LOG.debug("Fragment.service(" + idService + " ) d\u00e9but");
        if (!ctx.getListeServicesAutorises().contains(idService)) {
            return "Vous n'\u00eates pas autoris\u00e9s \u00e0 ex\u00e9cuter le service '" + idService + "'.";
        }
        HttpServletRequest request = ctx.getRequeteHTTP();
        HttpServletResponse response = ctx.getReponseHTTP();
        HttpServletRequest wrappedRequest = ServletObjectAccess.getServletRequest(request, this.portletWindow);
        if (wrappedRequest instanceof ServletRequestImpl) {
            ((ServletRequestImpl)wrappedRequest).setLocale(ctx.getLocale());
        }
        wrappedRequest.setAttribute("kportal.ctx", (Object)ctx);
        StringWriter storedWriter = new StringWriter();
        PrintWriter writer2 = new PrintWriter(storedWriter);
        ServletResponseImpl wrappedResponse = (ServletResponseImpl)ServletObjectAccess.getStoredServletResponse(response, writer2);
        String errorMsg = null;
        PortalEnvironment reqPortalEnv = PortalEnvironment.getPortalEnvironment(request);
        PortalURL newPortalURL = new PortalURL(reqPortalEnv);
        Map statefullsParameters = SessionStatefullParameter.getFromSession(request, this.portletWindow.getId().toString());
        if (statefullsParameters != null) {
            newPortalURL.setSessionStatefullParameter(statefullsParameters);
        }
        PortalControlParameter newPortalControlParameter = new PortalControlParameter(newPortalURL);
        newPortalControlParameter.getStateFullControlParameter().put("pid", this.portletWindow.getId().toString());
        boolean modifStatefull = false;
        if (ctx.getMetaCourant() != null) {
            newPortalControlParameter.setKportalParam(this.portletWindow, "ID_META", new String[]{ctx.getMetaCourant().getIdMetatag().toString()});
            modifStatefull = true;
        }
        if (ctx.getCodeRubriqueHistorique() != null && ctx.getCodeRubriqueHistorique().length() > 0) {
            newPortalControlParameter.setKportalParam(this.portletWindow, "RH", new String[]{ctx.getCodeRubriqueHistorique()});
            modifStatefull = true;
        }
        if ("unitaire".equals(newPortalURL.getUrlParameter("AFFICHAGE"))) {
            newPortalControlParameter.setKportalParam(this.portletWindow, "UNITAIRE", new String[]{"1"});
            modifStatefull = true;
        }
        if (modifStatefull) {
            SessionStatefullParameter.saveIntoSession(request, this.portletWindow.getId().toString(), newPortalControlParameter);
        }
        PortalEnvironment wrapReqPortalEnv = new PortalEnvironment(wrappedRequest, (HttpServletResponse)wrappedResponse);
        newPortalURL.setEnv(wrapReqPortalEnv);
        wrapReqPortalEnv.changeRequestedPortalURL(newPortalURL, newPortalControlParameter);
        wrappedRequest.setAttribute("org.apache.pluto.portalImpl.core.PortalEnvironment", (Object)wrapReqPortalEnv);
        ((ServletRequestImpl)wrappedRequest).setControl(newPortalControlParameter);
        PortletDefinition portletDefinition = this.portletWindow.getPortletEntity().getPortletDefinition();
        LanguageSet languageSet = portletDefinition.getLanguageSet();
        Locale lo = LangueUtil.getDefaultLocale();
        if (request.getLocale() != null) {
            lo = request.getLocale();
        }
        String title = (lang = languageSet.get(lo)) != null ? lang.getTitle() : "no title available";
        String contenuPortlet = null;
        ServletDefinition servletDefinition = this.portletWindow.getPortletEntity().getPortletDefinition().getServletDefinition();
        if (servletDefinition != null && !servletDefinition.isUnavailable()) {
            try {
                if (newPortalControlParameter.getMode(this.portletWindow).equals((Object)PortletMode.VIEW) && newPortalControlParameter.getState(this.portletWindow).equals((Object)WindowState.NORMAL)) {
                    String codeService = this.portletWindow.getPortletEntity().getId().toString();
                    ServiceBean service = ServicesUtil.getService(codeService);
                    contenuPortlet = CacheServiceViewManager.getContenuPortlet(ctx, service, this.portletWindow, storedWriter, wrappedRequest, (HttpServletResponse)wrappedResponse);
                } else {
                    PortletContainerFactory.getPortletContainer().portletLoad(this.portletWindow, wrappedRequest, (HttpServletResponse)wrappedResponse);
                    PortletContainerFactory.getPortletContainer().renderPortlet(this.portletWindow, wrappedRequest, (HttpServletResponse)wrappedResponse);
                    contenuPortlet = storedWriter.toString();
                }
            }
            catch (UnavailableException e) {
                LOG.error("Portlet is Unavailable", (Throwable)e);
                writer2.println("the portlet is currently unavailable!");
                ServletDefinitionCtrl servletDefinitionCtrl = (ServletDefinitionCtrl)ControllerObjectAccess.get((Model)this.portletWindow.getPortletEntity().getPortletDefinition().getServletDefinition());
                if (e.isPermanent()) {
                    servletDefinitionCtrl.setAvailable(Long.MAX_VALUE);
                } else {
                    int unavailableSeconds = e.getUnavailableSeconds();
                    if (unavailableSeconds <= 0) {
                        unavailableSeconds = 60;
                    }
                    servletDefinitionCtrl.setAvailable(System.currentTimeMillis() + (long)(unavailableSeconds * 1000));
                }
            }
            catch (Exception e) {
                LOG.error("Error in Portlet", (Throwable)e);
                errorMsg = this.getErrorMsg();
            }
            String dyn_title = ((DynamicTitleServiceImpl)FactoryAccess.getDynamicTitleContainerService()).getDynamicTitle(this.portletWindow, wrappedRequest);
            if (dyn_title != null) {
                title = dyn_title;
            }
        }
        PortletInfo portletInfo = new PortletInfo();
        portletInfo.setTitle(title);
        portletInfo.setNomAncre(this.portletWindow.getId().toString());
        ContentType supported = portletDefinition.getContentTypeSet().get(wrappedResponse.getContentType());
        PortalContextProvider portalContextProvider = FactoryAccess.getStaticProvider().getPortalContextProvider();
        if (supported != null && portalContextProvider != null) {
            Iterator modes = supported.getPortletModes();
            PortletMode currentMode = newPortalControlParameter.getMode(this.portletWindow);
            while (modes.hasNext()) {
                PortletMode mode = (PortletMode)modes.next();
                boolean portalSupport = false;
                for (PortletMode portalSupportedMode : portalContextProvider.getSupportedPortletModes()) {
                    if (!mode.equals((Object)portalSupportedMode)) continue;
                    portalSupport = true;
                    break;
                }
                if (!portalSupport) continue;
                newPortalControlParameter.setMode(this.portletWindow, mode);
                portletInfo.addPortletMode(mode, newPortalURL.toString(newPortalControlParameter, new Boolean(request.isSecure())), mode.equals((Object)currentMode));
            }
            newPortalControlParameter.setMode(this.portletWindow, currentMode);
            WindowState currentState = newPortalControlParameter.getState(this.portletWindow);
            Iterator states = portalContextProvider.getSupportedWindowStates().iterator();
            boolean affichageUnitaire = false;
            String[] unitaire = newPortalControlParameter.getKportalParamValues(this.portletWindow, "UNITAIRE");
            if (unitaire != null && "1".equals(unitaire[0])) {
                affichageUnitaire = true;
            }
            while (!affichageUnitaire && states.hasNext()) {
                WindowState state = (WindowState)states.next();
                newPortalControlParameter.setState(this.portletWindow, state);
                portletInfo.addPortletWindowState(state.toString().substring(0, 3), newPortalURL.toString(newPortalControlParameter, new Boolean(request.isSecure())), state.equals((Object)currentState));
            }
            newPortalControlParameter.setState(this.portletWindow, currentState);
        }
        if (contenuPortlet != null && encodage != null && encodage.length() > 0) {
            if (encodage.equals("I")) {
                contenuPortlet = new String(contenuPortlet.getBytes(), "UTF-8");
            } else if (encodage.equals("U")) {
                contenuPortlet = new String(contenuPortlet.getBytes(), "UTF-8");
            }
        }
        if ((wrappedRequestKportal = ServletObjectAccess.getServletRequest(request, this.portletWindow)) instanceof ServletRequestImpl) {
            ((ServletRequestImpl)wrappedRequestKportal).setLocale(ctx.getLocale());
        }
        StringWriter storedWriterKportal = new StringWriter();
        PrintWriter printWriterKportal = new PrintWriter(storedWriterKportal);
        ServletResponseImpl wrappedResponseKportal = (ServletResponseImpl)ServletObjectAccess.getStoredServletResponse(response, printWriterKportal);
        wrappedRequestKportal.setAttribute("portletInfo", (Object)portletInfo);
        try {
            RequestDispatcher rd = ctx.getServletContext().getRequestDispatcher("/adminsite/portal/PortletFragmentHeader.jsp");
            rd.include((ServletRequest)wrappedRequestKportal, (ServletResponse)wrappedResponseKportal);
            if (errorMsg == null) {
                if (this.portletWindow.getPortletEntity().getPortletDefinition().getServletDefinition().isUnavailable()) {
                    printWriterKportal.println("the portlet is currently unavailable!");
                } else {
                    printWriterKportal.println(contenuPortlet);
                }
            } else {
                printWriterKportal.println(errorMsg);
            }
            RequestDispatcher rdFooter = ctx.getServletContext().getRequestDispatcher("/adminsite/portal/PortletFragmentFooter.jsp");
            rdFooter.include((ServletRequest)wrappedRequestKportal, (ServletResponse)wrappedResponseKportal);
            request.removeAttribute("portletInfo");
        }
        catch (ServletException e) {
            LOG.error("Exception en tentant de construire le rendu de la portlet '" + idService, (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOG.error("Exception en tentant de construire le rendu de la portlet '" + idService, (Throwable)e);
            throw e;
        }
        return storedWriterKportal.toString();
    }

    public void createURL(PortalURL url) {
        LOG.debug("create url");
    }

    public boolean isPartOfURL(PortalURL url) {
        return true;
    }

    public PortletWindow getPortletWindow() {
        return this.portletWindow;
    }

    protected String getErrorMsg() {
        return PORTLET_ERROR_MSG;
    }

    public static class PortletModeInfo
    implements Comparable<PortletModeInfo> {
        private String name;
        private String url;
        private boolean isCurrent;

        public PortletModeInfo(String name, String url, boolean isCurrent) {
            this.name = name;
            this.url = url;
            this.isCurrent = isCurrent;
        }

        public boolean isCurrent() {
            return this.isCurrent;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setCurrent(boolean b) {
            this.isCurrent = b;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setUrl(String string) {
            this.url = string;
        }

        @Override
        public int compareTo(PortletModeInfo compare) {
            if (!(compare instanceof PortletModeInfo)) {
                throw new ClassCastException(compare + " is not a " + PortletModeInfo.class.getName());
            }
            PortletModeInfo other = compare;
            return this.getName().compareTo(other.getName());
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class PortletWindowStateInfo
    implements Comparable<PortletWindowStateInfo> {
        private String label;
        private String url;
        private boolean isCurrent;

        @Override
        public int compareTo(PortletWindowStateInfo compare) {
            if (!(compare instanceof PortletWindowStateInfo)) {
                throw new ClassCastException(compare + " is not a " + PortletWindowStateInfo.class.getName());
            }
            PortletWindowStateInfo other = compare;
            return this.getLabel().compareTo(other.getLabel());
        }

        public boolean isCurrentMin() {
            return "min".equals(this.label);
        }

        public PortletWindowStateInfo(String stateLabel, String activationURL, boolean isCurrent) {
            this.label = stateLabel;
            this.url = activationURL;
            this.isCurrent = isCurrent;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String string) {
            this.label = string;
        }

        public boolean isCurrent() {
            return this.isCurrent;
        }

        public String getUrl() {
            return this.url;
        }

        public void setCurrent(boolean b) {
            this.isCurrent = b;
        }

        public void setUrl(String string) {
            this.url = string;
        }

        public String toString() {
            return this.getLabel();
        }
    }

    public static class PortletInfo {
        private String nomAncre = null;
        private String title;
        private final List<PortletModeInfo> availablePortletModes = new ArrayList<PortletModeInfo>();
        private final List<PortletWindowStateInfo> availablePortletWindowStates = new ArrayList<PortletWindowStateInfo>();

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public List<PortletModeInfo> getAvailablePortletModes() {
            return this.availablePortletModes;
        }

        public void addPortletMode(PortletMode mode, String activationURL, boolean isCurrent) {
            PortletModeInfo pmi = new PortletModeInfo(mode.toString(), activationURL, isCurrent);
            this.availablePortletModes.add(pmi);
        }

        public List<PortletWindowStateInfo> getAvailablePortletWindowStates() {
            return this.availablePortletWindowStates;
        }

        public void addPortletWindowState(String stateLabel, String activationURL, boolean isCurrent) {
            PortletWindowStateInfo pwsi = new PortletWindowStateInfo(stateLabel, activationURL, isCurrent);
            this.availablePortletWindowStates.add(pwsi);
        }

        public String getNomAncre() {
            return this.nomAncre;
        }

        public void setNomAncre(String nomAncre) {
            this.nomAncre = nomAncre;
        }
    }
}

