/*
 * Decompiled with CFR 0.152.
 */
package com.univ.portail;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.webutils.ContextePage;
import com.kportal.cms.objetspartages.ObjetPartageHelper;
import com.kportal.extension.ExtensionHelper;
import com.kportal.servlet.ExtensionServlet;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.portail.core.FactoryAccess;
import com.univ.portail.core.PortalControlParameter;
import com.univ.portail.core.PortalEnvironment;
import com.univ.portail.core.PortletContainerFactory;
import com.univ.portail.core.SessionStatefullParameter;
import com.univ.portail.om.window.impl.PortletWindowImpl;
import com.univ.portail.service.ServiceManager;
import com.univ.portail.service.config.Config;
import com.univ.portail.service.factorymanager.FactoryManager;
import com.univ.portail.service.log.LogService;
import com.univ.portail.service.registry.PortletOccurenceRegistry;
import com.univ.portail.servlet.ServletObjectAccess;
import com.univ.portail.util.PortletHelper;
import com.univ.services.CacheServiceViewManager;
import com.univ.url.FrontOfficeMgr;
import com.univ.url.UrlManager;
import com.univ.utils.ContexteUniv;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.portalImpl.core.PortletContainerEnvironment;
import org.apache.pluto.services.ContainerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="servlet", urlPatterns={"/portal/*", "/privileged/*", "/secure/*"}, loadOnStartup=1)
public class Servlet
extends ExtensionServlet {
    private static final long serialVersionUID = -3967601594865921662L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Servlet.class);
    private static final String KPORTAL_CTX = "kportal.ctx";
    private static final String CHEMIN_JSP_PORTLET_MAX = "/WEB-INF/jsp/portal/fo/portlet_max.jsp";
    private static final String AFFICHAGE_UNITAIRE = "unitaire";
    private static String CONTENT_TYPE = "text/html";
    private static final String CONTAINER_SUPPORTS_BUFFERING = "portletcontainer.supportsBuffering";

    public String getServletInfo() {
        return "portalImpl - Pluto Driver";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String charset = config.getInitParameter("charset");
        if (charset != null && charset.length() > 0) {
            CONTENT_TYPE = "text/html; charset=" + charset;
        }
        try {
            ServiceManager.init(config);
        }
        catch (Exception exc) {
            LOGGER.error("Initialization failed!", (Throwable)exc);
            throw new UnavailableException("Initialization of one or more services failed.");
        }
        try {
            ServiceManager.postInit(config);
        }
        catch (Exception expos) {
            LOGGER.error("Post initialization failed!", (Throwable)expos);
            throw new UnavailableException("Post initialization of one or more services failed.");
        }
        try {
            PortletContainer pc = PortletContainerFactory.getPortletContainer();
            if (!pc.isInitialized()) {
                String uniqueContainerName = Config.getParameters().getString("portletcontainer.uniquename", "pluto");
                uniqueContainerName = uniqueContainerName + "_" + System.currentTimeMillis();
                LOGGER.info("Initializing PortletContainer [" + uniqueContainerName + "]...");
                PortletContainerEnvironment environment = new PortletContainerEnvironment();
                environment.addContainerService((ContainerService)LogService.getLogService());
                environment.addContainerService((ContainerService)FactoryManager.getService());
                environment.addContainerService((ContainerService)FactoryAccess.getInformationProviderContainerService());
                environment.addContainerService((ContainerService)FactoryAccess.getDynamicTitleContainerService());
                String allowSetBufferSizeString = Config.getParameters().getString(CONTAINER_SUPPORTS_BUFFERING);
                boolean allowSetBufferSize = false;
                if (allowSetBufferSizeString == null) {
                    LOGGER.warn("org.apache.pluto.portalImpl.Servlet#init(): Couldn't read property \"pluto.allowSetBufferSize\" from config file ConfigService.properties");
                } else {
                    allowSetBufferSize = allowSetBufferSizeString.equalsIgnoreCase("yes");
                }
                Properties containerProperties = new Properties();
                containerProperties.put(CONTAINER_SUPPORTS_BUFFERING, (Object)allowSetBufferSize);
                try {
                    pc.init(uniqueContainerName, config, (org.apache.pluto.services.PortletContainerEnvironment)environment, containerProperties);
                }
                catch (PortletContainerException exc) {
                    LOGGER.error("Initialization of the portlet container failed!", (Throwable)exc);
                    throw new UnavailableException("Initialization of the portlet container failed.");
                }
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info("PortletContainer already initialized");
            }
            LOGGER.debug("Ready to serve you.");
        }
        catch (Exception e) {
            LOGGER.warn("Initialization of the portlet container failed! file /WEB-INF/classes/portlet.properties is missing");
        }
    }

    public void destroy() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Shutting down portlet container. . .");
        }
        try {
            PortletContainerFactory.getPortletContainer().shutdown();
            ServiceManager.destroy(this.getServletConfig());
        }
        catch (PortletContainerException t) {
            LOGGER.error("Destruction failed!", (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException, ServletException {
        servletResponse.setContentType(CONTENT_TYPE);
        PortalEnvironment env = new PortalEnvironment(servletRequest, servletResponse);
        PortalControlParameter control = env.getPortalControlParameter();
        PortletWindow actionWindow = control.getPortletWindowOfAction();
        ContextePage ctx = null;
        CacheServiceViewManager cacheServiceMgr = (CacheServiceViewManager)ApplicationContextManager.getCoreContextBean("cacheServiceViewManager");
        try {
            ctx = ContexteUniv.initContexteUniv(servletRequest, servletResponse, this.getServletContext(), this.getServletConfig());
            if (actionWindow != null) {
                try {
                    HttpServletRequest request = ServletObjectAccess.getServletRequest(servletRequest, actionWindow);
                    request.setAttribute(KPORTAL_CTX, (Object)ctx);
                    HttpServletResponse response = ServletObjectAccess.getServletResponse(servletResponse);
                    PortletContainerFactory.getPortletContainer().processPortletAction(actionWindow, request, response);
                    cacheServiceMgr.flushView(((ContexteUniv)ctx).getKsession() + "@" + actionWindow.getPortletEntity().getId() + "@" + actionWindow.getId());
                    LOGGER.debug("invalidation cache portlet : " + actionWindow.getPortletEntity().getId().toString());
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
                return;
            }
            String idPortlet = control.getPIDValue();
            if (idPortlet != null && idPortlet.length() > 0) {
                PortletWindowImpl portletWindow = new PortletWindowImpl(idPortlet);
                WindowState stateCourant = control.getState(portletWindow);
                PortletMode modeCourant = control.getMode(portletWindow);
                PortletMode modePrecedent = control.getPrevMode(portletWindow);
                if (!stateCourant.equals((Object)WindowState.NORMAL) || modePrecedent != null && !modePrecedent.equals((Object)modeCourant)) {
                    if (idPortlet.contains("_occ")) {
                        idPortlet = idPortlet.substring(0, idPortlet.indexOf("_occ"));
                    }
                    cacheServiceMgr.flushView(((ContexteUniv)ctx).getKsession() + "@" + idPortlet + "@" + portletWindow.getId());
                    LOGGER.debug("Invalidation cache portlet : " + idPortlet);
                }
            }
            String typeVueService = servletRequest.getParameter("AFFICHAGE");
            String code = "";
            boolean isMaximized = control.isOnePortletWindowMaximized();
            if (AFFICHAGE_UNITAIRE.equals(typeVueService)) {
                code = servletRequest.getParameter("CODE_SERVICE");
            } else if (isMaximized) {
                code = control.getIdPortletMaximized();
            }
            SessionStatefullParameter.saveIntoSession(servletRequest, control.getPIDValue(), control);
            if (isMaximized || AFFICHAGE_UNITAIRE.equals(typeVueService) && code != null && !"".equals(code)) {
                servletRequest.setAttribute("fragment", (Object)PortletOccurenceRegistry.getOccurence(code));
                String forward = ExtensionHelper.getTemplateExtension("core", CHEMIN_JSP_PORTLET_MAX, true);
                RequestDispatcher rd = this.getServletConfig().getServletContext().getRequestDispatcher(forward);
                rd.forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            } else {
                servletRequest.setAttribute("PID", (Object)control.getPIDValue());
                PortletWindowImpl portletWindow = new PortletWindowImpl(control.getPIDValue());
                String urlPageLibre = UrlManager.calculerUrlPage(control.getKportalParamValues(portletWindow, "ID_META")[0]);
                if (control.getKportalParamValues(portletWindow, "RH") != null) {
                    ((ContexteUniv)ctx).setCodeRubriquePageCourante(control.getKportalParamValues(portletWindow, "RH")[0]);
                }
                FicheUniv ficheCourante = FrontOfficeMgr.lireFiche((ContexteUniv)ctx, urlPageLibre, new HashMap<String, String[]>());
                String forward = ObjetPartageHelper.getTemplateObjet("fiche", ReferentielObjets.getNomObjet(ficheCourante));
                RequestDispatcher rd = this.getServletConfig().getServletContext().getRequestDispatcher(forward);
                rd.forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (ctx != null) {
                ctx.release();
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    @Override
    public boolean isActive() {
        return PortletHelper.isPortletActivated();
    }
}

