/*
 * Decompiled with CFR 0.152.
 */
package com.univ.portail.core;

import com.univ.portail.core.PortalEnvironment;
import com.univ.portail.core.PortletActionProviderImpl;
import com.univ.portail.core.PortletURLProviderImpl;
import com.univ.portail.core.ResourceURLProviderImpl;
import com.univ.portail.service.config.Config;
import java.util.HashSet;
import java.util.Iterator;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.information.DynamicInformationProvider;
import org.apache.pluto.services.information.PortletActionProvider;
import org.apache.pluto.services.information.PortletURLProvider;
import org.apache.pluto.services.information.ResourceURLProvider;

public class DynamicInformationProviderImpl
implements DynamicInformationProvider {
    private static final int NumberOfKnownMimetypes = 15;
    private ServletConfig config;
    private PortalEnvironment env;
    HttpServletRequest request;

    public DynamicInformationProviderImpl(HttpServletRequest request, ServletConfig config) {
        this.request = request;
        this.config = config;
        this.env = PortalEnvironment.getPortalEnvironment(request);
    }

    public PortletMode getPortletMode(PortletWindow portletWindow) {
        return this.env.getPortalControlParameter().getMode(portletWindow);
    }

    public PortletURLProvider getPortletURLProvider(PortletWindow portletWindow) {
        return new PortletURLProviderImpl(this, portletWindow);
    }

    public ResourceURLProvider getResourceURLProvider(PortletWindow portletWindow) {
        return new ResourceURLProviderImpl(this, portletWindow);
    }

    public PortletActionProvider getPortletActionProvider(PortletWindow portletWindow) {
        return new PortletActionProviderImpl(this.request, this.config, portletWindow);
    }

    public PortletMode getPreviousPortletMode(PortletWindow portletWindow) {
        return this.env.getPortalControlParameter().getPrevMode(portletWindow);
    }

    public WindowState getPreviousWindowState(PortletWindow portletWindow) {
        return this.env.getPortalControlParameter().getPrevState(portletWindow);
    }

    public String getResponseContentType() {
        return "text/html";
    }

    public Iterator<String> getResponseContentTypes() {
        HashSet<String> responseMimeTypes = new HashSet<String>(15);
        responseMimeTypes.add("text/html");
        return responseMimeTypes.iterator();
    }

    public WindowState getWindowState(PortletWindow portletWindow) {
        return this.env.getPortalControlParameter().getState(portletWindow);
    }

    public boolean isPortletModeAllowed(PortletMode mode) {
        String[] supportedModes;
        for (String supportedMode : supportedModes = Config.getParameters().getStrings("supported.portletmode")) {
            if (!supportedMode.equalsIgnoreCase(mode.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean isWindowStateAllowed(WindowState state) {
        String[] supportedStates;
        for (String supportedState : supportedStates = Config.getParameters().getStrings("supported.windowstate")) {
            if (!supportedState.equalsIgnoreCase(state.toString())) continue;
            return true;
        }
        return false;
    }
}

