/*
 * Decompiled with CFR 0.152.
 */
package com.univ.portail.core;

import com.univ.portail.service.config.Config;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.pluto.services.information.PortalContextProvider;

public class PortalContextProviderImpl
implements PortalContextProvider {
    private String info = null;
    private Vector<PortletMode> modes;
    private Vector<WindowState> states;
    private final HashMap<String, String> properties = new HashMap();

    public PortalContextProviderImpl() {
        this.modes = this.getDefaultModes();
        this.states = this.getDefaultStates();
        this.info = Config.getParameters().getString("portaldriver.info");
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }
        return this.properties.get(name);
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Collection<PortletMode> getSupportedPortletModes() {
        return this.modes;
    }

    public Collection<WindowState> getSupportedWindowStates() {
        return this.states;
    }

    public String getPortalInfo() {
        return this.info;
    }

    private Vector<PortletMode> getDefaultModes() {
        String[] supportedModes;
        Vector<PortletMode> m = new Vector<PortletMode>();
        for (String supportedMode : supportedModes = Config.getParameters().getStrings("supported.portletmode")) {
            m.add(new PortletMode(supportedMode.toString().toLowerCase()));
        }
        return m;
    }

    private Vector<WindowState> getDefaultStates() {
        String[] supportedStates;
        Vector<WindowState> s = new Vector<WindowState>();
        for (String supportedState : supportedStates = Config.getParameters().getStrings("supported.windowstate")) {
            s.add(new WindowState(supportedState.toString().toLowerCase()));
        }
        return s;
    }

    public void setProperty(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }
        this.properties.put(name, value);
    }

    public void setSupportedPortletModes(Enumeration<PortletMode> portletModes) {
        Vector<PortletMode> v = new Vector<PortletMode>();
        while (portletModes.hasMoreElements()) {
            v.add(portletModes.nextElement());
        }
        this.modes = v;
    }

    public void setSupportedWindowStates(Enumeration<WindowState> windowStates) {
        Vector<WindowState> v = new Vector<WindowState>();
        while (windowStates.hasMoreElements()) {
            v.add(windowStates.nextElement());
        }
        this.states = v;
    }

    public void reset(String portalInfo) {
        this.info = new String(portalInfo);
        this.modes = this.getDefaultModes();
        this.states = this.getDefaultStates();
        this.properties.clear();
    }
}

