/*
 * Decompiled with CFR 0.152.
 */
package com.univ.portail.core;

import com.univ.portail.KportalPortletFragment;
import com.univ.portail.core.PortalURL;
import com.univ.portail.service.registry.PortletOccurenceRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.util.StringUtils;

public class PortalControlParameter {
    public static final String ACTION = "ac";
    public static final String MODE = "md";
    public static final String PORTLET_ID = "pid";
    public static final String PREFIX = "_";
    public static final String PREV_MODE = "pm";
    public static final String PREV_STATE = "ps";
    public static final String RENDER_PARAM = "rp";
    public static final String STATE = "st";
    public static final String KPORTAL_PARAM = "kp";
    private final Map<String, String[]> requestParameter = new HashMap<String, String[]>();
    private Map<String, Object> stateFullControlParameter = null;
    private Map<String, Object> stateLessControlParameter = null;
    private final PortalURL url;

    public static String decodeParameterName(String paramName) {
        return paramName.substring(PREFIX.length());
    }

    public static String decodeParameterValue(String paramName, String paramValue) {
        return paramValue;
    }

    private static String[] decodeRenderParamValues(String encodedParamValues) {
        StringTokenizer tokenizer = new StringTokenizer(encodedParamValues, PREFIX);
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        String _count = tokenizer.nextToken();
        int count = Integer.valueOf(_count);
        String[] values = new String[count];
        for (int i = 0; i < count; ++i) {
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            values[i] = PortalControlParameter.decodeValue(tokenizer.nextToken());
        }
        return values;
    }

    private static String decodeValue(String value) {
        value = StringUtils.replace((String)value, (String)"0x1", (String)PREFIX);
        value = StringUtils.replace((String)value, (String)"0x2", (String)".");
        value = StringUtils.replace((String)value, (String)"0x3", (String)"/");
        value = StringUtils.replace((String)value, (String)"0x4", (String)"\r");
        value = StringUtils.replace((String)value, (String)"0x5", (String)"\n");
        value = StringUtils.replace((String)value, (String)"0x6", (String)"<");
        value = StringUtils.replace((String)value, (String)"0x7", (String)">");
        value = StringUtils.replace((String)value, (String)"0x8", (String)" ");
        value = StringUtils.replace((String)value, (String)"0x9", (String)"?");
        return value;
    }

    public static String encodeParameter(String param) {
        return PREFIX + param;
    }

    public static String encodeRenderParamName(PortletWindow window, String paramName) {
        StringBuffer returnvalue = new StringBuffer(50);
        returnvalue.append(RENDER_PARAM);
        returnvalue.append(PREFIX);
        returnvalue.append(window.getId().toString());
        returnvalue.append(PREFIX);
        returnvalue.append(paramName);
        return returnvalue.toString();
    }

    public static String encodeKportalParamName(PortletWindow window, String paramName) {
        StringBuffer returnvalue = new StringBuffer(50);
        returnvalue.append(KPORTAL_PARAM);
        returnvalue.append(PREFIX);
        returnvalue.append(window.getId().toString());
        returnvalue.append(PREFIX);
        returnvalue.append(paramName);
        return returnvalue.toString();
    }

    public static String encodeRenderParamValues(String[] paramValues) {
        StringBuffer returnvalue = new StringBuffer(100);
        returnvalue.append(paramValues.length);
        for (String paramValue : paramValues) {
            returnvalue.append(PREFIX);
            if (paramValue == null) continue;
            returnvalue.append(PortalControlParameter.encodeValue(paramValue));
        }
        return returnvalue.toString();
    }

    private static String encodeValue(String value) {
        value = StringUtils.replace((String)value, (String)PREFIX, (String)"0x1");
        value = StringUtils.replace((String)value, (String)".", (String)"0x2");
        value = StringUtils.replace((String)value, (String)"/", (String)"0x3");
        value = StringUtils.replace((String)value, (String)"\r", (String)"0x4");
        value = StringUtils.replace((String)value, (String)"\n", (String)"0x5");
        value = StringUtils.replace((String)value, (String)"<", (String)"0x6");
        value = StringUtils.replace((String)value, (String)">", (String)"0x7");
        value = StringUtils.replace((String)value, (String)" ", (String)"0x8");
        value = StringUtils.replace((String)value, (String)"?", (String)"0x9");
        return value;
    }

    public static String getRenderParamKey(PortletWindow window) {
        return "rp_" + window.getId().toString();
    }

    public static String getKportalParamKey(PortletWindow window) {
        return "kp_" + window.getId().toString();
    }

    public static boolean isControlParameter(String param) {
        return param.startsWith(PREFIX);
    }

    public static boolean isStateFullParameter(String param) {
        return PortalControlParameter.isControlParameter(param) && (param.startsWith("_md") || param.startsWith("_pm") || param.startsWith("_st") || param.startsWith("_ps") || param.startsWith("_rp") || param.startsWith("_kp"));
    }

    public PortalControlParameter(PortalURL url) {
        this.url = url;
        this.stateFullControlParameter = this.url.getClonedStateFullControlParameter();
        this.stateLessControlParameter = this.url.getClonedStateLessControlParameter();
        if (url.getUrlParameter("AFFICHAGE") != null && url.getUrlParameter("CODE_SERVICE") != null) {
            this.requestParameter.put("AFFICHAGE", new String[]{url.getUrlParameter("AFFICHAGE")});
            this.requestParameter.put("CODE_SERVICE", new String[]{url.getUrlParameter("CODE_SERVICE")});
        }
    }

    public void clearRenderParameters(PortletWindow portletWindow) {
        String prefix = PortalControlParameter.getRenderParamKey(portletWindow);
        Iterator<String> keyIterator = this.stateFullControlParameter.keySet().iterator();
        while (keyIterator.hasNext()) {
            String name = keyIterator.next();
            if (!name.startsWith(prefix)) continue;
            keyIterator.remove();
        }
    }

    private String getActionKey(PortletWindow window) {
        return "ac_" + window.getId().toString();
    }

    public String[] getActionParameter(PortletWindow window, String paramName) {
        String encodedValues = (String)this.stateFullControlParameter.get(PortalControlParameter.encodeRenderParamName(window, paramName));
        String[] values = PortalControlParameter.decodeRenderParamValues(encodedValues);
        return values;
    }

    public PortletMode getMode(PortletWindow window) {
        String mode = (String)this.stateFullControlParameter.get(this.getModeKey(window));
        PortletMode modeRetour = PortletMode.VIEW;
        if (mode != null) {
            modeRetour = new PortletMode(mode);
        }
        return modeRetour;
    }

    private String getModeKey(PortletWindow window) {
        return "md_" + window.getId().toString();
    }

    public String getPIDValue() {
        String value = (String)this.stateLessControlParameter.get(this.getPortletIdKey());
        return value == null ? "" : value;
    }

    private String getPortletIdKey() {
        return PORTLET_ID;
    }

    public PortletWindow getPortletWindowOfAction() {
        for (String name : this.getStateLessControlParameter().keySet()) {
            if (!name.startsWith(ACTION)) continue;
            String id = name.substring(ACTION.length() + 1);
            KportalPortletFragment fragment = PortletOccurenceRegistry.getOccurence(id);
            PortletWindow window = null;
            if (fragment != null) {
                window = fragment.getPortletWindow();
            }
            return window;
        }
        return null;
    }

    public PortletMode getPrevMode(PortletWindow window) {
        String mode = (String)this.stateFullControlParameter.get(this.getPrevModeKey(window));
        if (mode != null) {
            return new PortletMode(mode);
        }
        return null;
    }

    private String getPrevModeKey(PortletWindow window) {
        return "pm_" + window.getId().toString();
    }

    public WindowState getPrevState(PortletWindow window) {
        String state = (String)this.stateFullControlParameter.get(this.getPrevStateKey(window));
        if (state != null) {
            return new WindowState(state);
        }
        return null;
    }

    private String getPrevStateKey(PortletWindow window) {
        return "ps_" + window.getId().toString();
    }

    public Iterator<String> getRenderParamNames(PortletWindow window) {
        ArrayList<String> returnvalue = new ArrayList<String>();
        String prefix = PortalControlParameter.getRenderParamKey(window);
        for (String name : this.stateFullControlParameter.keySet()) {
            if (!name.startsWith(prefix)) continue;
            returnvalue.add(name.substring(prefix.length() + 1));
        }
        return returnvalue.iterator();
    }

    public String[] getKportalParamValues(PortletWindow window, String paramName) {
        String encodedValues = (String)this.stateFullControlParameter.get(PortalControlParameter.encodeKportalParamName(window, paramName));
        if (encodedValues == null) {
            return null;
        }
        String[] values = PortalControlParameter.decodeRenderParamValues(encodedValues);
        return values;
    }

    public Iterator<String> getKportalParamNames(PortletWindow window) {
        ArrayList<String> returnvalue = new ArrayList<String>();
        String prefix = PortalControlParameter.getKportalParamKey(window);
        for (String name : this.stateFullControlParameter.keySet()) {
            if (!name.startsWith(prefix)) continue;
            returnvalue.add(name.substring(prefix.length() + 1));
        }
        return returnvalue.iterator();
    }

    public String[] getRenderParamValues(PortletWindow window, String paramName) {
        String encodedValues = (String)this.stateFullControlParameter.get(PortalControlParameter.encodeRenderParamName(window, paramName));
        String[] values = PortalControlParameter.decodeRenderParamValues(encodedValues);
        return values;
    }

    public Map<String, String[]> getRequestParameter() {
        return this.requestParameter;
    }

    public WindowState getState(PortletWindow window) {
        String state = (String)this.stateFullControlParameter.get(this.getStateKey(window));
        if (state != null) {
            return new WindowState(state);
        }
        return WindowState.NORMAL;
    }

    public Map<String, Object> getStateFullControlParameter() {
        return this.stateFullControlParameter;
    }

    private String getStateKey(PortletWindow window) {
        return "st_" + window.getId().toString();
    }

    public Map<String, Object> getStateLessControlParameter() {
        return this.stateLessControlParameter;
    }

    public boolean isOnePortletWindowMaximized() {
        for (String name : this.stateFullControlParameter.keySet()) {
            if (!name.startsWith(STATE) || !this.stateFullControlParameter.get(name).equals(WindowState.MAXIMIZED.toString())) continue;
            return true;
        }
        return false;
    }

    public void setAction(PortletWindow window) {
        this.getStateFullControlParameter().put(this.getActionKey(window), ACTION.toUpperCase());
    }

    public void setMode(PortletWindow window, PortletMode mode) {
        Object prevMode = this.stateFullControlParameter.get(this.getModeKey(window));
        if (prevMode != null) {
            this.stateFullControlParameter.put(this.getPrevModeKey(window), prevMode);
        }
        this.stateFullControlParameter.put(this.getModeKey(window), mode.toString());
    }

    public void setPortletId(PortletWindow window) {
        this.getStateFullControlParameter().put(this.getPortletIdKey(), window.getId().toString());
    }

    public void setRenderParam(PortletWindow window, String name, String[] values) {
        this.stateFullControlParameter.put(PortalControlParameter.encodeRenderParamName(window, name), PortalControlParameter.encodeRenderParamValues(values));
    }

    public void setKportalParam(PortletWindow window, String name, String[] values) {
        this.stateFullControlParameter.put(PortalControlParameter.encodeKportalParamName(window, name), PortalControlParameter.encodeRenderParamValues(values));
    }

    public void setRequestParam(String name, String[] values) {
        this.requestParameter.put(name, values);
    }

    public void setState(PortletWindow window, WindowState state) {
        Object prevState = this.stateFullControlParameter.get(this.getStateKey(window));
        if (prevState != null) {
            this.stateFullControlParameter.put(this.getPrevStateKey(window), prevState);
        }
        this.stateFullControlParameter.put(this.getStateKey(window), state.toString());
    }

    public String getIdPortletMaximized() {
        String code = "";
        for (String name : this.getStateFullControlParameter().keySet()) {
            if (!name.startsWith(STATE) || !this.getStateFullControlParameter().get(name).equals(WindowState.MAXIMIZED.toString())) continue;
            code = name.substring("st_".length());
        }
        return code;
    }
}

