/*
 * Decompiled with CFR 0.152.
 */
package com.univ.portail.core;

import com.univ.portail.KportalPortletFragment;
import com.univ.portail.core.PortalControlParameter;
import com.univ.portail.core.PortalEnvironment;
import com.univ.portail.service.config.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.pluto.om.window.PortletWindow;

public class PortalURL {
    private static final String insecureServlet = Config.getParameters().getString("servlet.insecure");
    private static final String secureServlet = Config.getParameters().getString("servlet.secure");
    private List<String> startGlobalNavigation = new ArrayList<String>();
    private List<String> startLocalNavigation = new ArrayList<String>();
    private HashMap<String, Object> startStateFullControlParameter = new HashMap();
    private HashMap<String, Object> startStateLessControlParameter = new HashMap();
    private boolean analyzed = false;
    private PortalEnvironment environment;
    private Map<String, ?> sessionStateFullsParameters = null;

    public String getBasePortalURL(HttpServletRequest request) {
        return this.getBasePortalURL(PortalEnvironment.getPortalEnvironment(request));
    }

    public String getBasePortalURL(PortalEnvironment env) {
        StringBuffer result = new StringBuffer(256);
        result.append(env.getRequest().getContextPath());
        result.append(env.getRequest().getServletPath());
        return result.toString();
    }

    public PortalURL(PortalEnvironment env) {
        this.environment = env;
    }

    public void setEnv(PortalEnvironment env) {
        this.environment = env;
    }

    public String getUrlParameter(String cle) {
        return this.environment.getRequest().getParameter(cle);
    }

    public PortalURL(HttpServletRequest request) {
        this(PortalEnvironment.getPortalEnvironment(request));
    }

    public PortalURL(HttpServletRequest request, KportalPortletFragment pointTo) {
        this(request);
        pointTo.createURL(this);
    }

    public PortalURL(PortalEnvironment env, KportalPortletFragment pointTo) {
        this(env);
        pointTo.createURL(this);
    }

    public void addGlobalNavigation(String nav) {
        this.startGlobalNavigation.add(nav);
    }

    public void setLocalNavigation() {
        this.startLocalNavigation = new ArrayList<String>();
    }

    public void addLocalNavigation(String nav) {
        this.startLocalNavigation.add(nav);
    }

    public boolean isPartOfGlobalNavigation(String nav) {
        return this.startGlobalNavigation.contains(nav);
    }

    public boolean isPartOfLocalNavigation(String nav) {
        return this.startLocalNavigation.contains(nav);
    }

    public String getGlobalNavigationAsString() {
        StringBuffer result = new StringBuffer(200);
        Iterator<String> iterator = this.startGlobalNavigation.iterator();
        if (iterator.hasNext()) {
            result.append(iterator.next());
            while (iterator.hasNext()) {
                result.append("/");
                String st = iterator.next();
                result.append(st);
            }
        }
        return result.toString();
    }

    public String getLocalNavigationAsString() {
        StringBuffer result = new StringBuffer(30);
        Iterator<String> iterator = this.startLocalNavigation.iterator();
        if (iterator.hasNext()) {
            result.append(iterator.next());
            while (iterator.hasNext()) {
                result.append(".");
                result.append(iterator.next());
            }
        }
        return result.toString();
    }

    public String getControlParameterAsString(PortalControlParameter controlParam) {
        Map<String, Object> stateFullParams = this.startStateFullControlParameter;
        if (controlParam != null) {
            stateFullParams = controlParam.getStateFullControlParameter();
        }
        StringBuffer result = new StringBuffer(100);
        Iterator<String> iterator = stateFullParams.keySet().iterator();
        while (iterator.hasNext()) {
            String name;
            String value;
            if (iterator.hasNext()) {
                result.append("/");
            }
            if ((value = (String)stateFullParams.get(name = iterator.next())) == null) continue;
            result.append(PortalControlParameter.encodeParameter(name));
            result.append("/");
            result.append(value);
        }
        return result.toString();
    }

    public String getRequestParameterAsString(PortalControlParameter controlParam) {
        if (controlParam != null) {
            Map<String, String[]> requestParams = controlParam.getRequestParameter();
            StringBuffer result = new StringBuffer(100);
            Iterator<String> iterator = requestParams.keySet().iterator();
            boolean hasNext = iterator.hasNext();
            if (hasNext) {
                result.append("?");
            }
            while (hasNext) {
                String[] stringArray;
                String name = iterator.next();
                String[] value = requestParams.get(name);
                if (value instanceof String) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = (String)value;
                } else {
                    stringArray = value;
                }
                String[] values = stringArray;
                result.append(name);
                result.append("=");
                result.append(values[0]);
                for (int i = 1; i < values.length; ++i) {
                    result.append("&");
                    result.append(name);
                    result.append("=");
                    result.append(values[i]);
                }
                hasNext = iterator.hasNext();
                if (!hasNext) continue;
                result.append("&");
            }
            return result.toString();
        }
        return "";
    }

    public String toString() {
        return this.toString(null, null);
    }

    public String toString(PortalControlParameter controlParam, Boolean p_secure) {
        String local;
        String requestParam;
        String control;
        StringBuffer urlBase = new StringBuffer(256);
        boolean secure = false;
        secure = p_secure != null ? p_secure.booleanValue() : this.environment.getRequest().isSecure();
        urlBase.append(this.environment.getRequest().getContextPath());
        urlBase.append(secure ? secureServlet : insecureServlet);
        String url = urlBase.toString();
        String global = this.getGlobalNavigationAsString();
        if (global.length() > 0) {
            url = url + "/";
            url = url + global;
        }
        if ((control = this.getControlParameterAsString(controlParam)).length() > 0) {
            control = control.replaceAll("\\+", "%20");
            url = url + control;
        }
        if ((requestParam = this.getRequestParameterAsString(controlParam)).length() > 0) {
            url = url + requestParam;
        }
        if ((local = this.getLocalNavigationAsString()).length() > 0) {
            url = url + "#";
            url = url + local;
        }
        return url;
    }

    Map<String, Object> getClonedStateFullControlParameter() {
        this.analyzeRequestInformation();
        return (Map)this.startStateFullControlParameter.clone();
    }

    Map<String, Object> getClonedStateLessControlParameter() {
        this.analyzeRequestInformation();
        return (Map)this.startStateLessControlParameter.clone();
    }

    void analyzeControlInformation(PortalControlParameter control) {
        this.startStateFullControlParameter = (HashMap)control.getStateFullControlParameter();
        this.startStateLessControlParameter = (HashMap)control.getStateLessControlParameter();
    }

    void analyzeRequestInformation() {
        if (this.analyzed) {
            return;
        }
        this.startGlobalNavigation = new ArrayList<String>();
        this.startLocalNavigation = new ArrayList<String>();
        this.startStateFullControlParameter = new HashMap();
        this.startStateLessControlParameter = new HashMap();
        if (this.environment.getRequest().getPathInfo() != null) {
            String pathInfo = this.environment.getRequest().getPathInfo();
            StringTokenizer tokenizer = new StringTokenizer(pathInfo, "/");
            boolean mode = false;
            String name = null;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (PortalControlParameter.isControlParameter(token)) {
                    mode = true;
                    name = token;
                    continue;
                }
                if (!mode) {
                    this.startGlobalNavigation.add(token);
                    continue;
                }
                if (!mode) continue;
                if (PortalControlParameter.isStateFullParameter(name)) {
                    this.startStateFullControlParameter.put(PortalControlParameter.decodeParameterName(name), PortalControlParameter.decodeParameterValue(name, token));
                } else {
                    this.startStateLessControlParameter.put(PortalControlParameter.decodeParameterName(name), PortalControlParameter.decodeParameterValue(name, token));
                }
                mode = false;
            }
        }
        if (this.sessionStateFullsParameters != null) {
            this.startStateFullControlParameter.clear();
            this.startStateFullControlParameter.putAll(this.sessionStateFullsParameters);
        }
        this.analyzed = true;
    }

    public void setRenderParameter(PortletWindow portletWindow, String name, String[] values) {
        this.startStateFullControlParameter.put(PortalControlParameter.encodeRenderParamName(portletWindow, name), PortalControlParameter.encodeRenderParamValues(values));
    }

    public void clearRenderParameters(PortletWindow portletWindow) {
        String prefix = PortalControlParameter.getRenderParamKey(portletWindow);
        Iterator<String> keyIterator = this.startStateFullControlParameter.keySet().iterator();
        while (keyIterator.hasNext()) {
            String name = keyIterator.next();
            if (!name.startsWith(prefix)) continue;
            keyIterator.remove();
        }
    }

    public void setSessionStatefullParameter(Map<String, ?> _sessionStatefullParam) {
        this.sessionStateFullsParameters = _sessionStatefullParam;
    }
}

