/*
 * Decompiled with CFR 0.152.
 */
package com.univ.portail.core.impl;

import com.univ.portail.om.user.UserPreference;
import com.univ.portail.util.PreferenceSetImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.apache.pluto.Constants;
import org.apache.pluto.om.ControllerObjectAccess;
import org.apache.pluto.om.Model;
import org.apache.pluto.om.common.Preference;
import org.apache.pluto.om.common.PreferenceCtrl;
import org.apache.pluto.om.common.PreferenceSet;
import org.apache.pluto.om.common.PreferenceSetCtrl;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.util.Enumerator;
import org.apache.pluto.util.StringUtils;

public class PortletPreferencesImpl
implements PortletPreferences {
    private final List<PreferenceSet> preferenceSetList = new LinkedList<PreferenceSet>();
    private final HashMap<String, String[]> changedPreferences = new HashMap();
    private final HashSet<String> removedPreferences = new HashSet();
    private Integer methodId = null;
    private PortletEntity portletEntity = null;
    private PortletDefinition portletDefinition = null;
    private UserPreference userPreference = null;

    public PortletPreferencesImpl(Integer methodId, PortletEntity portletEntity) {
        this.methodId = methodId;
        this.portletEntity = portletEntity;
        this.portletDefinition = portletEntity.getPortletDefinition();
        this.preferenceSetList.add(new PreferenceSetImpl());
        this.preferenceSetList.add(portletEntity.getPreferenceSet());
        this.preferenceSetList.add(this.portletDefinition.getPreferenceSet());
    }

    public PortletPreferencesImpl(Integer methodId, PortletDefinition portletDefinition) {
        this.methodId = methodId;
        this.portletDefinition = portletDefinition;
        this.preferenceSetList.add(new PreferenceSetImpl());
        this.preferenceSetList.add(portletDefinition.getPreferenceSet());
    }

    public boolean isReadOnly(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        boolean isReadOnly = false;
        if (this.preferenceSetList.size() != 2) {
            Preference preference = null;
            ListIterator<PreferenceSet> iter = this.preferenceSetList.listIterator();
            while (preference == null && iter.hasNext()) {
                preference = iter.next().get(key);
            }
            if (preference != null) {
                isReadOnly = preference.isReadOnly();
            }
        }
        return isReadOnly;
    }

    public String getValue(String key, String def) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        String[] defStr = new String[]{def};
        String[] values = this.getValues(key, defStr);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getValues(String key, String[] def) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        if (this.changedPreferences.containsKey(key)) {
            return StringUtils.copy((String[])this.changedPreferences.get(key));
        }
        ListIterator<PreferenceSet> iter = this.preferenceSetList.listIterator();
        if (this.removedPreferences.contains(key)) {
            iter.next();
        }
        Preference preference = null;
        while (preference == null && iter.hasNext()) {
            preference = iter.next().get(key);
        }
        if (preference == null || !preference.isValueSet()) {
            return def;
        }
        String[] result = this.getValuesFromPreference(preference);
        if (result != null) {
            result = StringUtils.copy((String[])result);
        }
        return result;
    }

    public void setValue(String key, String value) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        String[] values = new String[]{value};
        this.setValues(key, values);
    }

    public void setValues(String key, String[] values) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException("Preference attribute called " + key + " may not be modified");
        }
        this.changedPreferences.put(key, StringUtils.copy((String[])values));
        this.removedPreferences.remove(key);
    }

    public Enumeration<String> getNames() {
        String name;
        HashSet<String> keyset = new HashSet<String>();
        ListIterator<PreferenceSet> listIter = this.preferenceSetList.listIterator();
        Iterator<String> changedIter = this.changedPreferences.keySet().iterator();
        Iterator<String> removedIter = this.removedPreferences.iterator();
        while (changedIter.hasNext()) {
            keyset.add(changedIter.next());
        }
        Iterator preferencesIter = listIter.next().iterator();
        while (preferencesIter.hasNext()) {
            name = ((Preference)preferencesIter.next()).getName();
            keyset.add(name);
        }
        while (removedIter.hasNext()) {
            keyset.remove(removedIter.next());
        }
        while (listIter.hasNext()) {
            preferencesIter = listIter.next().iterator();
            while (preferencesIter.hasNext()) {
                name = ((Preference)preferencesIter.next()).getName();
                keyset.add(name);
            }
        }
        return new Enumerator(keyset.iterator());
    }

    public Map<String, String[]> getMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration<String> enumerator = this.getNames();
        while (enumerator.hasMoreElements()) {
            String name = enumerator.nextElement();
            map.put(name, this.getValues(name, null));
        }
        return map;
    }

    public void reset(String key) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException("preference attribute called " + key + " may not be modified");
        }
        this.changedPreferences.remove(key);
        this.removedPreferences.add(key);
    }

    public void setUserPreferences(UserPreference userPref) {
        this.userPreference = userPref;
    }

    public void store() throws IOException, ValidatorException {
        if (!this.methodId.equals(Constants.METHOD_ACTION)) {
            throw new IllegalStateException("store is only allowed inside a processAction call");
        }
        if (this.userPreference != null) {
            PreferencesValidator validator = this.portletDefinition.getPreferenceSet().getPreferencesValidator();
            if (validator != null) {
                validator.validate((PortletPreferences)this);
            }
            PreferenceSet preferences = this.preferenceSetList.get(0);
            PreferenceSetCtrl preferencesCtrl = (PreferenceSetCtrl)ControllerObjectAccess.get((Model)preferences);
            for (String key : this.changedPreferences.keySet()) {
                Preference preference;
                String[] values = this.changedPreferences.get(key);
                ArrayList<String> newValues = null;
                if (values != null) {
                    newValues = new ArrayList<String>(values.length);
                    for (String value : values) {
                        newValues.add(value);
                    }
                }
                if ((preference = preferences.get(key)) != null) {
                    PreferenceCtrl preferenceCtrl = (PreferenceCtrl)ControllerObjectAccess.get((Model)preference);
                    preferenceCtrl.setValues(newValues);
                    continue;
                }
                preferencesCtrl.add(key, newValues);
            }
            this.changedPreferences.clear();
            for (String key : this.removedPreferences) {
                preferencesCtrl.remove(key);
            }
            this.removedPreferences.clear();
            this.userPreference.store(preferences, this.portletEntity.getId().toString());
        }
    }

    public void setUserValues(String key, List values) {
        PreferenceSetImpl userPrefSet = (PreferenceSetImpl)this.preferenceSetList.get(0);
        userPrefSet.addUserPreferencesValues(key, values);
    }

    private String[] getValuesFromPreference(Preference preference) {
        if (preference == null) {
            return null;
        }
        Iterator values = preference.getValues();
        if (values == null) {
            return null;
        }
        if (!values.hasNext()) {
            return new String[0];
        }
        ArrayList newValues = new ArrayList();
        while (values.hasNext()) {
            newValues.add(values.next());
        }
        return newValues.toArray(new String[newValues.size()]);
    }
}

