/*
 * Decompiled with CFR 0.152.
 */
package com.univ.portail.deploiment;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.pluto.portlet.admin.PlutoAdminException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deploy {
    private static Logger LOG = LoggerFactory.getLogger(Deploy.class);
    private static boolean debug = false;
    private static String dirDelim = System.getProperty("file.separator");
    private static String webAppsDir;
    private static String portalImplWebDir;
    private static String plutoHome;

    public static void deployArchive(String webAppsDir, String warFile) throws IOException {
        String warFileName = warFile;
        if (warFileName.indexOf("/") != -1) {
            warFileName = warFileName.substring(warFileName.lastIndexOf("/") + 1);
        }
        if (warFileName.indexOf(dirDelim) != -1) {
            warFileName = warFileName.substring(warFileName.lastIndexOf(dirDelim) + 1);
        }
        if (warFileName.endsWith(".war")) {
            warFileName = warFileName.substring(0, warFileName.lastIndexOf("."));
        }
        LOG.info("deploying '" + warFileName + "' ...");
        String destination = webAppsDir + warFileName;
        JarFile jarFile = new JarFile(warFile);
        Enumeration<JarEntry> files = jarFile.entries();
        while (files.hasMoreElements()) {
            JarEntry entry = files.nextElement();
            String fileName = entry.getName();
            if (!entry.isDirectory() && entry.getName().endsWith(".jsp")) {
                InputStream is = jarFile.getInputStream(entry);
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                StreamTokenizer st = new StreamTokenizer(r);
                st.quoteChar(39);
                st.quoteChar(34);
                while (st.nextToken() != -1) {
                    if (st.ttype != 39 && st.ttype != 34) continue;
                    String sval = st.sval;
                    String sqc = Character.toString((char)st.ttype);
                    if (!sval.equals("/WEB-INF/tld/portlet.tld")) continue;
                    LOG.warn("Warning: " + sqc + st.sval + sqc + " has been found in file " + fileName + ". Use instead " + sqc + "http://java.sun.com/portlet" + sqc + " with your portlet taglib declaration!\n");
                    break;
                }
            }
            File file = new File(destination, fileName);
            File dirF = new File(file.getParent());
            dirF.mkdirs();
            if (entry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            byte[] buffer = new byte[1024];
            int length = 0;
            InputStream fis = jarFile.getInputStream(entry);
            FileOutputStream fos = new FileOutputStream(file);
            while ((length = fis.read(buffer)) >= 0) {
                fos.write(buffer, 0, length);
            }
            fos.close();
        }
        jarFile.close();
        System.out.println("finished!");
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("No argument specified. This command must be issued as:");
            System.out.println("deploy <TOMCAT-webapps-directory> <web-archive>");
            return;
        }
        if (args.length > 4 && (args[4].equals("-debug") || args[4].equals("/debug"))) {
            debug = true;
        }
        if (debug) {
            for (int i = 0; i < args.length; ++i) {
                System.out.println("args[" + i + "]:" + args[i]);
            }
        }
        if (!(webAppsDir = args[0]).endsWith(dirDelim)) {
            webAppsDir = webAppsDir + dirDelim;
        }
        if (!(portalImplWebDir = args[1]).endsWith(dirDelim)) {
            portalImplWebDir = portalImplWebDir + dirDelim;
        }
        String warFile = args[2];
        plutoHome = args[3];
        if (!plutoHome.endsWith(dirDelim)) {
            plutoHome = plutoHome + dirDelim;
        }
        try {
            Deploy.deployArchive(plutoHome, warFile);
        }
        catch (PlutoAdminException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Error found in Deploy.main()", (Throwable)e);
            throw new PlutoAdminException("Error found in Deploy.main()", (Throwable)e);
        }
    }
}

