/*
 * Decompiled with CFR 0.152.
 */
package com.univ.portail.deploiment;

import com.jsbsoft.jtf.exception.ErreurTechnique;
import com.univ.portail.deploiment.Deploy;
import com.univ.portail.deploiment.util.PlutoAdminContext;
import com.univ.portail.service.registry.PortletEntityRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.PortletDiskFileUpload;
import org.apache.commons.fileupload.PortletFileUploadBase;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.portlet.admin.BaseAdminObject;
import org.apache.pluto.portlet.admin.PlutoAdminConstants;
import org.apache.pluto.portlet.admin.PlutoAdminException;
import org.apache.pluto.portlet.admin.bean.PortletMessage;
import org.apache.pluto.portlet.admin.bean.PortletMessageType;
import org.apache.pluto.portlet.admin.services.PortletConfigService;
import org.apache.pluto.portlet.admin.services.PortletNameFinder;

public class DeployWarService
extends BaseAdminObject {
    public static final String ERROR_NO_FILE = "ERROR_NO_FILE";
    public static final String CLASS_NAME = "DeployWarService";

    public DeployWarService() {
        super(CLASS_NAME);
    }

    public DeployWarService(String logId) {
        super(CLASS_NAME, logId);
    }

    public String processFileUpload(ActionRequest request, ActionResponse response) {
        String METHOD_NAME = "processFileUpload(request,response)";
        String fileName = null;
        String serverFileName = null;
        boolean modifyWebXml = true;
        request.getPortletSession().setAttribute("message", (Object)new PortletMessage("Deployment unsuccessful", PortletMessageType.ERROR));
        if (PortletFileUploadBase.isMultipartContent((ActionRequest)request)) {
            PortletDiskFileUpload dfu = new PortletDiskFileUpload();
            dfu.setSizeMax(10000000L);
            dfu.setSizeThreshold(100000);
            try {
                List fileItems = dfu.parseRequest(request);
                for (FileItem item : fileItems) {
                    if (item.isFormField()) {
                        String fieldName = item.getFieldName();
                        String value = item.getString();
                        response.setRenderParameter(fieldName, value);
                        if (!fieldName.equalsIgnoreCase("NoWebXmlModification")) continue;
                        String noWebXmlModification = item.getString();
                        this.logWarn("processFileUpload(request,response)", "Don't modify web.xml? " + noWebXmlModification);
                        if (noWebXmlModification == null) continue;
                        modifyWebXml = false;
                        continue;
                    }
                    fileName = item.getName();
                    String contentType = item.getContentType();
                    long size = item.getSize();
                    response.setRenderParameter("size", Long.toString(size));
                    response.setRenderParameter("contentType", contentType);
                    String tempDir = System.getProperty("java.io.tmpdir");
                    serverFileName = this.getRootFilename(File.separatorChar, fileName);
                    File serverFile = new File(tempDir, serverFileName);
                    item.write(serverFile);
                    response.setRenderParameter("serverFileName", serverFileName);
                    int index = serverFileName.indexOf(".war");
                    String context = "";
                    context = index != -1 ? serverFileName.substring(0, index) : serverFileName;
                    boolean appExists = PortletEntityRegistry.getPortletEntity(context) != null;
                    ArrayList<String> argList = this.createDeploymentArgs(serverFileName, tempDir, request, appExists, context);
                    this.logDebug("processFileUpload(request,response)", "Arguments for Deploy.main():");
                    String[] args = DeployWarService.arrayListToStringArray(argList);
                    for (int i = 0; i < args.length; ++i) {
                        this.logDebug("processFileUpload(request,response)", "args[" + i + "]=" + args[i]);
                    }
                    Deploy.main(args);
                    if (modifyWebXml) {
                        this.updateWebXml(context);
                    }
                    if (appExists) {
                        request.getPortletSession().setAttribute("message", (Object)new PortletMessage("Deployment of the new portlet app has been successful, but the portlet app record '" + context + "' already exists in portletentityregistry.xml. This may have occurred if the portlet was previously partially deployed. If that is the case, continue with this screen and the next to register the portlet in pageregistry.xml. If you are deploying a previously deployed portlet app, click on the 'Deploy War home' link below and then the 'Hot deploy . . .' link on the resulting page to see your redeployed portlet. However, caching of the old app may require that you restart Pluto to see the new changes.", PortletMessageType.INFO));
                        continue;
                    }
                    request.getPortletSession().setAttribute("message", (Object)new PortletMessage("Deployment and addition to portletentityregistry.xml successful.", PortletMessageType.SUCCESS));
                }
            }
            catch (FileUploadException e) {
                String msg = "File Upload Exception: " + e.getMessage();
                this.logError("processFileUpload(request,response)", msg, e);
                throw new PlutoAdminException((Throwable)e);
            }
            catch (Exception e) {
                String msg = "Exception: " + e.getMessage();
                this.logError("processFileUpload(request,response)", msg, e);
                throw new PlutoAdminException((Throwable)e);
            }
        } else {
            request.getPortletSession().setAttribute("message", (Object)new PortletMessage("No file appears to have been selected.", PortletMessageType.ERROR));
        }
        this.logMethodEnd("processFileUpload(request,response)", serverFileName);
        return serverFileName;
    }

    private String getRootFilename(char delimiter, String pathName) {
        int startFilenameIndex = pathName.lastIndexOf(delimiter) + 1;
        String filename = pathName.substring(startFilenameIndex);
        return filename;
    }

    private static String[] arrayListToStringArray(ArrayList<String> argStringArrayList) {
        return argStringArrayList.toArray(new String[argStringArrayList.size()]);
    }

    private InputStream extractFile(String zipfilename, String filename) {
        String METHOD_NAME = "extractFile(zipfilename,filename)";
        InputStream ins = null;
        try (ZipFile zf = new ZipFile(zipfilename);){
            ZipEntry ze;
            if (null != zf && null != (ze = zf.getEntry(filename))) {
                ins = zf.getInputStream(ze);
            }
        }
        catch (Exception e) {
            this.logError(CLASS_NAME, "extractFile(zipfilename,filename)", e);
            throw new PlutoAdminException((Throwable)e);
        }
        return ins;
    }

    private ArrayList<String> createDeploymentArgs(String serverFileName, String tempDir, ActionRequest request, boolean appExists, String context) throws Exception {
        String METHOD_NAME = "createDeploymentArgs(serverFileName,tempDir,request)";
        Properties props = PlutoAdminContext.getProperties();
        String PORTLET_DEPLOY_DIR = props.getProperty("portlet-deploy-dir");
        ArrayList<String> args = new ArrayList<String>();
        args.add(PlutoAdminContext.getDeploymentPath());
        args.add(PlutoAdminContext.getPlutoWebContext());
        args.add(tempDir + PlutoAdminConstants.FS + serverFileName);
        args.add(PORTLET_DEPLOY_DIR);
        String appId = String.valueOf(Math.random());
        if (!appExists) {
            args.add("-addToEntityReg");
            args.add(appId);
        } else {
            appId = PortletEntityRegistry.getPortletEntity(context).getId().toString();
        }
        HashMap pmap = new HashMap();
        InputStream ins = this.extractFile(tempDir + PlutoAdminConstants.FS + serverFileName, "WEB-INF/portlet.xml");
        if (null != ins) {
            ArrayList names = PortletNameFinder.getPortletNames((InputStream)ins);
            for (int i = 0; i < names.size(); ++i) {
                if (!appExists) {
                    args.add(i + ":" + (String)names.get(i));
                }
                pmap.put(names.get(i), appId + "." + i);
            }
        } else {
            String msg = "Input stream is null";
            PlutoAdminException e = new PlutoAdminException("Input stream is null");
            this.logError("createDeploymentArgs(serverFileName,tempDir,request)", e);
            throw e;
        }
        ins.close();
        request.getPortletSession().setAttribute("portlet-map", pmap);
        return args;
    }

    private String readFileToString(File file) {
        String METHOD_NAME = "readFileToString(path)";
        String contents = null;
        FileInputStream fis = null;
        try {
            int c;
            fis = new FileInputStream(file);
            StringBuffer sb = new StringBuffer();
            while ((c = fis.read()) != -1) {
                char b = (char)c;
                sb.append(b);
            }
            contents = sb.toString().trim();
        }
        catch (FileNotFoundException e) {
            this.logError("readFileToString(path)", e);
            throw new PlutoAdminException((Throwable)e);
        }
        catch (IOException e) {
            this.logError("readFileToString(path)", e);
            throw new PlutoAdminException((Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    this.logError("readFileToString(path)", e);
                    throw new PlutoAdminException((Throwable)e);
                }
            }
        }
        return contents;
    }

    private void writeStringToFile(File file, String contents) {
        String METHOD_NAME = "addFileToStringToFile(contents)";
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            byte[] bytes = contents.getBytes();
            fos.write(bytes);
        }
        catch (FileNotFoundException e) {
            this.logError("addFileToStringToFile(contents)", e);
            throw new PlutoAdminException((Throwable)e);
        }
        catch (IOException e) {
            this.logError("addFileToStringToFile(contents)", e);
            throw new PlutoAdminException((Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    this.logError("addFileToStringToFile(contents)", e);
                    throw new PlutoAdminException((Throwable)e);
                }
            }
        }
    }

    public void updateWebXml(String context) throws ErreurTechnique {
        String newWebXml;
        String METHOD_NAME = "updateWebXml(context)";
        String[] PRIOR_ELEMENTS_SERVLET = new String[]{"servlet", "listener", "filter-mapping", "filter", "context-param", "distributable", "description", "display-name", "icon", "web-app"};
        String[] PRIOR_ELEMENTS_SERVLET_MAPPING = new String[]{"servlet-mapping", "servlet"};
        String webapps = PlutoAdminContext.getDeploymentPath();
        File webXml = new File(webapps + PlutoAdminConstants.FS + context + PlutoAdminConstants.FS + "WEB-INF" + PlutoAdminConstants.FS + "web.xml");
        DeployWarService svc = new DeployWarService();
        String contents = svc.readFileToString(webXml);
        File portletXml = new File(webapps + PlutoAdminConstants.FS + context + PlutoAdminConstants.FS + "WEB-INF" + PlutoAdminConstants.FS + "portlet.xml");
        List plist = null;
        try {
            FileInputStream ins = new FileInputStream(portletXml);
            PortletConfigService pcsvc = new PortletConfigService((InputStream)ins);
            plist = pcsvc.getPortletDDList();
        }
        catch (FileNotFoundException e) {
            this.logError("updateWebXml(context)", e);
            throw new PlutoAdminException((Throwable)e);
        }
        contents = newWebXml = svc.addRecordsToWebXml(context, contents, PRIOR_ELEMENTS_SERVLET, plist);
        newWebXml = svc.addRecordsToWebXml(context, contents, PRIOR_ELEMENTS_SERVLET_MAPPING, plist);
        this.writeStringToFile(webXml, newWebXml);
    }

    String addRecordsToWebXml(String context, String contents, String[] elements, List<PortletDD> portletData) {
        String METHOD_NAME = "addRecordsToWebXml(context.contents,elements,portletData)";
        StringBuffer results = new StringBuffer(contents);
        int index = -1;
        int len = portletData.size();
        int lenElements = elements.length;
        String before = null;
        String newRecord = null;
        String remainder = null;
        String rest = null;
        block0: for (int i = 0; i < len; ++i) {
            for (int j = 0; j < lenElements; ++j) {
                index = results.lastIndexOf("</" + elements[j] + ">");
                if (index == -1) continue;
                rest = results.substring(index);
                int elementLen = rest.indexOf(62) + 1;
                if (i == 0 & elements[j].equals("web-app")) {
                    index = results.indexOf("<web-app");
                    rest = results.substring(index);
                    elementLen = rest.indexOf(62) + 1;
                }
                this.logDebug("addRecordsToWebXml(context.contents,elements,portletData)", "Length of '" + elements[j] + "' tag = " + elementLen);
                before = results.substring(0, index + elementLen);
                remainder = results.substring(index + elementLen);
                if (elements[0].equals("servlet")) {
                    newRecord = this.getServletRecord(context, portletData.get(i));
                } else if (elements[0].equals("servlet-mapping")) {
                    newRecord = this.getServletMappingRecord(portletData.get(i));
                }
                results = new StringBuffer();
                results.append(before);
                results.append(PlutoAdminConstants.LS);
                results.append(newRecord);
                results.append(remainder);
                continue block0;
            }
        }
        return results.toString();
    }

    private String getServletRecord(String context, PortletDD portletData) {
        StringBuffer record = new StringBuffer();
        record.append("    <servlet>" + PlutoAdminConstants.LS);
        record.append("      <servlet-name>" + portletData.getPortletName() + "</servlet-name>" + PlutoAdminConstants.LS);
        record.append("      <display-name>" + portletData.getPortletName() + " Wrapper</display-name>" + PlutoAdminConstants.LS);
        record.append("      <description>Automated generated Portlet Wrapper</description>" + PlutoAdminConstants.LS);
        record.append("      <servlet-class>org.apache.pluto.core.PortletServlet</servlet-class>" + PlutoAdminConstants.LS);
        record.append("      <init-param>" + PlutoAdminConstants.LS);
        record.append("        <param-name>portlet-guid</param-name>" + PlutoAdminConstants.LS);
        record.append("        <param-value>" + context + "." + portletData.getPortletName() + "</param-value>" + PlutoAdminConstants.LS);
        record.append("      </init-param>" + PlutoAdminConstants.LS);
        record.append("      <init-param>" + PlutoAdminConstants.LS);
        record.append("        <param-name>portlet-class</param-name>" + PlutoAdminConstants.LS);
        record.append("        <param-value>" + portletData.getPortletClass() + "</param-value>" + PlutoAdminConstants.LS);
        record.append("      </init-param>" + PlutoAdminConstants.LS);
        String securityRef = this.getSecurityRoleRefRecord(context, portletData);
        if (securityRef != null && !securityRef.equals("")) {
            record.append(securityRef);
        }
        record.append("    </servlet>" + PlutoAdminConstants.LS);
        return record.toString();
    }

    private String getSecurityRoleRefRecord(String context, PortletDD portletData) {
        StringBuffer record = new StringBuffer("");
        List refs = portletData.getSecurityRoleRefs();
        String link = null;
        for (Object element : refs) {
            PortletConfigService.RoleRef ref = (PortletConfigService.RoleRef)element;
            record.append("      <security-role-ref>" + PlutoAdminConstants.LS);
            record.append("        <role-name>" + ref.roleName + "</role-name>" + PlutoAdminConstants.LS);
            link = ref.roleLink;
            if (link != null && !link.equals("")) {
                record.append("        <role-link>" + link + "</role-link>" + PlutoAdminConstants.LS);
            }
            record.append("      </security-role-ref>" + PlutoAdminConstants.LS);
        }
        return record.toString();
    }

    private String getServletMappingRecord(PortletDD portletData) {
        StringBuffer record = new StringBuffer();
        record.append("    <servlet-mapping>" + PlutoAdminConstants.LS);
        record.append("      <servlet-name>" + portletData.getPortletName() + "</servlet-name>" + PlutoAdminConstants.LS);
        record.append("      <url-pattern>/" + portletData.getPortletName() + "/*</url-pattern>" + PlutoAdminConstants.LS);
        record.append("    </servlet-mapping>" + PlutoAdminConstants.LS);
        return record.toString();
    }
}

