/*
 * Decompiled with CFR 0.152.
 */
package com.univ.portail.deploiment.util;

import com.jsbsoft.jtf.exception.ErreurTechnique;
import com.kportal.core.config.PropertyHelper;
import java.util.Properties;
import org.apache.pluto.portlet.admin.PlutoAdminConstants;
import org.apache.pluto.portlet.admin.PlutoAdminException;
import org.apache.pluto.portlet.admin.PlutoAdminLogger;

public class PlutoAdminContext {
    private static final String TOMCAT_DEPLOIEMENT = "tomcat.deploiement";
    private static final String CLASS_NAME = "PlutoAdminContext";
    private static String _containerHome = null;
    private static String _plutoHome = null;
    private static String _plutoContext = null;
    private static String _deploymentPath = null;
    private static PlutoAdminContext _instance = new PlutoAdminContext();

    private PlutoAdminContext() {
    }

    public static PlutoAdminContext getInstance() {
        return _instance;
    }

    public String getPageRegistryPath() {
        String path = PlutoAdminContext.getPlutoHome() + PlutoAdminConstants.FS + this.getRelDataDir() + PlutoAdminConstants.FS + PlutoAdminContext.getProperties().getProperty("pageregistry-file");
        return path;
    }

    public String getPortletEntityRegistryPath() {
        String path = PlutoAdminContext.getPlutoHome() + PlutoAdminConstants.FS + this.getRelDataDir() + PlutoAdminConstants.FS + PlutoAdminContext.getProperties().getProperty("portletentityregistry-file");
        return path;
    }

    public static String getPlutoHome() {
        return _plutoHome;
    }

    public static Properties getProperties(String propFileName) {
        return new Properties();
    }

    public static Properties getProperties() {
        return PlutoAdminContext.getProperties("pluto-admin.properties");
    }

    private String getRelDataDir() {
        String dir = PlutoAdminContext.getProperties().getProperty("data-dir-relative-path");
        return dir;
    }

    public String getPortletContextsPath() {
        String path = PlutoAdminContext.getPlutoHome() + PlutoAdminConstants.FS + this.getRelDataDir() + PlutoAdminConstants.FS + PlutoAdminContext.getProperties().getProperty("portletcontexts-file");
        return path;
    }

    public static String getContainerHome() {
        return _containerHome;
    }

    public static void parseDeploymentPaths(String plutoHome) {
        String METHOD_NAME = "parseDeploymentPaths(plutoHome)";
        int lastSlash = 0;
        if (plutoHome == null) {
            _plutoHome = PlutoAdminContext.getProperties().getProperty("pluto-home");
            if (_plutoHome == null || _plutoHome.equals("")) {
                throw new PlutoAdminException("pluto-home needs to be set in pluto-admin.properties.");
            }
        } else if (plutoHome.lastIndexOf(PlutoAdminConstants.FS) == plutoHome.length() - 1) {
            lastSlash = plutoHome.lastIndexOf(PlutoAdminConstants.FS);
            _plutoHome = plutoHome.substring(0, lastSlash);
        } else {
            _plutoHome = plutoHome;
        }
        PlutoAdminLogger.logDebug((String)CLASS_NAME, (String)"parseDeploymentPaths(plutoHome)", (String)("Pluto home: " + _plutoHome));
        lastSlash = _plutoHome.lastIndexOf(PlutoAdminConstants.FS);
        _plutoContext = _plutoHome.substring(lastSlash + 1);
        PlutoAdminLogger.logDebug((String)CLASS_NAME, (String)"parseDeploymentPaths(plutoHome)", (String)("Pluto web context: " + _plutoContext));
        _deploymentPath = _plutoHome.substring(0, lastSlash);
        PlutoAdminLogger.logDebug((String)CLASS_NAME, (String)"parseDeploymentPaths(plutoHome)", (String)("Portlet deployment path: " + _deploymentPath));
        lastSlash = _deploymentPath.lastIndexOf(PlutoAdminConstants.FS);
        _containerHome = _deploymentPath.substring(0, lastSlash);
        PlutoAdminLogger.logDebug((String)CLASS_NAME, (String)"parseDeploymentPaths(plutoHome)", (String)("Container (Tomcat) home: " + _containerHome));
    }

    public static String getDeploymentPath() throws ErreurTechnique {
        String tomcatDeploiement = PropertyHelper.getCoreProperty(TOMCAT_DEPLOIEMENT);
        if (tomcatDeploiement == null || "".equals(tomcatDeploiement)) {
            throw new ErreurTechnique(-1, "La variable 'tomcat.deploiement' n'est pas d\u00e9finie dans le jtf.");
        }
        return tomcatDeploiement;
    }

    public static String getPlutoWebContext() {
        return _plutoContext;
    }
}

