/*
 * Decompiled with CFR 0.152.
 */
package com.univ.portail.om.entity.impl;

import com.univ.portail.util.ObjectIDImpl;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import org.apache.pluto.om.common.Description;
import org.apache.pluto.om.common.DescriptionSet;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.common.Preference;
import org.apache.pluto.om.common.PreferenceSet;
import org.apache.pluto.om.entity.PortletApplicationEntity;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.entity.PortletEntityCtrl;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.window.PortletWindowList;
import org.apache.pluto.portalImpl.om.common.impl.DescriptionSetImpl;
import org.apache.pluto.portalImpl.om.common.impl.PreferenceSetImpl;
import org.apache.pluto.portalImpl.om.window.impl.PortletWindowListImpl;
import org.apache.pluto.portalImpl.services.ConfigurationException;
import org.apache.pluto.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletEntityImpl
implements PortletEntity,
PortletEntityCtrl,
Serializable {
    private static final long serialVersionUID = -7751261491265761604L;
    private static Logger LOG = LoggerFactory.getLogger(PortletEntityImpl.class);
    private String id = "";
    private String definitionId = "";
    protected PreferenceSet preferences = new PreferenceSetImpl();
    private PreferenceSet origPreferences = new PreferenceSetImpl();
    private PortletApplicationEntity applicationEntity;
    private PortletWindowList portletWindows = new PortletWindowListImpl();
    private ObjectID objectId;
    private final DescriptionSet descriptions = new DescriptionSetImpl();

    public ObjectID getId() {
        if (this.objectId == null && this.applicationEntity != null) {
            this.objectId = ObjectIDImpl.createFromString(this.id);
        }
        return this.objectId;
    }

    public PreferenceSet getPreferenceSet() {
        return this.preferences;
    }

    public PortletDefinition getPortletDefinition() {
        PortletDefinition def = this.applicationEntity.getPortletApplicationDefinition().getPortletDefinitionList().get((ObjectID)ObjectIDImpl.createFromString(this.definitionId));
        if (def == null) {
            throw new ConfigurationException("Unable to obtain portlet definition for :" + this.definitionId + " Perhaps a portlet has been defined incorrectly in the portlet registry.");
        }
        return def;
    }

    public void setPortletDefinition(PortletDefinition portletDefinition) {
        this.definitionId = portletDefinition.getId().toString();
    }

    public PortletApplicationEntity getPortletApplicationEntity() {
        return this.applicationEntity;
    }

    public PortletWindowList getPortletWindowList() {
        return this.portletWindows;
    }

    public Description getDescription(Locale locale) {
        return this.descriptions.get(locale);
    }

    public void setId(String id) {
        this.id = id;
        this.objectId = null;
    }

    public void store() throws IOException {
        LOG.debug("on enregistre les pr\u00e9f\u00e9rences normalement...");
        for (Preference pref : this.preferences) {
            LOG.debug(pref.toString());
            Preference origPref = this.origPreferences.get(pref.getName());
            if (origPref == null) continue;
            LOG.debug("comp: " + origPref.toString());
        }
    }

    public void reset() throws IOException {
        this.preferences = new PreferenceSetImpl();
        ((PreferenceSetImpl)this.preferences).clear();
        ((PreferenceSetImpl)this.preferences).addAll((Collection)this.origPreferences);
    }

    public void setPortletApplicationEntity(PortletApplicationEntity applicationEntity) {
        this.applicationEntity = applicationEntity;
    }

    public void setPortletWindowList(PortletWindowList portletWindows) {
        this.portletWindows = portletWindows;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuffer buffer = new StringBuffer(1000);
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append(this.getClass().toString());
        buffer.append(":");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("{");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("id='");
        buffer.append(this.id);
        buffer.append("'");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("definition-id='");
        buffer.append(this.definitionId);
        buffer.append("'");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append(((PreferenceSetImpl)this.preferences).toString(indent));
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append(((DescriptionSetImpl)this.descriptions).toString(indent));
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("}");
        return buffer.toString();
    }

    public void setOrigPreferences(PreferenceSet origPreferences) {
        this.origPreferences = origPreferences;
    }
}

