/*
 * Decompiled with CFR 0.152.
 */
package com.univ.portail.service;

import com.kportal.core.config.PropertyHelper;
import com.univ.portail.service.ServiceInit;
import com.univ.portail.util.Properties;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.pluto.util.StringUtils;

public class ServiceManager {
    private static final String CLE_SERVICE_MANAGER = "ServiceManager.";
    private static volatile boolean cInitialized = false;
    private static Map<Class<?>, ServiceInit> cServicesMap = new HashMap();
    private static List<ServiceInit> cServicesList = new LinkedList<ServiceInit>();

    private static Map<String, Object> getProperties(String prefixe) {
        if (!prefixe.endsWith(".")) {
            prefixe = prefixe.concat(".");
        }
        TreeMap<String, Object> props = new TreeMap<String, Object>();
        Enumeration<Object> enumProps = PropertyHelper.getProperties("core").keys();
        while (enumProps.hasMoreElements()) {
            String cleProp = (String)enumProps.nextElement();
            if (!cleProp.startsWith(prefixe)) continue;
            String cle = cleProp.substring(prefixe.length());
            String propriete = PropertyHelper.getCoreProperty(cleProp);
            if (propriete.indexOf(",") != -1) {
                props.put(cle, Arrays.asList(propriete.split(",")));
                continue;
            }
            props.put(cle, propriete);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(ServletConfig aConfig) throws Exception {
        if (!cInitialized) {
            Class<ServiceManager> clazz = ServiceManager.class;
            synchronized (ServiceManager.class) {
                if (cInitialized) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                cInitialized = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            return;
        }
        {
            ServletContext context = null;
            if (aConfig != null) {
                context = aConfig.getServletContext();
            }
            if (context != null) {
                context.log("ServiceManager: Loading services...");
            }
            int numAll = 0;
            int numSuccessful = 0;
            Map<String, Object> props = ServiceManager.getProperties(CLE_SERVICE_MANAGER);
            for (String cleService : props.keySet()) {
                Class<?> serviceBase;
                String serviceImplName = (String)props.get(cleService);
                ++numAll;
                try {
                    serviceBase = Class.forName(cleService);
                }
                catch (ClassNotFoundException exc) {
                    if (context == null) continue;
                    context.log("ServiceManager: A service with name " + cleService + " cannot be found.");
                    continue;
                }
                Class<?> serviceImpl = null;
                ServiceInit service = null;
                try {
                    serviceImpl = Class.forName(serviceImplName);
                    service = (ServiceInit)serviceImpl.newInstance();
                    Properties serviceProps = new Properties();
                    Map<String, Object> propsService = ServiceManager.getProperties(StringUtils.nameOf(serviceBase));
                    if (propsService != null && propsService.size() != 0) {
                        serviceProps.load(propsService);
                    }
                    if (context != null) {
                        context.log(StringUtils.nameOf(serviceBase) + " initializing...");
                    }
                    service.init(aConfig, serviceProps);
                    if (context != null) {
                        context.log(StringUtils.nameOf(serviceBase) + " done.");
                    }
                }
                catch (ClassNotFoundException exc) {
                    if (context == null) continue;
                    context.log("ServiceManager: A service implementation with name " + serviceImplName + " cannot be found.", (Throwable)exc);
                    continue;
                }
                catch (ClassCastException exc) {
                    if (context == null) continue;
                    context.log("ServiceManager: Service implementation " + serviceImplName + " is not a service of the required type.", (Throwable)exc);
                    continue;
                }
                catch (InstantiationException exc) {
                    if (context == null) continue;
                    context.log("ServiceManager: Service implementation " + serviceImplName + " cannot be instantiated.", (Throwable)exc);
                    continue;
                }
                catch (Exception exc) {
                    if (context != null) {
                        context.log("ServiceManager: An unidentified error occurred", (Throwable)exc);
                    }
                    service = null;
                }
                if (service == null) continue;
                cServicesMap.put(serviceBase, service);
                cServicesList.add(0, service);
                ++numSuccessful;
            }
            if (context != null) {
                context.log("ServiceManager: Services initialized (" + numSuccessful + "/" + numAll + " successful).");
            }
            if (numSuccessful != numAll) {
                throw new Exception("ServiceManager: Services initialized (" + numSuccessful + "/" + numAll + " successful).");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postInit(ServletConfig aConfig) {
        if (cInitialized) {
            Class<ServiceManager> clazz = ServiceManager.class;
            synchronized (ServiceManager.class) {
                if (!cInitialized) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                cInitialized = false;
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            return;
        }
        {
            ServletContext context = null;
            if (aConfig != null) {
                context = aConfig.getServletContext();
            }
            for (ServiceInit service : cServicesList) {
                try {
                    service.postInit(aConfig);
                }
                catch (Exception exc) {
                    if (context == null) continue;
                    context.log("ServiceManager: Service couldn't be started (postInit) after init..", (Throwable)exc);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(ServletConfig aConfig) {
        if (cInitialized) {
            Class<ServiceManager> clazz = ServiceManager.class;
            synchronized (ServiceManager.class) {
                if (!cInitialized) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                cInitialized = false;
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            return;
        }
        {
            ServletContext context = null;
            if (aConfig != null) {
                context = aConfig.getServletContext();
            }
            for (ServiceInit service : cServicesList) {
                try {
                    service.destroy(aConfig);
                }
                catch (Exception exc) {
                    if (context == null) continue;
                    context.log("ServiceManager: Service couldn't be destroyed.", (Throwable)exc);
                }
            }
            cServicesList.clear();
            cServicesMap.clear();
            return;
        }
    }

    public static ServiceInit getService(Class<?> aClass) {
        return cServicesMap.get(aClass);
    }
}

