/*
 * Decompiled with CFR 0.152.
 */
package com.univ.portail.service.registry;

import com.kportal.core.config.PropertyHelper;
import com.univ.portail.om.definition.impl.PortletApplicationDefinitionImpl;
import com.univ.portail.om.definition.impl.PortletApplicationDefinitionListImpl;
import com.univ.portail.om.definition.impl.PortletDefinitionListImpl;
import com.univ.portail.om.servlet.impl.WebApplicationDefinitionImpl;
import com.univ.portail.service.ServiceInit;
import com.univ.portail.util.Properties;
import com.univ.portail.util.xml.Constants;
import com.univ.portail.util.xml.XmlParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.UnavailableException;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.om.portlet.PortletApplicationDefinitionList;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.portlet.PortletDefinitionList;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class ServiceChargementPorltetsDefinition
extends ServiceInit {
    private static final String CONFIG_MAPPING_PORTLETXML = "mapping.portletxml.configfile";
    private static final String CONFIG_MAPPING_WEBXML = "mapping.webxml.configfile";
    private static final String DEFAULT_MAPPING_PORTLETXML = "portletdefinitionmapping.xml";
    private static final String DEFAULT_MAPPING_WEBXML = "servletdefinitionmapping.xml";
    private PortletApplicationDefinitionList listeApplicationDefinition = null;
    private PortletDefinitionList listeDefinition = null;
    private Mapping webXmlMapping = null;
    private Mapping portletXmlMapping = null;
    private final Map<ObjectID, PortletDefinition> definitions = new Hashtable<ObjectID, PortletDefinition>();
    private List<String> listeApplicationChargees = null;
    private static Logger LOG = LoggerFactory.getLogger(ServiceChargementPorltetsDefinition.class);

    @Override
    protected void init(ServletConfig config, Properties props) throws Exception {
        ServletContext servletContext = config.getServletContext();
        String cheminFichierConf = PropertyHelper.getCoreProperty("repertoire.configuration");
        this.portletXmlMapping = this.loadMapping(servletContext, props.getString(CONFIG_MAPPING_PORTLETXML, cheminFichierConf + DEFAULT_MAPPING_PORTLETXML));
        this.webXmlMapping = this.loadMapping(servletContext, props.getString(CONFIG_MAPPING_WEBXML, cheminFichierConf + DEFAULT_MAPPING_WEBXML));
        if (this.listeApplicationDefinition == null) {
            this.listeApplicationDefinition = new PortletApplicationDefinitionListImpl();
        }
        if (this.listeDefinition == null) {
            this.listeDefinition = new PortletDefinitionListImpl();
        }
        if (this.listeApplicationChargees == null) {
            this.listeApplicationChargees = new ArrayList<String>();
        }
    }

    public void forcerRelectureApplication() {
        this.listeApplicationDefinition = new PortletApplicationDefinitionListImpl();
        this.listeDefinition = new PortletDefinitionListImpl();
        this.listeApplicationChargees = new ArrayList<String>();
    }

    public synchronized void chargerPortletDefinition(String definitionId, ServletContext servletContext) {
        block5: {
            PortletApplicationDefinition application = null;
            String ajout = definitionId;
            if (definitionId.contains(".")) {
                ajout = definitionId.substring(0, definitionId.indexOf("."));
            }
            String applicationContexteName = "/".concat(ajout);
            try {
                if (this.listeApplicationChargees.contains(applicationContexteName)) break block5;
                application = this.loadApplicationDefinition(servletContext, applicationContexteName);
                if (application != null) {
                    this.listeApplicationChargees.add(applicationContexteName);
                    ((PortletApplicationDefinitionListImpl)this.listeApplicationDefinition).add(application);
                    for (PortletDefinition portlet : application.getPortletDefinitionList()) {
                        this.definitions.put(portlet.getId(), portlet);
                        ((PortletDefinitionListImpl)this.listeDefinition).add(portlet);
                    }
                    break block5;
                }
                String messageErreur = "Impossible de charger le contexte suivant: " + applicationContexteName;
                throw new UnavailableException(messageErreur);
            }
            catch (UnavailableException e) {
                LOG.error("Impossible de charger le contexte suivant: " + applicationContexteName, (Throwable)e);
            }
        }
    }

    public PortletApplicationDefinitionList getApplicationDefinitionList() {
        return this.listeApplicationDefinition;
    }

    public PortletDefinitionList getDefinitionList() {
        return this.listeDefinition;
    }

    public PortletDefinition get(ObjectID objectId) {
        return this.definitions.get(objectId);
    }

    private Mapping loadMapping(ServletContext context, String path) throws UnavailableException {
        InputSource source = new InputSource(context.getResourceAsStream(path));
        Mapping mapping = new Mapping();
        try {
            mapping.loadMapping(source);
        }
        catch (IOException e) {
            throw (UnavailableException)new UnavailableException("Error reading mapping " + path).initCause((Throwable)e);
        }
        catch (MappingException e) {
            throw (UnavailableException)new UnavailableException("Invalid mapping " + path).initCause((Throwable)e);
        }
        return mapping;
    }

    private PortletApplicationDefinition loadApplicationDefinition(ServletContext context, String path) throws UnavailableException {
        PortletApplicationDefinitionImpl portletApplicationDefinition;
        Unmarshaller unmarshaller;
        ServletContext appContext = context.getContext(path);
        if (appContext == null) {
            throw new UnavailableException("Unable to access context for " + path);
        }
        InputStream stream = appContext.getResourceAsStream("/WEB-INF/portlet.xml");
        if (stream == null) {
            throw new UnavailableException("No portlet.xml found in context " + appContext.getServletContextName());
        }
        InputSource source = new InputSource(stream);
        try {
            unmarshaller = new Unmarshaller(this.portletXmlMapping);
            unmarshaller.setEntityResolver((EntityResolver)new XmlParser.EntityResolver(context, Constants.RES_PORTLET_DTDS, Constants.RES_PORTLET_DTD_NAMES));
        }
        catch (MappingException e) {
            throw (UnavailableException)new UnavailableException("Unable to construct unmarshaller for portlet.xml").initCause((Throwable)e);
        }
        unmarshaller.setIgnoreExtraElements(true);
        try {
            portletApplicationDefinition = (PortletApplicationDefinitionImpl)unmarshaller.unmarshal(source);
        }
        catch (MarshalException e) {
            throw (UnavailableException)new UnavailableException("Unable to unmarshal portlet.xml from context " + appContext.getServletContextName()).initCause((Throwable)e);
        }
        catch (ValidationException e) {
            throw (UnavailableException)new UnavailableException("Unable to validate portlet.xml from context " + appContext.getServletContextName()).initCause((Throwable)e);
        }
        stream = appContext.getResourceAsStream("/WEB-INF/web.xml");
        if (stream == null) {
            throw new UnavailableException("No web.xml found in context " + appContext.getServletContextName());
        }
        source = new InputSource(stream);
        try {
            unmarshaller = new Unmarshaller(this.webXmlMapping);
            unmarshaller.setIgnoreExtraAttributes(true);
            unmarshaller.setIgnoreExtraElements(true);
            unmarshaller.setEntityResolver((EntityResolver)new XmlParser.EntityResolver(context, "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "web-app_2_3.dtd", "web-app_2_3.dtd"));
        }
        catch (MappingException e) {
            throw (UnavailableException)new UnavailableException("Unable to construct unmarshaller for web.xml").initCause((Throwable)e);
        }
        unmarshaller.setIgnoreExtraElements(true);
        WebApplicationDefinitionImpl webApplicationDefinition = null;
        try {
            webApplicationDefinition = (WebApplicationDefinitionImpl)unmarshaller.unmarshal(source);
        }
        catch (MarshalException e) {
            throw (UnavailableException)new UnavailableException("Unable to unmarshal web.xml from context " + appContext.getServletContextName()).initCause((Throwable)e);
        }
        catch (ValidationException e) {
            throw (UnavailableException)new UnavailableException("Unable to validate web.xml from context " + appContext.getServletContextName()).initCause((Throwable)e);
        }
        Vector<Object> structure = new Vector<Object>();
        structure.add(portletApplicationDefinition);
        structure.add(path);
        try {
            webApplicationDefinition.postLoad(structure);
            webApplicationDefinition.preBuild(structure);
            webApplicationDefinition.postBuild(structure);
        }
        catch (Exception e) {
            throw (UnavailableException)new UnavailableException(e.getMessage()).initCause((Throwable)e);
        }
        return portletApplicationDefinition;
    }
}

