/*
 * Decompiled with CFR 0.152.
 */
package com.univ.portail.servlet;

import com.univ.portail.core.PortalControlParameter;
import com.univ.portail.core.PortalEnvironment;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.pluto.om.window.PortletWindow;

public class ServletRequestImpl
extends HttpServletRequestWrapper {
    Map<String, Object> attributes = null;
    PortalControlParameter control = null;
    PortletWindow portletWindow = null;
    Locale locale = new Locale(Locale.getDefault().getCountry());

    public ServletRequestImpl(HttpServletRequest servletRequest, PortletWindow window) {
        super(servletRequest);
        this.portletWindow = window;
        this.control = new PortalControlParameter(PortalEnvironment.getPortalEnvironment(servletRequest).getRequestedPortalURL());
        this.attributes = new HashMap<String, Object>();
    }

    public void setControl(PortalControlParameter _control) {
        this.control = _control;
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public Object getAttribute(String name) {
        Object res = null;
        res = this.attributes.containsKey(name) ? this.attributes.get(name) : super.getAttribute(name);
        return res;
    }

    public Enumeration<String> getAttributeNames() {
        Vector v = new Vector();
        Enumeration enumeration = super.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            v.add(enumeration.nextElement());
        }
        v.addAll(this.attributes.keySet());
        return v.elements();
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
        super.getAttribute(name);
    }

    public String getContentType() {
        String contentType = super.getContentType();
        return contentType;
    }

    public String getParameter(String name) {
        String[] values = this.getParameterMap().get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        String wid;
        HashMap<String, String[]> portletParameters = new HashMap<String, String[]>();
        Iterator<String> iterator = this.control.getRenderParamNames(this.portletWindow);
        while (iterator.hasNext()) {
            String name = iterator.next();
            String[] values = this.control.getRenderParamValues(this.portletWindow, name);
            portletParameters.put(name, values);
        }
        String pid = this.control.getPIDValue();
        if (pid.equals(wid = this.portletWindow.getId().toString())) {
            Enumeration parameters = super.getParameterNames();
            while (parameters.hasMoreElements()) {
                String paramName = (String)parameters.nextElement();
                String[] paramValues = super.getParameterValues(paramName);
                String[] values = (String[])portletParameters.get(paramName);
                if (values != null) {
                    String[] temp = new String[paramValues.length + values.length];
                    System.arraycopy(paramValues, 0, temp, 0, paramValues.length);
                    System.arraycopy(values, 0, temp, paramValues.length, values.length);
                    paramValues = temp;
                }
                portletParameters.put(paramName, paramValues);
            }
        }
        return Collections.unmodifiableMap(portletParameters);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

