/*
 * Decompiled with CFR 0.152.
 */
package com.univ.portail.util;

import com.univ.portail.util.PreferenceImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.portlet.PreferencesValidator;
import org.apache.pluto.om.common.Preference;
import org.apache.pluto.om.common.PreferenceSet;
import org.apache.pluto.om.common.PreferenceSetCtrl;
import org.apache.pluto.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferenceSetImpl
extends HashSet
implements PreferenceSet,
PreferenceSetCtrl,
Serializable {
    private static final long serialVersionUID = -6556013026178698811L;
    private String castorPreferencesValidator;
    private ClassLoader classLoader;
    private PreferencesValidator validatorInstance = null;
    private static Logger LOG = LoggerFactory.getLogger(PreferenceSetImpl.class);

    public Preference get(String name) {
        for (Preference preference : this) {
            if (!preference.getName().equals(name)) continue;
            return preference;
        }
        return null;
    }

    public PreferencesValidator getPreferencesValidator() {
        if (this.validatorInstance == null && this.castorPreferencesValidator != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clazz = loader.loadClass(this.castorPreferencesValidator);
                this.validatorInstance = (PreferencesValidator)clazz.newInstance();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.validatorInstance;
    }

    public Preference add(String name, List values) {
        PreferenceImpl preference = new PreferenceImpl();
        preference.setName(name);
        preference.setValues(values);
        super.add(preference);
        return preference;
    }

    public Preference remove(String name) {
        for (Preference preference : this) {
            if (!preference.getName().equals(name)) continue;
            super.remove(preference);
            return preference;
        }
        return null;
    }

    public void remove(Preference preference) {
        super.remove(preference);
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuffer buffer = new StringBuffer(50);
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append(this.getClass().toString());
        buffer.append(": ");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            buffer.append(((PreferenceImpl)iterator.next()).toString(indent + 2));
        }
        return buffer.toString();
    }

    public String getCastorPreferencesValidator() {
        return this.castorPreferencesValidator;
    }

    public void setCastorPreferencesValidator(String castorPreferencesValidator) {
        this.castorPreferencesValidator = castorPreferencesValidator;
    }

    public Collection getCastorPreferences() {
        return this;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    @Override
    public boolean addAll(Collection c) {
        for (PreferenceImpl pref : c) {
            this.add(pref.getName(), pref.getClonedCastorValuesAsList());
        }
        return true;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void addUserPreferencesValues(String name, List values) {
        if (this.get(name) != null) {
            ((PreferenceImpl)this.get(name)).addUserValues(values);
        } else {
            this.add(name, values);
        }
    }
}

