/*
 * Decompiled with CFR 0.152.
 */
package com.univ.portlet.server;

import com.jsbsoft.jtf.identification.GestionnaireIdentification;
import com.kportal.servlet.ExtensionServlet;
import com.univ.objetspartages.om.Encadre;
import com.univ.portail.util.PortletHelper;
import com.univ.utils.ContexteUniv;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import com.univ.xhtml.XHTMLFormater;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@WebServlet(name="portletEncadreServlet", urlPatterns={"/servlet/com.univ.portlet.server.PortletEncadreServlet"}, loadOnStartup=0)
public class PortletEncadreServlet
extends ExtensionServlet {
    private static final long serialVersionUID = -5397826598375869079L;
    private static Logger LOG = LoggerFactory.getLogger(PortletEncadreServlet.class);
    private static GestionnaireIdentification gI;

    private static void processNode(Node node) throws Exception {
        NodeList children;
        NamedNodeMap attributes;
        short type = node.getNodeType();
        if (type == 1 && node.getNodeName().equalsIgnoreCase("a") && (attributes = node.getAttributes()) != null) {
            Node target;
            Node href = attributes.getNamedItem("href");
            if (href != null) {
                String host;
                ContexteUniv ctx = new ContexteUniv("");
                String url = href.getNodeValue();
                if (!url.toLowerCase().startsWith("http://")) {
                    if (url.charAt(0) != '/') {
                        url = "/" + url;
                    }
                    url = URLResolver.getAbsoluteUrl(url, ctx);
                }
                url = "http://" + url.substring(7).replaceAll("//", "/");
                gI = GestionnaireIdentification.getInstance();
                if (gI.estSourceAuth("cas") && url.startsWith(host = URLResolver.getAbsoluteUrl("", ctx))) {
                    url = URLResolver.getAbsoluteUrl("/adminsite/sso/casauth.jsp?cible=" + URLEncoder.encode(url.substring(host.length()), "UTF-8"), ctx);
                }
                href.setNodeValue(url);
            }
            if ((target = attributes.getNamedItem("target")) == null) {
                target = node.getOwnerDocument().createAttribute("target");
                target.setNodeValue("_blank");
                attributes.setNamedItem(target);
            }
        }
        if ((children = node.getChildNodes()) != null) {
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                PortletEncadreServlet.processNode(children.item(i));
            }
        }
    }

    public static String preparerContenu(ContexteUniv _ctx, Writer writer, String _codeEncadre) throws Exception {
        String resultat = "";
        Encadre encadre = new Encadre();
        encadre.setCtx(_ctx);
        encadre.init();
        if (encadre.select("WHERE CODE='" + _codeEncadre + "'") == 1) {
            encadre.nextItem();
            XHTMLFormater xhtmlf = new XHTMLFormater();
            resultat = xhtmlf.transformHTMLtoXML(UnivWebFmt.formaterEnHTML(_ctx, encadre.getContenu()));
        } else {
            resultat = "Contenu inexistant";
        }
        return resultat;
    }

    public static void renvoyerContenu(Writer writer, String resultat) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            resultat = "<root>" + resultat + "</root>";
            Document document = builder.parse(new ByteArrayInputStream(resultat.getBytes("UTF-8")));
            PortletEncadreServlet.processNode(document);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(writer);
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            LOG.error("erreur lors du renvoi de contenu", (Throwable)e);
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter writer = res.getWriter();
        String resultat = "";
        try {
            LOG.debug(" Portletencadreservlet user = " + req.getParameter("USER") + " encadre=" + req.getParameter("ENCADRE"));
            ContexteUniv ctx = GestionnaireIdentification.getInstance().initialiserContexteProxyClient(req);
            resultat = PortletEncadreServlet.preparerContenu(ctx, res.getWriter(), req.getParameter("ENCADRE"));
            ctx.release();
        }
        catch (Exception e) {
            LOG.error("erreur sur les portlets", (Throwable)e);
            resultat = "Contenu indisponible";
        }
        res.setContentType("application/xhtml");
        PortletEncadreServlet.renvoyerContenu(writer, resultat);
    }

    @Override
    public boolean isActive() {
        return PortletHelper.isPortletActivated();
    }
}

