/*
 * Decompiled with CFR 0.152.
 */
package com.univ.rss;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.database.OMContext;
import com.kportal.core.config.PropertyHelper;
import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.mediarss.MediaEntryModuleImpl;
import com.sun.syndication.feed.module.mediarss.types.MediaContent;
import com.sun.syndication.feed.module.mediarss.types.Metadata;
import com.sun.syndication.feed.module.mediarss.types.Reference;
import com.sun.syndication.feed.module.mediarss.types.UrlReference;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedOutput;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.Ressource;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.rss.CacheFeedManager;
import com.univ.utils.Chaine;
import com.univ.utils.ContexteUniv;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.RequeteUtil;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jdom.Verifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExportRss {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractExportRss.class);
    private String query = null;
    private String objectName = null;
    private String feedType;

    public AbstractExportRss(String query, String objectName, String feedType) {
        this.query = query;
        this.objectName = objectName;
        this.feedType = feedType;
    }

    public void export(ContexteUniv ctx, Writer writer) throws Exception {
        CacheFeedManager cacheFeedManager = (CacheFeedManager)ApplicationContextManager.getCoreContextBean("cacheFeedManager");
        SyndFeed feed = cacheFeedManager.getSyndFeed(this.query, ctx, this);
        SyndFeedOutput output = new SyndFeedOutput();
        output.output(feed, writer);
    }

    protected ArrayList<Module> getEntryModules(SyndFeed feed, FicheUniv fiche) {
        return new ArrayList<Module>();
    }

    protected ArrayList<Module> getFeedModules(SyndFeed feed) {
        return new ArrayList<Module>();
    }

    public String getQuery() {
        return this.query;
    }

    protected String getDescription(OMContext ctx) throws Exception {
        return URLDecoder.decode(RequeteUtil.renvoyerParametre(this.query, "DESCRIPTION"), "UTF-8");
    }

    protected abstract String getItemTitle(FicheUniv var1) throws Exception;

    protected abstract String getItemDescription(ContexteUniv var1, FicheUniv var2) throws Exception;

    protected SyndEntry getSynEntry(ContexteUniv ctx, SyndFeed feed, FicheUniv fiche) throws Exception {
        SyndEntryImpl entry = new SyndEntryImpl();
        Metatag meta = FicheUnivMgr.lireMeta(fiche);
        Utilisateur redacteur = Utilisateur.getUtilisateur(fiche.getCodeRedacteur());
        List<MediaContent> mediaContents = this.getMediaContents(ctx, fiche);
        entry.setModules(this.getEntryModules(feed, fiche));
        MediaEntryModuleImpl mediaModule = new MediaEntryModuleImpl();
        mediaModule.setMediaContents(mediaContents.toArray(new MediaContent[mediaContents.size()]));
        entry.getModules().add(mediaModule);
        entry.setTitle(StringEscapeUtils.unescapeHtml4((String)Chaine.encodeSpecialEntities(this.getItemTitle(fiche))));
        entry.setLink(URLResolver.getAbsoluteUrl(UnivWebFmt.determinerUrlFiche(ctx, fiche, false), ctx));
        if (!"0".equals(PropertyHelper.getCoreProperty("export.rss." + this.objectName + ".description"))) {
            SyndContentImpl description = new SyndContentImpl();
            description.setType("text/html");
            String valeurDescription = StringEscapeUtils.unescapeHtml4((String)Chaine.encodeSpecialEntities(this.getItemDescription(ctx, fiche)));
            valeurDescription = this.removeIllegalsXMLCharacters(valeurDescription);
            description.setValue(valeurDescription);
            entry.setDescription((SyndContent)description);
        }
        if (!"0".equals(PropertyHelper.getCoreProperty("export.rss." + this.objectName + ".pubDate"))) {
            entry.setPublishedDate((Date)meta.getMetaDateMiseEnLigne());
        }
        if (!"0".equals(PropertyHelper.getCoreProperty("export.rss." + this.objectName + ".author"))) {
            entry.setAuthor(StringEscapeUtils.unescapeHtml4((String)Chaine.encodeSpecialEntities(redacteur.getAdresseMail() + " (" + redacteur.getPrenom() + " " + redacteur.getNom() + ")")));
        }
        return entry;
    }

    protected List<MediaContent> getMediaContents(OMContext ctx, FicheUniv fiche) throws Exception {
        ArrayList<MediaContent> mediaContents = new ArrayList<MediaContent>();
        MediaContent mediaContent = null;
        Vector<Ressource> fileList = Ressource.getListeFichier(fiche);
        if (fileList.size() > 0) {
            for (Ressource ressource : fileList) {
                try {
                    mediaContent = new MediaContent((Reference)new UrlReference(URLResolver.getAbsoluteUrl(ressource.getUrl(), ctx)));
                    mediaContent.setFileSize(Long.valueOf((long)ressource.getPoids().intValue() * 1024L));
                    mediaContent.setType(ressource.getFormat());
                    Metadata md = new Metadata();
                    md.setDescription(Chaine.encodeSpecialEntities(ressource.getDescription()));
                    md.setTitle(Chaine.encodeSpecialEntities(ressource.getTitre()));
                    mediaContent.setMetadata(md);
                    mediaContents.add(mediaContent);
                }
                catch (URISyntaxException e) {
                    LOG.error("impossible de parser l'url de la ressource", (Throwable)e);
                }
            }
        }
        return mediaContents;
    }

    private String removeIllegalsXMLCharacters(String text) {
        char[] chars;
        StringBuffer result = new StringBuffer();
        for (char c : chars = text.toCharArray()) {
            if (!Verifier.isXMLCharacter((int)c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getFeedType() {
        return this.feedType;
    }

    public void setFeedType(String type) {
        this.feedType = type;
    }

    protected void setFeedProperties(OMContext ctx, SyndFeed feed) throws Exception {
        feed.setFeedType(this.getFeedType());
        String urlSite = URLResolver.getAbsoluteUrl("", ctx);
        feed.setTitle(StringEscapeUtils.unescapeHtml4((String)Chaine.encodeSpecialEntities(ctx.getInfosSite().getIntitule())));
        feed.setLink(urlSite);
        feed.setDescription(StringEscapeUtils.unescapeHtml4((String)Chaine.encodeSpecialEntities(this.getDescription(ctx))));
        feed.setLanguage("fr");
        feed.setEncoding("UTF-8");
    }
}

