/*
 * Decompiled with CFR 0.152.
 */
package com.univ.rss;

import com.kdecole.cache.aspect.TempCacheGet;
import com.kportal.extension.module.plugin.objetspartages.IPluginRecherche;
import com.kportal.extension.module.plugin.objetspartages.PluginRechercheHelper;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.rss.AbstractExportRss;
import com.univ.utils.ContexteUniv;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheFeedManager {
    public static final String ID_BEAN = "cacheFeedManager";
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheFeedManager.class);

    @TempCacheGet(key="CacheFeedManager.getSyndFeed", contextual=false)
    public SyndFeed getSyndFeed(String query, ContexteUniv ctx, AbstractExportRss aer) {
        SyndFeedImpl feed = new SyndFeedImpl();
        try {
            aer.setFeedProperties(ctx, (SyndFeed)feed);
            FicheUniv fiche = ReferentielObjets.instancierFiche(aer.getObjectName());
            fiche.setCtx(ctx);
            fiche.init();
            for (IPluginRecherche plugin : PluginRechercheHelper.getPlugins()) {
                if (!plugin.checkClasse(fiche.getClass().getName())) continue;
                Map<String, Object> queryParameters = CacheFeedManager.transformQueryToMap(query);
                queryParameters = plugin.taiterRecherche(ctx, queryParameters);
                query = CacheFeedManager.transformMapToQuery(queryParameters);
            }
            ctx.setCalculListeResultatsFront(true);
            fiche.traiterRequete(query);
            ctx.setCalculListeResultatsFront(false);
            ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>();
            while (fiche.nextItem()) {
                try {
                    SyndEntry entry = aer.getSynEntry(ctx, (SyndFeed)feed, fiche);
                    entries.add(entry);
                }
                catch (Exception e) {
                    LOGGER.error("Erreur sur une fiche dans l'export RSS : requete = " + query + " (id_fiche = " + fiche.getIdFiche(), (Throwable)e);
                }
            }
            feed.setModules(aer.getFeedModules((SyndFeed)feed));
            feed.setEntries(entries);
        }
        catch (Exception e) {
            LOGGER.error("Erreur de l'export RSS : requete = " + query, (Throwable)e);
        }
        return feed;
    }

    private static final Map<String, Object> transformQueryToMap(String query) {
        HashMap<String, Object> parametersMap = new HashMap<String, Object>();
        query = StringUtils.removeStart((String)query, (String)"?");
        List<String> parameters = Arrays.asList(StringUtils.split((String)query, (String)"&"));
        for (String parameterAndValues : parameters) {
            String[] valuesByParamNames = StringUtils.split((String)parameterAndValues, (String)"=");
            parametersMap.put(valuesByParamNames[0], valuesByParamNames[1]);
        }
        return parametersMap;
    }

    private static final String transformMapToQuery(Map<String, Object> queryToTransform) {
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry<String, Object> valueByParameterName : queryToTransform.entrySet()) {
            if (queryString.length() > 0) {
                queryString.append('&');
            }
            queryString.append(valueByParameterName.getKey()).append('=').append(valueByParameterName.getValue());
        }
        return queryString.toString();
    }
}

