/*
 * Decompiled with CFR 0.152.
 */
package com.univ.rss;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.PropertyHelper;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Ressource;
import com.univ.objetspartages.om.Structure;
import com.univ.rss.AbstractExportRss;
import com.univ.utils.ContexteUniv;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.RequeteUtil;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;

public class ExportRssDefaut
extends AbstractExportRss {
    public ExportRssDefaut(String query, String objectName, String feedType) {
        super(query, objectName, feedType);
    }

    @Override
    protected String getDescription(OMContext ctx) throws Exception {
        String description = super.getDescription(ctx);
        if (description.length() == 0) {
            String codeRattachement;
            String thematique = RequeteUtil.renvoyerParametre(this.getQuery(), "THEMATIQUE");
            if (thematique.length() > 0) {
                description = description + "\"" + Libelle.getLibelle("04", thematique, ctx.getLocale()) + "\" ";
            }
            if ((codeRattachement = RequeteUtil.renvoyerParametre(this.getQuery(), "CODE_RATTACHEMENT")).length() > 0) {
                description = description + "[" + Structure.getLibelleRattachement(ctx, codeRattachement, "0", true).replaceAll("<br />", " / ") + "]";
            }
            if (description.length() == 0) {
                String objet = RequeteUtil.renvoyerParametre(this.getQuery(), "OBJET");
                if (objet.length() > 0) {
                    description = "Les ";
                    String nombre = RequeteUtil.renvoyerParametre(this.getQuery(), "NOMBRE");
                    if (nombre.length() > 0) {
                        description = description + nombre + " ";
                    }
                    description = description + "derni\u00e8res fiches " + ReferentielObjets.getLibelleObjet(ReferentielObjets.getCodeObjet(objet));
                }
            } else {
                description = "S\u00e9lection " + description;
            }
        }
        return description;
    }

    @Override
    protected String getItemTitle(FicheUniv fiche) throws Exception {
        return fiche.getLibelleAffichable();
    }

    @Override
    protected String getItemDescription(ContexteUniv ctx, FicheUniv fiche) throws Exception {
        String description = "";
        Ressource ressource = Ressource.getFichier(fiche);
        if (ressource != null) {
            String urlVignette = URLResolver.getAbsoluteUrl(ressource.getUrlVignette(), ctx);
            description = "<img src=\"" + urlVignette + "\" width=\"150px\" /><br />";
        }
        String codeObjet = ReferentielObjets.getCodeObjet(fiche);
        String nomObjet = ReferentielObjets.getNomObjet(codeObjet);
        String libelleObjet = ReferentielObjets.getLibelleObjet(codeObjet);
        String optionExport = PropertyHelper.getCoreProperty("export_rss." + nomObjet + ".description");
        if (optionExport == null || optionExport.length() == 0) {
            Metatag meta = FicheUnivMgr.lireMeta(fiche);
            description = description + "Fiche " + libelleObjet + " - " + new SimpleDateFormat("dd/MM/yyyy").format(meta.getMetaDateMiseEnLigne());
        } else {
            try {
                String nomAccesseurGET = "get" + optionExport.substring(0, 1).toUpperCase() + optionExport.substring(1);
                Method accesseurGET = fiche.getClass().getMethod(nomAccesseurGET, new Class[0]);
                Object[] o = new Object[]{};
                description = description + (String)accesseurGET.invoke((Object)fiche, o);
            }
            catch (Exception e) {
                throw new ErreurApplicative("Attribut " + optionExport + " pour la fiche " + libelleObjet);
            }
        }
        ctx.setFicheCourante(fiche);
        return UnivWebFmt.formaterEnHTML(ctx, description);
    }
}

