/*
 * Decompiled with CFR 0.152.
 */
package com.univ.rss;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.PropertyHelper;
import com.univ.rss.AbstractExportRss;
import com.univ.utils.RequeteUtil;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportRssFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ExportRssFactory.class);
    private static ExportRssFactory instance = null;
    private HashMap<String, Constructor<?>> exportRssConstructors = new HashMap();

    private ExportRssFactory() {
        Properties allProperties = PropertyHelper.getAllProperties();
        Enumeration<Object> en = allProperties.keys();
        Class[] exportRssClassParams = new Class[]{String.class, String.class, String.class};
        while (en.hasMoreElements()) {
            String jtfParam = (String)en.nextElement();
            if (!jtfParam.startsWith("export_rss.") || !jtfParam.contains(".class")) continue;
            int deb = jtfParam.indexOf("export_rss.") + 11;
            int fin = jtfParam.indexOf(".class", deb);
            String objectName = jtfParam.substring(deb, fin).toUpperCase();
            try {
                Class<?> exportRssClass = Class.forName(allProperties.getProperty(jtfParam));
                this.exportRssConstructors.put(objectName, exportRssClass.getConstructor(exportRssClassParams));
            }
            catch (ReflectiveOperationException e) {
                LOG.error("Probl\u00e8me d'initialisation de l'export rss pour l'objet " + objectName, (Throwable)e);
            }
        }
    }

    public static ExportRssFactory getInstance() {
        if (instance == null) {
            ExportRssFactory.syncGetInstance();
        }
        return instance;
    }

    private static synchronized void syncGetInstance() {
        if (instance == null) {
            instance = new ExportRssFactory();
        }
    }

    public AbstractExportRss create(String requete) throws ErreurApplicative {
        AbstractExportRss rss;
        if (requete == null) {
            requete = "";
        }
        String typeFlux = (String)StringUtils.defaultIfEmpty((CharSequence)RequeteUtil.renvoyerParametre(requete, "TYPE_FLUX_FEED"), (CharSequence)PropertyHelper.getCoreProperty("export.flux.typeDefaut"));
        String objet = (String)StringUtils.defaultIfEmpty((CharSequence)RequeteUtil.renvoyerParametre(requete, "OBJET").toUpperCase(), (CharSequence)"ACTUALITE");
        String selection = RequeteUtil.renvoyerParametre(requete, "SELECTION");
        if (StringUtils.isEmpty((CharSequence)selection)) {
            if (requete.length() > 0) {
                requete = requete + "&";
            }
            requete = requete + "SELECTION=0007";
        }
        String nombre = RequeteUtil.renvoyerParametre(requete, "NOMBRE");
        int nb = 10;
        if (StringUtils.isEmpty((CharSequence)nombre)) {
            if (requete.length() > 0) {
                requete = requete + "&";
            }
            requete = requete + "NOMBRE=" + nb;
        } else {
            try {
                nb = Integer.parseInt(nombre);
                if (nb > 100) {
                    nb = 100;
                }
            }
            catch (NumberFormatException e) {
                LOG.debug("Impossible de r\u00e9cup\u00e9rer le nombre d'\u00e9l\u00e9ment \u00e0 afficher " + nombre);
            }
            requete = StringUtils.replace((String)requete, (String)("NOMBRE=" + nombre), (String)("NOMBRE=" + nb));
        }
        Constructor<?> constructor = this.exportRssConstructors.get(objet);
        if (constructor == null) {
            constructor = this.exportRssConstructors.get("DEFAUT");
        }
        Object[] params = new Object[]{requete, objet, typeFlux};
        try {
            rss = (AbstractExportRss)constructor.newInstance(params);
        }
        catch (Exception e) {
            LOG.error("Probl\u00e8me lors de l'instanciation du gestionnaire d'export rss pour l'objet " + objet, (Throwable)e);
            throw new ErreurApplicative("Une erreur est survenue lors de l'export rss.");
        }
        return rss;
    }
}

