/*
 * Decompiled with CFR 0.152.
 */
package com.univ.rss;

import com.kportal.core.config.PropertyHelper;
import com.univ.rss.RSSBean;
import com.univ.rss.impl.rome.RequeteRSSImplRome;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequeteMultiRSS {
    private static Logger LOG = LoggerFactory.getLogger(RequeteMultiRSS.class);
    private ArrayList<RSSBean> resultats = new ArrayList();
    private String titre = "";
    private String description = "";

    public Vector<RSSBean> lancerRequetes(String param) {
        Vector<String> vUrls = new Vector<String>();
        int maxResultats = 0;
        int indicePlus = param.indexOf("+");
        if (indicePlus == -1) {
            vUrls.add(StringUtils.replace((String)param, (String)"&amp;", (String)"&"));
            maxResultats = 100;
        } else {
            try {
                maxResultats = Integer.parseInt(param.substring(0, indicePlus));
                vUrls.add(StringUtils.replace((String)param.substring(indicePlus + 1), (String)"&amp;", (String)"&"));
            }
            catch (NumberFormatException e) {
                vUrls.add(StringUtils.replace((String)param, (String)"&amp;", (String)"&"));
                maxResultats = 100;
            }
            catch (Exception e) {
                LOG.error("mauvaise URL peut \u00eatre?", (Throwable)e);
            }
        }
        ArrayList<Thread> lstTread = new ArrayList<Thread>();
        try {
            RequeteRSSImplRome requete = null;
            for (int i = 0; i < vUrls.size(); ++i) {
                requete = new RequeteRSSImplRome(this, maxResultats, (String)vUrls.get(i));
                Thread threadRequete = new Thread(requete);
                threadRequete.start();
                lstTread.add(threadRequete);
            }
            long to = 2000L;
            if (PropertyHelper.getCoreProperty("import_rss.timeout") != null) {
                try {
                    to = Long.valueOf(PropertyHelper.getCoreProperty("import_rss.timeout"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (Thread thread : lstTread) {
                thread.join(to);
            }
        }
        catch (Exception e) {
            LOG.error("erreur lors de l'appel du thread", (Throwable)e);
        }
        Vector<RSSBean> res = new Vector<RSSBean>();
        Iterator<RSSBean> iter = this.resultats.iterator();
        while (iter.hasNext()) {
            res.add(iter.next());
        }
        return res;
    }

    public synchronized void ajouterResultat(RSSBean rss) {
        this.resultats.add(rss);
    }

    public synchronized void decrementerCptRequetes() {
    }

    public String getTitre() {
        return this.titre;
    }

    public void setTitre(String titre) {
        this.titre = titre;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

