/*
 * Decompiled with CFR 0.152.
 */
package com.univ.rss.impl.kosmos;

import com.kportal.core.webapp.WebAppUtil;
import com.univ.rss.AbstractRequeteRSS;
import com.univ.rss.RSSBean;
import com.univ.rss.RequeteMultiRSS;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RequeteRSS
extends AbstractRequeteRSS {
    private static Logger LOG = LoggerFactory.getLogger(RequeteRSS.class);
    private String errorMessage = "";
    private Exception eWithMessage = null;

    public RequeteRSS(RequeteMultiRSS requeteMulti, int maxReponses, String url) {
        super(requeteMulti, maxReponses, url);
    }

    @Override
    public void run() {
        block9: {
            LOG.debug("RequeteRSS : thread lanc\u00e9, url = " + this.getUrl());
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setEntityResolver(new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        if (publicId.equals("-//Netscape Communications//DTD RSS 0.91//EN")) {
                            return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                        }
                        return null;
                    }
                });
                URL zurl = new URL(this.getUrl());
                URLConnection urlConnection = zurl.openConnection();
                String ligne = "";
                BufferedReader flux = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                String fileName = WebAppUtil.getWorkDefaultPath() + File.separator + "rss" + System.currentTimeMillis();
                BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
                File fileRss = new File(fileName);
                while ((ligne = flux.readLine()) != null) {
                    out.write(ligne.replaceAll("&#x2019;", "'"));
                }
                flux.close();
                out.close();
                Document document = builder.parse(fileRss);
                fileRss.delete();
                Element nodeRss = document.getDocumentElement();
                if (nodeRss == null) break block9;
                NodeList channels = nodeRss.getChildNodes();
                int nbResultats = 0;
                int i = 0;
                while (i < channels.getLength() && nbResultats < this.getMaxReponses()) {
                    Node node = channels.item(i++);
                    Node nodeItem = null;
                    if (node.getNodeName().equalsIgnoreCase("channel")) {
                        NodeList items = node.getChildNodes();
                        int j = 0;
                        while (j < items.getLength() && nbResultats < this.getMaxReponses()) {
                            if (!(nodeItem = items.item(j++)).getNodeName().equalsIgnoreCase("item") || !nodeItem.hasChildNodes()) continue;
                            this.getRequeteMulti().ajouterResultat(this.readItem(nodeItem));
                            ++nbResultats;
                        }
                        continue;
                    }
                    if (!node.getNodeName().equalsIgnoreCase("item") || !node.hasChildNodes()) continue;
                    this.getRequeteMulti().ajouterResultat(this.readItem(node));
                    ++nbResultats;
                }
                if (this.errorMessage.length() > 0 && this.eWithMessage != null) {
                    LOG.error(this.errorMessage, (Throwable)this.eWithMessage);
                } else if (this.errorMessage.length() > 0) {
                    LOG.error(this.errorMessage);
                }
                this.errorMessage = "";
                this.eWithMessage = null;
            }
            catch (Exception e) {
                LOG.error("erreur sur la requete rss", (Throwable)e);
            }
        }
        this.getRequeteMulti().decrementerCptRequetes();
        LOG.debug("RequeteRSS : fin d'ex\u00e9cution du thread");
    }

    private RSSBean readItem(Node nodeItem) {
        RSSBean rss = new RSSBean();
        for (Node nextFeuille = nodeItem.getFirstChild(); nextFeuille != null; nextFeuille = nextFeuille.getNextSibling()) {
            SimpleDateFormat df;
            String date;
            if (nextFeuille.getFirstChild() == null) continue;
            if (nextFeuille.getNodeName().compareTo("title") == 0) {
                rss.setTitle(StringEscapeUtils.escapeHtml4((String)nextFeuille.getFirstChild().getNodeValue().trim()));
                continue;
            }
            if (nextFeuille.getNodeName().compareTo("link") == 0) {
                rss.setLink(nextFeuille.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nextFeuille.getNodeName().compareTo("description") == 0) {
                rss.setDescription(nextFeuille.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nextFeuille.getNodeName().indexOf("creator") != -1) {
                rss.setCreator(nextFeuille.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nextFeuille.getNodeName().indexOf("date") != -1) {
                date = nextFeuille.getFirstChild().getNodeValue().trim();
                try {
                    if (date.length() > 19) {
                        date = date.substring(0, 10) + " " + date.substring(11, 19);
                        df = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss");
                        rss.setDate(df.parse(date));
                        continue;
                    }
                    if (date.indexOf("/") != -1 && date.length() == 10) {
                        df = null;
                        if (date.indexOf("/") == 4) {
                            df = new SimpleDateFormat("yyyy/MM/dd");
                        } else if (date.indexOf("/") == 2) {
                            df = new SimpleDateFormat("dd/MM/yyyy");
                        }
                        rss.setDate(df.parse(date));
                        continue;
                    }
                    if (date.length() <= 0) continue;
                    this.errorMessage = "Format de date non interpr\u00e9t\u00e9 pour ce flux (" + date + ")";
                }
                catch (Exception e) {
                    this.errorMessage = "Erreur lors de la lecture de la date pour ce flux : " + date;
                    this.eWithMessage = e;
                }
                continue;
            }
            if (nextFeuille.getNodeName().indexOf("pubDate") == -1) continue;
            date = nextFeuille.getFirstChild().getNodeValue().trim();
            try {
                if (date.length() > 19) {
                    rss.setDate(new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US).parse(date));
                    continue;
                }
                if (date.indexOf("/") != -1 && date.length() == 10) {
                    df = null;
                    if (date.indexOf("/") == 4) {
                        df = new SimpleDateFormat("yyyy/MM/dd");
                    } else if (date.indexOf("/") == 2) {
                        df = new SimpleDateFormat("dd/MM/yyyy");
                    }
                    rss.setDate(df.parse(date));
                    continue;
                }
                if (date.length() <= 0) continue;
                this.errorMessage = "Format de date (pubDate) non interpr\u00e9t\u00e9 pour ce flux (" + date + ")";
                continue;
            }
            catch (Exception e) {
                this.errorMessage = "Erreur lors de la lecture de la date (pubDate) pour ce flux : " + date;
                this.eWithMessage = e;
            }
        }
        return rss;
    }
}

