/*
 * Decompiled with CFR 0.152.
 */
package com.univ.rss.impl.rome;

import com.kportal.core.config.PropertyHelper;
import com.sun.syndication.feed.module.mediarss.MediaEntryModule;
import com.sun.syndication.feed.module.mediarss.types.MediaContent;
import com.sun.syndication.feed.module.mediarss.types.MediaGroup;
import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.fetcher.FeedFetcher;
import com.sun.syndication.fetcher.FetcherException;
import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.LinkedHashMapFeedInfoCache;
import com.sun.syndication.io.FeedException;
import com.univ.rss.AbstractRequeteRSS;
import com.univ.rss.RSSBean;
import com.univ.rss.RSSMediaContentBean;
import com.univ.rss.RequeteMultiRSS;
import com.univ.rss.impl.rome.HttpURLFeedFetcherProxy;
import com.univ.utils.Chaine;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequeteRSSImplRome
extends AbstractRequeteRSS {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"com.univ.rss.impl.rome.RequeteRssImplRome");
    private final FeedFetcher fetcher;

    public RequeteRSSImplRome(RequeteMultiRSS requeteMulti, int maxReponses, String url) {
        super(requeteMulti, maxReponses, url);
        FeedFetcherCache feedInfoCache = LinkedHashMapFeedInfoCache.getInstance();
        int nb = 10;
        if (PropertyHelper.getCoreProperty("import_rss.cache.maxentries") != null) {
            try {
                nb = Integer.valueOf(PropertyHelper.getCoreProperty("import_rss.cache.maxentries"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ((LinkedHashMapFeedInfoCache)feedInfoCache).setMaxEntries(nb);
        this.fetcher = new HttpURLFeedFetcherProxy(feedInfoCache);
    }

    @Override
    public void run() {
        try {
            URL url = new URL(this.getUrl());
            this.testUrlConnection(url);
            SyndFeed feed = this.fetcher.retrieveFeed(url);
            this.getRequeteMulti().setTitre(feed.getTitle());
            this.getRequeteMulti().setDescription(feed.getDescription());
            Iterator itEntries = feed.getEntries().iterator();
            for (int cptReadEntries = 0; itEntries.hasNext() && cptReadEntries < this.getMaxReponses(); ++cptReadEntries) {
                RSSBean rssBean = this.getRSSBean((SyndEntry)itEntries.next(), feed.getEncoding());
                this.getRequeteMulti().ajouterResultat(rssBean);
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage() + " sur l'URL : " + this.getUrl());
        }
        catch (MalformedURLException e) {
            LOGGER.error(e.getMessage() + " sur l'URL : " + this.getUrl());
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage() + " sur l'URL : " + this.getUrl());
        }
        catch (FeedException e) {
            LOGGER.error(e.getMessage() + " sur l'URL : " + this.getUrl());
        }
        catch (FetcherException e) {
            LOGGER.error(e.getMessage() + " sur l'URL : " + this.getUrl());
        }
    }

    public void testUrlConnection(URL url) throws IOException {
        HttpURLConnection urlConn = null;
        try {
            urlConn = (HttpURLConnection)url.openConnection();
            urlConn.connect();
        }
        finally {
            urlConn.disconnect();
        }
    }

    private RSSBean getRSSBean(SyndEntry syndEntry, String encoding) {
        RSSBean result = new RSSBean();
        result.setCreator(syndEntry.getAuthor());
        result.setDate(syndEntry.getPublishedDate());
        if (syndEntry.getDescription() != null) {
            result.setDescription(Chaine.encodeSpecialEntities(syndEntry.getDescription().getValue()));
        }
        result.setLink(syndEntry.getLink());
        result.setTitle(Chaine.encodeSpecialEntities(syndEntry.getTitle()));
        result.addAllMedia(this.getRssMediaContentFromEnclosures(syndEntry));
        MediaEntryModule mediaEntryModule = (MediaEntryModule)syndEntry.getModule("http://search.yahoo.com/mrss/");
        result.addAllMedia(this.getRssMediaContentFromMediaEntryModule(mediaEntryModule));
        return result;
    }

    private List<RSSMediaContentBean> getRssMediaContentFromMediaEntryModule(MediaEntryModule mediaEntryModule) {
        ArrayList<RSSMediaContentBean> results = new ArrayList<RSSMediaContentBean>();
        if (mediaEntryModule != null) {
            int i;
            if (mediaEntryModule.getMediaContents() != null) {
                for (i = 0; i < mediaEntryModule.getMediaContents().length; ++i) {
                    MediaContent content = mediaEntryModule.getMediaContents()[i];
                    if (!RSSMediaContentBean.isMimeTypeSupported(content.getType())) continue;
                    try {
                        results.add(this.getRSSMediaContent(content));
                        continue;
                    }
                    catch (MalformedURLException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (mediaEntryModule.getMediaGroups() != null) {
                for (i = 0; i < mediaEntryModule.getMediaGroups().length; ++i) {
                    MediaGroup group = mediaEntryModule.getMediaGroups()[i];
                    if (group.getContents() == null) continue;
                    for (int j = 0; j < group.getContents().length; ++j) {
                        MediaContent content = group.getContents()[j];
                        if (!RSSMediaContentBean.isMimeTypeSupported(content.getType())) continue;
                        try {
                            results.add(this.getRSSMediaContent(content));
                            continue;
                        }
                        catch (MalformedURLException e) {
                            LOGGER.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
        return results;
    }

    private List<RSSMediaContentBean> getRssMediaContentFromEnclosures(SyndEntry syndEntry) {
        ArrayList<RSSMediaContentBean> results = new ArrayList<RSSMediaContentBean>();
        if (syndEntry.getEnclosures() != null) {
            for (SyndEnclosure enclosure : syndEntry.getEnclosures()) {
                if (!RSSMediaContentBean.isMimeTypeSupported(enclosure.getType())) continue;
                try {
                    String titre = "media";
                    if (enclosure.getUrl() != null) {
                        titre = StringUtils.substringAfterLast((String)enclosure.getUrl(), (String)"/");
                        titre = StringUtils.substringBefore((String)titre, (String)"?");
                    }
                    results.add(this.getRSSMediaContent(titre, null, null, null, enclosure.getType(), enclosure.getUrl()));
                }
                catch (MalformedURLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return results;
    }

    private RSSMediaContentBean getRSSMediaContent(MediaContent content) throws MalformedURLException {
        String titre = "media";
        String description = null;
        String url = null;
        if (content.getMetadata() != null) {
            description = content.getMetadata().getDescription();
        }
        if (content.getReference() != null) {
            url = content.getReference().toString();
        }
        if (url != null) {
            titre = StringUtils.substringAfterLast((String)url, (String)"/");
            titre = StringUtils.substringBefore((String)titre, (String)"?");
        }
        return this.getRSSMediaContent(titre, description, content.getWidth(), content.getHeight(), content.getType(), url);
    }

    private RSSMediaContentBean getRSSMediaContent(String titre, String description, Integer width, Integer height, String type, String url) throws MalformedURLException {
        RSSMediaContentBean rssMediaContentBean = new RSSMediaContentBean();
        rssMediaContentBean.setTitre(titre);
        rssMediaContentBean.setDescription(description);
        rssMediaContentBean.setHeight(height);
        rssMediaContentBean.setWidth(width);
        rssMediaContentBean.setMimeType(type);
        if (url != null) {
            rssMediaContentBean.setUrl(new URL(url));
        }
        return rssMediaContentBean;
    }
}

