/*
 * Decompiled with CFR 0.152.
 */
package com.univ.services;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.identification.GestionnaireIdentification;
import com.kdecole.cache.aspect.TempCacheFlush;
import com.kdecole.cache.aspect.TempCacheGet;
import com.univ.objetspartages.om.ServiceBean;
import com.univ.portail.KportalPortletFragment;
import com.univ.portail.core.PortalEnvironment;
import com.univ.portail.core.PortletContainerFactory;
import com.univ.portail.service.registry.PortletOccurenceRegistry;
import com.univ.services.RequeteService;
import com.univ.utils.ContexteUniv;
import com.univ.utils.RequeteUtil;
import com.univ.utils.ServiceWrappedResponse;
import com.univ.utils.ServicesUtil;
import com.univ.utils.URLResolver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import javax.portlet.PortletException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.om.window.PortletWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CacheServiceViewManager {
    private static Logger LOG = LoggerFactory.getLogger(CacheServiceViewManager.class);
    public static final String ID_BEAN = "cacheServiceViewManager";

    @TempCacheGet(key="CacheServiceViewManager.getServiceView", contextual=false)
    public String getServiceView(String key, Integer expirationCache, ContexteUniv ctx, ServiceBean serviceBean, String nomVue) throws Exception {
        String ticket;
        String kticket;
        String contenu = "";
        String url = "";
        if (serviceBean.getVueReduiteType().equals("1")) {
            url = serviceBean.getVueReduiteUrl();
            if (nomVue.length() > 0) {
                url = url + (!url.contains("?") ? "?" : "&");
                url = url + "nomvue=" + nomVue;
            }
            kticket = "";
            if (serviceBean.getJetonKportal().equals("1")) {
                kticket = ServicesUtil.genererTicketService(ctx);
            }
            url = ServicesUtil.ajouterParametresService(ctx, serviceBean, url, kticket);
            if (serviceBean.getProxyCas().equals("1") && (ticket = GestionnaireIdentification.getInstance().getValidateurCAS().getProxyTicket(ctx.getCode(), ctx.getCodeGestion(), url)) != null) {
                url = url + (!url.contains("?") ? "?" : "&");
                url = url + "PT=" + ticket;
            }
        }
        if (url.length() > 0) {
            if (url.charAt(0) == '/') {
                url = URLResolver.getAbsoluteUrl(url, ctx);
            }
            LOG.debug("*** url service appel\u00e9e " + url);
            try {
                URL urlAppel = new URL(url);
                URLConnection urlConnection = urlAppel.openConnection();
                String ligne = "";
                InputStreamReader reader = null;
                if (serviceBean.getEncodage().equals("")) {
                    reader = new InputStreamReader(urlConnection.getInputStream());
                } else {
                    String encodage = "";
                    if (serviceBean.getEncodage().equals("I")) {
                        encodage = "UTF-8";
                    }
                    if (serviceBean.getEncodage().equals("U")) {
                        encodage = "UTF-8";
                    }
                    reader = new InputStreamReader(urlConnection.getInputStream(), encodage);
                }
                BufferedReader flux = new BufferedReader(reader);
                while ((ligne = flux.readLine()) != null) {
                    contenu = contenu + ligne;
                }
                flux.close();
            }
            catch (Exception e) {
                LOG.error("erreur lors de l'appel de l'url", (Throwable)e);
            }
        }
        if (serviceBean.getVueReduiteType().equals("2") && ctx.getRequeteHTTP() != null && ctx.getReponseHTTP() != null && ctx.getServletContext() != null) {
            url = serviceBean.getVueReduiteUrlCrossCtx();
            kticket = "";
            if (serviceBean.getJetonKportal().equals("1")) {
                kticket = ServicesUtil.genererTicketService(ctx);
            }
            url = ServicesUtil.ajouterParametresService(ctx, serviceBean, url, kticket);
            if (serviceBean.getProxyCas().equals("1") && (ticket = GestionnaireIdentification.getInstance().getValidateurCAS().getProxyTicket(ctx.getCode(), ctx.getCodeGestion(), url)) != null) {
                url = url + (!url.contains("?") ? "?" : "&");
                url = url + "PT=" + ticket;
            }
            HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(ctx.getRequeteHTTP());
            StringWriter storedWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(storedWriter);
            ServiceWrappedResponse wrappedResponse = new ServiceWrappedResponse(ctx.getReponseHTTP(), writer);
            ServletContext ctxServlet = ctx.getServletContext();
            if (serviceBean.getVueReduiteCtx().length() > 0) {
                ctxServlet = ctxServlet.getContext(serviceBean.getVueReduiteCtx());
            }
            RequestDispatcher rd = ctxServlet.getRequestDispatcher(url);
            LOG.debug("*** url service appel\u00e9e " + url);
            rd.include((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
            contenu = storedWriter.toString();
        }
        return contenu;
    }

    @TempCacheGet(key="CacheServiceViewManager.getServiceView", contextual=false)
    public String getPortletView(String key, Integer expirationCache, PortletWindow portletWindow, StringWriter storedWriter, HttpServletRequest wrappedRequest, HttpServletResponse wrappedResponse) throws PortletException, IOException, PortletContainerException {
        PortletContainerFactory.getPortletContainer().portletLoad(portletWindow, wrappedRequest, wrappedResponse);
        PortletContainerFactory.getPortletContainer().renderPortlet(portletWindow, wrappedRequest, wrappedResponse);
        return storedWriter.toString();
    }

    @TempCacheFlush(key="CacheServiceViewManager.getServiceView", contextual=false)
    public void flushView(String key) {
    }

    public static String getContenuPortlet(ContexteUniv ctx, ServiceBean serviceBean, String codePortlet) throws Exception {
        KportalPortletFragment fragment;
        HttpServletRequest rq = ctx.getRequeteHTTP();
        if (ctx.getRequeteHTTP().getAttribute("org.apache.pluto.portalImpl.core.PortalEnvironment") == null) {
            new PortalEnvironment(rq, ctx.getReponseHTTP());
        }
        if ((fragment = PortletOccurenceRegistry.getOccurence(codePortlet)) == null) {
            fragment = PortletOccurenceRegistry.ajouterFragment(codePortlet);
        }
        return fragment.service(ctx, serviceBean.getEncodage());
    }

    public static String getContenuPortlet(ContexteUniv ctx, ServiceBean service, PortletWindow portletWindow, StringWriter storedWriter, HttpServletRequest wrappedRequest, HttpServletResponse wrappedResponse) throws Exception {
        String key = ctx.getKsession() + "@" + service.getCode() + "@" + portletWindow.getId().toString();
        CacheServiceViewManager cacheServiceMgr = (CacheServiceViewManager)ApplicationContextManager.getCoreContextBean(ID_BEAN);
        return cacheServiceMgr.getPortletView(key, service.getExpirationCache(), portletWindow, storedWriter, wrappedRequest, wrappedResponse);
    }

    public static void suppressionCacheService(ContexteUniv _ctx, Writer writer, String _requete) throws Exception {
        LOG.debug("suppressionCacheParIdentifiantExterne cache externe ");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        String codeRetour = "0";
        String ksession = RequeteUtil.renvoyerParametre(_requete, "ksession");
        String codeService = RequeteUtil.renvoyerParametre(_requete, "service");
        ServiceBean service = ServicesUtil.getService(codeService);
        String key = ksession + "@" + codeService + "@" + service.getVueReduiteUrl();
        CacheServiceViewManager cacheServiceMgr = (CacheServiceViewManager)ApplicationContextManager.getCoreContextBean(ID_BEAN);
        cacheServiceMgr.flushView(key);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        Document document = builder.newDocument();
        Element nodeFiche = document.createElement("REPONSE_KPORTAL");
        Element nodeCodeRetour = document.createElement("CODE_RETOUR");
        nodeCodeRetour.appendChild(document.createTextNode("0"));
        nodeFiche.appendChild(nodeCodeRetour);
        document.appendChild(nodeFiche);
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(writer);
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.transform(source, result);
    }

    public static String getContenuService(ContexteUniv ctx, RequeteService requete) throws Exception {
        String contenu = "";
        if ("P".equals(requete.getService().getType())) {
            contenu = CacheServiceViewManager.getContenuPortlet(ctx, requete.getService(), requete.codePortlet());
        } else {
            String key = ctx.getKsession() + "@" + requete.getService().getCode() + "@" + requete.getVue();
            CacheServiceViewManager cacheServiceMgr = (CacheServiceViewManager)ApplicationContextManager.getCoreContextBean(ID_BEAN);
            contenu = cacheServiceMgr.getServiceView(key, requete.getService().getExpirationCache(), ctx, requete.getService(), requete.getVue());
        }
        return contenu;
    }
}

