/*
 * Decompiled with CFR 0.152.
 */
package com.univ.services;

import com.kportal.core.config.PropertyHelper;
import com.univ.services.ReponseService;
import com.univ.services.RequeteService;
import com.univ.services.ServiceThread;
import com.univ.services.ThreadsPool;
import com.univ.utils.ContexteUniv;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesInvoker {
    private static Logger LOG = LoggerFactory.getLogger(ServicesInvoker.class);
    int nbRequetesTraitees = 0;
    private static final int TIMEOUT_THREAD = 10;
    Hashtable<String, ReponseService> reponses = new Hashtable();

    public Map<String, ReponseService> executer(ContexteUniv _ctx, Map<String, RequeteService> _requetes) throws Exception {
        LOG.debug("ServicesInvoker  -- d\u00e9but");
        for (String cleRequete : _requetes.keySet()) {
            RequeteService requete = _requetes.get(cleRequete);
            this.reponses.put(cleRequete, new ReponseService());
            ServiceThread thread = new ServiceThread(this, _ctx, cleRequete, requete);
            ThreadsPool.getInstance().execute(thread);
        }
        long debut = System.currentTimeMillis();
        int timeout = 10;
        String sTimeout = PropertyHelper.getCoreProperty("services.timeout_execution");
        if (sTimeout != null) {
            timeout = Integer.parseInt(sTimeout);
        }
        while (!this.estTermine() && System.currentTimeMillis() - debut < (long)(timeout * 1000)) {
        }
        LOG.debug("ServicesInvoker  -- fin");
        return this.reponses;
    }

    protected synchronized void finRequete(String _idRequete, String _reponse) {
        this.reponses.get(_idRequete).setTerminated(true);
        this.reponses.get(_idRequete).setReponse(_reponse);
        ++this.nbRequetesTraitees;
    }

    private synchronized boolean estTermine() throws Exception {
        boolean res;
        boolean bl = res = this.nbRequetesTraitees == this.reponses.size();
        if (!res) {
            this.wait(100L);
        }
        return res;
    }
}

