/*
 * Decompiled with CFR 0.152.
 */
package com.univ.services;

import com.kportal.core.config.PropertyHelper;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadsPool {
    private static Logger LOG = LoggerFactory.getLogger(ThreadsPool.class);
    private static ThreadsPool INSTANCE = null;
    private static final int MAX_THREADS_DEFAUT = 50;
    private static final int MIN_THREADS_DEFAUT = 10;
    private static final int MAX_REQUETES_ATTENTE = 100;
    private static final int KEEP_ALIVE_TIME = 30000;
    private final ThreadPoolExecutor pool;

    public static ThreadsPool getInstance() {
        if (INSTANCE == null) {
            INSTANCE = ThreadsPool.createInstance();
        }
        return INSTANCE;
    }

    public static synchronized ThreadsPool createInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ThreadsPool();
        }
        return INSTANCE;
    }

    private ThreadsPool() {
        int maxThreads = 50;
        String sMaxThreads = PropertyHelper.getCoreProperty("services.max_threads");
        if (sMaxThreads != null) {
            maxThreads = Integer.parseInt(sMaxThreads);
        }
        int minThreads = 10;
        String sMinThreads = PropertyHelper.getCoreProperty("services.min_thread");
        if (sMinThreads != null) {
            minThreads = Integer.parseInt(sMinThreads);
        }
        int tailleQueue = 100;
        String sTailleQueue = PropertyHelper.getCoreProperty("services.nb_max_requetes_attente");
        if (sTailleQueue != null) {
            tailleQueue = Integer.parseInt(sTailleQueue);
        }
        LOG.debug("Cr\u00e9ation pool threads maxThreads=" + maxThreads + " minThreads=" + minThreads + " tailleQueue=" + tailleQueue);
        ArrayBlockingQueue<Runnable> workingQueue = new ArrayBlockingQueue<Runnable>(tailleQueue);
        this.pool = new ThreadPoolExecutor(minThreads, maxThreads, 30000L, TimeUnit.MILLISECONDS, workingQueue);
    }

    public void execute(Runnable service) throws Exception {
        this.pool.execute(service);
    }
}

