/*
 * Decompiled with CFR 0.152.
 */
package com.univ.synchro;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.database.OMContext;
import com.kportal.core.config.PropertyHelper;
import com.univ.objetspartages.cache.CacheGroupeDsiManager;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.StructureModele;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchroGroupedsiStructure {
    private static Logger LOG = LoggerFactory.getLogger(SynchroGroupedsiStructure.class);
    private static final String PARAM_JTF_SYNCHRO_GROUPESDSI = "static.synchro_struct_groupesdsi";
    private static final String PARAM_JTF_DSI = "dsi.activation";

    public static void synchroniserGroupeDsi(OMContext ctx, StructureModele structure) {
        SynchroGroupedsiStructure.synchroniserGroupeDsi(ctx, structure, false);
    }

    public static void synchroniserGroupeDsi(OMContext ctx, StructureModele structure, boolean isImport) {
        String paramDsi;
        boolean bSynchroCreationGroupesDSI = true;
        String paramSynchro = PropertyHelper.getCoreProperty(PARAM_JTF_SYNCHRO_GROUPESDSI);
        if (paramSynchro != null) {
            bSynchroCreationGroupesDSI = paramSynchro.startsWith("1");
        }
        if ((paramDsi = PropertyHelper.getCoreProperty(PARAM_JTF_DSI)) == null || !paramDsi.equals("1")) {
            bSynchroCreationGroupesDSI = false;
        }
        try {
            if (bSynchroCreationGroupesDSI) {
                int count;
                Groupedsi groupedsi = new Groupedsi();
                groupedsi.setCtx(ctx);
                groupedsi.init();
                String typeGroupeStructure = "STRUCT";
                String codeGroupeStructure = "STRUCT_" + structure.getCode();
                String codeRattachement = structure.getCodeRattachement();
                if (codeRattachement.equals("00")) {
                    codeRattachement = "";
                }
                if (codeRattachement.length() > 0) {
                    codeRattachement = "STRUCT_" + codeRattachement;
                }
                if ((count = groupedsi.select(codeGroupeStructure, "", "", "", "")) == 0) {
                    groupedsi.init();
                    groupedsi.setCode(codeGroupeStructure);
                    groupedsi.setCodeGroupePere(codeRattachement);
                    String libelle = structure.getLibelleCourt();
                    if (libelle.length() == 0) {
                        libelle = structure.getLibelleLong();
                    }
                    groupedsi.setLibelle(libelle);
                    groupedsi.setType("STRUCT");
                    groupedsi.setCodeStructure(structure.getCode());
                    groupedsi.add();
                } else {
                    groupedsi.nextItem();
                    groupedsi.setCodeGroupePere(codeRattachement);
                    groupedsi.update();
                }
                if (!isImport) {
                    CacheGroupeDsiManager cache = (CacheGroupeDsiManager)ApplicationContextManager.getCoreContextBean("cacheGroupeDsiManager");
                    cache.flush();
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception pendant synchroniserGroupeDsi :" + structure.getClass() + ", code : " + structure.getCode() + " langue : " + structure.getLangue(), (Throwable)e);
        }
    }
}

