/*
 * Decompiled with CFR 0.152.
 */
package com.univ.tree.processus;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.exception.ErreurAsyncException;
import com.kportal.core.config.MessageHelper;
import com.univ.objetspartages.cache.CacheGroupeDsiManager;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.Groupeutilisateur;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Structure;
import com.univ.tree.bean.JsTreeDataModel;
import com.univ.tree.bean.JsTreeModel;
import com.univ.tree.bean.JsTreeNodeModel;
import com.univ.tree.bean.JsTreePath;
import com.univ.tree.processus.GestionJsTree;
import com.univ.tree.utils.JsTreeUtils;
import com.univ.utils.ContexteUtil;
import com.univ.utils.SessionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupsJsTree
extends GestionJsTree<Groupedsi> {
    private final CacheGroupeDsiManager cache = (CacheGroupeDsiManager)ApplicationContextManager.getCoreContextBean("cacheGroupeDsiManager");
    public static final String ID_BEAN = "groupsJsTree";
    private static final Logger LOG = LoggerFactory.getLogger(GroupsJsTree.class);

    @Override
    public JsTreeModel traiterDepuisRequete(HttpServletRequest req) {
        AutorisationBean autorisations = (AutorisationBean)SessionUtil.getInfosSession(req).get("AUTORISATIONS");
        JsTreeModel jsTree = new JsTreeModel();
        try {
            HashMap<String, String> parameters = JsTreeUtils.getParameters(req);
            this.assertParametersConsistency(parameters);
            String permissions = parameters.get("PERMISSION");
            CacheGroupeDsiManager cache = (CacheGroupeDsiManager)ApplicationContextManager.getCoreContextBean("cacheGroupeDsiManager");
            InfosGroupeDsi groupe = cache.getListeGroupesDsi().get(parameters.get("RACINE"));
            int niveau = Integer.parseInt(parameters.get("NIVEAU"));
            String[] selection = StringUtils.defaultString((String)parameters.get("SELECTED")).split(";");
            boolean locked_dyn = Boolean.parseBoolean(StringUtils.defaultString((String)parameters.get("LOCK_DYN"), (String)"false"));
            jsTree.getNodes().add(GroupsJsTree.buildGroupeNode(autorisations, permissions, groupe, niveau, null, locked_dyn));
            if (selection.length > 0) {
                this.loadToPath(autorisations, permissions, jsTree, selection, locked_dyn);
            }
        }
        catch (Exception e) {
            LOG.error("impossible de generer l'arborescence des groupes", (Throwable)e);
            jsTree = new JsTreeModel();
        }
        return jsTree;
    }

    private void loadToPath(AutorisationBean autorisations, String permissions, JsTreeModel jsTree, String[] selection, boolean locked_dyn) {
        ArrayList<String> loadedNodes = new ArrayList<String>();
        for (String code : selection) {
            try {
                JsTreeNodeModel parentNode;
                JsTreePath path = this.getPathToCode(code);
                if (path == null) continue;
                Iterator<String> codeIt = path.getChildPath().iterator();
                HashSet<String> nodes = new HashSet<String>();
                String topCode = codeIt.next();
                nodes.addAll(path.getChildPath());
                if (!loadedNodes.isEmpty()) {
                    while (loadedNodes.contains(topCode) && codeIt.hasNext()) {
                        topCode = codeIt.next();
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)topCode) || (parentNode = JsTreeUtils.getNodeWithCode(jsTree.getNodes().get(0), topCode)) == null || !CollectionUtils.isEmpty(parentNode.getChildren())) continue;
                InfosGroupeDsi parent = Groupedsi.renvoyerItemGroupeDsi(topCode);
                parentNode.getChildren().addAll(GroupsJsTree.buildGroupeNode(autorisations, permissions, parent, -2, nodes, locked_dyn).getChildren());
                loadedNodes.addAll(nodes);
            }
            catch (Exception e) {
                LOG.error("An error occured trying to get OpenPath for group tree", (Throwable)e);
            }
        }
    }

    private JsTreePath getPathToCode(String code) throws Exception {
        JsTreePath path = new JsTreePath();
        InfosGroupeDsi child = Groupedsi.renvoyerItemGroupeDsi(code);
        path.addChild(code);
        for (InfosGroupeDsi parent = child.getGroupePere(); parent != null && !parent.getCode().equals("00"); parent = parent.getGroupePere()) {
            path.addChild(parent.getCode());
        }
        return path;
    }

    private static JsTreeNodeModel buildGroupeNode(AutorisationBean autorisations, String permissions, InfosGroupeDsi groupe, int niveau, Set<String> ids, boolean locked_dyn) throws Exception {
        JsTreeNodeModel node;
        block10: {
            Iterator<InfosGroupeDsi> listSousGroupeIt;
            block11: {
                node = null;
                listSousGroupeIt = groupe.getListeSousGroupesSortedByLibelle().iterator();
                boolean selectable = JsTreeUtils.isGroupeSelectable(permissions, autorisations, groupe, ids);
                boolean isDynamicGroup = StringUtils.isNotBlank((CharSequence)groupe.getRequete());
                if (!JsTreeUtils.isGroupeVisible(permissions, autorisations, groupe, selectable, ids)) break block10;
                node = new JsTreeNodeModel();
                JsTreeDataModel datas = new JsTreeDataModel();
                if (groupe.getCode().equals("00")) {
                    datas.setTitle(" ");
                    node.getAttr().put("rel", "root");
                    node.getAttr().put("class", "groupe_root");
                    if (groupe.getListeSousGroupes().size() > 0) {
                        node.setState("open");
                    }
                } else {
                    if (!selectable) {
                        node.getAttr().put("rel", "not_selectable");
                    }
                    if (isDynamicGroup && locked_dyn) {
                        node.getAttr().put("rel", "locked");
                    }
                    datas.setTitle(groupe.getIntitule());
                    node.getAttr().put("class", "groupe_" + groupe.getType());
                    node.getAttr().put("title", groupe.getIntitule());
                    node.getMetadata().put("libelle", groupe.getIntitule());
                    node.getMetadata().put("sCode", groupe.getCode());
                    node.getMetadata().put("idGroupeDsi", groupe.getId().toString());
                    node.getMetadata().put("type", Libelle.getLibelle("11", groupe.getType(), LangueUtil.getDefaultLocale()));
                    node.getMetadata().put("structure", Structure.getLibelleAffichable(groupe.getCodeStructure(), "0"));
                    if (groupe.getListeSousGroupes().size() > 0 && GroupsJsTree.hasVisibleChildren(permissions, autorisations, groupe, ids)) {
                        node.setState("closed");
                    }
                }
                node.getMetadata().put("numchildren", Integer.toString(groupe.getListeSousGroupes().size()));
                node.getAttr().put("id", Long.toString(groupe.getId()));
                node.setData(datas);
                if (niveau <= 0 && niveau != -1) break block11;
                while (listSousGroupeIt.hasNext()) {
                    JsTreeNodeModel child;
                    InfosGroupeDsi sousGroupe = listSousGroupeIt.next();
                    if (niveau != -1) {
                        --niveau;
                    }
                    if ((child = GroupsJsTree.buildGroupeNode(autorisations, permissions, sousGroupe, niveau, ids, locked_dyn)) != null) {
                        node.getChildren().add(child);
                    }
                    if (niveau == -1) continue;
                    ++niveau;
                }
                break block10;
            }
            if (niveau != -2) break block10;
            while (listSousGroupeIt.hasNext()) {
                JsTreeNodeModel child = null;
                InfosGroupeDsi sousGroupe = listSousGroupeIt.next();
                child = !ids.contains(sousGroupe.getCode()) ? GroupsJsTree.buildGroupeNode(autorisations, permissions, sousGroupe, 0, null, locked_dyn) : GroupsJsTree.buildGroupeNode(autorisations, permissions, sousGroupe, niveau, ids, locked_dyn);
                if (child == null) continue;
                node.getChildren().add(child);
            }
        }
        return node;
    }

    @Override
    public void assertParametersConsistency(Map<String, String> parameters) throws Exception {
        if (parameters.get("CODE") == null || parameters.get("CODE").length() == 0) {
            parameters.put("CODE", "00");
        }
        if (parameters.get("RACINE") == null || parameters.get("RACINE").length() == 0) {
            parameters.put("RACINE", "00");
        }
    }

    @Override
    public JsTreeModel traiterRechercheDepuisRequete(HttpServletRequest req) {
        AutorisationBean autorisations = (AutorisationBean)SessionUtil.getInfosSession(req).get("AUTORISATIONS");
        JsTreeModel jsTree = new JsTreeModel();
        try {
            HashMap<String, String> parameters = JsTreeUtils.getParameters(req);
            this.assertParametersConsistency(parameters);
            Groupedsi groupe = new Groupedsi();
            groupe.setCtx(ContexteUtil.getContexteUniv());
            groupe.select(req.getParameter("CODE_RECHERCHE"), req.getParameter("TYPE"), req.getParameter("LIBELLE"), req.getParameter("CODE_STRUCTURE"), null);
            jsTree = this.filterTree(autorisations, groupe, parameters);
        }
        catch (Exception e) {
            LOG.error("impossible de generer l'arborescence des rubriques", (Throwable)e);
            jsTree = new JsTreeModel();
        }
        return jsTree;
    }

    @Override
    public JsTreeModel traiterFiltreDepuisRequete(HttpServletRequest req) {
        AutorisationBean autorisations = (AutorisationBean)SessionUtil.getInfosSession(req).get("AUTORISATIONS");
        JsTreeModel jsTree = new JsTreeModel();
        String query = StringUtils.defaultString((String)req.getParameter("QUERY"), (String)"");
        try {
            HashMap<String, String> parameters = JsTreeUtils.getParameters(req);
            this.assertParametersConsistency(parameters);
            parameters.put("NIVEAU", "-1");
            Groupedsi groupeFiltrage = new Groupedsi();
            groupeFiltrage.init();
            groupeFiltrage.setCtx(ContexteUtil.getContexteUniv());
            groupeFiltrage.selectNoCount("WHERE LIBELLE like '%" + query + "%'");
            jsTree = this.filterTree(autorisations, groupeFiltrage, parameters);
            this.openAllNodes(jsTree.getNodes());
        }
        catch (Exception e) {
            LOG.error(String.format("An error occured trying to filter Rubrique tree for query \"%s\"", query), (Throwable)e);
        }
        return jsTree;
    }

    @Override
    public String traiterAction(AutorisationBean autorisations, Map<String, String[]> parametresDeLaRequete) {
        String[] ids;
        String action = "";
        String message = "";
        if (parametresDeLaRequete.get("ACTION") != null) {
            action = parametresDeLaRequete.get("ACTION")[0];
        }
        if (action.equals("SUPPRIMER") && (ids = parametresDeLaRequete.get("IDS_GROUPE[]")) != null) {
            for (String currentId : ids) {
                Groupedsi groupedsi = new Groupedsi();
                groupedsi.setCtx(ContexteUtil.getContexteUniv());
                groupedsi.setIdGroupedsi(Long.valueOf(currentId));
                try {
                    groupedsi.retrieve();
                    String libelleGroupe = groupedsi.getLibelle();
                    message = String.format(MessageHelper.getCoreMessage("BO_SERVICES_ARBRE_SUPPRESSION_OK"), String.format(MessageHelper.getCoreMessage("BO_SERVICES_ARBRE_GROUP"), libelleGroupe));
                    this.traiterSuppression(groupedsi);
                }
                catch (Exception e) {
                    LOG.error("la suppression du groupe a echouee", (Throwable)e);
                    throw new ErreurAsyncException(e.getMessage());
                }
            }
        }
        return message;
    }

    private void traiterSuppression(Groupedsi groupedsi) throws Exception {
        groupedsi.delete();
        Groupeutilisateur.deleteParGroupe(ContexteUtil.getContexteUniv(), groupedsi.getCode());
        this.cache.flush();
    }

    public static String getPath(String root, String code, String separator) {
        ArrayList<String> path = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)root)) {
            root = "00";
        }
        if (StringUtils.isBlank((CharSequence)code)) {
            return root;
        }
        try {
            InfosGroupeDsi groupe = Groupedsi.renvoyerItemGroupeDsi(code);
            while (StringUtils.isNotBlank((CharSequence)groupe.getCode()) && !root.equals(groupe.getCode())) {
                path.add(groupe.getIntitule());
                groupe = Groupedsi.renvoyerItemGroupeDsi(groupe.getCodeGroupePere());
            }
        }
        catch (Exception e) {
            LOG.error(String.format("An error occured trying to compute Group tree path to element %s from %s", code, root), (Throwable)e);
        }
        Collections.reverse(path);
        return StringUtils.join(path, (String)separator);
    }

    @Override
    protected JsTreeModel filterTree(AutorisationBean autorisations, Groupedsi groupe, HashMap<String, String> parameters) {
        JsTreeModel jsTree = new JsTreeModel();
        try {
            String permissions = parameters.get("PERMISSION");
            InfosGroupeDsi groupeRacine = Groupedsi.renvoyerItemGroupeDsi(parameters.get("RACINE"));
            int niveau = Integer.parseInt(parameters.get("NIVEAU"));
            boolean locked_dyn = Boolean.parseBoolean(StringUtils.defaultString((String)parameters.get("LOCK_DYN"), (String)"false"));
            HashSet<String> ids = new HashSet<String>();
            while (groupe.nextItem() && !groupe.getCode().equals(parameters.get("CODE"))) {
                ids.add(groupe.getCode());
                InfosGroupeDsi groupePere = Groupedsi.renvoyerItemGroupeDsi(groupe.getCodeGroupePere());
                while (StringUtils.isNotBlank((CharSequence)groupePere.getCode())) {
                    ids.add(groupePere.getCode());
                    groupePere = Groupedsi.renvoyerItemGroupeDsi(groupePere.getCodeGroupePere());
                }
            }
            if (ids.isEmpty()) {
                return jsTree;
            }
            ids.add("00");
            jsTree.getNodes().add(GroupsJsTree.buildGroupeNode(autorisations, permissions, groupeRacine, niveau, ids, locked_dyn));
            return jsTree;
        }
        catch (Exception e) {
            LOG.error("impossible de generer l'arborescence des rubriques", (Throwable)e);
            jsTree = new JsTreeModel();
            return jsTree;
        }
    }

    private static boolean hasVisibleChildren(String permissions, AutorisationBean autorisations, InfosGroupeDsi groupe, Set<String> ids) {
        for (InfosGroupeDsi currentChild : groupe.getListeSousGroupes()) {
            try {
                boolean selectable = JsTreeUtils.isGroupeSelectable(permissions, autorisations, currentChild, ids);
                boolean visible = JsTreeUtils.isGroupeVisible(permissions, autorisations, currentChild, selectable, ids);
                if (!visible) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    @Override
    public String getSelectedIds(String string) {
        String[] selections;
        if (StringUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        ArrayList<String> selectedIds = new ArrayList<String>();
        for (String currentSelection : selections = string.split(";")) {
            try {
                InfosGroupeDsi groupe = Groupedsi.renvoyerItemGroupeDsi(currentSelection);
                if (groupe == null || !StringUtils.isNotBlank((CharSequence)groupe.getCode())) continue;
                selectedIds.add(Long.toString(groupe.getId()));
            }
            catch (Exception e) {
                LOG.error("An error occured trying to retrieve Rubrique", (Throwable)e);
            }
        }
        return StringUtils.join(selectedIds, (String)";");
    }
}

