/*
 * Decompiled with CFR 0.152.
 */
package com.univ.tree.processus;

import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Rubrique;
import com.univ.tree.bean.JsTreeDataModel;
import com.univ.tree.bean.JsTreeNodeModel;
import com.univ.tree.processus.RubriquesJsTree;
import com.univ.tree.utils.JsTreeUtils;
import com.univ.utils.EscapeString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RubriqueJsTreeProcessus
extends RubriquesJsTree {
    private static final Logger LOG = LoggerFactory.getLogger(RubriqueJsTreeProcessus.class);
    public static final String ID_BEAN = "rubriqueJsTreeProcessus";
    private static final String PERMISSION_MODIFICATION = "/TECH/rub/M";
    private static final String PERMISSION_SUPPRESSION = "/TECH/rub/S";

    @Override
    protected JsTreeNodeModel buildRubriqueNode(AutorisationBean autorisations, String permissions, InfosRubriques rubrique, int niveau, Set<String> ids) throws Exception {
        JsTreeNodeModel node;
        block11: {
            JsTreeNodeModel child;
            InfosRubriques sousRubrique;
            Iterator<InfosRubriques> listSousRubriquesIt;
            block12: {
                node = null;
                listSousRubriquesIt = rubrique.getListeSousRubriques().iterator();
                sousRubrique = null;
                boolean selectable = RubriqueJsTreeProcessus.isRubriqueSelectable(autorisations, rubrique, ids);
                if (!RubriqueJsTreeProcessus.isRubriqueVisible(autorisations, rubrique, ids, selectable)) break block11;
                node = new JsTreeNodeModel();
                JsTreeDataModel datas = new JsTreeDataModel();
                if (rubrique.getCode().equals("00")) {
                    datas.setTitle(" ");
                    node.getAttr().put("rel", "root");
                    node.getAttr().put("class", "rubrique_root");
                    node.setState("open");
                } else {
                    ArrayList<String> groups = new ArrayList<String>();
                    for (String groupCode : rubrique.getGroupesDsi()) {
                        InfosGroupeDsi infos = Groupedsi.renvoyerItemGroupeDsi(groupCode);
                        if (!StringUtils.isNotBlank((CharSequence)infos.getCode())) continue;
                        groups.add(infos.getIntitule());
                    }
                    if (!selectable) {
                        node.getAttr().put("rel", "not_selectable");
                    } else {
                        InfosSite infos = Site.renvoyerItemSiteParRubrique(rubrique.getCode());
                        if (infos != null) {
                            node.getAttr().put("rel", "rubrique_site");
                        }
                    }
                    String restrained = StringUtils.join(groups, (String)" ,");
                    StringBuffer cssClass = new StringBuffer(EscapeString.escapeAttributHtml("rubrique_" + rubrique.getTypeRubrique()));
                    cssClass.append(rubrique.getGroupesDsi().size() > 0 ? " restrained" : "");
                    StringBuffer finalTitle = new StringBuffer(rubrique.getIntitule());
                    finalTitle.append(StringUtils.isNotBlank((CharSequence)restrained) ? " (diffusion restreinte : " + restrained + " )" : "");
                    datas.setTitle(rubrique.getIntitule());
                    node.getAttr().put("class", cssClass.toString());
                    node.getAttr().put("title", finalTitle.toString());
                    node.getMetadata().put("libelle", rubrique.getIntitule());
                    node.getMetadata().put("sCode", rubrique.getCode());
                    node.getMetadata().put("idRubrique", rubrique.getIdRubrique().toString());
                    node.getMetadata().put("sCodeMere", rubrique.getCodeRubriqueMere());
                    node.getMetadata().put("libelleMere", Rubrique.getIntituleComplet(rubrique.getCode(), false));
                    node.getMetadata().put("langue", rubrique.getLangue());
                    if (rubrique.getListeSousRubriques().size() > 0 && RubriqueJsTreeProcessus.hasVisibleChildren(permissions, autorisations, rubrique, ids)) {
                        node.setState("closed");
                    }
                }
                node.getMetadata().put("numchildren", Integer.toString(rubrique.getListeSousRubriques().size()));
                node.getAttr().put("id", Long.toString(rubrique.getIdRubrique()));
                node.setData(datas);
                if (niveau <= 0 && niveau != -1) break block12;
                while (listSousRubriquesIt.hasNext()) {
                    sousRubrique = listSousRubriquesIt.next();
                    if (niveau != -1) {
                        --niveau;
                    }
                    if ((child = this.buildRubriqueNode(autorisations, permissions, sousRubrique, niveau, ids)) != null) {
                        node.getChildren().add(child);
                    }
                    if (niveau == -1) continue;
                    ++niveau;
                }
                break block11;
            }
            if (niveau != -2) break block11;
            while (listSousRubriquesIt.hasNext()) {
                sousRubrique = listSousRubriquesIt.next();
                child = !ids.contains(sousRubrique.getCode()) ? this.buildRubriqueNode(autorisations, permissions, sousRubrique, 0, null) : this.buildRubriqueNode(autorisations, permissions, sousRubrique, niveau, ids);
                if (child == null) continue;
                node.getChildren().add(child);
            }
        }
        return node;
    }

    private static boolean isRubriqueVisible(AutorisationBean autorisations, InfosRubriques rubrique, Set<String> ids, boolean selectable) {
        try {
            return JsTreeUtils.isRubriqueVisible(PERMISSION_MODIFICATION, autorisations, rubrique, selectable, ids) || JsTreeUtils.isRubriqueVisible(PERMISSION_SUPPRESSION, autorisations, rubrique, selectable, ids);
        }
        catch (Exception e) {
            LOG.info("impossible de savoir si la rubrique est visible pour l'arbre du processus", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    private static boolean isRubriqueSelectable(AutorisationBean autorisations, InfosRubriques rubrique, Set<String> ids) {
        try {
            return JsTreeUtils.isRubriqueSelectable(PERMISSION_MODIFICATION, autorisations, rubrique, ids) || JsTreeUtils.isRubriqueSelectable(PERMISSION_SUPPRESSION, autorisations, rubrique, ids);
        }
        catch (Exception e) {
            LOG.info("impossible de savoir si la rubrique est selectionnable pour l'arbre du processus", (Throwable)e);
            return Boolean.FALSE;
        }
    }
}

