/*
 * Decompiled with CFR 0.152.
 */
package com.univ.tree.processus;

import com.jsbsoft.jtf.exception.ErreurAsyncException;
import com.kportal.core.config.MessageHelper;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.InfosGroupeDsi;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.Rubrique;
import com.univ.tree.bean.JsTreeDataModel;
import com.univ.tree.bean.JsTreeModel;
import com.univ.tree.bean.JsTreeNodeModel;
import com.univ.tree.bean.JsTreePath;
import com.univ.tree.processus.GestionJsTree;
import com.univ.tree.utils.JsTreeUtils;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.EscapeString;
import com.univ.utils.SessionUtil;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RubriquesJsTree
extends GestionJsTree<Rubrique> {
    public static final String ID_BEAN = "rubriquesJsTree";
    private static Logger LOG = LoggerFactory.getLogger(RubriquesJsTree.class);

    @Override
    public JsTreeModel traiterDepuisRequete(HttpServletRequest req) {
        AutorisationBean autorisations = (AutorisationBean)SessionUtil.getInfosSession(req).get("AUTORISATIONS");
        JsTreeModel jsTree = new JsTreeModel();
        try {
            HashMap<String, String> parameters = JsTreeUtils.getParameters(req);
            this.assertParametersConsistency(parameters);
            String permissions = parameters.get("PERMISSION");
            InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(parameters.get("RACINE"));
            int niveau = Integer.parseInt(parameters.get("NIVEAU"));
            String[] selection = StringUtils.defaultString((String)parameters.get("SELECTED")).split(";");
            JsTreeNodeModel node = this.buildRubriqueNode(autorisations, permissions, rubrique, niveau, null);
            if (node != null) {
                jsTree.getNodes().add(node);
            }
            if (selection.length > 0) {
                this.loadToPath(autorisations, permissions, jsTree, selection);
            }
        }
        catch (Exception e) {
            LOG.error("Impossible de generer l'arborescence des rubriques", (Throwable)e);
            jsTree = new JsTreeModel();
        }
        return jsTree;
    }

    private void loadToPath(AutorisationBean autorisations, String permissions, JsTreeModel jsTree, String[] selection) {
        HashSet<String> loadedNodes = new HashSet<String>();
        for (String code : selection) {
            try {
                JsTreeNodeModel nodeModel;
                JsTreePath path = this.getPathToCode(code);
                Iterator<String> codeIt = path.getChildPath().iterator();
                HashSet<String> nodes = new HashSet<String>();
                String topCode = codeIt.next();
                nodes.addAll(path.getChildPath());
                if (!loadedNodes.isEmpty()) {
                    while (loadedNodes.contains(topCode) && codeIt.hasNext()) {
                        topCode = codeIt.next();
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)topCode)) continue;
                JsTreeNodeModel parentNode = JsTreeUtils.getNodeWithCode(jsTree.getNodes().get(0), topCode);
                InfosRubriques parent = Rubrique.renvoyerItemRubrique(topCode);
                if (parentNode != null && CollectionUtils.isEmpty(parentNode.getChildren()) && (nodeModel = this.buildRubriqueNode(autorisations, permissions, parent, -2, nodes)) != null && nodeModel.getChildren() != null) {
                    parentNode.getChildren().addAll(nodeModel.getChildren());
                }
                loadedNodes.addAll(nodes);
            }
            catch (Exception e) {
                LOG.error("An error occured trying to get OpenPath for rubrique tree", (Throwable)e);
            }
        }
    }

    private JsTreePath getPathToCode(String code) throws Exception {
        JsTreePath path = new JsTreePath();
        InfosRubriques child = Rubrique.renvoyerItemRubrique(code);
        path.addChild(code);
        for (InfosRubriques parent = child.getRubriqueMere(); parent != null && !parent.getCode().equals("00"); parent = parent.getRubriqueMere()) {
            path.addChild(parent.getCode());
        }
        return path;
    }

    protected JsTreeNodeModel buildRubriqueNode(AutorisationBean autorisations, String permissions, InfosRubriques rubrique, int niveau, Set<String> ids) throws Exception {
        JsTreeNodeModel node;
        block12: {
            JsTreeNodeModel child;
            InfosRubriques sousRubrique;
            Iterator<InfosRubriques> listSousRubriquesIt;
            block13: {
                node = null;
                listSousRubriquesIt = rubrique.getListeSousRubriques().iterator();
                sousRubrique = null;
                boolean selectable = JsTreeUtils.isRubriqueSelectable(permissions, autorisations, rubrique, ids);
                if (!JsTreeUtils.isRubriqueVisible(permissions, autorisations, rubrique, selectable, ids)) break block12;
                node = new JsTreeNodeModel();
                JsTreeDataModel datas = new JsTreeDataModel();
                if (rubrique.getCode().equals("00")) {
                    datas.setTitle(" ");
                    node.getAttr().put("rel", "root");
                    node.getAttr().put("class", "rubrique_root");
                    if (rubrique.getListeSousRubriques().size() > 0) {
                        node.setState("open");
                    }
                } else {
                    ArrayList<String> groups = new ArrayList<String>();
                    for (String groupCode : rubrique.getGroupesDsi()) {
                        InfosGroupeDsi infos = Groupedsi.renvoyerItemGroupeDsi(groupCode);
                        if (!StringUtils.isNotBlank((CharSequence)infos.getCode())) continue;
                        groups.add(infos.getIntitule());
                    }
                    if (!selectable) {
                        node.getAttr().put("rel", "not_selectable");
                    } else {
                        InfosSite infos = Site.renvoyerItemSiteParRubrique(rubrique.getCode());
                        if (infos != null) {
                            node.getAttr().put("rel", "rubrique_site");
                        }
                    }
                    String restrained = StringUtils.join(groups, (String)" ,");
                    StringBuffer cssClass = new StringBuffer(EscapeString.escapeAttributHtml("rubrique_" + rubrique.getTypeRubrique()));
                    cssClass.append(rubrique.getGroupesDsi().size() > 0 ? " restrained" : "");
                    StringBuffer finalTitle = new StringBuffer(rubrique.getIntitule());
                    finalTitle.append(StringUtils.isNotBlank((CharSequence)restrained) ? " (diffusion restreinte : " + restrained + " )" : "");
                    datas.setTitle(rubrique.getIntitule());
                    node.getAttr().put("class", cssClass.toString());
                    node.getAttr().put("title", finalTitle.toString());
                    node.getMetadata().put("libelle", rubrique.getIntitule());
                    node.getMetadata().put("sCode", rubrique.getCode());
                    node.getMetadata().put("idRubrique", rubrique.getIdRubrique().toString());
                    node.getMetadata().put("sCodeMere", rubrique.getCodeRubriqueMere());
                    node.getMetadata().put("libelleMere", Rubrique.getIntituleComplet(rubrique.getCode(), false));
                    node.getMetadata().put("langue", rubrique.getLangue());
                    if (rubrique.getListeSousRubriques().size() > 0 && RubriquesJsTree.hasVisibleChildren(permissions, autorisations, rubrique, ids)) {
                        node.setState("closed");
                    }
                }
                node.getMetadata().put("numchildren", Integer.toString(rubrique.getListeSousRubriques().size()));
                node.getAttr().put("id", Long.toString(rubrique.getIdRubrique()));
                node.setData(datas);
                if (niveau <= 0 && niveau != -1) break block13;
                while (listSousRubriquesIt.hasNext()) {
                    sousRubrique = listSousRubriquesIt.next();
                    if (niveau != -1) {
                        --niveau;
                    }
                    if ((child = this.buildRubriqueNode(autorisations, permissions, sousRubrique, niveau, ids)) != null) {
                        node.getChildren().add(child);
                    }
                    if (niveau == -1) continue;
                    ++niveau;
                }
                break block12;
            }
            if (niveau != -2) break block12;
            while (listSousRubriquesIt.hasNext()) {
                child = null;
                sousRubrique = listSousRubriquesIt.next();
                child = !ids.contains(sousRubrique.getCode()) ? this.buildRubriqueNode(autorisations, permissions, sousRubrique, 0, null) : this.buildRubriqueNode(autorisations, permissions, sousRubrique, niveau, ids);
                if (child == null) continue;
                node.getChildren().add(child);
            }
        }
        return node;
    }

    protected static boolean hasVisibleChildren(String permissions, AutorisationBean autorisations, InfosRubriques rubrique, Set<String> ids) {
        for (InfosRubriques currentChild : rubrique.getListeSousRubriques()) {
            boolean selectable = false;
            boolean visible = false;
            try {
                selectable = JsTreeUtils.isRubriqueSelectable(permissions, autorisations, currentChild, ids);
                visible = JsTreeUtils.isRubriqueVisible(permissions, autorisations, currentChild, selectable, ids);
                if (!visible) continue;
                return true;
            }
            catch (Exception e) {
                LOG.error(String.format("An error occured trying to determine if rubrique \"%s\" has visible children", rubrique.getLibelleAffichable()), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public JsTreeModel traiterRechercheDepuisRequete(HttpServletRequest req) {
        AutorisationBean autorisations = (AutorisationBean)SessionUtil.getInfosSession(req).get("AUTORISATIONS");
        JsTreeModel jsTree = new JsTreeModel();
        try {
            HashMap<String, String> parameters = JsTreeUtils.getParameters(req);
            this.assertParametersConsistency(parameters);
            Rubrique rubrique = new Rubrique();
            rubrique.setCtx(ContexteUtil.getContexteUniv());
            rubrique.select(req.getParameter("CODE_RECHERCHE"), req.getParameter("LANGUE"), req.getParameter("INTITULE"), req.getParameter("CODE_SAISI"));
            jsTree = this.filterTree(autorisations, rubrique, parameters);
        }
        catch (Exception e) {
            LOG.error("impossible de generer l'arborescence des rubriques", (Throwable)e);
            jsTree = new JsTreeModel();
        }
        return jsTree;
    }

    @Override
    protected JsTreeModel filterTree(AutorisationBean autorisations, Rubrique rubrique, HashMap<String, String> parameters) {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        JsTreeModel jsTree = new JsTreeModel();
        try {
            String permissions = parameters.get("PERMISSION");
            InfosRubriques rubriqueRacine = Rubrique.renvoyerItemRubrique(parameters.get("RACINE"));
            int niveau = Integer.parseInt(parameters.get("NIVEAU"));
            HashSet<String> ids = new HashSet<String>();
            while (rubrique.nextItem()) {
                if (rubrique.getCode().equals(parameters.get("CODE"))) continue;
                ids.add(rubrique.getCode());
                InfosRubriques rubriqueMere = Rubrique.renvoyerItemRubrique(rubrique.getCodeRubriqueMere());
                while (StringUtils.isNotBlank((CharSequence)rubriqueMere.getCode())) {
                    ids.add(rubriqueMere.getCode());
                    rubriqueMere = Rubrique.renvoyerItemRubrique(rubriqueMere.getCodeRubriqueMere());
                }
            }
            if (ids.isEmpty()) {
                return jsTree;
            }
            ids.add("00");
            jsTree.getNodes().add(this.buildRubriqueNode(autorisations, permissions, rubriqueRacine, niveau, ids));
            return jsTree;
        }
        catch (Exception e) {
            LOG.error("impossible de generer l'arborescence des rubriques", (Throwable)e);
            jsTree = new JsTreeModel();
            return jsTree;
        }
    }

    @Override
    public void assertParametersConsistency(Map<String, String> parameters) throws Exception {
        if (parameters.get("RACINE") == null || parameters.get("RACINE").length() == 0) {
            parameters.put("RACINE", "00");
        }
        if (parameters.get("CODE") == null || parameters.get("CODE").length() == 0) {
            parameters.put("CODE", parameters.get("RACINE"));
        }
        if (!parameters.get("RACINE").equals("00") && !parameters.get("RACINE").equals(parameters.get("CODE")) && Rubrique.renvoyerItemRubrique(parameters.get("CODE")).contains(Rubrique.renvoyerItemRubrique(parameters.get("RACINE")))) {
            parameters.put("RACINE", "00");
        }
    }

    @Override
    public String traiterAction(AutorisationBean autorisations, Map<String, String[]> parametresDeLaRequete) {
        String message;
        block14: {
            String action;
            block13: {
                action = "";
                message = "";
                if (parametresDeLaRequete.get("ACTION") != null) {
                    action = parametresDeLaRequete.get("ACTION")[0];
                }
                if (!action.equals("SUPPRIMER")) break block13;
                String[] codes = parametresDeLaRequete.get("CODES_RUBRIQUES");
                if (codes == null) break block14;
                for (String currentCode : codes) {
                    String libelleRubrique;
                    try {
                        InfosRubriques infos = Rubrique.renvoyerItemRubrique(currentCode);
                        libelleRubrique = infos.getLibelleAffichable();
                    }
                    catch (Exception e) {
                        libelleRubrique = currentCode;
                    }
                    message = String.format(MessageHelper.getCoreMessage("BO_SERVICES_ARBRE_SUPPRESSION_OK"), String.format(MessageHelper.getCoreMessage("BO_SERVICES_ARBRE_RUBRIQUE"), libelleRubrique));
                    try {
                        this.traiterSuppression(autorisations, currentCode);
                    }
                    catch (Exception e) {
                        LOG.error("la suppression de la rubrique a echouee", (Throwable)e);
                        throw new ErreurAsyncException(e.getMessage());
                    }
                }
                break block14;
            }
            if (action.equals("DEPLACER")) {
                String[] ordres;
                String[] codes = parametresDeLaRequete.get("CODES_RUBRIQUES[]");
                String[] codesMere = parametresDeLaRequete.get("CODES_MERE[]") != null ? parametresDeLaRequete.get("CODES_MERE[]") : new String[codes.length];
                String[] stringArray = ordres = parametresDeLaRequete.get("ORDRES[]") != null ? parametresDeLaRequete.get("ORDRES[]") : new String[codes.length];
                if (codes != null) {
                    for (int i = 0; i < codes.length; ++i) {
                        String libelleRubrique;
                        try {
                            InfosRubriques infos = Rubrique.renvoyerItemRubrique(codes[i]);
                            libelleRubrique = infos.getLibelleAffichable();
                        }
                        catch (Exception e) {
                            libelleRubrique = codes[i];
                        }
                        message = String.format(MessageHelper.getCoreMessage("BO_SERVICES_ARBRE_DEPLACEMENT_OK"), String.format(MessageHelper.getCoreMessage("BO_SERVICES_ARBRE_RUBRIQUE"), libelleRubrique));
                        try {
                            this.traiterDeplacement(autorisations, codes[i], codesMere[i], ordres[i]);
                            continue;
                        }
                        catch (Exception e) {
                            LOG.error("la suppression de la rubrique a echouee", (Throwable)e);
                            throw new ErreurAsyncException(e.getMessage());
                        }
                    }
                }
            }
        }
        return message;
    }

    private void traiterSuppression(AutorisationBean autorisations, String code) throws Exception {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        Rubrique rubrique = new Rubrique();
        rubrique.setCtx(ctx);
        rubrique.init();
        if (!autorisations.possedePermission(new PermissionBean("TECH", "rub", "M"), new Perimetre("*", code, "*", "*", ""))) {
            throw new ErreurAsyncException(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
        }
        if (rubrique.select(code, "", "", "") != 1) {
            throw new ErreurAsyncException(MessageHelper.getCoreMessage("BO_RUBRIQUE_INEXISTANTE"));
        }
        rubrique.nextItem();
        rubrique.setIdRubrique(rubrique.getIdRubrique());
        rubrique.delete();
        Rubrique.rechargement();
    }

    private void traiterDeplacement(AutorisationBean autorisations, String code, String codeMere, String ordre) throws Exception {
        ContexteUniv ctx = ContexteUtil.getContexteUniv();
        InfosRubriques infosRubrique = Rubrique.renvoyerItemRubrique(code);
        Rubrique rubrique = new Rubrique();
        rubrique.setCtx(ctx);
        rubrique.init();
        rubrique.setIdRubrique(infosRubrique.getIdRubrique());
        rubrique.retrieve();
        if (!autorisations.possedePermission(new PermissionBean("TECH", "rub", "M"), new Perimetre("*", code, "*", "*", ""))) {
            throw new ErreurAsyncException(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
        }
        if (rubrique.select(code, "", "", "") != 1) {
            throw new ErreurAsyncException(MessageHelper.getCoreMessage("BO_RUBRIQUE_INEXISTANTE"));
        }
        rubrique.setIdRubrique(rubrique.getIdRubrique());
        rubrique.setCodeRubriqueMere(StringUtils.defaultString((String)codeMere, (String)""));
        if (!StringUtils.isBlank((CharSequence)ordre)) {
            InfosRubriques rubriqueMere = Rubrique.renvoyerItemRubrique(StringUtils.isBlank((CharSequence)codeMere) ? "00" : codeMere);
            int order = 0;
            for (InfosRubriques currentRubrique : rubriqueMere.getListeSousRubriques()) {
                if (currentRubrique.getIdRubrique().compareTo(rubrique.getIdRubrique()) == 0) continue;
                if (order == Integer.parseInt(ordre)) {
                    ++order;
                }
                Rubrique orderedRubrique = new Rubrique();
                orderedRubrique.setCtx(ctx);
                orderedRubrique.init();
                orderedRubrique.setIdRubrique(currentRubrique.getIdRubrique());
                orderedRubrique.retrieve();
                orderedRubrique.setOrdre(Integer.toString(order));
                orderedRubrique.update();
                ++order;
            }
        }
        rubrique.setOrdre(ordre);
        rubrique.update();
        Rubrique.rechargement();
    }

    public static String getPath(String root, String code, String separator) {
        ArrayList<String> path = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)root)) {
            root = "00";
        }
        if (StringUtils.isBlank((CharSequence)code)) {
            return root;
        }
        try {
            InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(code);
            while (StringUtils.isNotBlank((CharSequence)rubrique.getCode()) && !root.equals(rubrique.getCode())) {
                path.add(rubrique.getLibelleAffichable());
                rubrique = Rubrique.renvoyerItemRubrique(rubrique.getCodeRubriqueMere());
            }
        }
        catch (Exception e) {
            LOG.error(String.format("An error occured trying to compute Rubrique tree path to element %s from %s", code, root), (Throwable)e);
        }
        Collections.reverse(path);
        return StringUtils.join(path, (String)separator);
    }

    @Override
    public JsTreeModel traiterFiltreDepuisRequete(HttpServletRequest req) {
        AutorisationBean autorisations = (AutorisationBean)SessionUtil.getInfosSession(req).get("AUTORISATIONS");
        JsTreeModel jsTree = new JsTreeModel();
        String query = StringUtils.defaultString((String)req.getParameter("QUERY"), (String)"");
        try {
            HashMap<String, String> parameters = JsTreeUtils.getParameters(req);
            this.assertParametersConsistency(parameters);
            parameters.put("NIVEAU", "-1");
            Rubrique rubriqueFiltrage = new Rubrique();
            rubriqueFiltrage.init();
            rubriqueFiltrage.setCtx(ContexteUtil.getContexteUniv());
            ClauseWhere whereIntiluleLike = new ClauseWhere(ConditionHelper.like("T1.INTITULE", query, "%", "%"));
            rubriqueFiltrage.selectNoCount(whereIntiluleLike.formaterSQL());
            jsTree = this.filterTree(autorisations, rubriqueFiltrage, parameters);
            this.openAllNodes(jsTree.getNodes());
        }
        catch (Exception e) {
            LOG.error(String.format("An error occured trying to filter Rubrique tree for query \"%s\"", query), (Throwable)e);
        }
        return jsTree;
    }

    @Override
    public String getSelectedIds(String string) {
        String[] selections;
        if (StringUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        ArrayList<String> selectedIds = new ArrayList<String>();
        for (String currentSelection : selections = string.split(";")) {
            try {
                InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(currentSelection);
                if (rubrique == null || !StringUtils.isNotBlank((CharSequence)rubrique.getCode())) continue;
                selectedIds.add(Long.toString(rubrique.getIdRubrique()));
            }
            catch (Exception e) {
                LOG.error("An error occured trying to retrieve Rubrique", (Throwable)e);
            }
        }
        return StringUtils.join(selectedIds, (String)";");
    }
}

